/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Optional;
import java.util.Set;
import org.gradle.cache.internal.locklistener.FileLockCommunicator;
import org.gradle.cache.internal.locklistener.FileLockPacketPayload;
import org.gradle.cache.internal.locklistener.FileLockPacketType;
import org.gradle.cache.internal.locklistener.InetAddressProvider;
import org.gradle.internal.UncheckedException;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class DefaultFileLockCommunicator
implements FileLockCommunicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockCommunicator.class);
    private final DatagramSocket socket;

    public DefaultFileLockCommunicator(InetAddressProvider inetAddressProvider) {
        try {
            this.socket = new DatagramSocket(0, inetAddressProvider.getWildcardBindingAddress());
        }
        catch (SocketException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public boolean pingOwner(InetAddress address, int ownerPort, long lockId, String displayName) {
        boolean pingSentSuccessfully = false;
        byte[] bytesToSend = FileLockPacketPayload.encode(lockId, FileLockPacketType.UNLOCK_REQUEST);
        try {
            this.socket.send(new DatagramPacket(bytesToSend, bytesToSend.length, address, ownerPort));
            pingSentSuccessfully = true;
        }
        catch (IOException e) {
            LOGGER.debug("Failed attempt to ping owner of lock for {} (lock id: {}, port: {}, address: {})", new Object[]{displayName, lockId, ownerPort, address});
        }
        return pingSentSuccessfully;
    }

    @Override
    public Optional<DatagramPacket> receive() throws IOException {
        try {
            byte[] bytes = new byte[10];
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            this.socket.receive(packet);
            return Optional.of(packet);
        }
        catch (IOException e) {
            if (this.socket.isClosed()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    @Override
    public FileLockPacketPayload decode(DatagramPacket receivedPacket) {
        return FileLockPacketPayload.decode(receivedPacket.getData(), receivedPacket.getLength());
    }

    @Override
    public void confirmUnlockRequest(SocketAddress requesterAddress, long lockId) {
        byte[] bytes = FileLockPacketPayload.encode(lockId, FileLockPacketType.UNLOCK_REQUEST_CONFIRMATION);
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
        packet.setSocketAddress(requesterAddress);
        LOGGER.debug("Confirming unlock request to process at port {} for lock with id {}.", (Object)packet.getPort(), (Object)lockId);
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to confirm unlock request to process at port {} for lock with id {}.", (Object)packet.getPort(), (Object)lockId);
        }
    }

    @Override
    public void confirmLockRelease(Set<SocketAddress> requesterAddresses, long lockId) {
        byte[] bytes = FileLockPacketPayload.encode(lockId, FileLockPacketType.LOCK_RELEASE_CONFIRMATION);
        for (SocketAddress requesterAddress : requesterAddresses) {
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            packet.setSocketAddress(requesterAddress);
            LOGGER.debug("Confirming lock release to process at port {} for lock with id {}.", (Object)packet.getPort(), (Object)lockId);
            try {
                this.socket.send(packet);
            }
            catch (IOException e) {
                LOGGER.debug("Failed to confirm lock release to process at port {} for lock with id {}.", (Object)packet.getPort(), (Object)lockId);
            }
        }
    }

    @Override
    public void stop() {
        this.socket.close();
    }

    @Override
    public int getPort() {
        return this.socket.getLocalPort();
    }
}

