# frozen_string_literal: true

module GitlabQuality
  module TestTooling
    module CodeCoverage
      class TestFileMappingData
        # @param [Hash<String, Array<String>>] test_to_sources Test files
        #   mapped to all source files they cover
        def initialize(test_to_sources)
          @test_to_sources = test_to_sources
        end

        # @return [Array<Hash<Symbol, String>>] Mapping data formatted for database insertion
        # @example Return value
        #   [
        #     { test_file: "spec/models/user_spec.rb", source_file: "app/models/user.rb" },
        #     { test_file: "spec/models/user_spec.rb", source_file: "lib/utils.rb" },
        #     ...
        #   ]
        def as_db_table
          @test_to_sources.flat_map do |test_file, source_files|
            source_files.map do |source_file|
              {
                test_file: test_file,
                source_file: source_file
              }
            end
          end
        end
      end
    end
  end
end
