/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.LangCondition;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.PseudoCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SheetContext;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.jclf.text.TokenParser;

class SelectorSerializer {
    private final SheetContext parentSheet;

    public SelectorSerializer(SheetContext parentSheet) {
        this.parentSheet = parentSheet;
    }

    private SheetContext getSheetContext() {
        return this.parentSheet;
    }

    void selectorText(StringBuilder buf, Selector sel, boolean omitUniversal) {
        this.selectorText(buf, sel, omitUniversal, false);
    }

    private void selectorText(StringBuilder buf, Selector sel, boolean omitUniversal, boolean scoped) {
        switch (sel.getSelectorType()) {
            case UNIVERSAL: {
                if (omitUniversal) break;
                buf.append('*');
                break;
            }
            case ELEMENT: {
                ElementSelector esel = (ElementSelector)sel;
                String lname = esel.getLocalName();
                String nsuri = esel.getNamespaceURI();
                if (lname != null) {
                    lname = ParseHelper.escape(lname, false, false);
                }
                if (nsuri != null) {
                    if (!nsuri.isEmpty()) {
                        String nsprefix = this.getSheetContext().getNamespacePrefix(esel.getNamespaceURI());
                        if (nsprefix == null) {
                            throw new IllegalStateException("Unknown ns prefix for URI " + esel.getNamespaceURI());
                        }
                        if (!nsprefix.isEmpty()) {
                            buf.append(nsprefix).append('|');
                        }
                    } else {
                        buf.append('|');
                    }
                    buf.append(lname);
                    break;
                }
                SheetContext psheet = this.getSheetContext();
                if (psheet != null && psheet.hasDefaultNamespace()) {
                    buf.append("*|");
                    if (lname != null) {
                        buf.append(lname);
                        break;
                    }
                    buf.append('*');
                    break;
                }
                if (lname != null) {
                    buf.append(lname);
                    break;
                }
                if (omitUniversal) break;
                buf.append('*');
                break;
            }
            case CHILD: {
                CombinatorSelector dsel = (CombinatorSelector)sel;
                Selector ancsel = dsel.getSelector();
                if (!scoped || ancsel.getSelectorType() != Selector.SelectorType.UNIVERSAL) {
                    this.selectorText(buf, ancsel, false, scoped);
                }
                buf.append('>');
                this.selectorText(buf, dsel.getSecondSelector(), false, scoped);
                break;
            }
            case CONDITIONAL: {
                ConditionalSelector csel = (ConditionalSelector)sel;
                SimpleSelector simpleSelector = csel.getSimpleSelector();
                if (simpleSelector != null) {
                    this.appendSimpleSelector(simpleSelector, buf);
                }
                this.conditionalSelectorText(csel.getCondition(), buf);
                break;
            }
            case DESCENDANT: {
                CombinatorSelector dsel = (CombinatorSelector)sel;
                Selector ancestor = dsel.getSelector();
                this.selectorText(buf, ancestor, false, scoped);
                buf.append(' ');
                this.selectorText(buf, dsel.getSecondSelector(), false, scoped);
                break;
            }
            case DIRECT_ADJACENT: {
                CombinatorSelector asel = (CombinatorSelector)sel;
                this.selectorText(buf, asel.getSelector(), omitUniversal, scoped);
                buf.append('+');
                this.selectorText(buf, asel.getSecondSelector(), false, scoped);
                break;
            }
            case SUBSEQUENT_SIBLING: {
                CombinatorSelector asel = (CombinatorSelector)sel;
                this.selectorText(buf, asel.getSelector(), omitUniversal, scoped);
                buf.append('~');
                this.selectorText(buf, asel.getSecondSelector(), false, scoped);
                break;
            }
            case COLUMN_COMBINATOR: {
                CombinatorSelector dsel = (CombinatorSelector)sel;
                this.selectorText(buf, dsel.getSelector(), omitUniversal, scoped);
                buf.append("||");
                this.selectorText(buf, dsel.getSecondSelector(), false, scoped);
                break;
            }
            case SCOPE_MARKER: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown selector: " + sel.toString());
            }
        }
    }

    private void conditionalSelectorText(Condition condition, StringBuilder buf) {
        switch (condition.getConditionType()) {
            case CLASS: {
                this.classText((AttributeCondition)condition, buf);
                break;
            }
            case ID: {
                String id = ((AttributeCondition)condition).getValue();
                buf.append('#').append(ParseHelper.escape(id, false, false));
                break;
            }
            case ATTRIBUTE: {
                this.attributeText((AttributeCondition)condition, buf);
                break;
            }
            case BEGINS_ATTRIBUTE: {
                this.attributeBeginsText((AttributeCondition)condition, buf);
                break;
            }
            case BEGIN_HYPHEN_ATTRIBUTE: {
                this.attributeBeginHyphenText((AttributeCondition)condition, buf);
                break;
            }
            case ENDS_ATTRIBUTE: {
                this.attributeEndsText((AttributeCondition)condition, buf);
                break;
            }
            case SUBSTRING_ATTRIBUTE: {
                this.attributeSubstringText((AttributeCondition)condition, buf);
                break;
            }
            case LANG: {
                this.langText((LangCondition)condition, buf);
                break;
            }
            case ONE_OF_ATTRIBUTE: {
                this.attributeOneOfText((AttributeCondition)condition, buf);
                break;
            }
            case ONLY_CHILD: {
                buf.append(":only-child");
                break;
            }
            case ONLY_TYPE: {
                buf.append(":only-of-type");
                break;
            }
            case POSITIONAL: {
                PositionalCondition pcond = (PositionalCondition)condition;
                buf.append(':');
                if (pcond.isOfType()) {
                    this.appendPositionalOfType(pcond, buf);
                    break;
                }
                this.appendPositional(pcond, buf);
                break;
            }
            case AND: {
                CombinatorCondition ccond = (CombinatorCondition)condition;
                int len = ccond.getLength();
                for (int i = 0; i < len; ++i) {
                    this.conditionalSelectorText(ccond.getCondition(i), buf);
                }
                break;
            }
            case PSEUDO_CLASS: {
                this.pseudoClassText((PseudoCondition)condition, buf);
                break;
            }
            case PSEUDO_ELEMENT: {
                this.pseudoElementText((PseudoCondition)condition, buf);
                break;
            }
            case SELECTOR_ARGUMENT_PSEUDO_ELEMENT: {
                buf.append(':');
            }
            case SELECTOR_ARGUMENT: {
                this.selectorArgumentText((ArgumentCondition)condition, buf);
                break;
            }
            case NESTING: {
                buf.append('&');
                break;
            }
            default: {
                throw new IllegalStateException("Unknown condition: " + condition.toString());
            }
        }
    }

    private void appendSimpleSelector(SimpleSelector simpleSelector, StringBuilder buf) {
        this.selectorText(buf, simpleSelector, true);
    }

    private void classText(AttributeCondition acond, StringBuilder buf) {
        buf.append(".").append(ParseHelper.escape(acond.getValue(), false, false));
    }

    private void pseudoClassText(PseudoCondition acond, StringBuilder buf) {
        buf.append(':');
        String name = acond.getName();
        String value = acond.getArgument();
        if (name == null) {
            buf.append(value);
        } else {
            buf.append(name);
            if (value != null) {
                buf.append('(');
                buf.append(value);
                buf.append(')');
            }
        }
    }

    private String attributeText(AttributeCondition acond, StringBuilder buf) {
        String value = acond.getValue();
        if (value != null) {
            buf.append('[');
            this.serializeAttributeQName(acond, buf);
            buf.append('=');
            this.appendAttributeValueAndClose(acond, buf);
        } else {
            buf.append('[');
            this.serializeAttributeQName(acond, buf);
            buf.append(']');
        }
        return buf.toString();
    }

    private void attributeBeginsText(AttributeCondition acond, StringBuilder buf) {
        buf.append('[');
        this.serializeAttributeQName(acond, buf);
        buf.append("^=");
        this.appendAttributeValueAndClose(acond, buf);
    }

    private void attributeBeginHyphenText(AttributeCondition acond, StringBuilder buf) {
        buf.append('[');
        this.serializeAttributeQName(acond, buf);
        buf.append("|=");
        this.appendAttributeValueAndClose(acond, buf);
    }

    private void attributeEndsText(AttributeCondition acond, StringBuilder buf) {
        buf.append('[');
        this.serializeAttributeQName(acond, buf);
        buf.append("$=");
        this.appendAttributeValueAndClose(acond, buf);
    }

    private void attributeSubstringText(AttributeCondition acond, StringBuilder buf) {
        buf.append('[');
        this.serializeAttributeQName(acond, buf);
        buf.append("*=");
        this.appendAttributeValueAndClose(acond, buf);
    }

    private void attributeOneOfText(AttributeCondition acond, StringBuilder buf) {
        buf.append('[');
        this.serializeAttributeQName(acond, buf);
        buf.append("~=");
        this.appendAttributeValueAndClose(acond, buf);
    }

    private void serializeAttributeQName(AttributeCondition acond, StringBuilder buf) {
        String nsuri = acond.getNamespaceURI();
        if (nsuri != null) {
            if (nsuri.length() != 0) {
                String nsprefix = this.getSheetContext().getNamespacePrefix(nsuri);
                if (nsprefix == null) {
                    throw new IllegalStateException("Unknown ns prefix for URI " + nsuri);
                }
                if (nsprefix.length() != 0) {
                    buf.append(nsprefix).append('|');
                }
            } else {
                buf.append('|');
            }
        }
        String escLName = ParseHelper.escape(acond.getLocalName(), false, false);
        buf.append(escLName);
    }

    private void appendAttributeValueAndClose(AttributeCondition acond, StringBuilder buf) {
        String value = acond.getValue();
        if (!acond.hasFlag() && !value.isEmpty() && CSSUtil.isValidIdentifier(value)) {
            buf.append(value);
        } else {
            char quote = this.quoteChar(true);
            buf.append(ParseHelper.quote(value, quote));
        }
        if (acond.hasFlag(AttributeCondition.Flag.CASE_I)) {
            buf.append(" i");
        } else if (acond.hasFlag(AttributeCondition.Flag.CASE_S)) {
            buf.append(" s");
        }
        buf.append(']');
    }

    private void langText(LangCondition condition, StringBuilder buf) {
        buf.append(":lang(");
        String lang = condition.getLang();
        if (!lang.isEmpty()) {
            if (CSSUtil.isValidIdentifier(lang)) {
                buf.append(lang);
            } else {
                TokenParser parser = new TokenParser(lang, ", ", "\"'");
                String s = parser.next();
                int commaIdx = lang.indexOf(44) + 1;
                buf.append(this.escapeLang(s, lang, commaIdx));
                while (parser.hasNext()) {
                    s = parser.next();
                    commaIdx = lang.indexOf(44, commaIdx) + 1;
                    buf.append(',').append(this.escapeLang(s, lang, commaIdx));
                }
            }
        }
        buf.append(')');
    }

    private String escapeLang(String s, String lang, int commaIdx) {
        boolean noDQ;
        int nextCommaIdx = lang.indexOf(44, commaIdx) + 1;
        int nextDQIdx = lang.indexOf(34, commaIdx);
        int nextSQIdx = lang.indexOf(39, commaIdx);
        boolean bl = noDQ = nextDQIdx == -1 || nextDQIdx > nextCommaIdx;
        if (s.indexOf(32) != -1) {
            char quote = this.quoteChar(noDQ);
            s = ParseHelper.quote(s, quote);
        } else {
            CharSequence escaped = ParseHelper.escapeCssCharsAndFirstChar(s);
            if (escaped != s) {
                boolean noSQ;
                boolean bl2 = noSQ = nextSQIdx == -1 || nextSQIdx > nextCommaIdx;
                if (escaped.length() < s.length() + 2 && noDQ && noSQ) {
                    s = escaped.toString();
                } else {
                    char quote = this.quoteChar(noDQ);
                    s = ParseHelper.quote(s, quote);
                }
            }
        }
        return s;
    }

    private char quoteChar(boolean noDQ) {
        SheetContext sheet = this.getSheetContext();
        int quote = sheet != null ? (sheet.hasFactoryFlag((short)2) ? 34 : (sheet.hasFactoryFlag((short)1) ? 39 : (noDQ ? 39 : 34))) : (noDQ ? 39 : 34);
        return (char)quote;
    }

    private void pseudoElementText(PseudoCondition acond, StringBuilder buf) {
        buf.append(':').append(':').append(acond.getName());
        String arg = acond.getArgument();
        if (arg != null) {
            buf.append('(').append(arg).append(')');
        }
    }

    private void selectorArgumentText(ArgumentCondition condition, StringBuilder buf) {
        buf.append(':').append(condition.getName()).append("(");
        this.selectorListText(buf, condition.getSelectors(), false, true);
        buf.append(')');
    }

    private void appendPositional(PositionalCondition pcond, StringBuilder buf) {
        int slope = pcond.getFactor();
        int offset = pcond.getOffset();
        SelectorList ofList = pcond.getOfList();
        boolean forwardCondition = pcond.isForwardCondition();
        if (slope == 0) {
            if (offset == 1 && ofList == null && !pcond.hasArgument()) {
                if (forwardCondition) {
                    buf.append("first-child");
                } else {
                    buf.append("last-child");
                }
            } else {
                if (forwardCondition) {
                    buf.append("nth-child(");
                } else {
                    buf.append("nth-last-child(");
                }
                buf.append(offset);
                if (!SelectorSerializer.isUniversalSelectorList(ofList)) {
                    buf.append(" of ");
                    this.selectorListText(buf, ofList, true, false);
                }
                buf.append(')');
            }
        } else {
            if (forwardCondition) {
                buf.append("nth-child(");
            } else {
                buf.append("nth-last-child(");
            }
            this.appendAnB(slope, offset, pcond.hasKeyword(), buf);
            if (!SelectorSerializer.isUniversalSelectorList(ofList)) {
                buf.append(" of ").append(ofList.toString());
            }
            buf.append(')');
        }
    }

    private void appendPositionalOfType(PositionalCondition pcond, StringBuilder buf) {
        int slope = pcond.getFactor();
        int offset = pcond.getOffset();
        SelectorList ofList = pcond.getOfList();
        boolean forwardCondition = pcond.isForwardCondition();
        if (slope == 0) {
            if (offset == 1 && ofList == null && !pcond.hasArgument()) {
                if (forwardCondition) {
                    buf.append("first-of-type");
                } else {
                    buf.append("last-of-type");
                }
            } else {
                if (forwardCondition) {
                    buf.append("nth-of-type(");
                } else {
                    buf.append("nth-last-of-type(");
                }
                buf.append(offset).append(')');
            }
        } else {
            if (forwardCondition) {
                buf.append("nth-of-type(");
            } else {
                buf.append("nth-last-of-type(");
            }
            this.appendAnB(slope, offset, pcond.hasKeyword(), buf);
            buf.append(')');
        }
    }

    private void appendAnB(int slope, int offset, boolean hasKeyword, StringBuilder buf) {
        if (hasKeyword && slope == 2) {
            if (offset == 0) {
                buf.append("even");
            } else {
                buf.append("odd");
            }
            return;
        }
        if (slope == -1) {
            buf.append('-');
        } else if (slope != 1) {
            buf.append(slope);
        }
        buf.append('n');
        if (offset > 0) {
            buf.append('+');
            buf.append(offset);
        } else if (offset != 0) {
            buf.append(offset);
        }
    }

    void selectorListText(StringBuilder buf, SelectorList selist, boolean omitUniversal, boolean scoped) {
        this.selectorText(buf, selist.item(0), omitUniversal, scoped);
        for (int i = 1; i < selist.getLength(); ++i) {
            buf.append(',');
            this.selectorText(buf, selist.item(i), omitUniversal, scoped);
        }
    }

    private static boolean isUniversalSelectorList(SelectorList selist) {
        if (selist == null) {
            return true;
        }
        for (int i = 0; i < selist.getLength(); ++i) {
            if (selist.item(i).getSelectorType() != Selector.SelectorType.UNIVERSAL) continue;
            return true;
        }
        return false;
    }
}

