/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.mozilla.javascript.NativePromise;

public class UnhandledRejectionTracker {
    private boolean enabled = false;
    private static final IdentityHashMap<NativePromise, NativePromise> unhandled = new IdentityHashMap(0);

    public void process(Consumer<Object> consumer) {
        Iterator<NativePromise> iterator = unhandled.values().iterator();
        while (iterator.hasNext()) {
            try {
                consumer.accept(iterator.next().getResult());
            }
            finally {
                iterator.remove();
            }
        }
    }

    public List<Object> enumerate() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (NativePromise nativePromise : unhandled.values()) {
            arrayList.add(nativePromise.getResult());
        }
        return arrayList;
    }

    void enable(boolean bl) {
        this.enabled = bl;
    }

    void promiseRejected(NativePromise nativePromise) {
        if (this.enabled) {
            unhandled.put(nativePromise, nativePromise);
        }
    }

    void promiseHandled(NativePromise nativePromise) {
        if (this.enabled) {
            unhandled.remove(nativePromise);
        }
    }
}

