define(["exports"],function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var calculateColorDifference=function(color1,color2){return Math.pow(color2.r-color1.r,2)+Math.pow(color2.g-color1.g,2)+Math.pow(color2.b-color1.b,2)},orderByLuminance=function(rgbValues){function calculateLuminance(p){return.2126*p.r+.7152*p.g+.0722*p.b}return rgbValues.sort(function(p1,p2){return calculateLuminance(p2)-calculateLuminance(p1)})};function buildPalette(colorsList){for(var orderedByColor=orderByLuminance(colorsList),colors=[],i=0;i<orderedByColor.length;i++){var color=orderedByColor[i];if(0<i)if(calculateColorDifference(color,orderedByColor[i-1])<120)continue;var rgb="rgb("+color.r+", "+color.g+", "+color.b+")";colors.push({css:rgb,color:color,relativeLuminance:function(color){var r_srgb=color.r/255,g_srgb=color.g/255,color=color.b/255;return.2126*(r_srgb<=.03928?r_srgb/12.92:Math.pow((.055+r_srgb)/1.055,2.4))+.7152*(g_srgb<=.03928?g_srgb/12.92:Math.pow((.055+g_srgb)/1.055,2.4))+.0722*(color<=.03928?color/12.92:Math.pow((.055+color)/1.055,2.4))}(color)})}return colors}var findBiggestColorRange=function(rgbValues){var rMin=Number.MAX_VALUE,gMin=Number.MAX_VALUE,bMin=Number.MAX_VALUE,rMax=Number.MIN_VALUE,gMax=Number.MIN_VALUE,bMax=Number.MIN_VALUE,rgbValues=(rgbValues.forEach(function(pixel){rMin=Math.min(rMin,pixel.r),gMin=Math.min(gMin,pixel.g),bMin=Math.min(bMin,pixel.b),rMax=Math.max(rMax,pixel.r),gMax=Math.max(gMax,pixel.g),bMax=Math.max(bMax,pixel.b)}),rMax-rMin),gRange=gMax-gMin,bRange=bMax-bMin,bRange=Math.max(rgbValues,gRange,bRange);return bRange===rgbValues?"r":bRange===gRange?"g":"b"},quantization=function(rgbValues,depth){var componentToSortBy,color;return 4===depth||0===rgbValues.length?((color=rgbValues.reduce(function(prev,curr){return prev.r+=curr.r,prev.g+=curr.g,prev.b+=curr.b,prev},{r:0,g:0,b:0})).r=Math.round(color.r/rgbValues.length),color.g=Math.round(color.g/rgbValues.length),color.b=Math.round(color.b/rgbValues.length),[color]):(componentToSortBy=findBiggestColorRange(rgbValues),rgbValues.sort(function(p1,p2){return p1[componentToSortBy]-p2[componentToSortBy]}),color=rgbValues.length/2,[].concat(babelHelpers.toConsumableArray(quantization(rgbValues.slice(0,color),depth+1)),babelHelpers.toConsumableArray(quantization(rgbValues.slice(1+color),depth+1))))};_exports.default={getPalette:function(url){return new Promise(function(resolve,reject){var image=new Image;image.crossOrigin="Anonymous",image.onload=function(){var canvas=document.createElement("canvas"),ctx=(canvas.width=image.width,canvas.height=image.height,canvas.getContext("2d"));ctx.drawImage(image,0,0);ctx=function(imageData){for(var rgbValues=[],i=0;i<imageData.length;i+=4){var rgb={r:imageData[i],g:imageData[i+1],b:imageData[i+2]};rgbValues.push(rgb)}return rgbValues}(ctx.getImageData(0,0,canvas.width,canvas.height).data),canvas=quantization(ctx,0);resolve(buildPalette(canvas))},image.onerror=reject,image.src=url})}}});