/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.net;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBServiceConnections;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.SecuredPasswordEncrypter;
import org.jkiss.utils.CommonUtils;

public class GlobalProxyAuthenticator
extends Authenticator {
    private static final Log log = Log.getLog(GlobalProxyAuthenticator.class);

    @Override
    @Nullable
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication pc;
        DBServiceConnections serviceConnections;
        DBPDataSourceContainer activeContext;
        String requestingProtocol;
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        String proxyHost = store.getString("ui.proxy.host");
        if (!CommonUtils.isEmpty((String)proxyHost) && proxyHost.equalsIgnoreCase(this.getRequestingHost()) && store.getInt("ui.proxy.port") == this.getRequestingPort()) {
            DBPAuthInfo credentials = null;
            try {
                credentials = GlobalProxyAuthenticator.readCredentials();
            }
            catch (DBException e) {
                log.error("Error reading proxy credentials", e);
            }
            if (credentials == null) {
                credentials = this.readCredentialsInUI("Auth proxy '" + proxyHost + "'", null, null);
            }
            if (credentials != null) {
                if (credentials.isSavePassword()) {
                    try {
                        GlobalProxyAuthenticator.saveCredentials(credentials.getUserName(), credentials.getUserPassword());
                    }
                    catch (DBException e) {
                        log.error("Error saving proxy credentials", e);
                    }
                }
                return new PasswordAuthentication(credentials.getUserName(), credentials.getUserPassword().toCharArray());
            }
        }
        if (("SOCKS5".equals(requestingProtocol = this.getRequestingProtocol()) || "SOCKS4".equals(requestingProtocol)) && (activeContext = DBExecUtils.findConnectionContext(this.getRequestingHost(), this.getRequestingPort(), this.getRequestingScheme())) != null) {
            for (DBWHandlerConfiguration networkHandler : activeContext.getActualConnectionConfiguration().getHandlers()) {
                DBPAuthInfo authInfo;
                if (!networkHandler.isEnabled() || networkHandler.getType() != DBWHandlerType.PROXY) continue;
                String userName = networkHandler.getUserName();
                String userPassword = networkHandler.getPassword();
                if ((CommonUtils.isEmpty((String)userName) || CommonUtils.isEmpty((String)userPassword)) && (authInfo = this.readCredentialsInUI(this.getRequestingPrompt(), userName, userPassword)) != null) {
                    userName = authInfo.getUserName();
                    userPassword = authInfo.getUserPassword();
                    if (authInfo.isSavePassword()) {
                        networkHandler.setUserName(userName);
                        networkHandler.setPassword(userPassword);
                        networkHandler.setSavePassword(true);
                        activeContext.getRegistry().flushConfig();
                    }
                }
                if (CommonUtils.isEmpty((String)userName) || CommonUtils.isEmpty((String)userPassword)) continue;
                return new PasswordAuthentication(userName, userPassword.toCharArray());
            }
        }
        if ((serviceConnections = DBWorkbench.getService(DBServiceConnections.class)) != null && (pc = serviceConnections.getGlobalProxyConfiguration(this.getRequestingProtocol(), this.getRequestingHost(), this.getRequestingPort())) != null) {
            return pc;
        }
        return null;
    }

    private DBPAuthInfo readCredentialsInUI(String prompt, String userName, String userPassword) {
        return DBWorkbench.getPlatformUI().promptUserCredentials(prompt, null, userName, userPassword, false, true);
    }

    @Nullable
    public static DBPAuthInfo readCredentials() throws DBException {
        DBSSecretController secrets = DBSSecretController.getGlobalSecretController();
        String userName = secrets.getPrivateSecretValue("ui.proxy.user");
        String password = secrets.getPrivateSecretValue("ui.proxy.password");
        if (CommonUtils.isNotEmpty((String)userName)) {
            return new DBPAuthInfo(userName, CommonUtils.notEmpty((String)password), true);
        }
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        userName = store.getString("ui.proxy.user");
        password = store.getString("ui.proxy.password");
        if (CommonUtils.isNotEmpty((String)userName)) {
            if (CommonUtils.isNotEmpty((String)password)) {
                try {
                    password = new SecuredPasswordEncrypter().decrypt(password);
                }
                catch (EncryptionException e) {
                    throw new DBException("Can't decrypt legacy password", e);
                }
            }
            return new DBPAuthInfo(userName, CommonUtils.notEmpty((String)password), true);
        }
        return null;
    }

    public static void saveCredentials(@NotNull String username, @NotNull String password) throws DBException {
        if (CommonUtils.isNotEmpty((String)username)) {
            DBSSecretController secrets = DBSSecretController.getGlobalSecretController();
            secrets.setPrivateSecretValue("ui.proxy.user", username);
            if (CommonUtils.isNotEmpty((String)password)) {
                secrets.setPrivateSecretValue("ui.proxy.password", password);
            }
            secrets.flushChanges();
        }
    }
}

