/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.manager.DB2AbstractDropOnlyManager;
import org.jkiss.dbeaver.ext.db2.model.DB2Alias;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class DB2AliasManager
extends DB2AbstractDropOnlyManager<DB2Alias, DB2Schema> {
    private static final String SQL_DROP_MODULE = "DROP ALIAS %s FOR MODULE";
    private static final String SQL_DROP_SEQUENCE = "DROP ALIAS %s FOR SEQUENCE";
    private static final String SQL_DROP_TABLE = "DROP ALIAS %s FOR TABLE";

    @Override
    public String buildDropStatement(DB2Alias db2Alias) {
        String fullyQualifiedName = db2Alias.getFullyQualifiedName(DBPEvaluationContext.DDL);
        switch (db2Alias.getType()) {
            case MODULE: {
                return String.format(SQL_DROP_MODULE, fullyQualifiedName);
            }
            case SEQUENCE: {
                return String.format(SQL_DROP_SEQUENCE, fullyQualifiedName);
            }
            case TABLE: {
                return String.format(SQL_DROP_TABLE, fullyQualifiedName);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)db2Alias.getType()) + " as DB2AliasType is not supported");
    }

    @Nullable
    public DBSObjectCache<DB2Schema, DB2Alias> getObjectsCache(DB2Alias db2Alias) {
        return db2Alias.getSchema().getAliasCache();
    }
}

