﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/LocalGatewayVirtualInterface.h>
#include <aws/ec2/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class DeleteLocalGatewayVirtualInterfaceResponse {
 public:
  AWS_EC2_API DeleteLocalGatewayVirtualInterfaceResponse() = default;
  AWS_EC2_API DeleteLocalGatewayVirtualInterfaceResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API DeleteLocalGatewayVirtualInterfaceResponse& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the deleted local gateway virtual interface.</p>
   */
  inline const LocalGatewayVirtualInterface& GetLocalGatewayVirtualInterface() const { return m_localGatewayVirtualInterface; }
  template <typename LocalGatewayVirtualInterfaceT = LocalGatewayVirtualInterface>
  void SetLocalGatewayVirtualInterface(LocalGatewayVirtualInterfaceT&& value) {
    m_localGatewayVirtualInterfaceHasBeenSet = true;
    m_localGatewayVirtualInterface = std::forward<LocalGatewayVirtualInterfaceT>(value);
  }
  template <typename LocalGatewayVirtualInterfaceT = LocalGatewayVirtualInterface>
  DeleteLocalGatewayVirtualInterfaceResponse& WithLocalGatewayVirtualInterface(LocalGatewayVirtualInterfaceT&& value) {
    SetLocalGatewayVirtualInterface(std::forward<LocalGatewayVirtualInterfaceT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DeleteLocalGatewayVirtualInterfaceResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  LocalGatewayVirtualInterface m_localGatewayVirtualInterface;

  ResponseMetadata m_responseMetadata;
  bool m_localGatewayVirtualInterfaceHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
