﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/support/Support_EXPORTS.h>
#include <aws/support/model/CaseDetails.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Support {
namespace Model {
/**
 * <p>Returns an array of <a
 * href="https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html">CaseDetails</a>
 * objects and a <code>nextToken</code> that defines a point for pagination in the
 * result set.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCasesResponse">AWS
 * API Reference</a></p>
 */
class DescribeCasesResult {
 public:
  AWS_SUPPORT_API DescribeCasesResult() = default;
  AWS_SUPPORT_API DescribeCasesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SUPPORT_API DescribeCasesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The details for the cases that match the request.</p>
   */
  inline const Aws::Vector<CaseDetails>& GetCases() const { return m_cases; }
  template <typename CasesT = Aws::Vector<CaseDetails>>
  void SetCases(CasesT&& value) {
    m_casesHasBeenSet = true;
    m_cases = std::forward<CasesT>(value);
  }
  template <typename CasesT = Aws::Vector<CaseDetails>>
  DescribeCasesResult& WithCases(CasesT&& value) {
    SetCases(std::forward<CasesT>(value));
    return *this;
  }
  template <typename CasesT = CaseDetails>
  DescribeCasesResult& AddCases(CasesT&& value) {
    m_casesHasBeenSet = true;
    m_cases.emplace_back(std::forward<CasesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A resumption point for pagination.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeCasesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeCasesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<CaseDetails> m_cases;
  bool m_casesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Support
}  // namespace Aws
