#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017-2025 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
# ----------------------------------------------------------------------------
#

from __future__ import absolute_import, division, print_function

__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "community",
}

DOCUMENTATION = r"""
---
author:
  - Google Inc. (@googlecloudplatform)
description:
  - A connection to a SCM like GitHub, GitHub Enterprise, Bitbucket Data Center/Cloud or GitLab.
extends_documentation_fragment:
  - google.cloud.gcp
module: gcp_cloudbuildv2_connection
notes:
  - 'API Reference: U(https://cloud.google.com/build/docs/api/reference/rest)'
  - 'Official Documentation Guide: U(https://cloud.google.com/build/docs)'
options:
  annotations:
    description:
      - Allows clients to store small amounts of arbitrary data.
    type: dict
  bitbucket_cloud_config:
    description:
      - Configuration for connections to Bitbucket Cloud.
    suboptions:
      authorizer_credential:
        description:
          - An access token with the `webhook`, `repository`, `repository:admin` and `pullrequest` scope access.
          - It can be either a workspace, project or repository access token.
          - It's recommended to use a system account to generate these credentials.
        required: true
        suboptions:
          user_token_secret_version:
            description:
              - A SecretManager resource containing the user token that authorizes the Cloud Build connection.
              - 'Format: `projects/*/secrets/*/versions/*`.'
            required: true
            type: str
          username:
            description:
              - Output only.
              - The username associated to this token.
            type: str
        type: dict
      read_authorizer_credential:
        description:
          - An access token with the `repository` access.
          - It can be either a workspace, project or repository access token.
          - It's recommended to use a system account to generate the credentials.
        required: true
        suboptions:
          user_token_secret_version:
            description:
              - A SecretManager resource containing the user token that authorizes the Cloud Build connection.
              - 'Format: `projects/*/secrets/*/versions/*`.'
            required: true
            type: str
          username:
            description:
              - Output only.
              - The username associated to this token.
            type: str
        type: dict
      webhook_secret_secret_version:
        description:
          - SecretManager resource containing the webhook secret used to verify webhook events, formatted as `projects/*/secrets/*/versions/*`.
          - This property is immutable, to change it, you must delete and recreate the resource.
        required: true
        type: str
      workspace:
        description:
          - The Bitbucket Cloud Workspace ID to be connected to Google Cloud Platform.
        required: true
        type: str
    type: dict
  bitbucket_data_center_config:
    description:
      - Configuration for connections to Bitbucket Data Center.
    suboptions:
      authorizer_credential:
        description:
          - A http access token with the `REPO_ADMIN` scope access.
        required: true
        suboptions:
          user_token_secret_version:
            description:
              - A SecretManager resource containing the user token that authorizes the Cloud Build connection.
              - 'Format: `projects/*/secrets/*/versions/*`.'
            required: true
            type: str
          username:
            description:
              - Output only.
              - The username associated to this token.
            type: str
        type: dict
      host_uri:
        description:
          - The URI of the Bitbucket Data Center host this connection is for.
        required: true
        type: str
      read_authorizer_credential:
        description:
          - A http access token with the `REPO_READ` access.
        required: true
        suboptions:
          user_token_secret_version:
            description:
              - A SecretManager resource containing the user token that authorizes the Cloud Build connection.
              - 'Format: `projects/*/secrets/*/versions/*`.'
            required: true
            type: str
          username:
            description:
              - Output only.
              - The username associated to this token.
            type: str
        type: dict
      server_version:
        description:
          - Output only.
          - Version of the Bitbucket Data Center running on the `host_uri`.
        type: str
      service_directory_config:
        description:
          - Configuration for using Service Directory to privately connect to a Bitbucket Data Center.
          - This should only be set if the Bitbucket Data Center is hosted on-premises and not reachable by public internet.
          - If this field is left empty, calls to the Bitbucket Data Center will be made over the public internet.
        suboptions:
          service:
            description:
              - The Service Directory service name.
              - 'Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.'
            required: true
            type: str
        type: dict
      ssl_ca:
        description:
          - SSL certificate to use for requests to the Bitbucket Data Center.
        type: str
      webhook_secret_secret_version:
        description:
          - SecretManager resource containing the webhook secret used to verify webhook events, formatted as `projects/*/secrets/*/versions/*`.
          - This property is immutable, to change it, you must delete and recreate the resource.
        required: true
        type: str
    type: dict
  disabled:
    description:
      - If disabled is set to true, functionality is disabled for this connection.
      - Repository based API methods and webhooks processing for repositories in this connection will be disabled.
    type: bool
  github_config:
    description:
      - Configuration for connections to github.com.
    suboptions:
      app_installation_id:
        description:
          - GitHub App installation id.
        type: int
      authorizer_credential:
        description:
          - OAuth credential of the account that authorized the Cloud Build GitHub App.
          - It is recommended to use a robot account instead of a human user account.
          - The OAuth token must be tied to the Cloud Build GitHub App.
        suboptions:
          oauth_token_secret_version:
            description:
              - A SecretManager resource containing the OAuth token that authorizes the Cloud Build connection.
              - 'Format: `projects/*/secrets/*/versions/*`.'
            type: str
          username:
            description:
              - Output only.
              - The username associated to this token.
            type: str
        type: dict
    type: dict
  github_enterprise_config:
    description:
      - Configuration for connections to an instance of GitHub Enterprise.
    suboptions:
      app_id:
        description:
          - Id of the GitHub App created from the manifest.
        type: int
      app_installation_id:
        description:
          - ID of the installation of the GitHub App.
        type: int
      app_slug:
        description:
          - The URL-friendly name of the GitHub App.
        type: str
      host_uri:
        description:
          - The URI of the GitHub Enterprise host this connection is for.
        required: true
        type: str
      private_key_secret_version:
        description:
          - SecretManager resource containing the private key of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        type: str
      service_directory_config:
        description:
          - Configuration for using Service Directory to privately connect to a GitHub Enterprise server.
          - This should only be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet.
          - If this field is left empty, calls to the GitHub Enterprise server will be made over the public internet.
        suboptions:
          service:
            description:
              - The Service Directory service name.
              - 'Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.'
            required: true
            type: str
        type: dict
      ssl_ca:
        description:
          - SSL certificate to use for requests to GitHub Enterprise.
        type: str
      webhook_secret_secret_version:
        description:
          - SecretManager resource containing the webhook secret of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        type: str
    type: dict
  gitlab_config:
    description:
      - Configuration for connections to gitlab.com or an instance of GitLab Enterprise.
    suboptions:
      authorizer_credential:
        description:
          - A GitLab personal access token with the `api` scope access.
        required: true
        suboptions:
          user_token_secret_version:
            description:
              - A SecretManager resource containing the user token that authorizes the Cloud Build connection.
              - 'Format: `projects/*/secrets/*/versions/*`.'
            required: true
            type: str
          username:
            description:
              - Output only.
              - The username associated to this token.
            type: str
        type: dict
      host_uri:
        description:
          - The URI of the GitLab Enterprise host this connection is for.
          - If not specified, the default value is https://gitlab.com.
        type: str
      read_authorizer_credential:
        description:
          - A GitLab personal access token with the minimum `read_api` scope access.
        required: true
        suboptions:
          user_token_secret_version:
            description:
              - A SecretManager resource containing the user token that authorizes the Cloud Build connection.
              - 'Format: `projects/*/secrets/*/versions/*`.'
            required: true
            type: str
          username:
            description:
              - Output only.
              - The username associated to this token.
            type: str
        type: dict
      server_version:
        description:
          - Output only.
          - Version of the GitLab Enterprise server running on the `host_uri`.
        type: str
      service_directory_config:
        description:
          - Configuration for using Service Directory to privately connect to a GitLab Enterprise server.
          - This should only be set if the GitLab Enterprise server is hosted on-premises and not reachable by public internet.
          - If this field is left empty, calls to the GitLab Enterprise server will be made over the public internet.
        suboptions:
          service:
            description:
              - The Service Directory service name.
              - 'Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.'
            required: true
            type: str
        type: dict
      ssl_ca:
        description:
          - SSL certificate to use for requests to GitLab Enterprise.
        type: str
      webhook_secret_secret_version:
        description:
          - SecretManager resource containing the webhook secret of a GitLab Enterprise project, formatted as `projects/*/secrets/*/versions/*`.
          - This property is immutable, to change it, you must delete and recreate the resource.
        required: true
        type: str
    type: dict
  location:
    description:
      - The location for the resource.
    required: true
    type: str
  name:
    description:
      - The resource name of the connection.
      - This property is immutable, to change it, you must delete and recreate the resource.
    required: true
    type: str
  state:
    choices:
      - present
      - absent
    default: present
    description:
      - Whether the resource should exist in GCP.
    type: str
requirements:
  - python >= 3.8
  - requests >= 2.18.4
  - google-auth >= 2.25.1
short_description: Creates a GCP Cloudbuildv2.Connection resource
"""

EXAMPLES = r"""
- name: Create github enterprise connection
  google.cloud.gcp_cloudbuildv2_connection:
    name: ghe_conn
    state: present
    location: us-central1
    github_enterprise_config:
      host_uri: https://github.example.com
      app_id: 12345
      app_installation_id: 67890
      app_slug: my-app
      private_key_secret_version: "projects/{{ gcp_project }}/secrets/github-pk/versions/1"
      webhook_secret_secret_version: "projects/{{ gcp_project }}/secrets/github-webhook/versions/1"
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"

################################################################################

- name: Create github connection
  google.cloud.gcp_cloudbuildv2_connection:
    name: github_conn
    state: present
    location: us-central1
    github_config:
      app_installation_id: 123456
      authorizer_credential:
        oauth_token_secret_version: "projects/{{ gcp_project }}/secrets/github-oauth-token/versions/1"
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"

################################################################################

- name: Create gitlab connection
  google.cloud.gcp_cloudbuildv2_connection:
    name: gitlab_conn
    state: present
    location: us-central1
    gitlab_config:
      authorizer_credential:
        user_token_secret_version: "projects/{{ gcp_project }}/secrets/gitlab-api-token/versions/3"
      read_authorizer_credential:
        user_token_secret_version: "projects/{{ gcp_project }}/secrets/gitlab-read-api-token/versions/1"
      webhook_secret_secret_version: "projects/{{ gcp_project }}/secrets/gitlab-webhook/versions/4"
      host_uri: https://gitlab.example.com  # if unset, defaults to gitlab.com
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
"""

RETURN = r"""
changed:
  description: Whether the resource was changed.
  returned: always
  type: bool
createTime:
  description:
    - Output only.
    - Server assigned timestamp for when the connection was created.
  returned: success
  type: str
etag:
  description:
    - >-
      This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the

      client has an up-to-date value before proceeding.
  returned: success
  type: str
installationState:
  contains:
    actionUri:
      description:
        - Output only.
        - Link to follow for next action.
        - Empty string if the installation is already complete.
      returned: success
      type: str
    message:
      description:
        - Output only.
        - Message of what the user should do next to continue the installation.
        - Empty string if the installation is already complete.
      returned: success
      type: str
    stage:
      description:
        - Output only.
        - Current step of the installation process.
      returned: success
      type: str
  description:
    - Output only.
    - Installation state of the Connection.
  returned: success
  type: dict
reconciling:
  description:
    - Output only.
    - Set to true when the connection is being set up or updated in the background.
  returned: success
  type: bool
state:
  description: The current state of the resource.
  returned: always
  type: str
updateTime:
  description:
    - Output only.
    - Server assigned timestamp for when the connection was updated.
  returned: success
  type: str
"""

################################################################################
# Imports
################################################################################

from ansible_collections.google.cloud.plugins.module_utils import gcp_utils as gcp
import copy

# BEGIN Custom imports
# END Custom imports


def build_link(module, uri):
    params = module.params.copy()

    return "https://cloudbuild.googleapis.com/v2/" + uri.format(**params)


class BitbucketCloudConfig(gcp.Resource):
    def _request(self):
        return {
            "authorizerCredential": BitbucketCloudConfigAuthorizerCredential(
                self.request.get("authorizer_credential", {})
            ).to_request(),
            "readAuthorizerCredential": BitbucketCloudConfigReadAuthorizerCredential(
                self.request.get("read_authorizer_credential", {})
            ).to_request(),
            "webhookSecretSecretVersion": self.request.get("webhook_secret_secret_version"),
            "workspace": self.request.get("workspace"),
        }

    def _response(self):
        return {
            "authorizerCredential": BitbucketCloudConfigAuthorizerCredential().from_response(
                self.response.get("authorizerCredential", {})
            ),
            "readAuthorizerCredential": BitbucketCloudConfigReadAuthorizerCredential().from_response(
                self.response.get("readAuthorizerCredential", {})
            ),
            "webhookSecretSecretVersion": self.response.get("webhookSecretSecretVersion"),
            "workspace": self.response.get("workspace"),
        }


class BitbucketCloudConfigAuthorizerCredential(gcp.Resource):
    def _request(self):
        return {
            "userTokenSecretVersion": self.request.get("user_token_secret_version"),
        }

    def _response(self):
        return {
            "userTokenSecretVersion": self.response.get("userTokenSecretVersion"),
            "username": self.response.get("username"),
        }


class BitbucketCloudConfigReadAuthorizerCredential(gcp.Resource):
    def _request(self):
        return {
            "userTokenSecretVersion": self.request.get("user_token_secret_version"),
        }

    def _response(self):
        return {
            "userTokenSecretVersion": self.response.get("userTokenSecretVersion"),
            "username": self.response.get("username"),
        }


class BitbucketDataCenterConfig(gcp.Resource):
    def _request(self):
        return {
            "authorizerCredential": BitbucketDataCenterConfigAuthorizerCredential(
                self.request.get("authorizer_credential", {})
            ).to_request(),
            "hostUri": self.request.get("host_uri"),
            "readAuthorizerCredential": BitbucketDataCenterConfigReadAuthorizerCredential(
                self.request.get("read_authorizer_credential", {})
            ).to_request(),
            "serviceDirectoryConfig": BitbucketDataCenterConfigServiceDirectoryConfig(
                self.request.get("service_directory_config", {})
            ).to_request(),
            "sslCa": self.request.get("ssl_ca"),
            "webhookSecretSecretVersion": self.request.get("webhook_secret_secret_version"),
        }

    def _response(self):
        return {
            "authorizerCredential": BitbucketDataCenterConfigAuthorizerCredential().from_response(
                self.response.get("authorizerCredential", {})
            ),
            "hostUri": self.response.get("hostUri"),
            "readAuthorizerCredential": BitbucketDataCenterConfigReadAuthorizerCredential().from_response(
                self.response.get("readAuthorizerCredential", {})
            ),
            "serverVersion": self.response.get("serverVersion"),
            "serviceDirectoryConfig": BitbucketDataCenterConfigServiceDirectoryConfig().from_response(
                self.response.get("serviceDirectoryConfig", {})
            ),
            "sslCa": self.response.get("sslCa"),
            "webhookSecretSecretVersion": self.response.get("webhookSecretSecretVersion"),
        }


class BitbucketDataCenterConfigAuthorizerCredential(gcp.Resource):
    def _request(self):
        return {
            "userTokenSecretVersion": self.request.get("user_token_secret_version"),
        }

    def _response(self):
        return {
            "userTokenSecretVersion": self.response.get("userTokenSecretVersion"),
            "username": self.response.get("username"),
        }


class BitbucketDataCenterConfigReadAuthorizerCredential(gcp.Resource):
    def _request(self):
        return {
            "userTokenSecretVersion": self.request.get("user_token_secret_version"),
        }

    def _response(self):
        return {
            "userTokenSecretVersion": self.response.get("userTokenSecretVersion"),
            "username": self.response.get("username"),
        }


class BitbucketDataCenterConfigServiceDirectoryConfig(gcp.Resource):
    def _request(self):
        return {
            "service": self.request.get("service"),
        }

    def _response(self):
        return {
            "service": self.response.get("service"),
        }


class GithubConfig(gcp.Resource):
    def _request(self):
        return {
            "appInstallationId": self.request.get("app_installation_id"),
            "authorizerCredential": GithubConfigAuthorizerCredential(
                self.request.get("authorizer_credential", {})
            ).to_request(),
        }

    def _response(self):
        return {
            "appInstallationId": self.response.get("appInstallationId"),
            "authorizerCredential": GithubConfigAuthorizerCredential().from_response(
                self.response.get("authorizerCredential", {})
            ),
        }


class GithubConfigAuthorizerCredential(gcp.Resource):
    def _request(self):
        return {
            "oauthTokenSecretVersion": self.request.get("oauth_token_secret_version"),
        }

    def _response(self):
        return {
            "oauthTokenSecretVersion": self.response.get("oauthTokenSecretVersion"),
            "username": self.response.get("username"),
        }


class GithubEnterpriseConfig(gcp.Resource):
    def _request(self):
        return {
            "appId": self.request.get("app_id"),
            "appInstallationId": self.request.get("app_installation_id"),
            "appSlug": self.request.get("app_slug"),
            "hostUri": self.request.get("host_uri"),
            "privateKeySecretVersion": self.request.get("private_key_secret_version"),
            "serviceDirectoryConfig": GithubEnterpriseConfigServiceDirectoryConfig(
                self.request.get("service_directory_config", {})
            ).to_request(),
            "sslCa": self.request.get("ssl_ca"),
            "webhookSecretSecretVersion": self.request.get("webhook_secret_secret_version"),
        }

    def _response(self):
        return {
            "appId": self.response.get("appId"),
            "appInstallationId": self.response.get("appInstallationId"),
            "appSlug": self.response.get("appSlug"),
            "hostUri": self.response.get("hostUri"),
            "privateKeySecretVersion": self.response.get("privateKeySecretVersion"),
            "serviceDirectoryConfig": GithubEnterpriseConfigServiceDirectoryConfig().from_response(
                self.response.get("serviceDirectoryConfig", {})
            ),
            "sslCa": self.response.get("sslCa"),
            "webhookSecretSecretVersion": self.response.get("webhookSecretSecretVersion"),
        }


class GithubEnterpriseConfigServiceDirectoryConfig(gcp.Resource):
    def _request(self):
        return {
            "service": self.request.get("service"),
        }

    def _response(self):
        return {
            "service": self.response.get("service"),
        }


class GitlabConfig(gcp.Resource):
    def _request(self):
        return {
            "authorizerCredential": GitlabConfigAuthorizerCredential(
                self.request.get("authorizer_credential", {})
            ).to_request(),
            "hostUri": self.request.get("host_uri"),
            "readAuthorizerCredential": GitlabConfigReadAuthorizerCredential(
                self.request.get("read_authorizer_credential", {})
            ).to_request(),
            "serviceDirectoryConfig": GitlabConfigServiceDirectoryConfig(
                self.request.get("service_directory_config", {})
            ).to_request(),
            "sslCa": self.request.get("ssl_ca"),
            "webhookSecretSecretVersion": self.request.get("webhook_secret_secret_version"),
        }

    def _response(self):
        return {
            "authorizerCredential": GitlabConfigAuthorizerCredential().from_response(
                self.response.get("authorizerCredential", {})
            ),
            "hostUri": self.response.get("hostUri"),
            "readAuthorizerCredential": GitlabConfigReadAuthorizerCredential().from_response(
                self.response.get("readAuthorizerCredential", {})
            ),
            "serverVersion": self.response.get("serverVersion"),
            "serviceDirectoryConfig": GitlabConfigServiceDirectoryConfig().from_response(
                self.response.get("serviceDirectoryConfig", {})
            ),
            "sslCa": self.response.get("sslCa"),
            "webhookSecretSecretVersion": self.response.get("webhookSecretSecretVersion"),
        }


class GitlabConfigAuthorizerCredential(gcp.Resource):
    def _request(self):
        return {
            "userTokenSecretVersion": self.request.get("user_token_secret_version"),
        }

    def _response(self):
        return {
            "userTokenSecretVersion": self.response.get("userTokenSecretVersion"),
            "username": self.response.get("username"),
        }


class GitlabConfigReadAuthorizerCredential(gcp.Resource):
    def _request(self):
        return {
            "userTokenSecretVersion": self.request.get("user_token_secret_version"),
        }

    def _response(self):
        return {
            "userTokenSecretVersion": self.response.get("userTokenSecretVersion"),
            "username": self.response.get("username"),
        }


class GitlabConfigServiceDirectoryConfig(gcp.Resource):
    def _request(self):
        return {
            "service": self.request.get("service"),
        }

    def _response(self):
        return {
            "service": self.response.get("service"),
        }


class InstallationState(gcp.Resource):
    def _response(self):
        return {
            "actionUri": self.response.get("actionUri"),
            "message": self.response.get("message"),
            "stage": self.response.get("stage"),
        }


class Cloudbuildv2(gcp.Resource):
    def _request(self):
        return {
            "annotations": self.request.get("annotations"),
            "bitbucketCloudConfig": BitbucketCloudConfig(self.request.get("bitbucket_cloud_config", {})).to_request(),
            "bitbucketDataCenterConfig": BitbucketDataCenterConfig(
                self.request.get("bitbucket_data_center_config", {})
            ).to_request(),
            "disabled": self.request.get("disabled"),
            "githubConfig": GithubConfig(self.request.get("github_config", {})).to_request(),
            "githubEnterpriseConfig": GithubEnterpriseConfig(
                self.request.get("github_enterprise_config", {})
            ).to_request(),
            "gitlabConfig": GitlabConfig(self.request.get("gitlab_config", {})).to_request(),
        }

    def _response(self):
        return {
            "annotations": self.response.get("annotations"),
            "bitbucketCloudConfig": BitbucketCloudConfig().from_response(self.response.get("bitbucketCloudConfig", {})),
            "bitbucketDataCenterConfig": BitbucketDataCenterConfig().from_response(
                self.response.get("bitbucketDataCenterConfig", {})
            ),
            "createTime": self.response.get("createTime"),
            "disabled": self.response.get("disabled"),
            "etag": self.response.get("etag"),
            "githubConfig": GithubConfig().from_response(self.response.get("githubConfig", {})),
            "githubEnterpriseConfig": GithubEnterpriseConfig().from_response(
                self.response.get("githubEnterpriseConfig", {})
            ),
            "gitlabConfig": GitlabConfig().from_response(self.response.get("gitlabConfig", {})),
            "installationState": InstallationState().from_response(self.response.get("installationState", {})),
            "reconciling": self.response.get("reconciling"),
            "updateTime": self.response.get("updateTime"),
        }


################################################################################
# Main
################################################################################


def encode(obj):
    """
    The encoder is a function which take the `obj` map after it has been
    assembled in either "Create" or "Update" and mutate it before it is sent to
    the server
    """

    if obj is None:
        return None
    r = copy.deepcopy(obj)
    # --------- BEGIN custom encoder code ---------
    # --------- END custom encoder code ---------

    return r


def decode(obj):
    """
    The decoder is a function which takes the `obj` map after the read succeeds
    and mutates it before it is returned to the module caller
    """

    if obj is None:
        return None
    r = copy.deepcopy(obj)
    # --------- BEGIN custom decoder code ---------
    # disabled key doesn't seem to appear consistently for gitlab,
    # set to the default if missing
    if "disabled" not in r.keys():
        r["disabled"] = False

    # the github app id returned from the API shows as a string,
    # and the input is an int, when running comparison they will be
    # incorrectly show as diff
    if r.get("githubConfig") is not None:
        r["githubConfig"]["appInstallationId"] = int(obj["githubConfig"]["appInstallationId"])
    # same for GHE
    if r.get("githubEnterpriseConfig") is not None:
        r["githubEnterpriseConfig"]["appInstallationId"] = int(obj["githubEnterpriseConfig"]["appInstallationId"])
    # --------- END custom decoder code ---------

    return r


def main():
    """Main function"""

    module = gcp.Module(
        argument_spec=dict(
            name=dict(
                type="str",
                required=True,
            ),
            state=dict(
                type="str",
                default="present",
                choices=["present", "absent"],
            ),
            annotations=dict(
                type="dict",
            ),
            bitbucket_cloud_config=dict(
                type="dict",
                options=dict(
                    authorizer_credential=dict(
                        type="dict",
                        required=True,
                        no_log=False,
                        options=dict(
                            user_token_secret_version=dict(
                                type="str",
                                required=True,
                                no_log=False,
                            ),
                            username=dict(
                                type="str",
                            ),
                        ),
                    ),
                    read_authorizer_credential=dict(
                        type="dict",
                        required=True,
                        no_log=False,
                        options=dict(
                            user_token_secret_version=dict(
                                type="str",
                                required=True,
                                no_log=False,
                            ),
                            username=dict(
                                type="str",
                            ),
                        ),
                    ),
                    webhook_secret_secret_version=dict(
                        type="str",
                        required=True,
                        no_log=False,
                    ),
                    workspace=dict(
                        type="str",
                        required=True,
                    ),
                ),
            ),
            bitbucket_data_center_config=dict(
                type="dict",
                options=dict(
                    authorizer_credential=dict(
                        type="dict",
                        required=True,
                        no_log=False,
                        options=dict(
                            user_token_secret_version=dict(
                                type="str",
                                required=True,
                                no_log=False,
                            ),
                            username=dict(
                                type="str",
                            ),
                        ),
                    ),
                    host_uri=dict(
                        type="str",
                        required=True,
                    ),
                    read_authorizer_credential=dict(
                        type="dict",
                        required=True,
                        no_log=False,
                        options=dict(
                            user_token_secret_version=dict(
                                type="str",
                                required=True,
                                no_log=False,
                            ),
                            username=dict(
                                type="str",
                            ),
                        ),
                    ),
                    server_version=dict(
                        type="str",
                    ),
                    service_directory_config=dict(
                        type="dict",
                        options=dict(
                            service=dict(
                                type="str",
                                required=True,
                            )
                        ),
                    ),
                    ssl_ca=dict(
                        type="str",
                    ),
                    webhook_secret_secret_version=dict(
                        type="str",
                        required=True,
                        no_log=False,
                    ),
                ),
            ),
            disabled=dict(
                type="bool",
            ),
            github_config=dict(
                type="dict",
                options=dict(
                    app_installation_id=dict(
                        type="int",
                    ),
                    authorizer_credential=dict(
                        type="dict",
                        no_log=False,
                        options=dict(
                            oauth_token_secret_version=dict(
                                type="str",
                                no_log=False,
                            ),
                            username=dict(
                                type="str",
                            ),
                        ),
                    ),
                ),
            ),
            github_enterprise_config=dict(
                type="dict",
                options=dict(
                    app_id=dict(
                        type="int",
                    ),
                    app_installation_id=dict(
                        type="int",
                    ),
                    app_slug=dict(
                        type="str",
                    ),
                    host_uri=dict(
                        type="str",
                        required=True,
                    ),
                    private_key_secret_version=dict(
                        type="str",
                        no_log=False,
                    ),
                    service_directory_config=dict(
                        type="dict",
                        options=dict(
                            service=dict(
                                type="str",
                                required=True,
                            )
                        ),
                    ),
                    ssl_ca=dict(
                        type="str",
                    ),
                    webhook_secret_secret_version=dict(
                        type="str",
                        no_log=False,
                    ),
                ),
            ),
            gitlab_config=dict(
                type="dict",
                options=dict(
                    authorizer_credential=dict(
                        type="dict",
                        required=True,
                        no_log=False,
                        options=dict(
                            user_token_secret_version=dict(
                                type="str",
                                required=True,
                                no_log=False,
                            ),
                            username=dict(
                                type="str",
                            ),
                        ),
                    ),
                    host_uri=dict(
                        type="str",
                    ),
                    read_authorizer_credential=dict(
                        type="dict",
                        required=True,
                        no_log=False,
                        options=dict(
                            user_token_secret_version=dict(
                                type="str",
                                required=True,
                                no_log=False,
                            ),
                            username=dict(
                                type="str",
                            ),
                        ),
                    ),
                    server_version=dict(
                        type="str",
                    ),
                    service_directory_config=dict(
                        type="dict",
                        options=dict(
                            service=dict(
                                type="str",
                                required=True,
                            )
                        ),
                    ),
                    ssl_ca=dict(
                        type="str",
                    ),
                    webhook_secret_secret_version=dict(
                        type="str",
                        required=True,
                        no_log=False,
                    ),
                ),
            ),
            location=dict(
                type="str",
                required=True,
            ),
        ),
        mutually_exclusive=[
            [
                "bitbucket_cloud_config",
                "bitbucket_data_center_config",
                "github_config",
                "github_enterprise_config",
                "gitlab_config",
            ]
        ],
    )

    if not module.params["scopes"]:
        module.params["scopes"] = ["https://www.googleapis.com/auth/cloud-platform"]

    state = module.params["state"]
    changed = False

    op_configs = gcp.ResourceOpConfigs(
        {
            "create": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/connections?connectionId={name}",
                    "async_uri": "{op_id}",
                    "verb": "POST",
                    "timeout_minutes": 20,
                }
            ),
            "delete": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/connections/{name}",
                    "async_uri": "{op_id}",
                    "verb": "DELETE",
                    "timeout_minutes": 20,
                }
            ),
            "read": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/connections/{name}",
                    "async_uri": "",
                    "verb": "GET",
                    "timeout_minutes": 0,
                }
            ),
            "update": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/connections/{name}",
                    "async_uri": "{op_id}",
                    "verb": "PATCH",
                    "timeout_minutes": 20,
                }
            ),
        }
    )

    params = gcp.remove_nones_from_dict(module.params)
    resource = Cloudbuildv2(params, module=module, product="Cloudbuildv2", kind="cloudbuildv2#connection")
    existing_obj = decode(resource.get(build_link(module, op_configs.read.uri), allow_not_found=True))

    if existing_obj is None:
        if state == "present":
            is_async = op_configs.create.async_uri != ""
            create_link = build_link(module, op_configs.create.uri)
            create_retries = op_configs.create.timeout
            create_func = getattr(resource, op_configs.create.verb)
            async_create_func = getattr(resource, op_configs.create.verb + "_async")
            async_create_link = build_link(module, "") + op_configs.create.async_uri
            # --------- BEGIN custom pre-create code ---------
            # --------- END custom pre-create code ---------
            gcp.debug(
                module,
                msg="Creating resource",
                create_link=create_link,
                async_create_link=async_create_link,
                is_async=is_async,
            )
            try:
                if is_async:
                    new_obj = async_create_func(create_link, async_link=async_create_link, retries=create_retries)
                else:
                    new_obj = create_func(create_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            pass  # nothing to do
    else:
        if state == "absent":
            is_async = op_configs.delete.async_uri != ""
            delete_link = build_link(module, op_configs.delete.uri)
            delete_retries = op_configs.delete.timeout
            delete_func = getattr(resource, op_configs.delete.verb)
            async_delete_func = getattr(resource, op_configs.delete.verb + "_async")
            async_delete_link = build_link(module, "") + op_configs.delete.async_uri
            # --------- BEGIN custom pre-delete code ---------
            # --------- END custom pre-delete code ---------
            gcp.debug(
                module,
                msg="Destroying resource",
                delete_link=delete_link,
                async_delete_link=async_delete_link,
                is_async=is_async,
            )
            try:
                if is_async:
                    new_obj = async_delete_func(delete_link, async_link=async_delete_link, retries=delete_retries)
                else:
                    new_obj = delete_func(delete_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            gcp.debug(module, existing=existing_obj, request=resource.to_request())
            if resource.diff(existing_obj):
                is_async = op_configs.update.async_uri != ""
                update_link = build_link(module, op_configs.update.uri)
                update_retries = op_configs.update.timeout
                update_func = getattr(resource, op_configs.update.verb)
                async_update_func = getattr(resource, op_configs.update.verb + "_async")
                async_update_link = build_link(module, "") + op_configs.update.async_uri
                # --------- BEGIN custom pre-update code ---------
                # --------- END custom pre-update code ---------
                gcp.debug(
                    module,
                    msg="Updating resource",
                    update_link=update_link,
                    async_update_link=async_update_link,
                    is_async=is_async,
                )
                try:
                    if is_async:
                        new_obj = async_update_func(update_link, async_link=async_update_link, retries=update_retries)
                    else:
                        new_obj = update_func(update_link)
                except Exception as e:
                    module.fail_json(msg=str(e))
                changed = True

    new_obj = decode(resource.get(build_link(module, op_configs.read.uri), allow_not_found=True))
    new_obj = resource.from_response(new_obj or {})

    new_obj.update({"changed": changed})
    module.exit_json(**new_obj)


if __name__ == "__main__":
    main()
