//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_RENDER_PRODUCT_SCHEMA_H
#define PXR_IMAGING_HD_RENDER_PRODUCT_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"
#include "pxr/imaging/hd/schemaTypeDefs.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_RENDER_PRODUCT_SCHEMA_TOKENS \
    (renderProduct) \
    (path) \
    (type) \
    (name) \
    (resolution) \
    (renderVars) \
    (cameraPrim) \
    (pixelAspectRatio) \
    (aspectRatioConformPolicy) \
    (apertureSize) \
    (dataWindowNDC) \
    (disableMotionBlur) \
    (disableDepthOfField) \
    (namespacedSettings) \

TF_DECLARE_PUBLIC_TOKENS(HdRenderProductSchemaTokens, HD_API,
    HD_RENDER_PRODUCT_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class HdRenderProductSchema
///
class HdRenderProductSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdRenderProductSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "renderProduct" from the parent container and constructs a
    /// HdRenderProductSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdRenderProductSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HD_API
    HdPathDataSourceHandle GetPath() const;

    HD_API
    HdTokenDataSourceHandle GetType() const;

    HD_API
    HdTokenDataSourceHandle GetName() const;

    HD_API
    HdVec2iDataSourceHandle GetResolution() const;

    HD_API
    HdRenderVarVectorSchema GetRenderVars() const;

    HD_API
    HdPathDataSourceHandle GetCameraPrim() const;

    HD_API
    HdFloatDataSourceHandle GetPixelAspectRatio() const;

    HD_API
    HdTokenDataSourceHandle GetAspectRatioConformPolicy() const;

    HD_API
    HdVec2fDataSourceHandle GetApertureSize() const;

    HD_API
    HdVec4fDataSourceHandle GetDataWindowNDC() const;

    HD_API
    HdBoolDataSourceHandle GetDisableMotionBlur() const;

    HD_API
    HdBoolDataSourceHandle GetDisableDepthOfField() const;

    HD_API
    HdContainerDataSourceHandle GetNamespacedSettings() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate resolution.
    HD_API
    static const HdDataSourceLocator &GetResolutionLocator();

    /// Prim-level relative data source locator to locate renderVars.
    HD_API
    static const HdDataSourceLocator &GetRenderVarsLocator();

    /// Prim-level relative data source locator to locate namespacedSettings.
    HD_API
    static const HdDataSourceLocator &GetNamespacedSettingsLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdPathDataSourceHandle &path,
        const HdTokenDataSourceHandle &type,
        const HdTokenDataSourceHandle &name,
        const HdVec2iDataSourceHandle &resolution,
        const HdVectorDataSourceHandle &renderVars,
        const HdPathDataSourceHandle &cameraPrim,
        const HdFloatDataSourceHandle &pixelAspectRatio,
        const HdTokenDataSourceHandle &aspectRatioConformPolicy,
        const HdVec2fDataSourceHandle &apertureSize,
        const HdVec4fDataSourceHandle &dataWindowNDC,
        const HdBoolDataSourceHandle &disableMotionBlur,
        const HdBoolDataSourceHandle &disableDepthOfField,
        const HdContainerDataSourceHandle &namespacedSettings
    );

    /// \class HdRenderProductSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetPath(
            const HdPathDataSourceHandle &path);
        HD_API
        Builder &SetType(
            const HdTokenDataSourceHandle &type);
        HD_API
        Builder &SetName(
            const HdTokenDataSourceHandle &name);
        HD_API
        Builder &SetResolution(
            const HdVec2iDataSourceHandle &resolution);
        HD_API
        Builder &SetRenderVars(
            const HdVectorDataSourceHandle &renderVars);
        HD_API
        Builder &SetCameraPrim(
            const HdPathDataSourceHandle &cameraPrim);
        HD_API
        Builder &SetPixelAspectRatio(
            const HdFloatDataSourceHandle &pixelAspectRatio);
        HD_API
        Builder &SetAspectRatioConformPolicy(
            const HdTokenDataSourceHandle &aspectRatioConformPolicy);
        HD_API
        Builder &SetApertureSize(
            const HdVec2fDataSourceHandle &apertureSize);
        HD_API
        Builder &SetDataWindowNDC(
            const HdVec4fDataSourceHandle &dataWindowNDC);
        HD_API
        Builder &SetDisableMotionBlur(
            const HdBoolDataSourceHandle &disableMotionBlur);
        HD_API
        Builder &SetDisableDepthOfField(
            const HdBoolDataSourceHandle &disableDepthOfField);
        HD_API
        Builder &SetNamespacedSettings(
            const HdContainerDataSourceHandle &namespacedSettings);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdPathDataSourceHandle _path;
        HdTokenDataSourceHandle _type;
        HdTokenDataSourceHandle _name;
        HdVec2iDataSourceHandle _resolution;
        HdVectorDataSourceHandle _renderVars;
        HdPathDataSourceHandle _cameraPrim;
        HdFloatDataSourceHandle _pixelAspectRatio;
        HdTokenDataSourceHandle _aspectRatioConformPolicy;
        HdVec2fDataSourceHandle _apertureSize;
        HdVec4fDataSourceHandle _dataWindowNDC;
        HdBoolDataSourceHandle _disableMotionBlur;
        HdBoolDataSourceHandle _disableDepthOfField;
        HdContainerDataSourceHandle _namespacedSettings;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif