/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.io.IOException;
import java.security.KeyException;
import java.security.KeyStoreException;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtilBase;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;
import org.apache.tomcat.util.net.openssl.OpenSSLContext;
import org.apache.tomcat.util.net.openssl.OpenSSLEngine;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLUtil
extends SSLUtilBase {
    private static final Log log = LogFactory.getLog(OpenSSLUtil.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLUtil.class);

    public OpenSSLUtil(SSLHostConfigCertificate sSLHostConfigCertificate) {
        super(sSLHostConfigCertificate);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Set<String> getImplementedProtocols() {
        return OpenSSLEngine.IMPLEMENTED_PROTOCOLS_SET;
    }

    @Override
    protected Set<String> getImplementedCiphers() {
        return OpenSSLEngine.AVAILABLE_CIPHER_SUITES;
    }

    @Override
    protected boolean isTls13RenegAuthAvailable() {
        return true;
    }

    @Override
    public SSLContext createSSLContextInternal(List<String> list) throws Exception {
        return new OpenSSLContext(this.certificate, list);
    }

    @Deprecated
    public static X509KeyManager chooseKeyManager(KeyManager[] keyManagerArray) throws Exception {
        return OpenSSLUtil.chooseKeyManager(keyManagerArray, true);
    }

    public static X509KeyManager chooseKeyManager(KeyManager[] keyManagerArray, boolean bl) throws Exception {
        if (keyManagerArray == null) {
            return null;
        }
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof JSSEKeyManager)) continue;
            return (JSSEKeyManager)keyManager;
        }
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        if (bl) {
            throw new IllegalStateException(sm.getString("openssl.keyManagerMissing"));
        }
        log.warn((Object)sm.getString("openssl.keyManagerMissing.warn"));
        return null;
    }

    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        try {
            return super.getKeyManagers();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = sm.getString("openssl.nonJsseChain", new Object[]{this.certificate.getCertificateChainFile()});
            if (log.isDebugEnabled()) {
                log.debug((Object)string, (Throwable)illegalArgumentException);
            } else {
                log.info((Object)string);
            }
            return null;
        }
        catch (IOException | KeyException | KeyStoreException exception) {
            if (this.certificate.getCertificateFile() != null) {
                String string = sm.getString("openssl.nonJsseCertificate", new Object[]{this.certificate.getCertificateFile(), this.certificate.getCertificateKeyFile()});
                if (log.isDebugEnabled()) {
                    log.debug((Object)string, (Throwable)exception);
                } else {
                    log.info((Object)string);
                }
                return null;
            }
            throw exception;
        }
    }
}

