/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.jsp.tagext.PageData;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.TagConstants;
import org.apache.tomcat.util.security.Escape;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class PageDataImpl
extends PageData
implements TagConstants {
    private static final String JSP_VERSION = "2.0";
    private static final String CDATA_START_SECTION = "<![CDATA[\n";
    private static final String CDATA_END_SECTION = "]]>\n";
    private final StringBuilder buf;

    PageDataImpl(Node.Nodes nodes, Compiler compiler) throws JasperException {
        FirstPassVisitor firstPassVisitor = new FirstPassVisitor(nodes.getRoot(), compiler.getPageInfo());
        nodes.visit(firstPassVisitor);
        this.buf = new StringBuilder();
        SecondPassVisitor secondPassVisitor = new SecondPassVisitor(nodes.getRoot(), this.buf, compiler, firstPassVisitor.getJspIdPrefix());
        nodes.visit(secondPassVisitor);
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static class FirstPassVisitor
    extends Node.Visitor
    implements TagConstants {
        private final Node.Root root;
        private final AttributesImpl rootAttrs;
        private final PageInfo pageInfo;
        private String jspIdPrefix;

        FirstPassVisitor(Node.Root root, PageInfo pageInfo) {
            this.root = root;
            this.pageInfo = pageInfo;
            this.rootAttrs = new AttributesImpl();
            this.rootAttrs.addAttribute("", "", "version", "CDATA", PageDataImpl.JSP_VERSION);
            this.jspIdPrefix = "jsp";
        }

        @Override
        public void visit(Node.Root root) throws JasperException {
            this.visitBody(root);
            if (root == this.root) {
                if (!"http://java.sun.com/JSP/Page".equals(this.rootAttrs.getValue("xmlns:jsp"))) {
                    this.rootAttrs.addAttribute("", "", "xmlns:jsp", "CDATA", "http://java.sun.com/JSP/Page");
                }
                if (this.pageInfo.isJspPrefixHijacked()) {
                    do {
                        this.jspIdPrefix = this.jspIdPrefix + "jsp";
                    } while (this.pageInfo.containsPrefix(this.jspIdPrefix));
                    this.rootAttrs.addAttribute("", "", "xmlns:" + this.jspIdPrefix, "CDATA", "http://java.sun.com/JSP/Page");
                }
                this.root.setAttributes(this.rootAttrs);
            }
        }

        @Override
        public void visit(Node.JspRoot jspRoot) throws JasperException {
            this.addAttributes(jspRoot.getTaglibAttributes());
            this.addAttributes(jspRoot.getNonTaglibXmlnsAttributes());
            this.addAttributes(jspRoot.getAttributes());
            this.visitBody(jspRoot);
        }

        @Override
        public void visit(Node.TaglibDirective taglibDirective) throws JasperException {
            String string;
            Attributes attributes = taglibDirective.getAttributes();
            if (attributes != null && this.rootAttrs.getIndex(string = "xmlns:" + attributes.getValue("prefix")) == -1) {
                String string2 = attributes.getValue("uri");
                if (string2 != null) {
                    if (string2.startsWith("/")) {
                        string2 = "urn:jsptld:" + string2;
                    }
                    this.rootAttrs.addAttribute("", "", string, "CDATA", string2);
                } else {
                    string2 = attributes.getValue("tagdir");
                    this.rootAttrs.addAttribute("", "", string, "CDATA", "urn:jsptagdir:" + string2);
                }
            }
        }

        public String getJspIdPrefix() {
            return this.jspIdPrefix;
        }

        private void addAttributes(Attributes attributes) {
            if (attributes != null) {
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    String string = attributes.getQName(i);
                    if ("version".equals(string) || this.rootAttrs.getIndex(string) != -1) continue;
                    this.rootAttrs.addAttribute(attributes.getURI(i), attributes.getLocalName(i), string, attributes.getType(i), attributes.getValue(i));
                }
            }
        }
    }

    private static class SecondPassVisitor
    extends Node.Visitor
    implements TagConstants {
        private final Node.Root root;
        private final StringBuilder buf;
        private final Compiler compiler;
        private final String jspIdPrefix;
        private boolean resetDefaultNS = false;
        private int jspId;

        SecondPassVisitor(Node.Root root, StringBuilder stringBuilder, Compiler compiler, String string) {
            this.root = root;
            this.buf = stringBuilder;
            this.compiler = compiler;
            this.jspIdPrefix = string;
        }

        @Override
        public void visit(Node.Root root) throws JasperException {
            if (root == this.root) {
                this.appendXmlProlog();
                this.appendTag(root);
            } else {
                boolean bl = this.resetDefaultNS;
                if (root.isXmlSyntax()) {
                    this.resetDefaultNS = true;
                }
                this.visitBody(root);
                this.resetDefaultNS = bl;
            }
        }

        @Override
        public void visit(Node.JspRoot jspRoot) throws JasperException {
            this.visitBody(jspRoot);
        }

        @Override
        public void visit(Node.PageDirective pageDirective) throws JasperException {
            this.appendPageDirective(pageDirective);
        }

        @Override
        public void visit(Node.IncludeDirective includeDirective) throws JasperException {
            this.visitBody(includeDirective);
        }

        @Override
        public void visit(Node.Comment comment) throws JasperException {
        }

        @Override
        public void visit(Node.Declaration declaration) throws JasperException {
            this.appendTag(declaration);
        }

        @Override
        public void visit(Node.Expression expression) throws JasperException {
            this.appendTag(expression);
        }

        @Override
        public void visit(Node.Scriptlet scriptlet) throws JasperException {
            this.appendTag(scriptlet);
        }

        @Override
        public void visit(Node.JspElement jspElement) throws JasperException {
            this.appendTag(jspElement);
        }

        @Override
        public void visit(Node.ELExpression eLExpression) throws JasperException {
            if (!eLExpression.getRoot().isXmlSyntax()) {
                this.buf.append('<').append("jsp:text");
                this.buf.append(' ');
                this.buf.append(this.jspIdPrefix);
                this.buf.append(":id=\"");
                this.buf.append(this.jspId++).append("\">");
            }
            this.buf.append("${");
            this.buf.append(Escape.xml((String)eLExpression.getText()));
            this.buf.append('}');
            if (!eLExpression.getRoot().isXmlSyntax()) {
                this.buf.append("</jsp:text>");
            }
            this.buf.append("\n");
        }

        @Override
        public void visit(Node.IncludeAction includeAction) throws JasperException {
            this.appendTag(includeAction);
        }

        @Override
        public void visit(Node.ForwardAction forwardAction) throws JasperException {
            this.appendTag(forwardAction);
        }

        @Override
        public void visit(Node.GetProperty getProperty) throws JasperException {
            this.appendTag(getProperty);
        }

        @Override
        public void visit(Node.SetProperty setProperty) throws JasperException {
            this.appendTag(setProperty);
        }

        @Override
        public void visit(Node.ParamAction paramAction) throws JasperException {
            this.appendTag(paramAction);
        }

        @Override
        public void visit(Node.ParamsAction paramsAction) throws JasperException {
            this.appendTag(paramsAction);
        }

        @Override
        public void visit(Node.FallBackAction fallBackAction) throws JasperException {
            this.appendTag(fallBackAction);
        }

        @Override
        public void visit(Node.UseBean useBean) throws JasperException {
            this.appendTag(useBean);
        }

        @Override
        public void visit(Node.PlugIn plugIn) throws JasperException {
            this.appendTag(plugIn);
        }

        @Override
        public void visit(Node.NamedAttribute namedAttribute) throws JasperException {
            this.appendTag(namedAttribute);
        }

        @Override
        public void visit(Node.JspBody jspBody) throws JasperException {
            this.appendTag(jspBody);
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            boolean bl = this.resetDefaultNS;
            this.appendTag(customTag, this.resetDefaultNS);
            this.resetDefaultNS = bl;
        }

        @Override
        public void visit(Node.UninterpretedTag uninterpretedTag) throws JasperException {
            boolean bl = this.resetDefaultNS;
            this.appendTag(uninterpretedTag, this.resetDefaultNS);
            this.resetDefaultNS = bl;
        }

        @Override
        public void visit(Node.JspText jspText) throws JasperException {
            this.appendTag(jspText);
        }

        @Override
        public void visit(Node.DoBodyAction doBodyAction) throws JasperException {
            this.appendTag(doBodyAction);
        }

        @Override
        public void visit(Node.InvokeAction invokeAction) throws JasperException {
            this.appendTag(invokeAction);
        }

        @Override
        public void visit(Node.TagDirective tagDirective) throws JasperException {
            this.appendTagDirective(tagDirective);
        }

        @Override
        public void visit(Node.AttributeDirective attributeDirective) throws JasperException {
            this.appendTag(attributeDirective);
        }

        @Override
        public void visit(Node.VariableDirective variableDirective) throws JasperException {
            this.appendTag(variableDirective);
        }

        @Override
        public void visit(Node.TemplateText templateText) throws JasperException {
            this.appendText(templateText.getText(), !templateText.getRoot().isXmlSyntax());
        }

        private void appendTag(Node node) throws JasperException {
            this.appendTag(node, false);
        }

        private void appendTag(Node node, boolean bl) throws JasperException {
            Node.Nodes nodes = node.getBody();
            String string = node.getText();
            this.buf.append('<').append(node.getQName());
            this.buf.append("\n");
            this.printAttributes(node, bl);
            this.buf.append("  ").append(this.jspIdPrefix).append(":id").append("=\"");
            this.buf.append(this.jspId++).append("\"\n");
            if ("root".equals(node.getLocalName()) || nodes != null || string != null) {
                this.buf.append(">\n");
                if ("root".equals(node.getLocalName())) {
                    if (this.compiler.getCompilationContext().isTagFile()) {
                        this.appendTagDirective();
                    } else {
                        this.appendPageDirective();
                    }
                }
                if (nodes != null) {
                    nodes.visit(this);
                } else {
                    this.appendText(string, false);
                }
                this.buf.append("</").append(node.getQName()).append(">\n");
            } else {
                this.buf.append("/>\n");
            }
        }

        private void appendPageDirective(Node.PageDirective pageDirective) {
            Object object;
            int n;
            boolean bl = false;
            Attributes attributes = pageDirective.getAttributes();
            int n2 = attributes == null ? 0 : attributes.getLength();
            for (n = 0; n < n2; ++n) {
                object = attributes.getQName(n);
                if ("pageEncoding".equals(object) || "contentType".equals(object)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            this.buf.append('<').append(pageDirective.getQName());
            this.buf.append("\n");
            this.buf.append("  ").append(this.jspIdPrefix).append(":id").append("=\"");
            this.buf.append(this.jspId++).append("\"\n");
            for (n = 0; n < n2; ++n) {
                object = attributes.getQName(n);
                if ("import".equals(object) || "contentType".equals(object) || "pageEncoding".equals(object)) continue;
                String string = attributes.getValue(n);
                this.buf.append("  ").append((String)object).append("=\"");
                this.buf.append(JspUtil.getExprInXml(string)).append("\"\n");
            }
            if (!pageDirective.getImports().isEmpty()) {
                n = 1;
                for (String string : pageDirective.getImports()) {
                    if (n != 0) {
                        n = 0;
                        this.buf.append("  import=\"");
                    } else {
                        this.buf.append(',');
                    }
                    this.buf.append(JspUtil.getExprInXml(string));
                }
                this.buf.append("\"\n");
            }
            this.buf.append("/>\n");
        }

        private void appendPageDirective() {
            this.buf.append('<').append("jsp:directive.page");
            this.buf.append("\n");
            this.buf.append("  ").append(this.jspIdPrefix).append(":id").append("=\"");
            this.buf.append(this.jspId++).append("\"\n");
            this.buf.append("  ").append("pageEncoding").append("=\"UTF-8\"\n");
            this.buf.append("  ").append("contentType").append("=\"");
            this.buf.append(this.compiler.getPageInfo().getContentType()).append("\"\n");
            this.buf.append("/>\n");
        }

        private void appendTagDirective(Node.TagDirective tagDirective) throws JasperException {
            boolean bl = false;
            Attributes attributes = tagDirective.getAttributes();
            int n = attributes == null ? 0 : attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getQName(i);
                if ("pageEncoding".equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            this.appendTag(tagDirective);
        }

        private void appendTagDirective() {
            this.buf.append('<').append("jsp:directive.tag");
            this.buf.append("\n");
            this.buf.append("  ").append(this.jspIdPrefix).append(":id").append("=\"");
            this.buf.append(this.jspId++).append("\"\n");
            this.buf.append("  ").append("pageEncoding").append("=\"UTF-8\"\n");
            this.buf.append("/>\n");
        }

        private void appendText(String string, boolean bl) {
            if (bl) {
                this.buf.append('<').append("jsp:text");
                this.buf.append("\n");
                this.buf.append("  ").append(this.jspIdPrefix).append(":id").append("=\"");
                this.buf.append(this.jspId++).append("\"\n");
                this.buf.append(">\n");
                this.appendCDATA(string);
                this.buf.append("</jsp:text>");
                this.buf.append("\n");
            } else {
                this.appendCDATA(string);
            }
        }

        private void appendCDATA(String string) {
            this.buf.append(PageDataImpl.CDATA_START_SECTION);
            this.buf.append(this.escapeCDATA(string));
            this.buf.append(PageDataImpl.CDATA_END_SECTION);
        }

        private String escapeCDATA(String string) {
            if (string == null) {
                return "";
            }
            int n = string.length();
            CharArrayWriter charArrayWriter = new CharArrayWriter(n);
            for (int i = 0; i < n; ++i) {
                if (i + 2 < n && string.charAt(i) == ']' && string.charAt(i + 1) == ']' && string.charAt(i + 2) == '>') {
                    charArrayWriter.write(93);
                    charArrayWriter.write(93);
                    charArrayWriter.write(38);
                    charArrayWriter.write(103);
                    charArrayWriter.write(116);
                    charArrayWriter.write(59);
                    i += 2;
                    continue;
                }
                charArrayWriter.write(string.charAt(i));
            }
            return charArrayWriter.toString();
        }

        private void printAttributes(Node node, boolean bl) {
            String string;
            int n;
            String string2;
            int n2;
            Attributes attributes = node.getTaglibAttributes();
            int n3 = attributes == null ? 0 : attributes.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                String string3 = attributes.getQName(n2);
                string2 = attributes.getValue(n2);
                this.buf.append("  ").append(string3).append("=\"").append(string2).append("\"\n");
            }
            attributes = node.getNonTaglibXmlnsAttributes();
            n3 = attributes == null ? 0 : attributes.getLength();
            n2 = 0;
            for (n = 0; n < n3; ++n) {
                string2 = attributes.getQName(n);
                string = attributes.getValue(n);
                this.buf.append("  ").append(string2).append("=\"").append(string).append("\"\n");
                n2 |= "xmlns".equals(string2);
            }
            if (bl && n2 == 0) {
                this.buf.append("  xmlns=\"\"\n");
            }
            this.resetDefaultNS = false;
            attributes = node.getAttributes();
            n3 = attributes == null ? 0 : attributes.getLength();
            for (n = 0; n < n3; ++n) {
                string2 = attributes.getQName(n);
                string = attributes.getValue(n);
                this.buf.append("  ").append(string2).append("=\"");
                this.buf.append(JspUtil.getExprInXml(string)).append("\"\n");
            }
        }

        private void appendXmlProlog() {
            this.buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        }
    }
}

