/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.api.trace;

import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.internal.ApiUsageLogger;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.Span;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanContext;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanKind;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.Tracer;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;

@ThreadSafe
final class DefaultTracer
implements Tracer {
    private static final Tracer INSTANCE = new DefaultTracer();

    static Tracer getInstance() {
        return INSTANCE;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        return NoopSpanBuilder.create();
    }

    private DefaultTracer() {
    }

    private static final class NoopSpanBuilder
    implements SpanBuilder {
        @Nullable
        private SpanContext spanContext;

        static NoopSpanBuilder create() {
            return new NoopSpanBuilder();
        }

        @Override
        public Span startSpan() {
            if (this.spanContext == null) {
                this.spanContext = Span.current().getSpanContext();
            }
            return Span.wrap(this.spanContext);
        }

        @Override
        public NoopSpanBuilder setParent(Context context) {
            if (context == null) {
                ApiUsageLogger.log("context is null");
                return this;
            }
            this.spanContext = Span.fromContext(context).getSpanContext();
            return this;
        }

        @Override
        public NoopSpanBuilder setNoParent() {
            this.spanContext = SpanContext.getInvalid();
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, String value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, long value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, double value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, boolean value) {
            return this;
        }

        @Override
        public <T> NoopSpanBuilder setAttribute(AttributeKey<T> key, T value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAllAttributes(Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setSpanKind(SpanKind spanKind) {
            return this;
        }

        @Override
        public NoopSpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
            return this;
        }

        private NoopSpanBuilder() {
        }
    }
}

