/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.LongConsumer;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.SettableApiFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.ResultRetryAlgorithm;
import net.snowflake.client.jdbc.internal.google.api.services.storage.model.StorageObject;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ApiaryUnbufferedWritableByteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferHandle;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferedWritableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ChannelSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.DefaultBufferedWritableByteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpClientContext;
import net.snowflake.client.jdbc.internal.google.cloud.storage.JsonResumableWrite;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Retrying;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageByteChannels;
import net.snowflake.client.jdbc.internal.google.cloud.storage.UnbufferedWritableByteChannelSession;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.NonNull;

final class HttpWritableByteChannelSessionBuilder {
    private static final int DEFAULT_BUFFER_CAPACITY = 0x1000000;
    private final @NonNull HttpClientContext httpClientContext;

    HttpWritableByteChannelSessionBuilder(@NonNull HttpClientContext httpClientContext) {
        this.httpClientContext = Objects.requireNonNull(httpClientContext, "httpClientContext must be non null");
    }

    ResumableUploadBuilder resumable() {
        return new ResumableUploadBuilder(this.httpClientContext);
    }

    static final class ResumableUploadBuilder {
        private final @NonNull HttpClientContext httpClientContext;
        private Retrying.RetryingDependencies deps;
        private ResultRetryAlgorithm<?> alg;
        private LongConsumer committedBytesCallback;

        ResumableUploadBuilder(@NonNull HttpClientContext httpClientContext) {
            this.httpClientContext = httpClientContext;
            this.deps = Retrying.RetryingDependencies.attemptOnce();
            this.alg = Retrying.neverRetry();
            this.committedBytesCallback = l -> {};
        }

        ResumableUploadBuilder setCommittedBytesCallback(@NonNull LongConsumer committedBytesCallback) {
            this.committedBytesCallback = Objects.requireNonNull(committedBytesCallback, "committedBytesCallback must be non null");
            return this;
        }

        ResumableUploadBuilder withRetryConfig(@NonNull Retrying.RetryingDependencies deps, @NonNull ResultRetryAlgorithm<?> alg) {
            this.deps = Objects.requireNonNull(deps, "deps must be non null");
            this.alg = Objects.requireNonNull(alg, "alg must be non null");
            return this;
        }

        UnbufferedResumableUploadBuilder unbuffered() {
            return new UnbufferedResumableUploadBuilder();
        }

        BufferedResumableUploadBuilder buffered() {
            return this.buffered(BufferHandle.allocate(0x1000000));
        }

        BufferedResumableUploadBuilder buffered(ByteBuffer byteBuffer) {
            return this.buffered(BufferHandle.handleOf(byteBuffer));
        }

        BufferedResumableUploadBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedResumableUploadBuilder(bufferHandle);
        }

        private BiFunction<JsonResumableWrite, SettableApiFuture<StorageObject>, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel> bindFunction() {
            Retrying.RetryingDependencies boundDeps = this.deps;
            ResultRetryAlgorithm<?> boundAlg = this.alg;
            return (start, resultFuture) -> new ApiaryUnbufferedWritableByteChannel(this.httpClientContext, boundDeps, boundAlg, (JsonResumableWrite)start, (SettableApiFuture<StorageObject>)resultFuture, this.committedBytesCallback);
        }

        final class UnbufferedResumableUploadBuilder {
            private ApiFuture<JsonResumableWrite> start;

            UnbufferedResumableUploadBuilder() {
            }

            UnbufferedResumableUploadBuilder setStartAsync(ApiFuture<JsonResumableWrite> start) {
                this.start = Objects.requireNonNull(start, "start must be non null");
                return this;
            }

            UnbufferedWritableByteChannelSession<StorageObject> build() {
                return new ChannelSession.UnbufferedWriteSession(Objects.requireNonNull(this.start, "start must be non null"), ResumableUploadBuilder.this.bindFunction().andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }

        final class BufferedResumableUploadBuilder {
            private final BufferHandle bufferHandle;
            private ApiFuture<JsonResumableWrite> start;

            BufferedResumableUploadBuilder(BufferHandle bufferHandle) {
                this.bufferHandle = bufferHandle;
            }

            BufferedResumableUploadBuilder setStartAsync(ApiFuture<JsonResumableWrite> start) {
                this.start = Objects.requireNonNull(start, "start must be non null");
                return this;
            }

            BufferedWritableByteChannelSession<StorageObject> build() {
                return new ChannelSession.BufferedWriteSession(Objects.requireNonNull(this.start, "start must be non null"), ResumableUploadBuilder.this.bindFunction().andThen(c -> new DefaultBufferedWritableByteChannel(this.bufferHandle, (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel)c)).andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }
    }
}

