/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobWriteSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.WritableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;

final class BlobWriteSessions {
    private BlobWriteSessions() {
    }

    static BlobWriteSession of(WritableByteChannelSession<?, BlobInfo> s2) {
        return new WritableByteChannelSessionAdapter(s2);
    }

    static final class WritableByteChannelSessionAdapter
    implements BlobWriteSession {
        private final WritableByteChannelSession<?, BlobInfo> delegate;
        private boolean open;

        private WritableByteChannelSessionAdapter(WritableByteChannelSession<?, BlobInfo> delegate) {
            this.delegate = delegate;
            this.open = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WritableByteChannel open() throws IOException {
            WritableByteChannelSessionAdapter writableByteChannelSessionAdapter = this;
            synchronized (writableByteChannelSessionAdapter) {
                Preconditions.checkState(!this.open, "already open");
                this.open = true;
                return this.delegate.open();
            }
        }

        @Override
        public ApiFuture<BlobInfo> getResult() {
            return this.delegate.getResult();
        }
    }
}

