/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.assertions.jwt;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.SecurityContext;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.proc.BadJWTException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.util.DateUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Audience;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Identifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public class JWTAssertionDetailsVerifier
extends DefaultJWTClaimsVerifier {
    private final Set<Audience> expectedAudience;
    private final long expMaxAhead;

    public JWTAssertionDetailsVerifier(Set<Audience> expectedAudience) {
        this(expectedAudience, -1L);
    }

    public JWTAssertionDetailsVerifier(Set<Audience> expectedAudience, long expMaxAhead) {
        super(new HashSet<String>(Identifier.toStringList(expectedAudience)), null, new HashSet<String>(Arrays.asList("aud", "exp", "sub", "iss")), null);
        if (CollectionUtils.isEmpty(expectedAudience)) {
            throw new IllegalArgumentException("The expected audience set must not be null or empty");
        }
        this.expectedAudience = expectedAudience;
        this.expMaxAhead = expMaxAhead;
    }

    @Deprecated
    public Set<Audience> getExpectedAudience() {
        return this.expectedAudience;
    }

    public long getExpirationTimeMaxAhead() {
        return this.expMaxAhead;
    }

    @Override
    public void verify(JWTClaimsSet claimsSet, SecurityContext context) throws BadJWTException {
        long exp;
        long now;
        super.verify(claimsSet, context);
        if (this.expMaxAhead > 0L && (now = DateUtils.toSecondsSinceEpoch(new Date())) + this.expMaxAhead < (exp = DateUtils.toSecondsSinceEpoch(claimsSet.getExpirationTime()))) {
            throw new BadJWTException("JWT expiration too far ahead");
        }
    }
}

