/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.snowflake.client.jdbc.internal.apache.arrow.log.ArrowLogger;
import net.snowflake.client.jdbc.internal.apache.arrow.log.ArrowLoggerFactory;
import net.snowflake.client.jdbc.internal.apache.arrow.util.VisibleForTesting;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorSchemaRoot;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.compression.CompressionCodec;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.compression.CompressionUtil;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.Dictionary;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.DictionaryProvider;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.ArrowMagic;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.ArrowWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.InvalidArrowFileException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.WriteChannel;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowBlock;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFooter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.IpcOption;

public class ArrowFileWriter
extends ArrowWriter {
    private static final ArrowLogger LOGGER = ArrowLoggerFactory.getLogger(ArrowFileWriter.class);
    private final List<ArrowBlock> dictionaryBlocks = new ArrayList<ArrowBlock>();
    private final List<ArrowBlock> recordBlocks = new ArrayList<ArrowBlock>();
    private Map<String, String> metaData;
    private boolean dictionariesWritten = false;

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out) {
        super(root, provider, out);
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, Map<String, String> metaData) {
        super(root, provider, out);
        this.metaData = metaData;
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, IpcOption option) {
        super(root, provider, out, option);
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, Map<String, String> metaData, IpcOption option) {
        super(root, provider, out, option);
        this.metaData = metaData;
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, Map<String, String> metaData, IpcOption option, CompressionCodec.Factory compressionFactory, CompressionUtil.CodecType codecType) {
        this(root, provider, out, metaData, option, compressionFactory, codecType, Optional.empty());
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, Map<String, String> metaData, IpcOption option, CompressionCodec.Factory compressionFactory, CompressionUtil.CodecType codecType, Optional<Integer> compressionLevel) {
        super(root, provider, out, option, compressionFactory, codecType, compressionLevel);
        this.metaData = metaData;
    }

    @Override
    protected void startInternal(WriteChannel out) throws IOException {
        ArrowMagic.writeMagic(out, true);
    }

    @Override
    protected ArrowBlock writeDictionaryBatch(ArrowDictionaryBatch batch) throws IOException {
        ArrowBlock block = super.writeDictionaryBatch(batch);
        this.dictionaryBlocks.add(block);
        return block;
    }

    @Override
    protected ArrowBlock writeRecordBatch(ArrowRecordBatch batch) throws IOException {
        ArrowBlock block = super.writeRecordBatch(batch);
        this.recordBlocks.add(block);
        return block;
    }

    @Override
    protected void endInternal(WriteChannel out) throws IOException {
        if (!this.option.write_legacy_ipc_format) {
            out.writeIntLittleEndian(-1);
        }
        out.writeIntLittleEndian(0);
        long footerStart = out.getCurrentPosition();
        out.write(new ArrowFooter(this.schema, this.dictionaryBlocks, this.recordBlocks, this.metaData, this.option.metadataVersion), false);
        int footerLength = (int)(out.getCurrentPosition() - footerStart);
        if (footerLength <= 0) {
            throw new InvalidArrowFileException("invalid footer");
        }
        out.writeIntLittleEndian(footerLength);
        LOGGER.debug("Footer starts at {}, length: {}", footerStart, footerLength);
        ArrowMagic.writeMagic(out, false);
        LOGGER.debug("magic written, now at {}", out.getCurrentPosition());
    }

    @Override
    protected void ensureDictionariesWritten(DictionaryProvider provider, Set<Long> dictionaryIdsUsed) throws IOException {
        if (this.dictionariesWritten) {
            return;
        }
        this.dictionariesWritten = true;
        for (long id : dictionaryIdsUsed) {
            Dictionary dictionary = provider.lookup(id);
            this.writeDictionaryBatch(dictionary);
        }
    }

    @VisibleForTesting
    public List<ArrowBlock> getRecordBlocks() {
        return this.recordBlocks;
    }

    @VisibleForTesting
    public List<ArrowBlock> getDictionaryBlocks() {
        return this.dictionaryBlocks;
    }
}

