/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.backend.panama.AbstractErrorContext;
import com.oracle.truffle.nfi.backend.panama.AbstractPanamaNFIContext;
import com.oracle.truffle.nfi.backend.panama.PanamaAccessor;
import com.oracle.truffle.nfi.backend.spi.NFIBackend;
import com.oracle.truffle.nfi.backend.spi.NFIBackendFactory;
import com.oracle.truffle.nfi.backend.spi.NFIState;

@TruffleLanguage.Registration(id="internal/nfi-panama", name="nfi-panama", version="0.1", characterMimeTypes={"trufflenfi/panama"}, internal=true, services={NFIBackendFactory.class}, contextPolicy=TruffleLanguage.ContextPolicy.SHARED)
public class PanamaNFILanguage
extends TruffleLanguage<AbstractPanamaNFIContext> {
    public static final String MIME_TYPE = "trufflenfi/panama";
    @CompilerDirectives.CompilationFinal
    private NFIBackend backend;
    private final Assumption singleContextAssumption = Truffle.getRuntime().createAssumption("panama backend single context");
    public final ContextThreadLocal<AbstractErrorContext> errorContext = this.createErrorContext();
    @CompilerDirectives.CompilationFinal
    private ContextThreadLocal<NFIState> state;
    private static final TruffleLanguage.LanguageReference<PanamaNFILanguage> REFERENCE = TruffleLanguage.LanguageReference.create(PanamaNFILanguage.class);

    static Assumption getSingleContextAssumption() {
        return PanamaNFILanguage.get(null).singleContextAssumption;
    }

    NFIState getNFIState() {
        return (NFIState)this.state.get();
    }

    protected void initializeMultipleContexts() {
        super.initializeMultipleContexts();
        this.singleContextAssumption.invalidate();
    }

    protected AbstractPanamaNFIContext createContext(TruffleLanguage.Env env) {
        env.registerService((Object)new NFIBackendFactory(){

            public String getBackendId() {
                return "panama";
            }

            public NFIBackend createBackend(ContextThreadLocal<NFIState> newState) {
                if (PanamaAccessor.isSupported()) {
                    if (PanamaNFILanguage.this.backend == null) {
                        PanamaNFILanguage.this.backend = PanamaAccessor.createNFIBackend(PanamaNFILanguage.this);
                        PanamaNFILanguage.this.state = newState;
                    }
                    return PanamaNFILanguage.this.backend;
                }
                return null;
            }
        });
        if (PanamaAccessor.isSupported()) {
            return PanamaAccessor.createPanamaNFIContext(this, env);
        }
        return null;
    }

    public final ContextThreadLocal<AbstractErrorContext> createErrorContext() {
        if (PanamaAccessor.isSupported()) {
            return this.locals.createContextThreadLocal((ctx, thread) -> PanamaAccessor.createErrorContext());
        }
        return null;
    }

    protected void initializeContext(AbstractPanamaNFIContext context) throws Exception {
        if (PanamaAccessor.isSupported()) {
            context.initialize();
            ((AbstractErrorContext)this.errorContext.get()).initialize();
        }
    }

    protected void initializeThread(AbstractPanamaNFIContext context, Thread thread) {
        if (PanamaAccessor.isSupported()) {
            assert (thread == Thread.currentThread());
            ((AbstractErrorContext)this.errorContext.get()).initialize();
        }
    }

    protected boolean patchContext(AbstractPanamaNFIContext context, TruffleLanguage.Env newEnv) {
        if (PanamaAccessor.isSupported()) {
            context.patchEnv(newEnv);
            context.initialize();
        }
        return true;
    }

    protected void disposeContext(AbstractPanamaNFIContext context) {
        if (PanamaAccessor.isSupported()) {
            context.dispose();
        }
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) {
        RootNode ret = new RootNode(this){

            public Object execute(VirtualFrame frame) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException("illegal access to internal language");
            }
        };
        return ret.getCallTarget();
    }

    static PanamaNFILanguage get(Node node) {
        return (PanamaNFILanguage)REFERENCE.get(node);
    }
}

