/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;

public enum SSLErrorCode {
    ERROR_UNKNOWN(0, PythonBuiltinClassType.SSLError),
    ERROR_SSL(1, PythonBuiltinClassType.SSLError),
    ERROR_WANT_READ(2, PythonBuiltinClassType.SSLWantReadError),
    ERROR_WANT_WRITE(3, PythonBuiltinClassType.SSLWantWriteError),
    ERROR_WANT_X509_LOOKUP(4, PythonBuiltinClassType.SSLError),
    ERROR_SYSCALL(5, PythonBuiltinClassType.SSLSyscallError),
    ERROR_ZERO_RETURN(6, PythonBuiltinClassType.SSLZeroReturnError),
    ERROR_WANT_CONNECT(7, PythonBuiltinClassType.SSLError),
    ERROR_EOF(8, PythonBuiltinClassType.SSLEOFError),
    ERROR_SSL_PEM_LIB(9, PythonBuiltinClassType.SSLError),
    ERROR_NO_START_LINE("NO_START_LINE", 108, PythonBuiltinClassType.SSLError),
    ERROR_NO_CERTIFICATE_OR_CRL_FOUND("NO_CERTIFICATE_OR_CRL_FOUND", 136, PythonBuiltinClassType.SSLError),
    ERROR_KEY_TYPE_MISMATCH("KEY_TYPE_MISMATCH", 115, PythonBuiltinClassType.SSLError),
    ERROR_KEY_VALUES_MISMATCH("KEY_VALUES_MISMATCH", 116, PythonBuiltinClassType.SSLError),
    ERROR_BAD_BASE64_DECODE("BAD_BASE64_DECODE", 100, PythonBuiltinClassType.SSLError),
    ERROR_NOT_ENOUGH_DATA("NOT_ENOUGH_DATA", 142, PythonBuiltinClassType.SSLError),
    ERROR_CERT_VERIFICATION("CERTIFICATE_VERIFY_FAILED", 1, PythonBuiltinClassType.SSLCertVerificationError);

    private final TruffleString mnemonic;
    private final int errno;
    private final PythonBuiltinClassType type;

    private SSLErrorCode(int errno, PythonBuiltinClassType type) {
        this(null, errno, type);
    }

    private SSLErrorCode(String mnemonic, int errno, PythonBuiltinClassType type) {
        this.mnemonic = PythonUtils.toTruffleStringUncached(mnemonic);
        this.errno = errno;
        this.type = type;
    }

    public TruffleString getMnemonic() {
        return this.mnemonic;
    }

    public int getErrno() {
        return this.errno;
    }

    public PythonBuiltinClassType getType() {
        return this.type;
    }
}

