/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext;

import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.utilities.TriState;
import java.util.Objects;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=PythonBufferAcquireLibrary.class)})
public final class PythonAbstractNativeObject
extends PythonAbstractObject
implements PythonNativeObject,
PythonNativeClass {
    public final Object object;
    public TpSlots slots;
    public CApiTransitions.NativeObjectReference ref;
    private Object[] replicatedNativeReferences;

    public PythonAbstractNativeObject(Object object) {
        this.object = object;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    public void setReplicatedNativeReferences(Object[] replicatedNativeReferences) {
        this.replicatedNativeReferences = replicatedNativeReferences;
    }

    public Object[] getReplicatedNativeReferences() {
        return this.replicatedNativeReferences;
    }

    @Override
    public Object getPtr() {
        return this.object;
    }

    public int hashCode() {
        CompilerAsserts.neverPartOfCompilation();
        return Objects.hashCode(this.object);
    }

    @ExportMessage.Ignore
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PythonAbstractNativeObject other = (PythonAbstractNativeObject)obj;
        return Objects.equals(this.object, other.object);
    }

    @CompilerDirectives.TruffleBoundary
    public String toStringWithContext() {
        return "PythonAbstractNativeObject(" + PythonUtils.formatPointer(this.object) + ")";
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "PythonAbstractNativeObject(" + String.valueOf(this.object) + ")";
    }

    @ExportMessage
    int identityHashCode(@CachedLibrary(value="this.object") InteropLibrary lib) throws UnsupportedMessageException {
        if (lib.isPointer(this.object)) {
            return Long.hashCode(lib.asPointer(this.object));
        }
        return lib.identityHashCode(this.object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    boolean isIdentical(Object other, InteropLibrary otherInterop, @Bind Node inliningTarget, @Cached InlinedExactClassProfile otherProfile, @Cached.Exclusive @CachedLibrary(limit="1") InteropLibrary thisLib, @Cached.Exclusive @CachedLibrary(limit="3") InteropLibrary lib1, @Cached.Exclusive @CachedLibrary(limit="3") InteropLibrary lib2, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object profiled = otherProfile.profile(inliningTarget, other);
            if (profiled instanceof PythonAbstractNativeObject) {
                Object otherPtr = ((PythonAbstractNativeObject)other).getPtr();
                if (lib1.isPointer(this.getPtr())) {
                    if (lib2.isPointer(otherPtr)) {
                        try {
                            boolean bl = lib1.asPointer(this.getPtr()) == lib2.asPointer(otherPtr);
                            return bl;
                        }
                        catch (UnsupportedMessageException e) {
                            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
                if (lib2.isPointer(otherPtr)) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = lib1.isIdentical(this.getPtr(), otherPtr, lib2);
                return bl;
            }
            boolean bl = otherInterop.isIdentical(profiled, (Object)this, thisLib);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    public void setTpSlots(TpSlots slots) {
        this.slots = slots;
    }

    public TpSlots getTpSlots() {
        return this.slots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage(library=InteropLibrary.class)
    boolean isMetaObject(@Bind Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isType, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = isType.execute(inliningTarget, this);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    boolean isMetaInstance(Object instance, @Bind Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isType, @Cached GetClassNode getClassNode, @Cached PForeignToPTypeNode convert, @Cached IsSubtypeNode isSubtype, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            if (!isType.execute(inliningTarget, this)) {
                throw UnsupportedMessageException.create();
            }
            boolean bl = isSubtype.execute(getClassNode.execute(inliningTarget, convert.executeConvert(instance)), this);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    String getMetaSimpleName(@Bind Node inliningTarget, @Cached.Shared(value="isType") @Cached TypeNodes.IsTypeNode isType, @Cached.Shared(value="getTypeMember") @Cached CStructAccess.ReadCharPtrNode getTpNameNode, @Cached.Shared(value="castToJavaStringNode") @Cached CastToJavaStringNode castToJavaStringNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        return PythonAbstractNativeObject.getSimpleName(this.getMetaQualifiedName(inliningTarget, isType, getTpNameNode, castToJavaStringNode, gil));
    }

    @CompilerDirectives.TruffleBoundary
    private static String getSimpleName(String fqname) {
        int firstDot = fqname.indexOf(46);
        if (firstDot != -1) {
            return fqname.substring(firstDot + 1);
        }
        return fqname;
    }

    @ExportMessage
    String getMetaQualifiedName(@Bind Node inliningTarget, @Cached.Shared(value="isType") @Cached TypeNodes.IsTypeNode isType, @Cached.Shared(value="getTypeMember") @Cached CStructAccess.ReadCharPtrNode getTpNameNode, @Cached.Shared(value="castToJavaStringNode") @Cached CastToJavaStringNode castToJavaStringNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            if (!isType.execute(inliningTarget, this)) {
                throw UnsupportedMessageException.create();
            }
            try {
                String string = castToJavaStringNode.execute(getTpNameNode.readFromObj(this, CFields.PyTypeObject__tp_name));
                return string;
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    boolean hasBuffer(@Bind Node inliningTarget, @Cached CExtNodes.HasNativeBufferNode hasNativeBuffer) {
        return hasNativeBuffer.execute(inliningTarget, this);
    }

    @ExportMessage
    Object acquire(int flags, @Bind Node inliningTarget, @Cached CExtNodes.CreateMemoryViewFromNativeNode createMemoryView) {
        PMemoryView mv = createMemoryView.execute(inliningTarget, this, flags);
        mv.setShouldReleaseImmediately(true);
        return mv;
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doPythonAbstractNativeObject(PythonAbstractNativeObject receiver, PythonAbstractNativeObject other, @CachedLibrary(value="receiver") InteropLibrary objLib, @Cached.Exclusive @CachedLibrary(limit="1") InteropLibrary otherObjectLib) {
            return TriState.valueOf((boolean)objLib.isIdentical((Object)receiver, (Object)other, otherObjectLib));
        }

        @Fallback
        static TriState doOther(PythonAbstractNativeObject receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

