/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.tregex.nodes.dfa.CGTrackingTransitionNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupLazyTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.Matchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;

public final class CGTrackingDFAStateNode
extends DFAStateNode {
    private final DFACaptureGroupLazyTransition preUnAnchoredFinalStateTransition;
    private final DFACaptureGroupPartialTransition unAnchoredFinalStateTransition;
    private final DFACaptureGroupPartialTransition cgLoopToSelf;
    private final boolean cgLoopToSelfHasDependency;

    public CGTrackingDFAStateNode(short id, byte flags, short loopTransitionIndex, short indexOfNodeId, byte indexOfIsFast, short[] successors, Matchers matchers, short anchoredFinalSuccessor, DFACaptureGroupLazyTransition preUnAnchoredFinalStateTransition, DFACaptureGroupPartialTransition unAnchoredFinalStateTransition, DFACaptureGroupPartialTransition cgLoopToSelf, boolean cgLoopToSelfHasDependency) {
        super(id, flags, loopTransitionIndex, indexOfNodeId, indexOfIsFast, successors, matchers, anchoredFinalSuccessor);
        this.unAnchoredFinalStateTransition = unAnchoredFinalStateTransition;
        this.preUnAnchoredFinalStateTransition = preUnAnchoredFinalStateTransition;
        this.cgLoopToSelf = cgLoopToSelf;
        this.cgLoopToSelfHasDependency = cgLoopToSelfHasDependency;
    }

    private DFACaptureGroupPartialTransition getCGTransitionToSelf() {
        return this.cgLoopToSelf;
    }

    @Override
    boolean beforeFindSuccessor(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (executor.isSearching()) {
            this.checkFinalStateCG(locals, executor);
        }
        return false;
    }

    @Override
    void afterIndexOf(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int preLoopIndex, int postLoopIndex, TruffleString.CodeRange codeRange) {
        assert (locals.getIndex() == preLoopIndex);
        if (locals.getIndex() < postLoopIndex) {
            DFAAbstractNode loopTransitionNode = executor.getNodes()[this.successors[this.getLoopToSelf()]];
            if (loopTransitionNode instanceof CGTrackingTransitionNode) {
                CGTrackingTransitionNode cgTrackingLoopTransitionNode = (CGTrackingTransitionNode)loopTransitionNode;
                cgTrackingLoopTransitionNode.apply(locals, executor);
            }
            locals.setLastIndex();
            executor.inputSkip(locals, codeRange);
        }
        int secondIndex = locals.getIndex();
        DFACaptureGroupPartialTransition transition = this.getCGTransitionToSelf();
        if (transition.doesReorderResults()) {
            while (locals.getIndex() < postLoopIndex) {
                transition.apply(executor, locals.getCGData(), locals.getLastIndex());
                locals.setLastIndex();
                executor.inputSkip(locals, codeRange);
            }
        } else if (postLoopIndex > preLoopIndex) {
            locals.setIndex(postLoopIndex);
            executor.inputSkipReverse(locals, codeRange);
            locals.setLastIndex();
            if (secondIndex < postLoopIndex) {
                executor.inputSkipReverse(locals, codeRange);
            }
            if (this.cgLoopToSelfHasDependency && secondIndex < locals.getLastIndex()) {
                int postLoopMinusTwoIndex = locals.getIndex();
                executor.inputSkipReverse(locals, codeRange);
                transition.apply(executor, locals.getCGData(), locals.getIndex());
                locals.setIndex(postLoopMinusTwoIndex);
            }
            if (secondIndex < postLoopIndex) {
                transition.apply(executor, locals.getCGData(), locals.getIndex());
            }
            locals.setIndex(postLoopIndex);
        }
        if (!executor.inputAtEnd(locals)) {
            executor.inputIncNextIndexRaw(locals, executor.inputGetCodePointSize(locals, codeRange));
        }
        if (executor.isSearching()) {
            this.checkFinalStateCG(locals, executor);
        }
    }

    @Override
    void atEnd(TRegexDFAExecutorLocals frame, TRegexDFAExecutorNode executor, boolean inputAtEnd) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (!this.isAnchoredFinalState() || !inputAtEnd) {
            this.checkFinalStateCG(frame, executor);
        }
    }

    private void checkFinalStateCG(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (this.isFinalState()) {
            this.preUnAnchoredFinalStateTransition.applyPreFinal(locals, executor);
            this.unAnchoredFinalStateTransition.applyFinalStateTransition(executor, locals.getCGData(), locals.getIndex());
            CGTrackingDFAStateNode.storeResult(locals, executor);
        }
    }

    static void storeResult(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        if (!executor.isSearching()) {
            locals.getCGData().exportResult(executor, (byte)0);
        }
        locals.setResultInt(0);
    }

    public int getCGTrackingCost() {
        return CGTrackingDFAStateNode.getCost(this.preUnAnchoredFinalStateTransition) + CGTrackingDFAStateNode.getCost(this.unAnchoredFinalStateTransition);
    }

    private static int getCost(DFACaptureGroupLazyTransition t) {
        return t == null ? 0 : t.getCost();
    }

    private static int getCost(DFACaptureGroupPartialTransition t) {
        return t == null ? 0 : t.getCost();
    }
}

