/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.rpc;

import java.util.List;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.AutoValue_ErrorDetails;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ProtocolBufferParsingException;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.protobuf.Any;
import net.snowflake.client.jdbc.internal.google.protobuf.InvalidProtocolBufferException;
import net.snowflake.client.jdbc.internal.google.protobuf.Message;
import net.snowflake.client.jdbc.internal.google.rpc.BadRequest;
import net.snowflake.client.jdbc.internal.google.rpc.DebugInfo;
import net.snowflake.client.jdbc.internal.google.rpc.ErrorInfo;
import net.snowflake.client.jdbc.internal.google.rpc.Help;
import net.snowflake.client.jdbc.internal.google.rpc.LocalizedMessage;
import net.snowflake.client.jdbc.internal.google.rpc.PreconditionFailure;
import net.snowflake.client.jdbc.internal.google.rpc.QuotaFailure;
import net.snowflake.client.jdbc.internal.google.rpc.RequestInfo;
import net.snowflake.client.jdbc.internal.google.rpc.ResourceInfo;
import net.snowflake.client.jdbc.internal.google.rpc.RetryInfo;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@AutoValue
public abstract class ErrorDetails {
    @Nullable
    public ErrorInfo getErrorInfo() {
        return this.unpack(ErrorInfo.class);
    }

    @Nullable
    public RetryInfo getRetryInfo() {
        return this.unpack(RetryInfo.class);
    }

    @Nullable
    public DebugInfo getDebugInfo() {
        return this.unpack(DebugInfo.class);
    }

    @Nullable
    public QuotaFailure getQuotaFailure() {
        return this.unpack(QuotaFailure.class);
    }

    @Nullable
    public PreconditionFailure getPreconditionFailure() {
        return this.unpack(PreconditionFailure.class);
    }

    @Nullable
    public BadRequest getBadRequest() {
        return this.unpack(BadRequest.class);
    }

    @Nullable
    public RequestInfo getRequestInfo() {
        return this.unpack(RequestInfo.class);
    }

    @Nullable
    public ResourceInfo getResourceInfo() {
        return this.unpack(ResourceInfo.class);
    }

    @Nullable
    public Help getHelp() {
        return this.unpack(Help.class);
    }

    @Nullable
    public LocalizedMessage getLocalizedMessage() {
        return this.unpack(LocalizedMessage.class);
    }

    @Nullable
    public <T extends Message> T getMessage(Class<T> messageClass) {
        return this.unpack(messageClass);
    }

    @Nullable
    abstract List<Any> getRawErrorMessages();

    public static Builder builder() {
        return new AutoValue_ErrorDetails.Builder();
    }

    @VisibleForTesting
    <T extends Message> T unpack(Class<T> errorTypeClazz) {
        List<Any> rawErrorMessages = this.getRawErrorMessages();
        if (rawErrorMessages == null) {
            return null;
        }
        for (Any detail : rawErrorMessages) {
            if (!detail.is(errorTypeClazz)) continue;
            try {
                return detail.unpack(errorTypeClazz);
            }
            catch (InvalidProtocolBufferException e) {
                throw new ProtocolBufferParsingException(String.format("Failed to unpack %s from raw error messages", errorTypeClazz.getSimpleName()), e);
            }
        }
        return null;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRawErrorMessages(List<Any> var1);

        public abstract ErrorDetails build();
    }
}

