/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.arrow.BigIntToTimeConverter;
import net.snowflake.client.core.arrow.BigIntToTimestampLTZConverter;
import net.snowflake.client.core.arrow.BigIntToTimestampNTZConverter;
import net.snowflake.client.core.arrow.DateConverter;
import net.snowflake.client.core.arrow.ThreeFieldStructToTimestampTZConverter;
import net.snowflake.client.core.arrow.TwoFieldStructToTimestampLTZConverter;
import net.snowflake.client.core.arrow.TwoFieldStructToTimestampNTZConverter;
import net.snowflake.client.core.arrow.TwoFieldStructToTimestampTZConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.JsonStringHashMap;

@SnowflakeJdbcInternalApi
public class StructuredTypeDateTimeConverter {
    private final TimeZone sessionTimeZone;
    private final long resultVersion;
    private final boolean honorClientTZForTimestampNTZ;
    private final boolean treatNTZAsUTC;
    private final boolean useSessionTimezone;
    private final boolean formatDateWithTimeZone;

    public StructuredTypeDateTimeConverter(TimeZone sessionTimeZone, long resultVersion, boolean honorClientTZForTimestampNTZ, boolean treatNTZAsUTC, boolean useSessionTimezone, boolean formatDateWithTimeZone) {
        this.sessionTimeZone = sessionTimeZone;
        this.resultVersion = resultVersion;
        this.honorClientTZForTimestampNTZ = honorClientTZForTimestampNTZ;
        this.treatNTZAsUTC = treatNTZAsUTC;
        this.useSessionTimezone = useSessionTimezone;
        this.formatDateWithTimeZone = formatDateWithTimeZone;
    }

    public Timestamp getTimestamp(Map<String, Object> obj, int columnType, int columnSubType, TimeZone tz, int scale) throws SFException {
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        if (93 == columnType) {
            if (50000 == columnSubType) {
                return this.convertTimestampLtz(obj, scale);
            }
            return this.convertTimestampNtz(obj, tz, scale);
        }
        if (2014 == columnType && 50001 == columnSubType) {
            return this.convertTimestampTz(obj, scale);
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, "Unexpected Arrow Field for columnType " + columnType + " , column subtype " + columnSubType + " , and object type " + obj.getClass());
    }

    public Date getDate(int value, TimeZone tz) throws SFException {
        return DateConverter.getDate(value, tz, this.sessionTimeZone, this.formatDateWithTimeZone);
    }

    public Time getTime(long value, int scale) throws SFException {
        return BigIntToTimeConverter.getTime(value, scale, this.useSessionTimezone);
    }

    private Timestamp convertTimestampLtz(Object obj, int scale) throws SFException {
        if (obj instanceof JsonStringHashMap) {
            JsonStringHashMap map = (JsonStringHashMap)obj;
            if (map.values().size() == 2) {
                return TwoFieldStructToTimestampLTZConverter.getTimestamp((Long)map.get("epoch"), (Integer)map.get("fraction"), this.sessionTimeZone, this.useSessionTimezone, false);
            }
        } else if (obj instanceof Long) {
            return BigIntToTimestampLTZConverter.getTimestamp((Long)obj, scale, this.sessionTimeZone, this.useSessionTimezone);
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, "Unexpected Arrow Field for " + (Object)((Object)SnowflakeType.TIMESTAMP_LTZ) + " and object type " + obj.getClass());
    }

    private Timestamp convertTimestampNtz(Object obj, TimeZone tz, int scale) throws SFException {
        if (obj instanceof JsonStringHashMap) {
            JsonStringHashMap map = (JsonStringHashMap)obj;
            if (map.values().size() == 2) {
                return TwoFieldStructToTimestampNTZConverter.getTimestamp((Long)map.get("epoch"), (Integer)map.get("fraction"), tz, this.sessionTimeZone, this.treatNTZAsUTC, this.useSessionTimezone, this.honorClientTZForTimestampNTZ, false);
            }
        } else if (obj instanceof Long) {
            return BigIntToTimestampNTZConverter.getTimestamp((Long)obj, tz, scale, this.honorClientTZForTimestampNTZ, false);
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, "Unexpected Arrow Field for " + (Object)((Object)SnowflakeType.TIMESTAMP_NTZ) + " and object type " + obj.getClass());
    }

    private Timestamp convertTimestampTz(Object obj, int scale) throws SFException {
        if (obj instanceof JsonStringHashMap) {
            JsonStringHashMap map = (JsonStringHashMap)obj;
            if (map.values().size() == 2) {
                return TwoFieldStructToTimestampTZConverter.getTimestamp((Long)map.get("epoch"), (Integer)map.get("timezone"), scale);
            }
            if (map.values().size() == 3) {
                return ThreeFieldStructToTimestampTZConverter.getTimestamp((Long)map.get("epoch"), (Integer)map.get("fraction"), (Integer)map.get("timezone"), this.resultVersion, this.useSessionTimezone, false);
            }
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, "Unexpected Arrow Field for " + (Object)((Object)SnowflakeType.TIMESTAMP_TZ) + " and object type " + obj.getClass());
    }
}

