/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import us.fatehi.utility.SQLRuntimeException;
import us.fatehi.utility.datasource.AbstractDatabaseConnectionSource;

final class DataSourceConnectionSource
extends AbstractDatabaseConnectionSource {
    private static final Logger LOGGER = Logger.getLogger(DataSourceConnectionSource.class.getName());
    private final DataSource dataSource;

    DataSourceConnectionSource(DataSource dataSource) {
        super((Connection connection) -> {});
        this.dataSource = Objects.requireNonNull(dataSource, "Data source not provided");
    }

    @Override
    public void close() throws Exception {
        DataSource dataSource = this.dataSource;
        if (dataSource instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)((Object)dataSource);
            closeable.close();
        } else {
            Method method = this.shutdownMethod();
            if (method != null) {
                method.setAccessible(true);
                method.invoke((Object)this.dataSource, new Object[0]);
            }
        }
    }

    @Override
    public Connection get() {
        try {
            Connection connection = this.dataSource.getConnection();
            this.connectionInitializer.accept(connection);
            return connection;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public boolean releaseConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not close database connection", e);
            return false;
        }
        return true;
    }

    private Method shutdownMethod() {
        Method[] methods;
        Class<?> c = this.dataSource.getClass();
        for (Method method : methods = c.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!methodName.equalsIgnoreCase("shutdown")) continue;
            return method;
        }
        return null;
    }
}

