// Copyright (c) 2024 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCRAND_LFSR113_PRECOMPUTED_H_
#define ROCRAND_LFSR113_PRECOMPUTED_H_

// Auto-generated file. Do not edit!
// Generated by tools/lfsr113_precomputed_generator

#define LFSR113_N 4
#define LFSR113_M 32
#define LFSR113_SIZE (LFSR113_M * LFSR113_N * LFSR113_N)
#define LFSR113_JUMP_MATRICES 32
#define LFSR113_JUMP_LOG2 2

// clang-format off
static const __device__ unsigned int d_lfsr113_jump_matrices[LFSR113_JUMP_MATRICES][LFSR113_SIZE] = {
    {
        0, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 
        4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554433, 0, 0, 0, 
        67108866, 0, 0, 0, 134217732, 0, 0, 0, 268435464, 0, 0, 0, 536870928, 0, 0, 0, 
        1073741856, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 260, 0, 0, 0, 
        520, 0, 0, 0, 1040, 0, 0, 0, 2080, 0, 0, 0, 4160, 0, 0, 0, 
        8320, 0, 0, 0, 16640, 0, 0, 0, 33280, 0, 0, 0, 66560, 0, 0, 0, 
        133120, 0, 0, 0, 266240, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 
        32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 
        0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 
        0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 
        0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 
        0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 
        0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554432, 0, 0, 
        0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 0, 536870917, 0, 0, 
        0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 
        0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 0, 0, 262152, 0, 
        0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 
        0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67108864, 0, 
        0, 0, 134217728, 0, 0, 0, 268435457, 0, 0, 0, 536870914, 0, 0, 0, 1073741828, 0, 
        0, 0, 2147483656, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 64, 0, 
        0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1048576, 
        0, 0, 0, 2097152, 0, 0, 0, 4194305, 0, 0, 0, 8388610, 0, 0, 0, 16777220, 
        0, 0, 0, 33554441, 0, 0, 0, 67108882, 0, 0, 0, 134217764, 0, 0, 0, 268435528, 
        0, 0, 0, 536871056, 0, 0, 0, 1073742112, 0, 0, 0, 2147484224, 0, 0, 0, 1152, 
        0, 0, 0, 2304, 0, 0, 0, 4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 
        0, 0, 0, 36864, 0, 0, 0, 73728, 0, 0, 0, 147456, 0, 0, 0, 294912, 
        0, 0, 0, 589824, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 
    },
    {
        0, 0, 0, 0, 8390656, 0, 0, 0, 16781312, 0, 0, 0, 33562625, 0, 0, 0, 
        67125250, 0, 0, 0, 134250500, 0, 0, 0, 268501000, 0, 0, 0, 537002000, 0, 0, 0, 
        1074004000, 0, 0, 0, 2148008001, 0, 0, 0, 1048706, 0, 0, 0, 2097412, 0, 0, 0, 
        4194824, 0, 0, 0, 8389648, 0, 0, 0, 16779296, 0, 0, 0, 33558593, 0, 0, 0, 
        67117186, 0, 0, 0, 134234372, 0, 0, 0, 268468744, 0, 0, 0, 536937488, 0, 0, 0, 
        1073874976, 0, 0, 0, 2147749953, 0, 0, 0, 532610, 0, 0, 0, 1065220, 0, 0, 0, 
        2130440, 0, 0, 0, 4260880, 0, 0, 0, 131104, 0, 0, 0, 262208, 0, 0, 0, 
        524416, 0, 0, 0, 1048832, 0, 0, 0, 2097664, 0, 0, 0, 4195328, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 131092, 0, 0, 0, 262184, 0, 0, 0, 524368, 0, 0, 0, 1048736, 0, 
        0, 0, 2097472, 0, 0, 0, 4194944, 0, 0, 0, 8389888, 0, 0, 0, 16779776, 0, 
        0, 0, 33559552, 0, 0, 0, 67119104, 0, 0, 0, 134238208, 0, 0, 0, 268476416, 0, 
        0, 0, 536952832, 0, 0, 0, 1073905665, 0, 0, 0, 2147811330, 0, 0, 0, 524304, 0, 
        0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 0, 0, 8388864, 0, 
        0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67110912, 0, 0, 0, 134221824, 0, 
        0, 0, 268443649, 0, 0, 0, 536887298, 0, 0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33280, 
        0, 0, 0, 66560, 0, 0, 0, 133120, 0, 0, 0, 266240, 0, 0, 0, 532480, 
        0, 0, 0, 1064960, 0, 0, 0, 2129920, 0, 0, 0, 4259841, 0, 0, 0, 8519682, 
        0, 0, 0, 17039364, 0, 0, 0, 34078729, 0, 0, 0, 68157458, 0, 0, 0, 136314916, 
        0, 0, 0, 272629833, 0, 0, 0, 545259666, 0, 0, 0, 1090519332, 0, 0, 0, 2181038665, 
        0, 0, 0, 67110034, 0, 0, 0, 134220068, 0, 0, 0, 268440136, 0, 0, 0, 536880272, 
        0, 0, 0, 1073760544, 0, 0, 0, 2147487808, 0, 0, 0, 8320, 0, 0, 0, 16640, 
    },
    {
        0, 0, 0, 0, 134300932, 0, 0, 0, 268601864, 0, 0, 0, 537203728, 0, 0, 0, 
        1074407456, 0, 0, 0, 2148814913, 0, 0, 0, 2662530, 0, 0, 0, 5325060, 0, 0, 0, 
        10650120, 0, 0, 0, 21300240, 0, 0, 0, 42600481, 0, 0, 0, 85200962, 0, 0, 0, 
        170401925, 0, 0, 0, 340803850, 0, 0, 0, 681607700, 0, 0, 0, 1363215400, 0, 0, 0, 
        2726430800, 0, 0, 0, 1157894304, 0, 0, 0, 2315788608, 0, 0, 0, 336609920, 0, 0, 0, 
        673219840, 0, 0, 0, 1346439680, 0, 0, 0, 2692879361, 0, 0, 0, 1090791426, 0, 0, 0, 
        2181582852, 0, 0, 0, 68198408, 0, 0, 0, 2098452, 0, 0, 0, 4196904, 0, 0, 0, 
        8393808, 0, 0, 0, 16787616, 0, 0, 0, 33575233, 0, 0, 0, 67150466, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 2560, 0, 0, 0, 5120, 0, 0, 
        0, 10240, 0, 0, 0, 20480, 0, 0, 0, 40960, 0, 0, 0, 81920, 0, 0, 
        0, 163840, 0, 0, 0, 327680, 0, 0, 0, 655360, 0, 0, 0, 1310720, 0, 0, 
        0, 2621440, 0, 0, 0, 5242880, 0, 0, 0, 10485760, 0, 0, 0, 20971520, 0, 0, 
        0, 41943040, 0, 0, 0, 83886080, 0, 0, 0, 167772161, 0, 0, 0, 335544322, 0, 0, 
        0, 671088644, 0, 0, 0, 1342177288, 0, 0, 0, 2684354577, 0, 0, 0, 1073741858, 0, 0, 
        0, 2147483716, 0, 0, 0, 136, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 335546385, 0, 0, 0, 671092770, 0, 0, 0, 1342185541, 0, 0, 0, 2684371082, 0, 
        0, 0, 1073774869, 0, 0, 0, 2147549738, 0, 0, 0, 132180, 0, 0, 0, 264360, 0, 
        0, 0, 528720, 0, 0, 0, 1057440, 0, 0, 0, 2114880, 0, 0, 0, 4229761, 0, 
        0, 0, 8459522, 0, 0, 0, 16919044, 0, 0, 0, 33838088, 0, 0, 0, 269000704, 0, 
        0, 0, 538001408, 0, 0, 0, 1076002817, 0, 0, 0, 2152005634, 0, 0, 0, 9043972, 0, 
        0, 0, 18087944, 0, 0, 0, 36175888, 0, 0, 0, 72351776, 0, 0, 0, 144703552, 0, 
        0, 0, 289407105, 0, 0, 0, 578814210, 0, 0, 0, 1157628420, 0, 0, 0, 2315256840, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180224, 
        0, 0, 0, 360448, 0, 0, 0, 720896, 0, 0, 0, 1441792, 0, 0, 0, 2883584, 
        0, 0, 0, 5767169, 0, 0, 0, 11534338, 0, 0, 0, 23068677, 0, 0, 0, 46137354, 
        0, 0, 0, 92274708, 0, 0, 0, 184549417, 0, 0, 0, 369098835, 0, 0, 0, 738197670, 
        0, 0, 0, 1476395340, 0, 0, 0, 2952790680, 0, 0, 0, 1610614064, 0, 0, 0, 3221228128, 
        0, 0, 0, 2147488960, 0, 0, 0, 10624, 0, 0, 0, 21248, 0, 0, 0, 42496, 
        0, 0, 0, 84992, 0, 0, 0, 22528, 0, 0, 0, 45056, 0, 0, 0, 90112, 
    },
    {
        0, 0, 0, 0, 826542200, 0, 0, 0, 1653084401, 0, 0, 0, 3306168803, 0, 0, 0, 
        2317370310, 0, 0, 0, 339773324, 0, 0, 0, 679546648, 0, 0, 0, 1359093296, 0, 0, 0, 
        2718186592, 0, 0, 0, 1141405888, 0, 0, 0, 2282811777, 0, 0, 0, 270656258, 0, 0, 0, 
        541312516, 0, 0, 0, 1082625032, 0, 0, 0, 2165250065, 0, 0, 0, 35532835, 0, 0, 0, 
        71065670, 0, 0, 0, 142131340, 0, 0, 0, 284262680, 0, 0, 0, 568525360, 0, 0, 0, 
        1137050721, 0, 0, 0, 2274101442, 0, 0, 0, 253235589, 0, 0, 0, 506471179, 0, 0, 0, 
        1012942358, 0, 0, 0, 2025884716, 0, 0, 0, 3234140193, 0, 0, 0, 2173313091, 0, 0, 0, 
        51658887, 0, 0, 0, 103317775, 0, 0, 0, 206635550, 0, 0, 0, 413271100, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8421376, 0, 0, 
        0, 16842752, 0, 0, 0, 33685504, 0, 0, 0, 67371008, 0, 0, 0, 134742017, 0, 0, 
        0, 269484034, 0, 0, 0, 538968069, 0, 0, 0, 1077936138, 0, 0, 0, 2155872276, 0, 0, 
        0, 16777256, 0, 0, 0, 33554512, 0, 0, 0, 67109024, 0, 0, 0, 134218049, 0, 0, 
        0, 268436098, 0, 0, 0, 536872197, 0, 0, 0, 1073744394, 0, 0, 0, 2147488788, 0, 0, 
        0, 10280, 0, 0, 0, 20560, 0, 0, 0, 41120, 0, 0, 0, 82240, 0, 0, 
        0, 164480, 0, 0, 0, 328960, 0, 0, 0, 657920, 0, 0, 0, 1315840, 0, 0, 
        0, 2631680, 0, 0, 0, 5263360, 0, 0, 0, 2105344, 0, 0, 0, 4210688, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 539164932, 0, 0, 0, 1078329864, 0, 0, 0, 2156659728, 0, 0, 0, 18352160, 0, 
        0, 0, 36704320, 0, 0, 0, 73408640, 0, 0, 0, 146817280, 0, 0, 0, 293634560, 0, 
        0, 0, 587269120, 0, 0, 0, 1174538240, 0, 0, 0, 2349076480, 0, 0, 0, 403185665, 0, 
        0, 0, 806371331, 0, 0, 0, 1612742663, 0, 0, 0, 3225485326, 0, 0, 0, 2694906136, 0, 
        0, 0, 1094844976, 0, 0, 0, 2189689952, 0, 0, 0, 84412608, 0, 0, 0, 168825216, 0, 
        0, 0, 337650433, 0, 0, 0, 675300866, 0, 0, 0, 1350601732, 0, 0, 0, 2701203464, 0, 
        0, 0, 1107439632, 0, 0, 0, 2214879264, 0, 0, 0, 134791233, 0, 0, 0, 269582466, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37905416, 
        0, 0, 0, 75810832, 0, 0, 0, 151621664, 0, 0, 0, 303243329, 0, 0, 0, 606486658, 
        0, 0, 0, 1212973317, 0, 0, 0, 2425946634, 0, 0, 0, 556925972, 0, 0, 0, 1113851944, 
        0, 0, 0, 2227703889, 0, 0, 0, 160440482, 0, 0, 0, 320880965, 0, 0, 0, 641761930, 
        0, 0, 0, 1283523860, 0, 0, 0, 2567047720, 0, 0, 0, 839128145, 0, 0, 0, 1678256290, 
        0, 0, 0, 3356512580, 0, 0, 0, 2418057864, 0, 0, 0, 541148433, 0, 0, 0, 1082296866, 
        0, 0, 0, 2164593732, 0, 0, 0, 4738177, 0, 0, 0, 9476354, 0, 0, 0, 18952708, 
    },
    {
        0, 0, 0, 0, 2499687121, 0, 0, 0, 704406946, 0, 0, 0, 1408813893, 0, 0, 0, 
        2817627786, 0, 0, 0, 1340288277, 0, 0, 0, 2680576554, 0, 0, 0, 1066185813, 0, 0, 0, 
        2132371627, 0, 0, 0, 4264743254, 0, 0, 0, 4234519213, 0, 0, 0, 4174071131, 0, 0, 0, 
        4053174967, 0, 0, 0, 3811382638, 0, 0, 0, 3327797980, 0, 0, 0, 2360628665, 0, 0, 0, 
        426290034, 0, 0, 0, 852580069, 0, 0, 0, 1705160138, 0, 0, 0, 3410320276, 0, 0, 0, 
        2525673256, 0, 0, 0, 756379216, 0, 0, 0, 1512758433, 0, 0, 0, 3025516867, 0, 0, 0, 
        1756066438, 0, 0, 0, 3512132877, 0, 0, 0, 911472843, 0, 0, 0, 1822945686, 0, 0, 0, 
        3645891373, 0, 0, 0, 2996815450, 0, 0, 0, 1698663604, 0, 0, 0, 3397327208, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 591396869, 0, 0, 
        0, 1182793738, 0, 0, 0, 2365587477, 0, 0, 0, 436207659, 0, 0, 0, 872415319, 0, 0, 
        0, 1744830638, 0, 0, 0, 3489661276, 0, 0, 0, 2684355257, 0, 0, 0, 1073743218, 0, 0, 
        0, 2147486436, 0, 0, 0, 5576, 0, 0, 0, 11152, 0, 0, 0, 22304, 0, 0, 
        0, 44608, 0, 0, 0, 89216, 0, 0, 0, 178432, 0, 0, 0, 356864, 0, 0, 
        0, 713728, 0, 0, 0, 1427456, 0, 0, 0, 2854912, 0, 0, 0, 5709824, 0, 0, 
        0, 11419648, 0, 0, 0, 22839296, 0, 0, 0, 45678592, 0, 0, 0, 91357184, 0, 0, 
        0, 182714369, 0, 0, 0, 365428738, 0, 0, 0, 147849217, 0, 0, 0, 295698434, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 490817699, 0, 0, 0, 981635398, 0, 0, 0, 1963270797, 0, 0, 0, 3926541594, 0, 
        0, 0, 3558115892, 0, 0, 0, 2821264488, 0, 0, 0, 1347561681, 0, 0, 0, 2695123362, 0, 
        0, 0, 1095279429, 0, 0, 0, 2190558858, 0, 0, 0, 86150421, 0, 0, 0, 172300842, 0, 
        0, 0, 344601685, 0, 0, 0, 689203370, 0, 0, 0, 1378406740, 0, 0, 0, 3104893450, 0, 
        0, 0, 1914819604, 0, 0, 0, 3829639209, 0, 0, 0, 3364311122, 0, 0, 0, 2433654948, 0, 
        0, 0, 572342600, 0, 0, 0, 1144685201, 0, 0, 0, 2289370402, 0, 0, 0, 283773509, 0, 
        0, 0, 567547018, 0, 0, 0, 1135094036, 0, 0, 0, 2270188072, 0, 0, 0, 245408849, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2731147994, 
        0, 0, 0, 1167328692, 0, 0, 0, 2334657385, 0, 0, 0, 374347474, 0, 0, 0, 748694948, 
        0, 0, 0, 1497389897, 0, 0, 0, 2994779795, 0, 0, 0, 1694592294, 0, 0, 0, 3389184589, 
        0, 0, 0, 2483401882, 0, 0, 0, 671836468, 0, 0, 0, 1343672936, 0, 0, 0, 2687345872, 
        0, 0, 0, 1079724449, 0, 0, 0, 2159448898, 0, 0, 0, 23930501, 0, 0, 0, 47861002, 
        0, 0, 0, 95722004, 0, 0, 0, 191444008, 0, 0, 0, 382888016, 0, 0, 0, 765776032, 
        0, 0, 0, 1531552064, 0, 0, 0, 341393499, 0, 0, 0, 682786998, 0, 0, 0, 1365573997, 
    },
    {
        0, 0, 0, 0, 2271571420, 0, 0, 0, 248175545, 0, 0, 0, 496351090, 0, 0, 0, 
        992702181, 0, 0, 0, 1985404363, 0, 0, 0, 3970808727, 0, 0, 0, 3646650159, 0, 0, 0, 
        2998333022, 0, 0, 0, 1701698748, 0, 0, 0, 3403397496, 0, 0, 0, 2511827697, 0, 0, 0, 
        728688099, 0, 0, 0, 1457376199, 0, 0, 0, 2914752399, 0, 0, 0, 1534537503, 0, 0, 0, 
        3069075006, 0, 0, 0, 1843182716, 0, 0, 0, 3686365432, 0, 0, 0, 3077763568, 0, 0, 0, 
        1860559841, 0, 0, 0, 3721119683, 0, 0, 0, 3147272070, 0, 0, 0, 1999576845, 0, 0, 0, 
        3999153690, 0, 0, 0, 3703340085, 0, 0, 0, 1042126263, 0, 0, 0, 2084252526, 0, 0, 0, 
        4168505053, 0, 0, 0, 4042042811, 0, 0, 0, 3789118327, 0, 0, 0, 3283269358, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 661652741, 0, 0, 
        0, 1323305483, 0, 0, 0, 2646610967, 0, 0, 0, 998254638, 0, 0, 0, 1996509277, 0, 0, 
        0, 3993018554, 0, 0, 0, 3691069813, 0, 0, 0, 3087172330, 0, 0, 0, 1879377365, 0, 0, 
        0, 3758754731, 0, 0, 0, 3222542166, 0, 0, 0, 2150117036, 0, 0, 0, 5266776, 0, 0, 
        0, 10533552, 0, 0, 0, 21067104, 0, 0, 0, 42134208, 0, 0, 0, 84268416, 0, 0, 
        0, 168536833, 0, 0, 0, 337073666, 0, 0, 0, 674147332, 0, 0, 0, 1348294664, 0, 0, 
        0, 2696589329, 0, 0, 0, 1098211362, 0, 0, 0, 2196422724, 0, 0, 0, 97878152, 0, 0, 
        0, 195756305, 0, 0, 0, 391512610, 0, 0, 0, 165413185, 0, 0, 0, 330826370, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2541187255, 0, 0, 0, 787407215, 0, 0, 0, 1574814430, 0, 0, 0, 3149628860, 0, 
        0, 0, 2004290425, 0, 0, 0, 4008580850, 0, 0, 0, 3722194405, 0, 0, 0, 3149421515, 0, 
        0, 0, 2003875734, 0, 0, 0, 4007751468, 0, 0, 0, 3720535640, 0, 0, 0, 3146103984, 0, 
        0, 0, 1997240673, 0, 0, 0, 3994481347, 0, 0, 0, 3693995398, 0, 0, 0, 791460795, 0, 
        0, 0, 1582921591, 0, 0, 0, 3165843182, 0, 0, 0, 2036719068, 0, 0, 0, 4073438136, 0, 
        0, 0, 3851908976, 0, 0, 0, 3408850657, 0, 0, 0, 2522734018, 0, 0, 0, 750500741, 0, 
        0, 0, 1501001483, 0, 0, 0, 3002002966, 0, 0, 0, 1709038637, 0, 0, 0, 3418077275, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3732057110, 
        0, 0, 0, 3169146925, 0, 0, 0, 2043326555, 0, 0, 0, 4086653111, 0, 0, 0, 3878338927, 
        0, 0, 0, 3461710558, 0, 0, 0, 2628453820, 0, 0, 0, 961940345, 0, 0, 0, 1923880691, 
        0, 0, 0, 3847761383, 0, 0, 0, 3400555471, 0, 0, 0, 2506143647, 0, 0, 0, 717319998, 
        0, 0, 0, 1434639996, 0, 0, 0, 2869279993, 0, 0, 0, 1443592691, 0, 0, 0, 2887185382, 
        0, 0, 0, 1479403468, 0, 0, 0, 2958806937, 0, 0, 0, 1622646578, 0, 0, 0, 3245293157, 
        0, 0, 0, 2195619018, 0, 0, 0, 3687732610, 0, 0, 0, 3080497925, 0, 0, 0, 1866028555, 
    },
    {
        0, 0, 0, 0, 1739616249, 0, 0, 0, 3479232498, 0, 0, 0, 2663497700, 0, 0, 0, 
        1032028104, 0, 0, 0, 2064056209, 0, 0, 0, 4128112418, 0, 0, 0, 3961257541, 0, 0, 0, 
        3627547787, 0, 0, 0, 2960128279, 0, 0, 0, 1625289262, 0, 0, 0, 3250578525, 0, 0, 0, 
        2206189754, 0, 0, 0, 117412213, 0, 0, 0, 234824426, 0, 0, 0, 469648853, 0, 0, 0, 
        939297707, 0, 0, 0, 1878595415, 0, 0, 0, 3757190830, 0, 0, 0, 3219414364, 0, 0, 0, 
        2143861433, 0, 0, 0, 4287722866, 0, 0, 0, 4280478436, 0, 0, 0, 4265989576, 0, 0, 0, 
        4237011857, 0, 0, 0, 4179056419, 0, 0, 0, 2510209471, 0, 0, 0, 725451647, 0, 0, 0, 
        1450903295, 0, 0, 0, 2901806591, 0, 0, 0, 1508645886, 0, 0, 0, 3017291772, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2815455249, 0, 0, 
        0, 1335943203, 0, 0, 0, 2671886407, 0, 0, 0, 1048805518, 0, 0, 0, 2097611036, 0, 0, 
        0, 4195222072, 0, 0, 0, 4095476849, 0, 0, 0, 3895986402, 0, 0, 0, 3497005508, 0, 0, 
        0, 2699043721, 0, 0, 0, 1103120146, 0, 0, 0, 2206240292, 0, 0, 0, 117513288, 0, 0, 
        0, 235026577, 0, 0, 0, 470053155, 0, 0, 0, 940106310, 0, 0, 0, 1880212621, 0, 0, 
        0, 3760425243, 0, 0, 0, 3225883190, 0, 0, 0, 2156799084, 0, 0, 0, 18630872, 0, 0, 
        0, 37261744, 0, 0, 0, 74523488, 0, 0, 0, 149046977, 0, 0, 0, 298093954, 0, 0, 
        0, 596187909, 0, 0, 0, 1192375818, 0, 0, 0, 703863812, 0, 0, 0, 1407727624, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2614536692, 0, 0, 0, 934106089, 0, 0, 0, 1868212179, 0, 0, 0, 3736424359, 0, 
        0, 0, 3177881422, 0, 0, 0, 2060795549, 0, 0, 0, 4121591099, 0, 0, 0, 3948214903, 0, 
        0, 0, 3601462510, 0, 0, 0, 2907957725, 0, 0, 0, 1520948154, 0, 0, 0, 3041896308, 0, 
        0, 0, 1788825320, 0, 0, 0, 3577650640, 0, 0, 0, 2860333984, 0, 0, 0, 3475824309, 0, 
        0, 0, 2656681322, 0, 0, 0, 1018395349, 0, 0, 0, 2036790698, 0, 0, 0, 4073581396, 0, 
        0, 0, 3852195497, 0, 0, 0, 3409423699, 0, 0, 0, 2523880103, 0, 0, 0, 752792911, 0, 
        0, 0, 1505585823, 0, 0, 0, 3011171646, 0, 0, 0, 1727375997, 0, 0, 0, 3454751994, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2033130968, 
        0, 0, 0, 4066261936, 0, 0, 0, 3837556576, 0, 0, 0, 3380145857, 0, 0, 0, 2465324418, 
        0, 0, 0, 635681541, 0, 0, 0, 1271363082, 0, 0, 0, 2542726165, 0, 0, 0, 790485035, 
        0, 0, 0, 1580970071, 0, 0, 0, 3161940143, 0, 0, 0, 2028912991, 0, 0, 0, 4057825983, 
        0, 0, 0, 3820684671, 0, 0, 0, 3346402046, 0, 0, 0, 2397836796, 0, 0, 0, 500706297, 
        0, 0, 0, 1001412595, 0, 0, 0, 2002825190, 0, 0, 0, 4005650380, 0, 0, 0, 3716333464, 
        0, 0, 0, 3137699633, 0, 0, 0, 254141371, 0, 0, 0, 508282742, 0, 0, 0, 1016565484, 
    },
    {
        0, 0, 0, 0, 1915396941, 0, 0, 0, 3830793883, 0, 0, 0, 3366620471, 0, 0, 0, 
        2438273647, 0, 0, 0, 581579999, 0, 0, 0, 1163159998, 0, 0, 0, 2326319996, 0, 0, 0, 
        357672696, 0, 0, 0, 715345393, 0, 0, 0, 1430690786, 0, 0, 0, 2861381572, 0, 0, 0, 
        1427795848, 0, 0, 0, 2855591696, 0, 0, 0, 1416216096, 0, 0, 0, 2832432193, 0, 0, 0, 
        1369897090, 0, 0, 0, 2739794180, 0, 0, 0, 1184621065, 0, 0, 0, 2369242131, 0, 0, 0, 
        443516967, 0, 0, 0, 887033934, 0, 0, 0, 1774067868, 0, 0, 0, 3548135736, 0, 0, 0, 
        2801304176, 0, 0, 0, 1307641056, 0, 0, 0, 3922242189, 0, 0, 0, 3549517082, 0, 0, 0, 
        2804066868, 0, 0, 0, 1313166441, 0, 0, 0, 2626332883, 0, 0, 0, 957698470, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1432822912, 0, 0, 
        0, 2865645824, 0, 0, 0, 1436324352, 0, 0, 0, 2872648704, 0, 0, 0, 1450330112, 0, 0, 
        0, 2900660224, 0, 0, 0, 1506353153, 0, 0, 0, 3012706307, 0, 0, 0, 1730445319, 0, 0, 
        0, 3460890639, 0, 0, 0, 2626813983, 0, 0, 0, 958660670, 0, 0, 0, 1917321341, 0, 0, 
        0, 3834642683, 0, 0, 0, 3374318071, 0, 0, 0, 2453668846, 0, 0, 0, 612370397, 0, 0, 
        0, 1224740795, 0, 0, 0, 2449481590, 0, 0, 0, 603995885, 0, 0, 0, 1207991771, 0, 0, 
        0, 2415983542, 0, 0, 0, 536999789, 0, 0, 0, 1073999578, 0, 0, 0, 2147999156, 0, 0, 
        0, 1031016, 0, 0, 0, 2062032, 0, 0, 0, 1431947552, 0, 0, 0, 2863895104, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2983242506, 0, 0, 0, 1671517716, 0, 0, 0, 3343035433, 0, 0, 0, 2391103570, 0, 
        0, 0, 487239844, 0, 0, 0, 974479689, 0, 0, 0, 1948959378, 0, 0, 0, 3897918757, 0, 
        0, 0, 3500870219, 0, 0, 0, 2706773142, 0, 0, 0, 1118578988, 0, 0, 0, 2237157976, 0, 
        0, 0, 179348657, 0, 0, 0, 358697315, 0, 0, 0, 717394631, 0, 0, 0, 3830812293, 0, 
        0, 0, 3366657290, 0, 0, 0, 2438347285, 0, 0, 0, 581727274, 0, 0, 0, 1163454549, 0, 
        0, 0, 2326909099, 0, 0, 0, 358850902, 0, 0, 0, 717701804, 0, 0, 0, 1435403608, 0, 
        0, 0, 2870807216, 0, 0, 0, 1446647137, 0, 0, 0, 2893294274, 0, 0, 0, 1491621253, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2199499341, 
        0, 0, 0, 104031387, 0, 0, 0, 208062775, 0, 0, 0, 416125551, 0, 0, 0, 832251102, 
        0, 0, 0, 1664502205, 0, 0, 0, 3329004410, 0, 0, 0, 2363041525, 0, 0, 0, 431115754, 
        0, 0, 0, 862231508, 0, 0, 0, 1724463016, 0, 0, 0, 3448926032, 0, 0, 0, 2602884769, 
        0, 0, 0, 910802242, 0, 0, 0, 1821604484, 0, 0, 0, 3643208968, 0, 0, 0, 2991450640, 
        0, 0, 0, 1687933984, 0, 0, 0, 3375867968, 0, 0, 0, 2456768640, 0, 0, 0, 618569985, 
        0, 0, 0, 1237139970, 0, 0, 0, 274937417, 0, 0, 0, 549874835, 0, 0, 0, 1099749670, 
    },
    {
        0, 0, 0, 0, 4038889453, 0, 0, 0, 3782811611, 0, 0, 0, 3270655926, 0, 0, 0, 
        2246344557, 0, 0, 0, 197721819, 0, 0, 0, 395443639, 0, 0, 0, 790887279, 0, 0, 0, 
        1581774559, 0, 0, 0, 3163549119, 0, 0, 0, 2032130942, 0, 0, 0, 4064261884, 0, 0, 0, 
        3833556473, 0, 0, 0, 3372145651, 0, 0, 0, 2449324007, 0, 0, 0, 603680719, 0, 0, 0, 
        1207361439, 0, 0, 0, 2414722878, 0, 0, 0, 534478461, 0, 0, 0, 1068956923, 0, 0, 0, 
        2137913847, 0, 0, 0, 4275827694, 0, 0, 0, 4256688093, 0, 0, 0, 4218408890, 0, 0, 0, 
        4141850484, 0, 0, 0, 3988733673, 0, 0, 0, 734196287, 0, 0, 0, 1468392575, 0, 0, 0, 
        2936785150, 0, 0, 0, 1578603005, 0, 0, 0, 3157206011, 0, 0, 0, 2019444726, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2740852545, 0, 0, 
        0, 1186737794, 0, 0, 0, 2373475589, 0, 0, 0, 451983883, 0, 0, 0, 903967767, 0, 0, 
        0, 1807935534, 0, 0, 0, 3615871068, 0, 0, 0, 2936774840, 0, 0, 0, 1578582385, 0, 0, 
        0, 3157164770, 0, 0, 0, 2019362244, 0, 0, 0, 4038724489, 0, 0, 0, 3782481683, 0, 0, 
        0, 3269996070, 0, 0, 0, 2245024844, 0, 0, 0, 195082393, 0, 0, 0, 390164786, 0, 0, 
        0, 780329572, 0, 0, 0, 1560659145, 0, 0, 0, 3121318290, 0, 0, 0, 1947669285, 0, 0, 
        0, 3895338570, 0, 0, 0, 3495709844, 0, 0, 0, 2696452393, 0, 0, 0, 1097937490, 0, 0, 
        0, 2195874980, 0, 0, 0, 96782664, 0, 0, 0, 2832696784, 0, 0, 0, 1370426272, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2797805596, 0, 0, 0, 1300643896, 0, 0, 0, 2601287792, 0, 0, 0, 907608289, 0, 
        0, 0, 1815216578, 0, 0, 0, 3630433157, 0, 0, 0, 2965899019, 0, 0, 0, 1636830742, 0, 
        0, 0, 3273661484, 0, 0, 0, 2252355672, 0, 0, 0, 209744048, 0, 0, 0, 419488096, 0, 
        0, 0, 838976192, 0, 0, 0, 1677952385, 0, 0, 0, 3355904770, 0, 0, 0, 919418393, 0, 
        0, 0, 1838836786, 0, 0, 0, 3677673572, 0, 0, 0, 3060379848, 0, 0, 0, 1825792400, 0, 
        0, 0, 3651584800, 0, 0, 0, 3008202304, 0, 0, 0, 1721437312, 0, 0, 0, 3442874624, 0, 
        0, 0, 2590781953, 0, 0, 0, 886596611, 0, 0, 0, 1773193223, 0, 0, 0, 3546386446, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4196822677, 
        0, 0, 0, 4098678059, 0, 0, 0, 3902388822, 0, 0, 0, 3509810348, 0, 0, 0, 2724653400, 
        0, 0, 0, 1154339505, 0, 0, 0, 2308679010, 0, 0, 0, 322390725, 0, 0, 0, 644781450, 
        0, 0, 0, 1289562901, 0, 0, 0, 2579125802, 0, 0, 0, 863284308, 0, 0, 0, 1726568616, 
        0, 0, 0, 3453137233, 0, 0, 0, 2611307171, 0, 0, 0, 927647046, 0, 0, 0, 1855294093, 
        0, 0, 0, 3710588186, 0, 0, 0, 3126209076, 0, 0, 0, 1957450856, 0, 0, 0, 3914901713, 
        0, 0, 0, 3534836131, 0, 0, 0, 1598344658, 0, 0, 0, 3196689317, 0, 0, 0, 2098411338, 
    },
    {
        0, 0, 0, 0, 3824344628, 0, 0, 0, 3353721960, 0, 0, 0, 2412476624, 0, 0, 0, 
        529985953, 0, 0, 0, 1059971907, 0, 0, 0, 2119943815, 0, 0, 0, 4239887631, 0, 0, 0, 
        4184807967, 0, 0, 0, 4074648638, 0, 0, 0, 3854329981, 0, 0, 0, 3413692666, 0, 0, 0, 
        2532418036, 0, 0, 0, 769868776, 0, 0, 0, 1539737553, 0, 0, 0, 3079475106, 0, 0, 0, 
        1863982917, 0, 0, 0, 3727965834, 0, 0, 0, 3160964373, 0, 0, 0, 2026961450, 0, 0, 0, 
        4053922901, 0, 0, 0, 3812878506, 0, 0, 0, 3330789716, 0, 0, 0, 2366612137, 0, 0, 0, 
        438256979, 0, 0, 0, 876513958, 0, 0, 0, 2341456760, 0, 0, 0, 387946225, 0, 0, 0, 
        775892451, 0, 0, 0, 1551784902, 0, 0, 0, 3103569805, 0, 0, 0, 1912172314, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3220345106, 0, 0, 
        0, 2145722916, 0, 0, 0, 4291445832, 0, 0, 0, 4287924368, 0, 0, 0, 4280881440, 0, 0, 
        0, 4266795584, 0, 0, 0, 4238623872, 0, 0, 0, 4182280448, 0, 0, 0, 4069593601, 0, 0, 
        0, 3844219907, 0, 0, 0, 3393472519, 0, 0, 0, 2491977742, 0, 0, 0, 688988188, 0, 0, 
        0, 1377976376, 0, 0, 0, 2755952753, 0, 0, 0, 1216938211, 0, 0, 0, 2433876422, 0, 0, 
        0, 572785549, 0, 0, 0, 1145571098, 0, 0, 0, 2291142197, 0, 0, 0, 287317098, 0, 0, 
        0, 574634197, 0, 0, 0, 1149268394, 0, 0, 0, 2298536789, 0, 0, 0, 302106282, 0, 0, 
        0, 604212565, 0, 0, 0, 1208425131, 0, 0, 0, 805086276, 0, 0, 0, 1610172553, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 3324387232, 0, 0, 0, 2353807168, 0, 0, 0, 412647041, 0, 0, 0, 825294082, 0, 
        0, 0, 1650588165, 0, 0, 0, 3301176331, 0, 0, 0, 2307385367, 0, 0, 0, 319803438, 0, 
        0, 0, 639606877, 0, 0, 0, 1279213754, 0, 0, 0, 2558427508, 0, 0, 0, 821887721, 0, 
        0, 0, 1643775442, 0, 0, 0, 3287550884, 0, 0, 0, 2280134472, 0, 0, 0, 3388354864, 0, 
        0, 0, 2481742433, 0, 0, 0, 668517571, 0, 0, 0, 1337035143, 0, 0, 0, 2674070287, 0, 
        0, 0, 1053173279, 0, 0, 0, 2106346559, 0, 0, 0, 4212693118, 0, 0, 0, 4130418941, 0, 
        0, 0, 3965870586, 0, 0, 0, 3636773876, 0, 0, 0, 2978580456, 0, 0, 0, 1662193616, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2034053848, 
        0, 0, 0, 4068107696, 0, 0, 0, 3841248097, 0, 0, 0, 3387528899, 0, 0, 0, 2480090502, 
        0, 0, 0, 665213709, 0, 0, 0, 1330427418, 0, 0, 0, 2660854837, 0, 0, 0, 1026742378, 
        0, 0, 0, 2053484756, 0, 0, 0, 4106969513, 0, 0, 0, 3918971730, 0, 0, 0, 3542976165, 
        0, 0, 0, 2790985034, 0, 0, 0, 1287002772, 0, 0, 0, 2574005545, 0, 0, 0, 853043794, 
        0, 0, 0, 1706087588, 0, 0, 0, 3412175176, 0, 0, 0, 2529383056, 0, 0, 0, 763798816, 
        0, 0, 0, 1527597633, 0, 0, 0, 3475482203, 0, 0, 0, 2655997110, 0, 0, 0, 1017026924, 
    },
    {
        0, 0, 0, 0, 1099834596, 0, 0, 0, 2199669192, 0, 0, 0, 104371089, 0, 0, 0, 
        208742178, 0, 0, 0, 417484356, 0, 0, 0, 834968712, 0, 0, 0, 1669937425, 0, 0, 0, 
        3339874850, 0, 0, 0, 2384782404, 0, 0, 0, 474597512, 0, 0, 0, 949195024, 0, 0, 0, 
        1898390048, 0, 0, 0, 3796780096, 0, 0, 0, 3298592897, 0, 0, 0, 2302218499, 0, 0, 0, 
        309469703, 0, 0, 0, 618939406, 0, 0, 0, 1237878812, 0, 0, 0, 2475757624, 0, 0, 0, 
        656547953, 0, 0, 0, 1313095907, 0, 0, 0, 2626191815, 0, 0, 0, 957416334, 0, 0, 0, 
        1914832669, 0, 0, 0, 3829665339, 0, 0, 0, 2298886291, 0, 0, 0, 302805287, 0, 0, 0, 
        605610574, 0, 0, 0, 1211221148, 0, 0, 0, 2422442297, 0, 0, 0, 549917298, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 348140706, 0, 0, 
        0, 696281412, 0, 0, 0, 1392562824, 0, 0, 0, 2785125649, 0, 0, 0, 1275284003, 0, 0, 
        0, 2550568007, 0, 0, 0, 806168719, 0, 0, 0, 1612337439, 0, 0, 0, 3224674878, 0, 0, 
        0, 2154382460, 0, 0, 0, 13797624, 0, 0, 0, 27595248, 0, 0, 0, 55190496, 0, 0, 
        0, 110380992, 0, 0, 0, 220761985, 0, 0, 0, 441523971, 0, 0, 0, 883047943, 0, 0, 
        0, 1766095886, 0, 0, 0, 3532191772, 0, 0, 0, 2769416249, 0, 0, 0, 1243865203, 0, 0, 
        0, 2487730406, 0, 0, 0, 680493516, 0, 0, 0, 1360987032, 0, 0, 0, 2721974065, 0, 0, 
        0, 1148980834, 0, 0, 0, 2297961669, 0, 0, 0, 87035176, 0, 0, 0, 174070353, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 470870896, 0, 0, 0, 941741792, 0, 0, 0, 1883483584, 0, 0, 0, 3766967168, 0, 
        0, 0, 3238967041, 0, 0, 0, 2182966786, 0, 0, 0, 70966277, 0, 0, 0, 141932555, 0, 
        0, 0, 283865111, 0, 0, 0, 567730223, 0, 0, 0, 1135460447, 0, 0, 0, 2270920895, 0, 
        0, 0, 246874494, 0, 0, 0, 493748989, 0, 0, 0, 987497979, 0, 0, 0, 1772675207, 0, 
        0, 0, 3545350414, 0, 0, 0, 2795733533, 0, 0, 0, 1296499770, 0, 0, 0, 2592999541, 0, 
        0, 0, 891031787, 0, 0, 0, 1782063574, 0, 0, 0, 3564127149, 0, 0, 0, 2833287003, 0, 
        0, 0, 1371606711, 0, 0, 0, 2743213422, 0, 0, 0, 1191459548, 0, 0, 0, 2382919096, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30521863, 
        0, 0, 0, 61043727, 0, 0, 0, 122087454, 0, 0, 0, 244174909, 0, 0, 0, 488349818, 
        0, 0, 0, 976699637, 0, 0, 0, 1953399275, 0, 0, 0, 3906798551, 0, 0, 0, 3518629806, 
        0, 0, 0, 2742292316, 0, 0, 0, 1189617336, 0, 0, 0, 2379234673, 0, 0, 0, 463502051, 
        0, 0, 0, 927004102, 0, 0, 0, 1854008205, 0, 0, 0, 3708016410, 0, 0, 0, 3121065525, 
        0, 0, 0, 1947163754, 0, 0, 0, 3894327508, 0, 0, 0, 3493687720, 0, 0, 0, 2692408145, 
        0, 0, 0, 1089848995, 0, 0, 0, 2151298880, 0, 0, 0, 7630465, 0, 0, 0, 15260931, 
    },
    {
        0, 0, 0, 0, 3400190380, 0, 0, 0, 2505413465, 0, 0, 0, 715859635, 0, 0, 0, 
        1431719270, 0, 0, 0, 2863438540, 0, 0, 0, 1431909784, 0, 0, 0, 2863819568, 0, 0, 0, 
        1432671840, 0, 0, 0, 2865343680, 0, 0, 0, 1435720064, 0, 0, 0, 2871440128, 0, 0, 0, 
        1447912961, 0, 0, 0, 2895825923, 0, 0, 0, 1496684550, 0, 0, 0, 2993369100, 0, 0, 0, 
        1691770904, 0, 0, 0, 3383541809, 0, 0, 0, 2472116322, 0, 0, 0, 649265349, 0, 0, 0, 
        1298530698, 0, 0, 0, 2597061396, 0, 0, 0, 899155496, 0, 0, 0, 1798310993, 0, 0, 0, 
        3596621986, 0, 0, 0, 2898276677, 0, 0, 0, 2469047078, 0, 0, 0, 643126861, 0, 0, 0, 
        1286253722, 0, 0, 0, 2572507445, 0, 0, 0, 850047595, 0, 0, 0, 1700095190, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2692483345, 0, 0, 
        0, 1089999394, 0, 0, 0, 2179998788, 0, 0, 0, 65030280, 0, 0, 0, 130060560, 0, 0, 
        0, 260121121, 0, 0, 0, 520242243, 0, 0, 0, 1040484486, 0, 0, 0, 2080968972, 0, 0, 
        0, 4161937944, 0, 0, 0, 4028908593, 0, 0, 0, 3762849891, 0, 0, 0, 3230732486, 0, 0, 
        0, 2166497676, 0, 0, 0, 38028056, 0, 0, 0, 76056112, 0, 0, 0, 152112225, 0, 0, 
        0, 304224450, 0, 0, 0, 608448901, 0, 0, 0, 1216897803, 0, 0, 0, 2433795606, 0, 0, 
        0, 572623917, 0, 0, 0, 1145247834, 0, 0, 0, 2290495669, 0, 0, 0, 286024042, 0, 0, 
        0, 572048085, 0, 0, 0, 1144096170, 0, 0, 0, 673120836, 0, 0, 0, 1346241672, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 27673132, 0, 0, 0, 55346265, 0, 0, 0, 110692530, 0, 0, 0, 221385060, 0, 
        0, 0, 442770121, 0, 0, 0, 885540243, 0, 0, 0, 1771080487, 0, 0, 0, 3542160975, 0, 
        0, 0, 2789354654, 0, 0, 0, 1283742012, 0, 0, 0, 2567484024, 0, 0, 0, 840000753, 0, 
        0, 0, 1680001507, 0, 0, 0, 3360003015, 0, 0, 0, 2425038735, 0, 0, 0, 548408626, 0, 
        0, 0, 1096817252, 0, 0, 0, 2193634504, 0, 0, 0, 92301712, 0, 0, 0, 184603425, 0, 
        0, 0, 369206850, 0, 0, 0, 738413700, 0, 0, 0, 1476827400, 0, 0, 0, 2953654801, 0, 
        0, 0, 1612342306, 0, 0, 0, 3224684613, 0, 0, 0, 2154401931, 0, 0, 0, 13836566, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33833481, 
        0, 0, 0, 67666962, 0, 0, 0, 135333924, 0, 0, 0, 270667848, 0, 0, 0, 541335697, 
        0, 0, 0, 1082671394, 0, 0, 0, 2165342788, 0, 0, 0, 35718281, 0, 0, 0, 71436563, 
        0, 0, 0, 142873126, 0, 0, 0, 285746252, 0, 0, 0, 571492505, 0, 0, 0, 1142985010, 
        0, 0, 0, 2285970021, 0, 0, 0, 276972746, 0, 0, 0, 553945492, 0, 0, 0, 1107890985, 
        0, 0, 0, 2215781970, 0, 0, 0, 136596644, 0, 0, 0, 273193289, 0, 0, 0, 546386578, 
        0, 0, 0, 1092773156, 0, 0, 0, 2151712833, 0, 0, 0, 8458370, 0, 0, 0, 16916740, 
    },
    {
        0, 0, 0, 0, 2928597988, 0, 0, 0, 1562228680, 0, 0, 0, 3124457360, 0, 0, 0, 
        1953947424, 0, 0, 0, 3907894849, 0, 0, 0, 3520822403, 0, 0, 0, 2746677510, 0, 0, 0, 
        1198387725, 0, 0, 0, 2396775450, 0, 0, 0, 498583604, 0, 0, 0, 997167209, 0, 0, 0, 
        1994334419, 0, 0, 0, 3988668839, 0, 0, 0, 3682370382, 0, 0, 0, 3069773468, 0, 0, 0, 
        1844579640, 0, 0, 0, 3689159280, 0, 0, 0, 3083351264, 0, 0, 0, 1871735233, 0, 0, 0, 
        3743470466, 0, 0, 0, 3191973636, 0, 0, 0, 2088979976, 0, 0, 0, 4177959953, 0, 0, 0, 
        4060952610, 0, 0, 0, 3826937925, 0, 0, 0, 1723480943, 0, 0, 0, 3446961887, 0, 0, 0, 
        2598956478, 0, 0, 0, 902945660, 0, 0, 0, 1805891321, 0, 0, 0, 3611782642, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1473249760, 0, 0, 
        0, 2946499520, 0, 0, 0, 1598031745, 0, 0, 0, 3196063490, 0, 0, 0, 2097159684, 0, 0, 
        0, 4194319368, 0, 0, 0, 4093671441, 0, 0, 0, 3892375586, 0, 0, 0, 3489783876, 0, 0, 
        0, 2684600457, 0, 0, 0, 1074233618, 0, 0, 0, 2148467236, 0, 0, 0, 1967176, 0, 0, 
        0, 3934352, 0, 0, 0, 7868704, 0, 0, 0, 15737408, 0, 0, 0, 31474816, 0, 0, 
        0, 62949632, 0, 0, 0, 125899264, 0, 0, 0, 251798529, 0, 0, 0, 503597059, 0, 0, 
        0, 1007194118, 0, 0, 0, 2014388236, 0, 0, 0, 4028776473, 0, 0, 0, 3762585651, 0, 0, 
        0, 3230204006, 0, 0, 0, 2165440716, 0, 0, 0, 1442054264, 0, 0, 0, 2884108528, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1749068055, 0, 0, 0, 3498136111, 0, 0, 0, 2701304927, 0, 0, 0, 1107642558, 0, 
        0, 0, 2215285117, 0, 0, 0, 135602938, 0, 0, 0, 271205877, 0, 0, 0, 542411755, 0, 
        0, 0, 1084823510, 0, 0, 0, 2169647020, 0, 0, 0, 44326744, 0, 0, 0, 88653489, 0, 
        0, 0, 177306978, 0, 0, 0, 354613956, 0, 0, 0, 709227913, 0, 0, 0, 1019953669, 0, 
        0, 0, 2039907338, 0, 0, 0, 4079814677, 0, 0, 0, 3864662058, 0, 0, 0, 3434356820, 0, 
        0, 0, 2573746345, 0, 0, 0, 852525394, 0, 0, 0, 1705050788, 0, 0, 0, 3410101576, 0, 
        0, 0, 2525235857, 0, 0, 0, 755504418, 0, 0, 0, 1511008837, 0, 0, 0, 3022017675, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67141650, 
        0, 0, 0, 134283300, 0, 0, 0, 268566600, 0, 0, 0, 537133200, 0, 0, 0, 1074266400, 
        0, 0, 0, 2148532800, 0, 0, 0, 2098304, 0, 0, 0, 4196609, 0, 0, 0, 8393218, 
        0, 0, 0, 16786436, 0, 0, 0, 33572873, 0, 0, 0, 67145746, 0, 0, 0, 134291492, 
        0, 0, 0, 268582984, 0, 0, 0, 537165968, 0, 0, 0, 1074331936, 0, 0, 0, 2148663872, 
        0, 0, 0, 2360448, 0, 0, 0, 4720897, 0, 0, 0, 9441794, 0, 0, 0, 18883588, 
        0, 0, 0, 37767176, 0, 0, 0, 8392706, 0, 0, 0, 16785412, 0, 0, 0, 33570825, 
    },
    {
        0, 0, 0, 0, 1874778401, 0, 0, 0, 3749556802, 0, 0, 0, 3204146308, 0, 0, 0, 
        2113325320, 0, 0, 0, 4226650640, 0, 0, 0, 4158333984, 0, 0, 0, 4021700672, 0, 0, 0, 
        3748434048, 0, 0, 0, 3201900800, 0, 0, 0, 2108834304, 0, 0, 0, 4217668608, 0, 0, 0, 
        4140369920, 0, 0, 0, 3985772545, 0, 0, 0, 3676577794, 0, 0, 0, 3058188292, 0, 0, 0, 
        1821409288, 0, 0, 0, 3642818577, 0, 0, 0, 2990669858, 0, 0, 0, 1686372420, 0, 0, 0, 
        3372744841, 0, 0, 0, 2450522386, 0, 0, 0, 606077476, 0, 0, 0, 1212154952, 0, 0, 0, 
        2424309905, 0, 0, 0, 553652514, 0, 0, 0, 767490916, 0, 0, 0, 1534981833, 0, 0, 0, 
        3069963666, 0, 0, 0, 1844960036, 0, 0, 0, 3689920072, 0, 0, 0, 3084872848, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1442838528, 0, 0, 
        0, 2885677056, 0, 0, 0, 1476386816, 0, 0, 0, 2952773632, 0, 0, 0, 1610579969, 0, 0, 
        0, 3221159938, 0, 0, 0, 2147352580, 0, 0, 0, 4294705160, 0, 0, 0, 4294443024, 0, 0, 
        0, 4293918752, 0, 0, 0, 4292870208, 0, 0, 0, 4290773120, 0, 0, 0, 4286578944, 0, 0, 
        0, 4278190592, 0, 0, 0, 4261413888, 0, 0, 0, 4227860480, 0, 0, 0, 4160753664, 0, 0, 
        0, 4026540033, 0, 0, 0, 3758112771, 0, 0, 0, 3221258246, 0, 0, 0, 2147549196, 0, 0, 
        0, 131096, 0, 0, 0, 262192, 0, 0, 0, 524384, 0, 0, 0, 1048768, 0, 0, 
        0, 2097536, 0, 0, 0, 4195072, 0, 0, 0, 1434451456, 0, 0, 0, 2868902912, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2164392972, 0, 0, 0, 33818648, 0, 0, 0, 67637296, 0, 0, 0, 135274592, 0, 
        0, 0, 270549185, 0, 0, 0, 541098371, 0, 0, 0, 1082196742, 0, 0, 0, 2164393484, 0, 
        0, 0, 33819672, 0, 0, 0, 67639344, 0, 0, 0, 135278688, 0, 0, 0, 270557377, 0, 
        0, 0, 541114755, 0, 0, 0, 1082229511, 0, 0, 0, 2164459022, 0, 0, 0, 2198079504, 0, 
        0, 0, 101191712, 0, 0, 0, 202383424, 0, 0, 0, 404766849, 0, 0, 0, 809533698, 0, 
        0, 0, 1619067396, 0, 0, 0, 3238134792, 0, 0, 0, 2181302288, 0, 0, 0, 67637280, 0, 
        0, 0, 135274560, 0, 0, 0, 270549121, 0, 0, 0, 541098243, 0, 0, 0, 1082196486, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2304, 
        0, 0, 0, 4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 0, 0, 0, 36864, 
        0, 0, 0, 73728, 0, 0, 0, 147456, 0, 0, 0, 294912, 0, 0, 0, 589824, 
        0, 0, 0, 1179648, 0, 0, 0, 2359296, 0, 0, 0, 4718593, 0, 0, 0, 9437186, 
        0, 0, 0, 18874372, 0, 0, 0, 37748744, 0, 0, 0, 75497488, 0, 0, 0, 150994976, 
        0, 0, 0, 301989953, 0, 0, 0, 603979906, 0, 0, 0, 1207959812, 0, 0, 0, 2415919624, 
        0, 0, 0, 536871952, 0, 0, 0, 1073742112, 0, 0, 0, 2147484224, 0, 0, 0, 1152, 
    },
    {
        0, 0, 0, 0, 882001920, 0, 0, 0, 1764003840, 0, 0, 0, 3528007680, 0, 0, 0, 
        2761048065, 0, 0, 0, 1227128834, 0, 0, 0, 2454257668, 0, 0, 0, 613548040, 0, 0, 0, 
        1227096080, 0, 0, 0, 2454192160, 0, 0, 0, 613417024, 0, 0, 0, 1226834048, 0, 0, 0, 
        2453668096, 0, 0, 0, 612368896, 0, 0, 0, 1224737792, 0, 0, 0, 2449475584, 0, 0, 0, 
        603983872, 0, 0, 0, 1207967744, 0, 0, 0, 2415935489, 0, 0, 0, 536903682, 0, 0, 0, 
        1073807364, 0, 0, 0, 2147614729, 0, 0, 0, 262162, 0, 0, 0, 524324, 0, 0, 0, 
        1048648, 0, 0, 0, 2097296, 0, 0, 0, 886196512, 0, 0, 0, 1772393024, 0, 0, 0, 
        3544786048, 0, 0, 0, 2794604800, 0, 0, 0, 1294242304, 0, 0, 0, 2588484608, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 
        0, 32, 0, 0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 
        0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 
        0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 
        0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 
        0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 
        0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 
        0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483652, 0, 0, 0, 8, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 
        0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 0, 0, 262152, 0, 
        0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 
        0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67108864, 0, 
        0, 0, 134217728, 0, 0, 0, 268435457, 0, 0, 0, 536870914, 0, 0, 0, 1073741828, 0, 
        0, 0, 2147483656, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 64, 0, 
        0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8390658, 
        0, 0, 0, 16781316, 0, 0, 0, 33562633, 0, 0, 0, 67125266, 0, 0, 0, 134250532, 
        0, 0, 0, 268501064, 0, 0, 0, 537002128, 0, 0, 0, 1074004256, 0, 0, 0, 2148008512, 
        0, 0, 0, 1049728, 0, 0, 0, 2099456, 0, 0, 0, 4198913, 0, 0, 0, 8397826, 
        0, 0, 0, 16795652, 0, 0, 0, 33591305, 0, 0, 0, 67182610, 0, 0, 0, 134365220, 
        0, 0, 0, 268730440, 0, 0, 0, 537460880, 0, 0, 0, 1074921760, 0, 0, 0, 2149843520, 
        0, 0, 0, 4719745, 0, 0, 0, 1048832, 0, 0, 0, 2097664, 0, 0, 0, 4195329, 
    },
    {
        0, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 
        8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 0, 
        131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 
        2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 
        33554433, 0, 0, 0, 67108866, 0, 0, 0, 134217732, 0, 0, 0, 268435464, 0, 0, 0, 
        536870928, 0, 0, 0, 1073741856, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 
        260, 0, 0, 0, 520, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 
        64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 
        0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 32, 0, 0, 0, 64, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 131092, 0, 0, 0, 262184, 0, 0, 0, 524368, 0, 0, 0, 1048736, 0, 
        0, 0, 2097472, 0, 0, 0, 4194944, 0, 0, 0, 8389888, 0, 0, 0, 16779776, 0, 
        0, 0, 33559552, 0, 0, 0, 67119104, 0, 0, 0, 134238208, 0, 0, 0, 268476416, 0, 
        0, 0, 536952832, 0, 0, 0, 1073905665, 0, 0, 0, 2147811330, 0, 0, 0, 524304, 0, 
        0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 0, 0, 8388864, 0, 
        0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67110912, 0, 0, 0, 134221824, 0, 
        0, 0, 268443649, 0, 0, 0, 536887298, 0, 0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144703526, 
        0, 0, 0, 289407053, 0, 0, 0, 578814107, 0, 0, 0, 1157628214, 0, 0, 0, 2315256429, 
        0, 0, 0, 335545562, 0, 0, 0, 671091124, 0, 0, 0, 1342182248, 0, 0, 0, 2684364496, 
        0, 0, 0, 1073761696, 0, 0, 0, 2147523392, 0, 0, 0, 79488, 0, 0, 0, 158976, 
        0, 0, 0, 317952, 0, 0, 0, 635904, 0, 0, 0, 1271808, 0, 0, 0, 2543616, 
        0, 0, 0, 5087233, 0, 0, 0, 10174466, 0, 0, 0, 20348932, 0, 0, 0, 40697864, 
        0, 0, 0, 81395729, 0, 0, 0, 18087940, 0, 0, 0, 36175881, 0, 0, 0, 72351763, 
    },
    {
        0, 0, 0, 0, 4160, 0, 0, 0, 8320, 0, 0, 0, 16640, 0, 0, 0, 
        33280, 0, 0, 0, 66560, 0, 0, 0, 133120, 0, 0, 0, 266240, 0, 0, 0, 
        532480, 0, 0, 0, 1064960, 0, 0, 0, 2129920, 0, 0, 0, 4259840, 0, 0, 0, 
        8519680, 0, 0, 0, 17039360, 0, 0, 0, 34078721, 0, 0, 0, 68157442, 0, 0, 0, 
        136314884, 0, 0, 0, 272629768, 0, 0, 0, 545259536, 0, 0, 0, 1090519072, 0, 0, 0, 
        2181038144, 0, 0, 0, 67108992, 0, 0, 0, 134217984, 0, 0, 0, 268435968, 0, 0, 0, 
        536871936, 0, 0, 0, 1073743872, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 
        260, 0, 0, 0, 520, 0, 0, 0, 1040, 0, 0, 0, 2080, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 2560, 0, 0, 0, 5120, 0, 0, 
        0, 10240, 0, 0, 0, 20480, 0, 0, 0, 40960, 0, 0, 0, 81920, 0, 0, 
        0, 163840, 0, 0, 0, 327680, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 335546385, 0, 0, 0, 671092770, 0, 0, 0, 1342185541, 0, 0, 0, 2684371082, 0, 
        0, 0, 1073774869, 0, 0, 0, 2147549738, 0, 0, 0, 132180, 0, 0, 0, 264360, 0, 
        0, 0, 528720, 0, 0, 0, 1057440, 0, 0, 0, 2114880, 0, 0, 0, 4229761, 0, 
        0, 0, 8459522, 0, 0, 0, 16919044, 0, 0, 0, 33838088, 0, 0, 0, 269000704, 0, 
        0, 0, 538001408, 0, 0, 0, 1076002817, 0, 0, 0, 2152005634, 0, 0, 0, 9043972, 0, 
        0, 0, 18087944, 0, 0, 0, 36175888, 0, 0, 0, 72351776, 0, 0, 0, 144703552, 0, 
        0, 0, 289407105, 0, 0, 0, 578814210, 0, 0, 0, 1157628420, 0, 0, 0, 2315256840, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135049252, 
        0, 0, 0, 270098504, 0, 0, 0, 540197008, 0, 0, 0, 1080394017, 0, 0, 0, 2160788035, 
        0, 0, 0, 26608774, 0, 0, 0, 53217549, 0, 0, 0, 106435098, 0, 0, 0, 212870196, 
        0, 0, 0, 425740393, 0, 0, 0, 851480786, 0, 0, 0, 1702961572, 0, 0, 0, 3405923145, 
        0, 0, 0, 2516878995, 0, 0, 0, 738790694, 0, 0, 0, 1477581388, 0, 0, 0, 2955162776, 
        0, 0, 0, 1615358257, 0, 0, 0, 3230716514, 0, 0, 0, 2166465732, 0, 0, 0, 37964168, 
        0, 0, 0, 75928336, 0, 0, 0, 16881156, 0, 0, 0, 33762313, 0, 0, 0, 67524626, 
    },
    {
        0, 0, 0, 0, 3162112, 0, 0, 0, 6324224, 0, 0, 0, 12648448, 0, 0, 0, 
        25296896, 0, 0, 0, 50593793, 0, 0, 0, 101187587, 0, 0, 0, 202375174, 0, 0, 0, 
        404750348, 0, 0, 0, 809500696, 0, 0, 0, 1619001392, 0, 0, 0, 3238002785, 0, 0, 0, 
        2181038274, 0, 0, 0, 67109252, 0, 0, 0, 134218504, 0, 0, 0, 268437008, 0, 0, 0, 
        536874016, 0, 0, 0, 1073748032, 0, 0, 0, 2147496065, 0, 0, 0, 24834, 0, 0, 0, 
        49668, 0, 0, 0, 99336, 0, 0, 0, 198672, 0, 0, 0, 397344, 0, 0, 0, 
        794688, 0, 0, 0, 1589376, 0, 0, 0, 49408, 0, 0, 0, 98816, 0, 0, 0, 
        197632, 0, 0, 0, 395264, 0, 0, 0, 790528, 0, 0, 0, 1581056, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8704, 0, 0, 
        0, 17408, 0, 0, 0, 34816, 0, 0, 0, 69632, 0, 0, 0, 139264, 0, 0, 
        0, 278528, 0, 0, 0, 557056, 0, 0, 0, 1114112, 0, 0, 0, 2228224, 0, 0, 
        0, 4456448, 0, 0, 0, 8912896, 0, 0, 0, 17825792, 0, 0, 0, 35651584, 0, 0, 
        0, 71303168, 0, 0, 0, 142606337, 0, 0, 0, 285212674, 0, 0, 0, 570425349, 0, 0, 
        0, 1140850698, 0, 0, 0, 2281701397, 0, 0, 0, 268435498, 0, 0, 0, 536870997, 0, 0, 
        0, 1073741994, 0, 0, 0, 2147483988, 0, 0, 0, 680, 0, 0, 0, 1360, 0, 0, 
        0, 2720, 0, 0, 0, 5440, 0, 0, 0, 2176, 0, 0, 0, 4352, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 539164932, 0, 0, 0, 1078329864, 0, 0, 0, 2156659728, 0, 0, 0, 18352160, 0, 
        0, 0, 36704320, 0, 0, 0, 73408640, 0, 0, 0, 146817280, 0, 0, 0, 293634560, 0, 
        0, 0, 587269120, 0, 0, 0, 1174538240, 0, 0, 0, 2349076480, 0, 0, 0, 403185665, 0, 
        0, 0, 806371331, 0, 0, 0, 1612742663, 0, 0, 0, 3225485326, 0, 0, 0, 2694906136, 0, 
        0, 0, 1094844976, 0, 0, 0, 2189689952, 0, 0, 0, 84412608, 0, 0, 0, 168825216, 0, 
        0, 0, 337650433, 0, 0, 0, 675300866, 0, 0, 0, 1350601732, 0, 0, 0, 2701203464, 0, 
        0, 0, 1107439632, 0, 0, 0, 2214879264, 0, 0, 0, 134791233, 0, 0, 0, 269582466, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3961969350, 
        0, 0, 0, 3628971405, 0, 0, 0, 2962975514, 0, 0, 0, 1630983732, 0, 0, 0, 3261967464, 
        0, 0, 0, 2228967633, 0, 0, 0, 162967970, 0, 0, 0, 325935940, 0, 0, 0, 651871880, 
        0, 0, 0, 1303743760, 0, 0, 0, 2607487520, 0, 0, 0, 920007744, 0, 0, 0, 1840015488, 
        0, 0, 0, 3680030976, 0, 0, 0, 3065094657, 0, 0, 0, 1835222019, 0, 0, 0, 3670444038, 
        0, 0, 0, 3045920780, 0, 0, 0, 1796874265, 0, 0, 0, 3593748531, 0, 0, 0, 2892529767, 
        0, 0, 0, 1490092239, 0, 0, 0, 1568987992, 0, 0, 0, 3137975985, 0, 0, 0, 1980984675, 
    },
    {
        0, 0, 0, 0, 2554888269, 0, 0, 0, 814809242, 0, 0, 0, 1629618484, 0, 0, 0, 
        3259236968, 0, 0, 0, 2223506641, 0, 0, 0, 152045986, 0, 0, 0, 304091973, 0, 0, 0, 
        608183946, 0, 0, 0, 1216367892, 0, 0, 0, 2432735785, 0, 0, 0, 570504275, 0, 0, 0, 
        1141008550, 0, 0, 0, 2282017101, 0, 0, 0, 269066906, 0, 0, 0, 538133812, 0, 0, 0, 
        1076267624, 0, 0, 0, 2152535249, 0, 0, 0, 10103202, 0, 0, 0, 20206404, 0, 0, 0, 
        40412809, 0, 0, 0, 80825618, 0, 0, 0, 161651236, 0, 0, 0, 323302473, 0, 0, 0, 
        646604947, 0, 0, 0, 1293209894, 0, 0, 0, 39920129, 0, 0, 0, 79840258, 0, 0, 0, 
        159680516, 0, 0, 0, 319361033, 0, 0, 0, 638722067, 0, 0, 0, 1277444134, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134299649, 0, 0, 
        0, 268599298, 0, 0, 0, 537198597, 0, 0, 0, 1074397194, 0, 0, 0, 2148794388, 0, 0, 
        0, 2621480, 0, 0, 0, 5242960, 0, 0, 0, 10485920, 0, 0, 0, 20971840, 0, 0, 
        0, 41943680, 0, 0, 0, 83887360, 0, 0, 0, 167774721, 0, 0, 0, 335549442, 0, 0, 
        0, 671098884, 0, 0, 0, 1342197768, 0, 0, 0, 2684395537, 0, 0, 0, 1073823778, 0, 0, 
        0, 2147647556, 0, 0, 0, 327816, 0, 0, 0, 655632, 0, 0, 0, 1311264, 0, 0, 
        0, 2622528, 0, 0, 0, 5245056, 0, 0, 0, 10490112, 0, 0, 0, 20980224, 0, 0, 
        0, 41960448, 0, 0, 0, 83920896, 0, 0, 0, 33574912, 0, 0, 0, 67149824, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 490817699, 0, 0, 0, 981635398, 0, 0, 0, 1963270797, 0, 0, 0, 3926541594, 0, 
        0, 0, 3558115892, 0, 0, 0, 2821264488, 0, 0, 0, 1347561681, 0, 0, 0, 2695123362, 0, 
        0, 0, 1095279429, 0, 0, 0, 2190558858, 0, 0, 0, 86150421, 0, 0, 0, 172300842, 0, 
        0, 0, 344601685, 0, 0, 0, 689203370, 0, 0, 0, 1378406740, 0, 0, 0, 3104893450, 0, 
        0, 0, 1914819604, 0, 0, 0, 3829639209, 0, 0, 0, 3364311122, 0, 0, 0, 2433654948, 0, 
        0, 0, 572342600, 0, 0, 0, 1144685201, 0, 0, 0, 2289370402, 0, 0, 0, 283773509, 0, 
        0, 0, 567547018, 0, 0, 0, 1135094036, 0, 0, 0, 2270188072, 0, 0, 0, 245408849, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3548126500, 
        0, 0, 0, 2801285704, 0, 0, 0, 1307604113, 0, 0, 0, 2615208226, 0, 0, 0, 935449156, 
        0, 0, 0, 1870898313, 0, 0, 0, 3741796627, 0, 0, 0, 3188625959, 0, 0, 0, 2082284622, 
        0, 0, 0, 4164569244, 0, 0, 0, 4034171193, 0, 0, 0, 3773375091, 0, 0, 0, 3251782887, 
        0, 0, 0, 2208598479, 0, 0, 0, 122229662, 0, 0, 0, 244459325, 0, 0, 0, 488918650, 
        0, 0, 0, 977837300, 0, 0, 0, 1955674600, 0, 0, 0, 3911349200, 0, 0, 0, 3527731104, 
        0, 0, 0, 2760494912, 0, 0, 0, 2590999460, 0, 0, 0, 887031625, 0, 0, 0, 1774063250, 
    },
    {
        0, 0, 0, 0, 1164254896, 0, 0, 0, 2328509792, 0, 0, 0, 362052288, 0, 0, 0, 
        724104577, 0, 0, 0, 1448209155, 0, 0, 0, 2896418311, 0, 0, 0, 1497869326, 0, 0, 0, 
        2995738652, 0, 0, 0, 1696510008, 0, 0, 0, 3393020016, 0, 0, 0, 2491072737, 0, 0, 0, 
        687178178, 0, 0, 0, 1374356356, 0, 0, 0, 2748712712, 0, 0, 0, 1202458129, 0, 0, 0, 
        2404916258, 0, 0, 0, 514865221, 0, 0, 0, 1029730442, 0, 0, 0, 2059460885, 0, 0, 0, 
        4118921771, 0, 0, 0, 3942876246, 0, 0, 0, 3590785196, 0, 0, 0, 2886603097, 0, 0, 0, 
        1478238898, 0, 0, 0, 2956477797, 0, 0, 0, 622171258, 0, 0, 0, 1244342517, 0, 0, 0, 
        2488685035, 0, 0, 0, 682402774, 0, 0, 0, 1364805548, 0, 0, 0, 2729611096, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 336678914, 0, 0, 
        0, 673357828, 0, 0, 0, 1346715656, 0, 0, 0, 2693431313, 0, 0, 0, 1091895330, 0, 0, 
        0, 2183790660, 0, 0, 0, 72614024, 0, 0, 0, 145228049, 0, 0, 0, 290456098, 0, 0, 
        0, 580912197, 0, 0, 0, 1161824394, 0, 0, 0, 2323648789, 0, 0, 0, 352330282, 0, 0, 
        0, 704660564, 0, 0, 0, 1409321128, 0, 0, 0, 2818642256, 0, 0, 0, 1342317216, 0, 0, 
        0, 2684634433, 0, 0, 0, 1074301570, 0, 0, 0, 2148603140, 0, 0, 0, 2238984, 0, 0, 
        0, 4477968, 0, 0, 0, 8955936, 0, 0, 0, 17911872, 0, 0, 0, 35823744, 0, 0, 
        0, 71647488, 0, 0, 0, 143294977, 0, 0, 0, 84169728, 0, 0, 0, 168339457, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2541187255, 0, 0, 0, 787407215, 0, 0, 0, 1574814430, 0, 0, 0, 3149628860, 0, 
        0, 0, 2004290425, 0, 0, 0, 4008580850, 0, 0, 0, 3722194405, 0, 0, 0, 3149421515, 0, 
        0, 0, 2003875734, 0, 0, 0, 4007751468, 0, 0, 0, 3720535640, 0, 0, 0, 3146103984, 0, 
        0, 0, 1997240673, 0, 0, 0, 3994481347, 0, 0, 0, 3693995398, 0, 0, 0, 791460795, 0, 
        0, 0, 1582921591, 0, 0, 0, 3165843182, 0, 0, 0, 2036719068, 0, 0, 0, 4073438136, 0, 
        0, 0, 3851908976, 0, 0, 0, 3408850657, 0, 0, 0, 2522734018, 0, 0, 0, 750500741, 0, 
        0, 0, 1501001483, 0, 0, 0, 3002002966, 0, 0, 0, 1709038637, 0, 0, 0, 3418077275, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 357270623, 
        0, 0, 0, 714541247, 0, 0, 0, 1429082494, 0, 0, 0, 2858164988, 0, 0, 0, 1421362680, 
        0, 0, 0, 2842725361, 0, 0, 0, 1390483426, 0, 0, 0, 2780966853, 0, 0, 0, 1266966411, 
        0, 0, 0, 2533932823, 0, 0, 0, 772898351, 0, 0, 0, 1545796702, 0, 0, 0, 3091593405, 
        0, 0, 0, 1888219514, 0, 0, 0, 3776439028, 0, 0, 0, 3257910761, 0, 0, 0, 2220854227, 
        0, 0, 0, 146741158, 0, 0, 0, 293482317, 0, 0, 0, 586964634, 0, 0, 0, 1173929269, 
        0, 0, 0, 2347858538, 0, 0, 0, 44658827, 0, 0, 0, 89317655, 0, 0, 0, 178635311, 
    },
    {
        0, 0, 0, 0, 126298325, 0, 0, 0, 252596651, 0, 0, 0, 505193303, 0, 0, 0, 
        1010386606, 0, 0, 0, 2020773212, 0, 0, 0, 4041546425, 0, 0, 0, 3788125555, 0, 0, 0, 
        3281283814, 0, 0, 0, 2267600332, 0, 0, 0, 240233369, 0, 0, 0, 480466738, 0, 0, 0, 
        960933476, 0, 0, 0, 1921866953, 0, 0, 0, 3843733907, 0, 0, 0, 3392500518, 0, 0, 0, 
        2490033741, 0, 0, 0, 685100186, 0, 0, 0, 1370200372, 0, 0, 0, 2740400744, 0, 0, 0, 
        1185834193, 0, 0, 0, 2371668387, 0, 0, 0, 448369479, 0, 0, 0, 896738958, 0, 0, 0, 
        1793477917, 0, 0, 0, 3586955835, 0, 0, 0, 2887654563, 0, 0, 0, 1480341830, 0, 0, 0, 
        2960683661, 0, 0, 0, 1626400026, 0, 0, 0, 3252800053, 0, 0, 0, 2210632810, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 339960066, 0, 0, 
        0, 679920132, 0, 0, 0, 1359840264, 0, 0, 0, 2719680529, 0, 0, 0, 1144393762, 0, 0, 
        0, 2288787525, 0, 0, 0, 282607754, 0, 0, 0, 565215509, 0, 0, 0, 1130431018, 0, 0, 
        0, 2260862036, 0, 0, 0, 226756777, 0, 0, 0, 453513555, 0, 0, 0, 907027111, 0, 0, 
        0, 1814054222, 0, 0, 0, 3628108445, 0, 0, 0, 2961249595, 0, 0, 0, 1627531895, 0, 0, 
        0, 3255063790, 0, 0, 0, 2215160284, 0, 0, 0, 135353273, 0, 0, 0, 270706546, 0, 0, 
        0, 541413093, 0, 0, 0, 1082826186, 0, 0, 0, 2165652372, 0, 0, 0, 36337448, 0, 0, 
        0, 72674896, 0, 0, 0, 145349793, 0, 0, 0, 84990016, 0, 0, 0, 169980033, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2614536692, 0, 0, 0, 934106089, 0, 0, 0, 1868212179, 0, 0, 0, 3736424359, 0, 
        0, 0, 3177881422, 0, 0, 0, 2060795549, 0, 0, 0, 4121591099, 0, 0, 0, 3948214903, 0, 
        0, 0, 3601462510, 0, 0, 0, 2907957725, 0, 0, 0, 1520948154, 0, 0, 0, 3041896308, 0, 
        0, 0, 1788825320, 0, 0, 0, 3577650640, 0, 0, 0, 2860333984, 0, 0, 0, 3475824309, 0, 
        0, 0, 2656681322, 0, 0, 0, 1018395349, 0, 0, 0, 2036790698, 0, 0, 0, 4073581396, 0, 
        0, 0, 3852195497, 0, 0, 0, 3409423699, 0, 0, 0, 2523880103, 0, 0, 0, 752792911, 0, 
        0, 0, 1505585823, 0, 0, 0, 3011171646, 0, 0, 0, 1727375997, 0, 0, 0, 3454751994, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3265725291, 
        0, 0, 0, 2236483287, 0, 0, 0, 177999279, 0, 0, 0, 355998558, 0, 0, 0, 711997116, 
        0, 0, 0, 1423994233, 0, 0, 0, 2847988467, 0, 0, 0, 1401009639, 0, 0, 0, 2802019279, 
        0, 0, 0, 1309071263, 0, 0, 0, 2618142526, 0, 0, 0, 941317756, 0, 0, 0, 1882635512, 
        0, 0, 0, 3765271025, 0, 0, 0, 3235574755, 0, 0, 0, 2176182214, 0, 0, 0, 57397132, 
        0, 0, 0, 114794264, 0, 0, 0, 229588528, 0, 0, 0, 459177056, 0, 0, 0, 918354113, 
        0, 0, 0, 1836708227, 0, 0, 0, 408215661, 0, 0, 0, 816431322, 0, 0, 0, 1632862645, 
    },
    {
        0, 0, 0, 0, 3480795388, 0, 0, 0, 2666623480, 0, 0, 0, 1038279664, 0, 0, 0, 
        2076559329, 0, 0, 0, 4153118658, 0, 0, 0, 4011270020, 0, 0, 0, 3727572744, 0, 0, 0, 
        3160178193, 0, 0, 0, 2025389090, 0, 0, 0, 4050778181, 0, 0, 0, 3806589066, 0, 0, 0, 
        3318210837, 0, 0, 0, 2341454378, 0, 0, 0, 387941461, 0, 0, 0, 775882923, 0, 0, 0, 
        1551765846, 0, 0, 0, 3103531693, 0, 0, 0, 1912096090, 0, 0, 0, 3824192180, 0, 0, 0, 
        3353417064, 0, 0, 0, 2411866832, 0, 0, 0, 528766369, 0, 0, 0, 1057532739, 0, 0, 0, 
        2115065479, 0, 0, 0, 4230130959, 0, 0, 0, 926802659, 0, 0, 0, 1853605319, 0, 0, 0, 
        3707210639, 0, 0, 0, 3119453983, 0, 0, 0, 1943940671, 0, 0, 0, 3887881342, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1457526048, 0, 0, 
        0, 2915052096, 0, 0, 0, 1535136897, 0, 0, 0, 3070273795, 0, 0, 0, 1845580294, 0, 0, 
        0, 3691160589, 0, 0, 0, 3087353882, 0, 0, 0, 1879740469, 0, 0, 0, 3759480939, 0, 0, 
        0, 3223994582, 0, 0, 0, 2153021868, 0, 0, 0, 11076440, 0, 0, 0, 22152880, 0, 0, 
        0, 44305760, 0, 0, 0, 88611520, 0, 0, 0, 177223041, 0, 0, 0, 354446082, 0, 0, 
        0, 708892164, 0, 0, 0, 1417784328, 0, 0, 0, 2835568656, 0, 0, 0, 1376170016, 0, 0, 
        0, 2752340033, 0, 0, 0, 1209712771, 0, 0, 0, 2419425542, 0, 0, 0, 543883789, 0, 0, 
        0, 1087767578, 0, 0, 0, 2175535156, 0, 0, 0, 1438123336, 0, 0, 0, 2876246672, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2983242506, 0, 0, 0, 1671517716, 0, 0, 0, 3343035433, 0, 0, 0, 2391103570, 0, 
        0, 0, 487239844, 0, 0, 0, 974479689, 0, 0, 0, 1948959378, 0, 0, 0, 3897918757, 0, 
        0, 0, 3500870219, 0, 0, 0, 2706773142, 0, 0, 0, 1118578988, 0, 0, 0, 2237157976, 0, 
        0, 0, 179348657, 0, 0, 0, 358697315, 0, 0, 0, 717394631, 0, 0, 0, 3830812293, 0, 
        0, 0, 3366657290, 0, 0, 0, 2438347285, 0, 0, 0, 581727274, 0, 0, 0, 1163454549, 0, 
        0, 0, 2326909099, 0, 0, 0, 358850902, 0, 0, 0, 717701804, 0, 0, 0, 1435403608, 0, 
        0, 0, 2870807216, 0, 0, 0, 1446647137, 0, 0, 0, 2893294274, 0, 0, 0, 1491621253, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3612118070, 
        0, 0, 0, 2929268845, 0, 0, 0, 1563570394, 0, 0, 0, 3127140788, 0, 0, 0, 1959314281, 
        0, 0, 0, 3918628562, 0, 0, 0, 3542289829, 0, 0, 0, 2789612362, 0, 0, 0, 1284257428, 
        0, 0, 0, 2568514856, 0, 0, 0, 842062417, 0, 0, 0, 1684124835, 0, 0, 0, 3368249671, 
        0, 0, 0, 2441532046, 0, 0, 0, 588096797, 0, 0, 0, 1176193595, 0, 0, 0, 2352387190, 
        0, 0, 0, 409807085, 0, 0, 0, 819614171, 0, 0, 0, 1639228342, 0, 0, 0, 3278456684, 
        0, 0, 0, 2261946072, 0, 0, 0, 3672740230, 0, 0, 0, 3050513165, 0, 0, 0, 1806059035, 
    },
    {
        0, 0, 0, 0, 460238757, 0, 0, 0, 920477515, 0, 0, 0, 1840955030, 0, 0, 0, 
        3681910060, 0, 0, 0, 3068852824, 0, 0, 0, 1842738352, 0, 0, 0, 3685476704, 0, 0, 0, 
        3075986112, 0, 0, 0, 1857004929, 0, 0, 0, 3714009859, 0, 0, 0, 3133052422, 0, 0, 0, 
        1971137548, 0, 0, 0, 3942275096, 0, 0, 0, 3589582897, 0, 0, 0, 2884198498, 0, 0, 0, 
        1473429701, 0, 0, 0, 2946859402, 0, 0, 0, 1598751509, 0, 0, 0, 3197503018, 0, 0, 0, 
        2100038740, 0, 0, 0, 4200077480, 0, 0, 0, 4105187665, 0, 0, 0, 3915408035, 0, 0, 0, 
        3535848774, 0, 0, 0, 2776730253, 0, 0, 0, 1349368510, 0, 0, 0, 2698737021, 0, 0, 0, 
        1102506746, 0, 0, 0, 2205013492, 0, 0, 0, 115059689, 0, 0, 0, 230119378, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4124527681, 0, 0, 
        0, 3954088066, 0, 0, 0, 3613208836, 0, 0, 0, 2931450376, 0, 0, 0, 1567933457, 0, 0, 
        0, 3135866914, 0, 0, 0, 1976766533, 0, 0, 0, 3953533066, 0, 0, 0, 3612098836, 0, 0, 
        0, 2929230376, 0, 0, 0, 1563493457, 0, 0, 0, 3126986914, 0, 0, 0, 1959006533, 0, 0, 
        0, 3918013066, 0, 0, 0, 3541058836, 0, 0, 0, 2787150377, 0, 0, 0, 1279333459, 0, 0, 
        0, 2558666919, 0, 0, 0, 822366543, 0, 0, 0, 1644733087, 0, 0, 0, 3289466174, 0, 0, 
        0, 2283965053, 0, 0, 0, 272962810, 0, 0, 0, 545925621, 0, 0, 0, 1091851242, 0, 0, 
        0, 2183702484, 0, 0, 0, 72437672, 0, 0, 0, 4252357392, 0, 0, 0, 4209747488, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2797805596, 0, 0, 0, 1300643896, 0, 0, 0, 2601287792, 0, 0, 0, 907608289, 0, 
        0, 0, 1815216578, 0, 0, 0, 3630433157, 0, 0, 0, 2965899019, 0, 0, 0, 1636830742, 0, 
        0, 0, 3273661484, 0, 0, 0, 2252355672, 0, 0, 0, 209744048, 0, 0, 0, 419488096, 0, 
        0, 0, 838976192, 0, 0, 0, 1677952385, 0, 0, 0, 3355904770, 0, 0, 0, 919418393, 0, 
        0, 0, 1838836786, 0, 0, 0, 3677673572, 0, 0, 0, 3060379848, 0, 0, 0, 1825792400, 0, 
        0, 0, 3651584800, 0, 0, 0, 3008202304, 0, 0, 0, 1721437312, 0, 0, 0, 3442874624, 0, 
        0, 0, 2590781953, 0, 0, 0, 886596611, 0, 0, 0, 1773193223, 0, 0, 0, 3546386446, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 490940283, 
        0, 0, 0, 981880567, 0, 0, 0, 1963761134, 0, 0, 0, 3927522269, 0, 0, 0, 3560077242, 
        0, 0, 0, 2825187189, 0, 0, 0, 1355407083, 0, 0, 0, 2710814166, 0, 0, 0, 1126661037, 
        0, 0, 0, 2253322074, 0, 0, 0, 211676852, 0, 0, 0, 423353704, 0, 0, 0, 846707408, 
        0, 0, 0, 1693414817, 0, 0, 0, 3386829635, 0, 0, 0, 2478691975, 0, 0, 0, 662416654, 
        0, 0, 0, 1324833308, 0, 0, 0, 2649666617, 0, 0, 0, 1004365938, 0, 0, 0, 2008731877, 
        0, 0, 0, 4017463754, 0, 0, 0, 3282593007, 0, 0, 0, 2270218718, 0, 0, 0, 245470141, 
    },
    {
        0, 0, 0, 0, 1980210557, 0, 0, 0, 3960421115, 0, 0, 0, 3625874935, 0, 0, 0, 
        2956782575, 0, 0, 0, 1618597854, 0, 0, 0, 3237195709, 0, 0, 0, 2179424123, 0, 0, 0, 
        63880951, 0, 0, 0, 127761903, 0, 0, 0, 255523807, 0, 0, 0, 511047615, 0, 0, 0, 
        1022095230, 0, 0, 0, 2044190460, 0, 0, 0, 4088380920, 0, 0, 0, 3881794544, 0, 0, 0, 
        3468621792, 0, 0, 0, 2642276289, 0, 0, 0, 989585283, 0, 0, 0, 1979170566, 0, 0, 0, 
        3958341132, 0, 0, 0, 3621714968, 0, 0, 0, 2948462640, 0, 0, 0, 1601957985, 0, 0, 0, 
        3203915970, 0, 0, 0, 2112864644, 0, 0, 0, 2379751029, 0, 0, 0, 464534763, 0, 0, 0, 
        929069527, 0, 0, 0, 1858139055, 0, 0, 0, 3716278111, 0, 0, 0, 3137588926, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3560175108, 0, 0, 
        0, 2825382920, 0, 0, 0, 1355798544, 0, 0, 0, 2711597089, 0, 0, 0, 1128226882, 0, 0, 
        0, 2256453764, 0, 0, 0, 217940233, 0, 0, 0, 435880467, 0, 0, 0, 871760935, 0, 0, 
        0, 1743521871, 0, 0, 0, 3487043743, 0, 0, 0, 2679120191, 0, 0, 0, 1063273086, 0, 0, 
        0, 2126546172, 0, 0, 0, 4253092344, 0, 0, 0, 4211217392, 0, 0, 0, 4127467489, 0, 0, 
        0, 3959967682, 0, 0, 0, 3624968069, 0, 0, 0, 2954968843, 0, 0, 0, 1614970391, 0, 0, 
        0, 3229940782, 0, 0, 0, 2164914268, 0, 0, 0, 34861240, 0, 0, 0, 69722480, 0, 0, 
        0, 139444961, 0, 0, 0, 278889922, 0, 0, 0, 4111269249, 0, 0, 0, 3927571202, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 3324387232, 0, 0, 0, 2353807168, 0, 0, 0, 412647041, 0, 0, 0, 825294082, 0, 
        0, 0, 1650588165, 0, 0, 0, 3301176331, 0, 0, 0, 2307385367, 0, 0, 0, 319803438, 0, 
        0, 0, 639606877, 0, 0, 0, 1279213754, 0, 0, 0, 2558427508, 0, 0, 0, 821887721, 0, 
        0, 0, 1643775442, 0, 0, 0, 3287550884, 0, 0, 0, 2280134472, 0, 0, 0, 3388354864, 0, 
        0, 0, 2481742433, 0, 0, 0, 668517571, 0, 0, 0, 1337035143, 0, 0, 0, 2674070287, 0, 
        0, 0, 1053173279, 0, 0, 0, 2106346559, 0, 0, 0, 4212693118, 0, 0, 0, 4130418941, 0, 
        0, 0, 3965870586, 0, 0, 0, 3636773876, 0, 0, 0, 2978580456, 0, 0, 0, 1662193616, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42029323, 
        0, 0, 0, 84058646, 0, 0, 0, 168117293, 0, 0, 0, 336234586, 0, 0, 0, 672469172, 
        0, 0, 0, 1344938344, 0, 0, 0, 2689876689, 0, 0, 0, 1084786082, 0, 0, 0, 2169572165, 
        0, 0, 0, 44177035, 0, 0, 0, 88354071, 0, 0, 0, 176708143, 0, 0, 0, 353416286, 
        0, 0, 0, 706832573, 0, 0, 0, 1413665147, 0, 0, 0, 2827330294, 0, 0, 0, 1359693292, 
        0, 0, 0, 2719386585, 0, 0, 0, 1143805874, 0, 0, 0, 2287611749, 0, 0, 0, 280256202, 
        0, 0, 0, 560512405, 0, 0, 0, 1078995489, 0, 0, 0, 2157990978, 0, 0, 0, 21014661, 
    },
    {
        0, 0, 0, 0, 893107048, 0, 0, 0, 1786214097, 0, 0, 0, 3572428195, 0, 0, 0, 
        2849889095, 0, 0, 0, 1404810895, 0, 0, 0, 2809621790, 0, 0, 0, 1324276285, 0, 0, 0, 
        2648552571, 0, 0, 0, 1002137847, 0, 0, 0, 2004275695, 0, 0, 0, 4008551390, 0, 0, 0, 
        3722135485, 0, 0, 0, 3149303674, 0, 0, 0, 2003640053, 0, 0, 0, 4007280106, 0, 0, 0, 
        3719592917, 0, 0, 0, 3144218538, 0, 0, 0, 1993469781, 0, 0, 0, 3986939563, 0, 0, 0, 
        3678911830, 0, 0, 0, 3062856364, 0, 0, 0, 1830745432, 0, 0, 0, 3661490864, 0, 0, 0, 
        3028014433, 0, 0, 0, 1761061570, 0, 0, 0, 3839160045, 0, 0, 0, 3383352795, 0, 0, 0, 
        2471738294, 0, 0, 0, 648509293, 0, 0, 0, 1297018586, 0, 0, 0, 2594037172, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3625984309, 0, 0, 
        0, 2957001323, 0, 0, 0, 1619035351, 0, 0, 0, 3238070702, 0, 0, 0, 2181174108, 0, 0, 
        0, 67380920, 0, 0, 0, 134761841, 0, 0, 0, 269523682, 0, 0, 0, 539047365, 0, 0, 
        0, 1078094730, 0, 0, 0, 2156189460, 0, 0, 0, 17411624, 0, 0, 0, 34823248, 0, 0, 
        0, 69646496, 0, 0, 0, 139292993, 0, 0, 0, 278585986, 0, 0, 0, 557171973, 0, 0, 
        0, 1114343946, 0, 0, 0, 2228687892, 0, 0, 0, 162408489, 0, 0, 0, 324816978, 0, 0, 
        0, 649633957, 0, 0, 0, 1299267915, 0, 0, 0, 2598535831, 0, 0, 0, 902104367, 0, 0, 
        0, 1804208734, 0, 0, 0, 3608417468, 0, 0, 0, 1980237901, 0, 0, 0, 3960475802, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 470870896, 0, 0, 0, 941741792, 0, 0, 0, 1883483584, 0, 0, 0, 3766967168, 0, 
        0, 0, 3238967041, 0, 0, 0, 2182966786, 0, 0, 0, 70966277, 0, 0, 0, 141932555, 0, 
        0, 0, 283865111, 0, 0, 0, 567730223, 0, 0, 0, 1135460447, 0, 0, 0, 2270920895, 0, 
        0, 0, 246874494, 0, 0, 0, 493748989, 0, 0, 0, 987497979, 0, 0, 0, 1772675207, 0, 
        0, 0, 3545350414, 0, 0, 0, 2795733533, 0, 0, 0, 1296499770, 0, 0, 0, 2592999541, 0, 
        0, 0, 891031787, 0, 0, 0, 1782063574, 0, 0, 0, 3564127149, 0, 0, 0, 2833287003, 0, 
        0, 0, 1371606711, 0, 0, 0, 2743213422, 0, 0, 0, 1191459548, 0, 0, 0, 2382919096, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 537135248, 
        0, 0, 0, 1074270496, 0, 0, 0, 2148540992, 0, 0, 0, 2114688, 0, 0, 0, 4229377, 
        0, 0, 0, 8458754, 0, 0, 0, 16917508, 0, 0, 0, 33835017, 0, 0, 0, 67670034, 
        0, 0, 0, 135340068, 0, 0, 0, 270680136, 0, 0, 0, 541360273, 0, 0, 0, 1082720546, 
        0, 0, 0, 2165441092, 0, 0, 0, 35914889, 0, 0, 0, 71829779, 0, 0, 0, 143659558, 
        0, 0, 0, 287319116, 0, 0, 0, 574638232, 0, 0, 0, 1149276464, 0, 0, 0, 2298552928, 
        0, 0, 0, 302138561, 0, 0, 0, 67141906, 0, 0, 0, 134283812, 0, 0, 0, 268567624, 
    },
    {
        0, 0, 0, 0, 2113541784, 0, 0, 0, 4227083568, 0, 0, 0, 4159199840, 0, 0, 0, 
        4023432384, 0, 0, 0, 3751897472, 0, 0, 0, 3208827648, 0, 0, 0, 2122688001, 0, 0, 0, 
        4245376003, 0, 0, 0, 4195784710, 0, 0, 0, 4096602125, 0, 0, 0, 3898236955, 0, 0, 0, 
        3501506615, 0, 0, 0, 2708045935, 0, 0, 0, 1121124575, 0, 0, 0, 2242249151, 0, 0, 0, 
        189531007, 0, 0, 0, 379062015, 0, 0, 0, 758124030, 0, 0, 0, 1516248061, 0, 0, 0, 
        3032496123, 0, 0, 0, 1770024950, 0, 0, 0, 3540049900, 0, 0, 0, 2785132504, 0, 0, 0, 
        1275297712, 0, 0, 0, 2550595425, 0, 0, 0, 1308092506, 0, 0, 0, 2616185012, 0, 0, 0, 
        937402729, 0, 0, 0, 1874805459, 0, 0, 0, 3749610918, 0, 0, 0, 3204254540, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99817600, 0, 0, 
        0, 199635201, 0, 0, 0, 399270402, 0, 0, 0, 798540804, 0, 0, 0, 1597081609, 0, 0, 
        0, 3194163218, 0, 0, 0, 2093359140, 0, 0, 0, 4186718280, 0, 0, 0, 4078469265, 0, 0, 
        0, 3861971235, 0, 0, 0, 3428975175, 0, 0, 0, 2562983055, 0, 0, 0, 830998815, 0, 0, 
        0, 1661997631, 0, 0, 0, 3323995262, 0, 0, 0, 2353023229, 0, 0, 0, 411079163, 0, 0, 
        0, 822158327, 0, 0, 0, 1644316655, 0, 0, 0, 3288633310, 0, 0, 0, 2282299325, 0, 0, 
        0, 269631354, 0, 0, 0, 539262709, 0, 0, 0, 1078525418, 0, 0, 0, 2157050836, 0, 0, 
        0, 19134376, 0, 0, 0, 38268752, 0, 0, 0, 24954400, 0, 0, 0, 49908800, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 27673132, 0, 0, 0, 55346265, 0, 0, 0, 110692530, 0, 0, 0, 221385060, 0, 
        0, 0, 442770121, 0, 0, 0, 885540243, 0, 0, 0, 1771080487, 0, 0, 0, 3542160975, 0, 
        0, 0, 2789354654, 0, 0, 0, 1283742012, 0, 0, 0, 2567484024, 0, 0, 0, 840000753, 0, 
        0, 0, 1680001507, 0, 0, 0, 3360003015, 0, 0, 0, 2425038735, 0, 0, 0, 548408626, 0, 
        0, 0, 1096817252, 0, 0, 0, 2193634504, 0, 0, 0, 92301712, 0, 0, 0, 184603425, 0, 
        0, 0, 369206850, 0, 0, 0, 738413700, 0, 0, 0, 1476827400, 0, 0, 0, 2953654801, 0, 
        0, 0, 1612342306, 0, 0, 0, 3224684613, 0, 0, 0, 2154401931, 0, 0, 0, 13836566, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1048576, 
        0, 0, 0, 2097152, 0, 0, 0, 4194305, 0, 0, 0, 8388610, 0, 0, 0, 16777220, 
        0, 0, 0, 33554441, 0, 0, 0, 67108882, 0, 0, 0, 134217764, 0, 0, 0, 268435528, 
        0, 0, 0, 536871056, 0, 0, 0, 1073742112, 0, 0, 0, 2147484224, 0, 0, 0, 1152, 
        0, 0, 0, 2304, 0, 0, 0, 4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 
        0, 0, 0, 36864, 0, 0, 0, 73728, 0, 0, 0, 147456, 0, 0, 0, 294912, 
        0, 0, 0, 589824, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 
    },
    {
        0, 0, 0, 0, 307855197, 0, 0, 0, 615710394, 0, 0, 0, 1231420788, 0, 0, 0, 
        2462841576, 0, 0, 0, 630715856, 0, 0, 0, 1261431713, 0, 0, 0, 2522863426, 0, 0, 0, 
        750759556, 0, 0, 0, 1501519112, 0, 0, 0, 3003038224, 0, 0, 0, 1711109152, 0, 0, 0, 
        3422218304, 0, 0, 0, 2549469312, 0, 0, 0, 803971329, 0, 0, 0, 1607942659, 0, 0, 0, 
        3215885318, 0, 0, 0, 2136803341, 0, 0, 0, 4273606682, 0, 0, 0, 4252246069, 0, 0, 0, 
        4209524842, 0, 0, 0, 4124082389, 0, 0, 0, 3953197482, 0, 0, 0, 3611427668, 0, 0, 0, 
        2927888040, 0, 0, 0, 1560808784, 0, 0, 0, 2823382525, 0, 0, 0, 1351797754, 0, 0, 0, 
        2703595509, 0, 0, 0, 1112223723, 0, 0, 0, 2224447447, 0, 0, 0, 153927598, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1409835056, 0, 0, 
        0, 2819670112, 0, 0, 0, 1344372928, 0, 0, 0, 2688745857, 0, 0, 0, 1082524418, 0, 0, 
        0, 2165048836, 0, 0, 0, 35130376, 0, 0, 0, 70260752, 0, 0, 0, 140521505, 0, 0, 
        0, 281043010, 0, 0, 0, 562086021, 0, 0, 0, 1124172042, 0, 0, 0, 2248344084, 0, 0, 
        0, 201720873, 0, 0, 0, 403441747, 0, 0, 0, 806883495, 0, 0, 0, 1613766991, 0, 0, 
        0, 3227533982, 0, 0, 0, 2160100668, 0, 0, 0, 25234040, 0, 0, 0, 50468080, 0, 0, 
        0, 100936160, 0, 0, 0, 201872321, 0, 0, 0, 403744643, 0, 0, 0, 807489287, 0, 0, 
        0, 1614978575, 0, 0, 0, 3229957150, 0, 0, 0, 3573684236, 0, 0, 0, 2852401176, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1749068055, 0, 0, 0, 3498136111, 0, 0, 0, 2701304927, 0, 0, 0, 1107642558, 0, 
        0, 0, 2215285117, 0, 0, 0, 135602938, 0, 0, 0, 271205877, 0, 0, 0, 542411755, 0, 
        0, 0, 1084823510, 0, 0, 0, 2169647020, 0, 0, 0, 44326744, 0, 0, 0, 88653489, 0, 
        0, 0, 177306978, 0, 0, 0, 354613956, 0, 0, 0, 709227913, 0, 0, 0, 1019953669, 0, 
        0, 0, 2039907338, 0, 0, 0, 4079814677, 0, 0, 0, 3864662058, 0, 0, 0, 3434356820, 0, 
        0, 0, 2573746345, 0, 0, 0, 852525394, 0, 0, 0, 1705050788, 0, 0, 0, 3410101576, 0, 
        0, 0, 2525235857, 0, 0, 0, 755504418, 0, 0, 0, 1511008837, 0, 0, 0, 3022017675, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33280, 
        0, 0, 0, 66560, 0, 0, 0, 133120, 0, 0, 0, 266240, 0, 0, 0, 532480, 
        0, 0, 0, 1064960, 0, 0, 0, 2129920, 0, 0, 0, 4259841, 0, 0, 0, 8519682, 
        0, 0, 0, 17039364, 0, 0, 0, 34078729, 0, 0, 0, 68157458, 0, 0, 0, 136314916, 
        0, 0, 0, 272629833, 0, 0, 0, 545259666, 0, 0, 0, 1090519332, 0, 0, 0, 2181038665, 
        0, 0, 0, 67110034, 0, 0, 0, 134220068, 0, 0, 0, 268440136, 0, 0, 0, 536880272, 
        0, 0, 0, 1073760544, 0, 0, 0, 2147487808, 0, 0, 0, 8320, 0, 0, 0, 16640, 
    },
    {
        0, 0, 0, 0, 1769338744, 0, 0, 0, 3538677488, 0, 0, 0, 2782387681, 0, 0, 0, 
        1269808067, 0, 0, 0, 2539616134, 0, 0, 0, 784264973, 0, 0, 0, 1568529946, 0, 0, 0, 
        3137059892, 0, 0, 0, 1979152488, 0, 0, 0, 3958304976, 0, 0, 0, 3621642656, 0, 0, 0, 
        2948318016, 0, 0, 0, 1601668737, 0, 0, 0, 3203337474, 0, 0, 0, 2111707652, 0, 0, 0, 
        4223415304, 0, 0, 0, 4151863312, 0, 0, 0, 4008759328, 0, 0, 0, 3722551361, 0, 0, 0, 
        3150135426, 0, 0, 0, 2005303557, 0, 0, 0, 4010607114, 0, 0, 0, 3726246932, 0, 0, 0, 
        3157526569, 0, 0, 0, 2020085842, 0, 0, 0, 2577782749, 0, 0, 0, 860598203, 0, 0, 0, 
        1721196407, 0, 0, 0, 3442392815, 0, 0, 0, 2589818334, 0, 0, 0, 884669372, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1430273920, 0, 0, 
        0, 2860547840, 0, 0, 0, 1426128384, 0, 0, 0, 2852256768, 0, 0, 0, 1409546240, 0, 0, 
        0, 2819092480, 0, 0, 0, 1343217664, 0, 0, 0, 2686435329, 0, 0, 0, 1077903362, 0, 0, 
        0, 2155806724, 0, 0, 0, 16646152, 0, 0, 0, 33292304, 0, 0, 0, 66584608, 0, 0, 
        0, 133169216, 0, 0, 0, 266338433, 0, 0, 0, 532676867, 0, 0, 0, 1065353734, 0, 0, 
        0, 2130707468, 0, 0, 0, 4261414936, 0, 0, 0, 4227862576, 0, 0, 0, 4160757856, 0, 0, 
        0, 4026548417, 0, 0, 0, 3758129539, 0, 0, 0, 3221291782, 0, 0, 0, 2147616268, 0, 0, 
        0, 265240, 0, 0, 0, 530480, 0, 0, 0, 1431310304, 0, 0, 0, 2862620608, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2164392972, 0, 0, 0, 33818648, 0, 0, 0, 67637296, 0, 0, 0, 135274592, 0, 
        0, 0, 270549185, 0, 0, 0, 541098371, 0, 0, 0, 1082196742, 0, 0, 0, 2164393484, 0, 
        0, 0, 33819672, 0, 0, 0, 67639344, 0, 0, 0, 135278688, 0, 0, 0, 270557377, 0, 
        0, 0, 541114755, 0, 0, 0, 1082229511, 0, 0, 0, 2164459022, 0, 0, 0, 2198079504, 0, 
        0, 0, 101191712, 0, 0, 0, 202383424, 0, 0, 0, 404766849, 0, 0, 0, 809533698, 0, 
        0, 0, 1619067396, 0, 0, 0, 3238134792, 0, 0, 0, 2181302288, 0, 0, 0, 67637280, 0, 
        0, 0, 135274560, 0, 0, 0, 270549121, 0, 0, 0, 541098243, 0, 0, 0, 1082196486, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180224, 
        0, 0, 0, 360448, 0, 0, 0, 720896, 0, 0, 0, 1441792, 0, 0, 0, 2883584, 
        0, 0, 0, 5767169, 0, 0, 0, 11534338, 0, 0, 0, 23068677, 0, 0, 0, 46137354, 
        0, 0, 0, 92274708, 0, 0, 0, 184549417, 0, 0, 0, 369098835, 0, 0, 0, 738197670, 
        0, 0, 0, 1476395340, 0, 0, 0, 2952790680, 0, 0, 0, 1610614064, 0, 0, 0, 3221228128, 
        0, 0, 0, 2147488960, 0, 0, 0, 10624, 0, 0, 0, 21248, 0, 0, 0, 42496, 
        0, 0, 0, 84992, 0, 0, 0, 22528, 0, 0, 0, 45056, 0, 0, 0, 90112, 
    },
    {
        0, 0, 0, 0, 2045181768, 0, 0, 0, 4090363536, 0, 0, 0, 3885759776, 0, 0, 0, 
        3476552256, 0, 0, 0, 2658137216, 0, 0, 0, 1021307136, 0, 0, 0, 2042614272, 0, 0, 0, 
        4085228544, 0, 0, 0, 3875489792, 0, 0, 0, 3456012289, 0, 0, 0, 2617057282, 0, 0, 0, 
        939147269, 0, 0, 0, 1878294539, 0, 0, 0, 3756589078, 0, 0, 0, 3218210860, 0, 0, 0, 
        2141454425, 0, 0, 0, 4282908850, 0, 0, 0, 4270850404, 0, 0, 0, 4246733513, 0, 0, 0, 
        4198499730, 0, 0, 0, 4102032165, 0, 0, 0, 3909097035, 0, 0, 0, 3523226774, 0, 0, 0, 
        2751486253, 0, 0, 0, 1208005210, 0, 0, 0, 3924270077, 0, 0, 0, 3553572858, 0, 0, 0, 
        2812178420, 0, 0, 0, 1329389545, 0, 0, 0, 2658779090, 0, 0, 0, 1022590884, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4294705152, 0, 0, 
        0, 4294443008, 0, 0, 0, 4293918720, 0, 0, 0, 4292870144, 0, 0, 0, 4290772992, 0, 0, 
        0, 4286578688, 0, 0, 0, 4278190080, 0, 0, 0, 4261412864, 0, 0, 0, 4227858432, 0, 0, 
        0, 4160749568, 0, 0, 0, 4026531841, 0, 0, 0, 3758096387, 0, 0, 0, 3221225478, 0, 0, 
        0, 2147483660, 0, 0, 0, 24, 0, 0, 0, 48, 0, 0, 0, 96, 0, 0, 
        0, 192, 0, 0, 0, 384, 0, 0, 0, 768, 0, 0, 0, 1536, 0, 0, 
        0, 3072, 0, 0, 0, 6144, 0, 0, 0, 12288, 0, 0, 0, 24576, 0, 0, 
        0, 49152, 0, 0, 0, 98304, 0, 0, 0, 4294901760, 0, 0, 0, 4294836224, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 
        0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 0, 0, 262152, 0, 
        0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 
        0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67108864, 0, 
        0, 0, 134217728, 0, 0, 0, 268435457, 0, 0, 0, 536870914, 0, 0, 0, 1073741828, 0, 
        0, 0, 2147483656, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 64, 0, 
        0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37905416, 
        0, 0, 0, 75810832, 0, 0, 0, 151621664, 0, 0, 0, 303243329, 0, 0, 0, 606486658, 
        0, 0, 0, 1212973317, 0, 0, 0, 2425946634, 0, 0, 0, 556925972, 0, 0, 0, 1113851944, 
        0, 0, 0, 2227703889, 0, 0, 0, 160440482, 0, 0, 0, 320880965, 0, 0, 0, 641761930, 
        0, 0, 0, 1283523860, 0, 0, 0, 2567047720, 0, 0, 0, 839128145, 0, 0, 0, 1678256290, 
        0, 0, 0, 3356512580, 0, 0, 0, 2418057864, 0, 0, 0, 541148433, 0, 0, 0, 1082296866, 
        0, 0, 0, 2164593732, 0, 0, 0, 4738177, 0, 0, 0, 9476354, 0, 0, 0, 18952708, 
    },
    {
        0, 0, 0, 0, 698651200, 0, 0, 0, 1397302401, 0, 0, 0, 2794604802, 0, 0, 0, 
        1294242308, 0, 0, 0, 2588484616, 0, 0, 0, 882001936, 0, 0, 0, 1764003872, 0, 0, 0, 
        3528007744, 0, 0, 0, 2761048193, 0, 0, 0, 1227129090, 0, 0, 0, 2454258180, 0, 0, 0, 
        613549064, 0, 0, 0, 1227098128, 0, 0, 0, 2454196256, 0, 0, 0, 613425216, 0, 0, 0, 
        1226850432, 0, 0, 0, 2453700864, 0, 0, 0, 612434432, 0, 0, 0, 1224868864, 0, 0, 0, 
        2449737728, 0, 0, 0, 604508160, 0, 0, 0, 1209016320, 0, 0, 0, 2418032641, 0, 0, 0, 
        541097986, 0, 0, 0, 1082195972, 0, 0, 0, 2829488713, 0, 0, 0, 1364010130, 0, 0, 0, 
        2728020260, 0, 0, 0, 1161073224, 0, 0, 0, 2322146448, 0, 0, 0, 349325600, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 
        0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 
        0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 
        0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 
        0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 
        0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554432, 0, 0, 
        0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 0, 536870917, 0, 0, 
        0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 131092, 0, 0, 0, 262184, 0, 0, 0, 524368, 0, 0, 0, 1048736, 0, 
        0, 0, 2097472, 0, 0, 0, 4194944, 0, 0, 0, 8389888, 0, 0, 0, 16779776, 0, 
        0, 0, 33559552, 0, 0, 0, 67119104, 0, 0, 0, 134238208, 0, 0, 0, 268476416, 0, 
        0, 0, 536952832, 0, 0, 0, 1073905665, 0, 0, 0, 2147811330, 0, 0, 0, 524304, 0, 
        0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 0, 0, 8388864, 0, 
        0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67110912, 0, 0, 0, 134221824, 0, 
        0, 0, 268443649, 0, 0, 0, 536887298, 0, 0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2731147994, 
        0, 0, 0, 1167328692, 0, 0, 0, 2334657385, 0, 0, 0, 374347474, 0, 0, 0, 748694948, 
        0, 0, 0, 1497389897, 0, 0, 0, 2994779795, 0, 0, 0, 1694592294, 0, 0, 0, 3389184589, 
        0, 0, 0, 2483401882, 0, 0, 0, 671836468, 0, 0, 0, 1343672936, 0, 0, 0, 2687345872, 
        0, 0, 0, 1079724449, 0, 0, 0, 2159448898, 0, 0, 0, 23930501, 0, 0, 0, 47861002, 
        0, 0, 0, 95722004, 0, 0, 0, 191444008, 0, 0, 0, 382888016, 0, 0, 0, 765776032, 
        0, 0, 0, 1531552064, 0, 0, 0, 341393499, 0, 0, 0, 682786998, 0, 0, 0, 1365573997, 
    },
    {
        0, 0, 0, 0, 1226833920, 0, 0, 0, 2453667840, 0, 0, 0, 612368384, 0, 0, 0, 
        1224736768, 0, 0, 0, 2449473536, 0, 0, 0, 603979776, 0, 0, 0, 1207959552, 0, 0, 0, 
        2415919105, 0, 0, 0, 536870914, 0, 0, 0, 1073741828, 0, 0, 0, 2147483657, 0, 0, 0, 
        18, 0, 0, 0, 36, 0, 0, 0, 72, 0, 0, 0, 144, 0, 0, 0, 
        288, 0, 0, 0, 576, 0, 0, 0, 1152, 0, 0, 0, 2304, 0, 0, 0, 
        4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 0, 0, 0, 36864, 0, 0, 0, 
        73728, 0, 0, 0, 147456, 0, 0, 0, 1227128832, 0, 0, 0, 2454257664, 0, 0, 0, 
        613548032, 0, 0, 0, 1227096064, 0, 0, 0, 2454192128, 0, 0, 0, 613416960, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 335546385, 0, 0, 0, 671092770, 0, 0, 0, 1342185541, 0, 0, 0, 2684371082, 0, 
        0, 0, 1073774869, 0, 0, 0, 2147549738, 0, 0, 0, 132180, 0, 0, 0, 264360, 0, 
        0, 0, 528720, 0, 0, 0, 1057440, 0, 0, 0, 2114880, 0, 0, 0, 4229761, 0, 
        0, 0, 8459522, 0, 0, 0, 16919044, 0, 0, 0, 33838088, 0, 0, 0, 269000704, 0, 
        0, 0, 538001408, 0, 0, 0, 1076002817, 0, 0, 0, 2152005634, 0, 0, 0, 9043972, 0, 
        0, 0, 18087944, 0, 0, 0, 36175888, 0, 0, 0, 72351776, 0, 0, 0, 144703552, 0, 
        0, 0, 289407105, 0, 0, 0, 578814210, 0, 0, 0, 1157628420, 0, 0, 0, 2315256840, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3732057110, 
        0, 0, 0, 3169146925, 0, 0, 0, 2043326555, 0, 0, 0, 4086653111, 0, 0, 0, 3878338927, 
        0, 0, 0, 3461710558, 0, 0, 0, 2628453820, 0, 0, 0, 961940345, 0, 0, 0, 1923880691, 
        0, 0, 0, 3847761383, 0, 0, 0, 3400555471, 0, 0, 0, 2506143647, 0, 0, 0, 717319998, 
        0, 0, 0, 1434639996, 0, 0, 0, 2869279993, 0, 0, 0, 1443592691, 0, 0, 0, 2887185382, 
        0, 0, 0, 1479403468, 0, 0, 0, 2958806937, 0, 0, 0, 1622646578, 0, 0, 0, 3245293157, 
        0, 0, 0, 2195619018, 0, 0, 0, 3687732610, 0, 0, 0, 3080497925, 0, 0, 0, 1866028555, 
    },
    {
        0, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 
        4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554433, 0, 0, 0, 
        67108866, 0, 0, 0, 134217732, 0, 0, 0, 268435464, 0, 0, 0, 536870928, 0, 0, 0, 
        1073741856, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 260, 0, 0, 0, 
        520, 0, 0, 0, 1040, 0, 0, 0, 2080, 0, 0, 0, 4160, 0, 0, 0, 
        8320, 0, 0, 0, 16640, 0, 0, 0, 33280, 0, 0, 0, 66560, 0, 0, 0, 
        133120, 0, 0, 0, 266240, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 
        32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 2560, 0, 0, 0, 5120, 0, 0, 
        0, 10240, 0, 0, 0, 20480, 0, 0, 0, 40960, 0, 0, 0, 81920, 0, 0, 
        0, 163840, 0, 0, 0, 327680, 0, 0, 0, 655360, 0, 0, 0, 1310720, 0, 0, 
        0, 2621440, 0, 0, 0, 5242880, 0, 0, 0, 10485760, 0, 0, 0, 20971520, 0, 0, 
        0, 41943040, 0, 0, 0, 83886080, 0, 0, 0, 167772161, 0, 0, 0, 335544322, 0, 0, 
        0, 671088644, 0, 0, 0, 1342177288, 0, 0, 0, 2684354577, 0, 0, 0, 1073741858, 0, 0, 
        0, 2147483716, 0, 0, 0, 136, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 539164932, 0, 0, 0, 1078329864, 0, 0, 0, 2156659728, 0, 0, 0, 18352160, 0, 
        0, 0, 36704320, 0, 0, 0, 73408640, 0, 0, 0, 146817280, 0, 0, 0, 293634560, 0, 
        0, 0, 587269120, 0, 0, 0, 1174538240, 0, 0, 0, 2349076480, 0, 0, 0, 403185665, 0, 
        0, 0, 806371331, 0, 0, 0, 1612742663, 0, 0, 0, 3225485326, 0, 0, 0, 2694906136, 0, 
        0, 0, 1094844976, 0, 0, 0, 2189689952, 0, 0, 0, 84412608, 0, 0, 0, 168825216, 0, 
        0, 0, 337650433, 0, 0, 0, 675300866, 0, 0, 0, 1350601732, 0, 0, 0, 2701203464, 0, 
        0, 0, 1107439632, 0, 0, 0, 2214879264, 0, 0, 0, 134791233, 0, 0, 0, 269582466, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2033130968, 
        0, 0, 0, 4066261936, 0, 0, 0, 3837556576, 0, 0, 0, 3380145857, 0, 0, 0, 2465324418, 
        0, 0, 0, 635681541, 0, 0, 0, 1271363082, 0, 0, 0, 2542726165, 0, 0, 0, 790485035, 
        0, 0, 0, 1580970071, 0, 0, 0, 3161940143, 0, 0, 0, 2028912991, 0, 0, 0, 4057825983, 
        0, 0, 0, 3820684671, 0, 0, 0, 3346402046, 0, 0, 0, 2397836796, 0, 0, 0, 500706297, 
        0, 0, 0, 1001412595, 0, 0, 0, 2002825190, 0, 0, 0, 4005650380, 0, 0, 0, 3716333464, 
        0, 0, 0, 3137699633, 0, 0, 0, 254141371, 0, 0, 0, 508282742, 0, 0, 0, 1016565484, 
    },
};

// clang-format on
// clang-format off
static const unsigned int h_lfsr113_jump_matrices[LFSR113_JUMP_MATRICES][LFSR113_SIZE] = {
    {
        0, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 
        4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554433, 0, 0, 0, 
        67108866, 0, 0, 0, 134217732, 0, 0, 0, 268435464, 0, 0, 0, 536870928, 0, 0, 0, 
        1073741856, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 260, 0, 0, 0, 
        520, 0, 0, 0, 1040, 0, 0, 0, 2080, 0, 0, 0, 4160, 0, 0, 0, 
        8320, 0, 0, 0, 16640, 0, 0, 0, 33280, 0, 0, 0, 66560, 0, 0, 0, 
        133120, 0, 0, 0, 266240, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 
        32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 
        0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 
        0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 
        0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 
        0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 
        0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554432, 0, 0, 
        0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 0, 536870917, 0, 0, 
        0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 
        0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 0, 0, 262152, 0, 
        0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 
        0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67108864, 0, 
        0, 0, 134217728, 0, 0, 0, 268435457, 0, 0, 0, 536870914, 0, 0, 0, 1073741828, 0, 
        0, 0, 2147483656, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 64, 0, 
        0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1048576, 
        0, 0, 0, 2097152, 0, 0, 0, 4194305, 0, 0, 0, 8388610, 0, 0, 0, 16777220, 
        0, 0, 0, 33554441, 0, 0, 0, 67108882, 0, 0, 0, 134217764, 0, 0, 0, 268435528, 
        0, 0, 0, 536871056, 0, 0, 0, 1073742112, 0, 0, 0, 2147484224, 0, 0, 0, 1152, 
        0, 0, 0, 2304, 0, 0, 0, 4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 
        0, 0, 0, 36864, 0, 0, 0, 73728, 0, 0, 0, 147456, 0, 0, 0, 294912, 
        0, 0, 0, 589824, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 
    },
    {
        0, 0, 0, 0, 8390656, 0, 0, 0, 16781312, 0, 0, 0, 33562625, 0, 0, 0, 
        67125250, 0, 0, 0, 134250500, 0, 0, 0, 268501000, 0, 0, 0, 537002000, 0, 0, 0, 
        1074004000, 0, 0, 0, 2148008001, 0, 0, 0, 1048706, 0, 0, 0, 2097412, 0, 0, 0, 
        4194824, 0, 0, 0, 8389648, 0, 0, 0, 16779296, 0, 0, 0, 33558593, 0, 0, 0, 
        67117186, 0, 0, 0, 134234372, 0, 0, 0, 268468744, 0, 0, 0, 536937488, 0, 0, 0, 
        1073874976, 0, 0, 0, 2147749953, 0, 0, 0, 532610, 0, 0, 0, 1065220, 0, 0, 0, 
        2130440, 0, 0, 0, 4260880, 0, 0, 0, 131104, 0, 0, 0, 262208, 0, 0, 0, 
        524416, 0, 0, 0, 1048832, 0, 0, 0, 2097664, 0, 0, 0, 4195328, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 131092, 0, 0, 0, 262184, 0, 0, 0, 524368, 0, 0, 0, 1048736, 0, 
        0, 0, 2097472, 0, 0, 0, 4194944, 0, 0, 0, 8389888, 0, 0, 0, 16779776, 0, 
        0, 0, 33559552, 0, 0, 0, 67119104, 0, 0, 0, 134238208, 0, 0, 0, 268476416, 0, 
        0, 0, 536952832, 0, 0, 0, 1073905665, 0, 0, 0, 2147811330, 0, 0, 0, 524304, 0, 
        0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 0, 0, 8388864, 0, 
        0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67110912, 0, 0, 0, 134221824, 0, 
        0, 0, 268443649, 0, 0, 0, 536887298, 0, 0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33280, 
        0, 0, 0, 66560, 0, 0, 0, 133120, 0, 0, 0, 266240, 0, 0, 0, 532480, 
        0, 0, 0, 1064960, 0, 0, 0, 2129920, 0, 0, 0, 4259841, 0, 0, 0, 8519682, 
        0, 0, 0, 17039364, 0, 0, 0, 34078729, 0, 0, 0, 68157458, 0, 0, 0, 136314916, 
        0, 0, 0, 272629833, 0, 0, 0, 545259666, 0, 0, 0, 1090519332, 0, 0, 0, 2181038665, 
        0, 0, 0, 67110034, 0, 0, 0, 134220068, 0, 0, 0, 268440136, 0, 0, 0, 536880272, 
        0, 0, 0, 1073760544, 0, 0, 0, 2147487808, 0, 0, 0, 8320, 0, 0, 0, 16640, 
    },
    {
        0, 0, 0, 0, 134300932, 0, 0, 0, 268601864, 0, 0, 0, 537203728, 0, 0, 0, 
        1074407456, 0, 0, 0, 2148814913, 0, 0, 0, 2662530, 0, 0, 0, 5325060, 0, 0, 0, 
        10650120, 0, 0, 0, 21300240, 0, 0, 0, 42600481, 0, 0, 0, 85200962, 0, 0, 0, 
        170401925, 0, 0, 0, 340803850, 0, 0, 0, 681607700, 0, 0, 0, 1363215400, 0, 0, 0, 
        2726430800, 0, 0, 0, 1157894304, 0, 0, 0, 2315788608, 0, 0, 0, 336609920, 0, 0, 0, 
        673219840, 0, 0, 0, 1346439680, 0, 0, 0, 2692879361, 0, 0, 0, 1090791426, 0, 0, 0, 
        2181582852, 0, 0, 0, 68198408, 0, 0, 0, 2098452, 0, 0, 0, 4196904, 0, 0, 0, 
        8393808, 0, 0, 0, 16787616, 0, 0, 0, 33575233, 0, 0, 0, 67150466, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 2560, 0, 0, 0, 5120, 0, 0, 
        0, 10240, 0, 0, 0, 20480, 0, 0, 0, 40960, 0, 0, 0, 81920, 0, 0, 
        0, 163840, 0, 0, 0, 327680, 0, 0, 0, 655360, 0, 0, 0, 1310720, 0, 0, 
        0, 2621440, 0, 0, 0, 5242880, 0, 0, 0, 10485760, 0, 0, 0, 20971520, 0, 0, 
        0, 41943040, 0, 0, 0, 83886080, 0, 0, 0, 167772161, 0, 0, 0, 335544322, 0, 0, 
        0, 671088644, 0, 0, 0, 1342177288, 0, 0, 0, 2684354577, 0, 0, 0, 1073741858, 0, 0, 
        0, 2147483716, 0, 0, 0, 136, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 335546385, 0, 0, 0, 671092770, 0, 0, 0, 1342185541, 0, 0, 0, 2684371082, 0, 
        0, 0, 1073774869, 0, 0, 0, 2147549738, 0, 0, 0, 132180, 0, 0, 0, 264360, 0, 
        0, 0, 528720, 0, 0, 0, 1057440, 0, 0, 0, 2114880, 0, 0, 0, 4229761, 0, 
        0, 0, 8459522, 0, 0, 0, 16919044, 0, 0, 0, 33838088, 0, 0, 0, 269000704, 0, 
        0, 0, 538001408, 0, 0, 0, 1076002817, 0, 0, 0, 2152005634, 0, 0, 0, 9043972, 0, 
        0, 0, 18087944, 0, 0, 0, 36175888, 0, 0, 0, 72351776, 0, 0, 0, 144703552, 0, 
        0, 0, 289407105, 0, 0, 0, 578814210, 0, 0, 0, 1157628420, 0, 0, 0, 2315256840, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180224, 
        0, 0, 0, 360448, 0, 0, 0, 720896, 0, 0, 0, 1441792, 0, 0, 0, 2883584, 
        0, 0, 0, 5767169, 0, 0, 0, 11534338, 0, 0, 0, 23068677, 0, 0, 0, 46137354, 
        0, 0, 0, 92274708, 0, 0, 0, 184549417, 0, 0, 0, 369098835, 0, 0, 0, 738197670, 
        0, 0, 0, 1476395340, 0, 0, 0, 2952790680, 0, 0, 0, 1610614064, 0, 0, 0, 3221228128, 
        0, 0, 0, 2147488960, 0, 0, 0, 10624, 0, 0, 0, 21248, 0, 0, 0, 42496, 
        0, 0, 0, 84992, 0, 0, 0, 22528, 0, 0, 0, 45056, 0, 0, 0, 90112, 
    },
    {
        0, 0, 0, 0, 826542200, 0, 0, 0, 1653084401, 0, 0, 0, 3306168803, 0, 0, 0, 
        2317370310, 0, 0, 0, 339773324, 0, 0, 0, 679546648, 0, 0, 0, 1359093296, 0, 0, 0, 
        2718186592, 0, 0, 0, 1141405888, 0, 0, 0, 2282811777, 0, 0, 0, 270656258, 0, 0, 0, 
        541312516, 0, 0, 0, 1082625032, 0, 0, 0, 2165250065, 0, 0, 0, 35532835, 0, 0, 0, 
        71065670, 0, 0, 0, 142131340, 0, 0, 0, 284262680, 0, 0, 0, 568525360, 0, 0, 0, 
        1137050721, 0, 0, 0, 2274101442, 0, 0, 0, 253235589, 0, 0, 0, 506471179, 0, 0, 0, 
        1012942358, 0, 0, 0, 2025884716, 0, 0, 0, 3234140193, 0, 0, 0, 2173313091, 0, 0, 0, 
        51658887, 0, 0, 0, 103317775, 0, 0, 0, 206635550, 0, 0, 0, 413271100, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8421376, 0, 0, 
        0, 16842752, 0, 0, 0, 33685504, 0, 0, 0, 67371008, 0, 0, 0, 134742017, 0, 0, 
        0, 269484034, 0, 0, 0, 538968069, 0, 0, 0, 1077936138, 0, 0, 0, 2155872276, 0, 0, 
        0, 16777256, 0, 0, 0, 33554512, 0, 0, 0, 67109024, 0, 0, 0, 134218049, 0, 0, 
        0, 268436098, 0, 0, 0, 536872197, 0, 0, 0, 1073744394, 0, 0, 0, 2147488788, 0, 0, 
        0, 10280, 0, 0, 0, 20560, 0, 0, 0, 41120, 0, 0, 0, 82240, 0, 0, 
        0, 164480, 0, 0, 0, 328960, 0, 0, 0, 657920, 0, 0, 0, 1315840, 0, 0, 
        0, 2631680, 0, 0, 0, 5263360, 0, 0, 0, 2105344, 0, 0, 0, 4210688, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 539164932, 0, 0, 0, 1078329864, 0, 0, 0, 2156659728, 0, 0, 0, 18352160, 0, 
        0, 0, 36704320, 0, 0, 0, 73408640, 0, 0, 0, 146817280, 0, 0, 0, 293634560, 0, 
        0, 0, 587269120, 0, 0, 0, 1174538240, 0, 0, 0, 2349076480, 0, 0, 0, 403185665, 0, 
        0, 0, 806371331, 0, 0, 0, 1612742663, 0, 0, 0, 3225485326, 0, 0, 0, 2694906136, 0, 
        0, 0, 1094844976, 0, 0, 0, 2189689952, 0, 0, 0, 84412608, 0, 0, 0, 168825216, 0, 
        0, 0, 337650433, 0, 0, 0, 675300866, 0, 0, 0, 1350601732, 0, 0, 0, 2701203464, 0, 
        0, 0, 1107439632, 0, 0, 0, 2214879264, 0, 0, 0, 134791233, 0, 0, 0, 269582466, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37905416, 
        0, 0, 0, 75810832, 0, 0, 0, 151621664, 0, 0, 0, 303243329, 0, 0, 0, 606486658, 
        0, 0, 0, 1212973317, 0, 0, 0, 2425946634, 0, 0, 0, 556925972, 0, 0, 0, 1113851944, 
        0, 0, 0, 2227703889, 0, 0, 0, 160440482, 0, 0, 0, 320880965, 0, 0, 0, 641761930, 
        0, 0, 0, 1283523860, 0, 0, 0, 2567047720, 0, 0, 0, 839128145, 0, 0, 0, 1678256290, 
        0, 0, 0, 3356512580, 0, 0, 0, 2418057864, 0, 0, 0, 541148433, 0, 0, 0, 1082296866, 
        0, 0, 0, 2164593732, 0, 0, 0, 4738177, 0, 0, 0, 9476354, 0, 0, 0, 18952708, 
    },
    {
        0, 0, 0, 0, 2499687121, 0, 0, 0, 704406946, 0, 0, 0, 1408813893, 0, 0, 0, 
        2817627786, 0, 0, 0, 1340288277, 0, 0, 0, 2680576554, 0, 0, 0, 1066185813, 0, 0, 0, 
        2132371627, 0, 0, 0, 4264743254, 0, 0, 0, 4234519213, 0, 0, 0, 4174071131, 0, 0, 0, 
        4053174967, 0, 0, 0, 3811382638, 0, 0, 0, 3327797980, 0, 0, 0, 2360628665, 0, 0, 0, 
        426290034, 0, 0, 0, 852580069, 0, 0, 0, 1705160138, 0, 0, 0, 3410320276, 0, 0, 0, 
        2525673256, 0, 0, 0, 756379216, 0, 0, 0, 1512758433, 0, 0, 0, 3025516867, 0, 0, 0, 
        1756066438, 0, 0, 0, 3512132877, 0, 0, 0, 911472843, 0, 0, 0, 1822945686, 0, 0, 0, 
        3645891373, 0, 0, 0, 2996815450, 0, 0, 0, 1698663604, 0, 0, 0, 3397327208, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 591396869, 0, 0, 
        0, 1182793738, 0, 0, 0, 2365587477, 0, 0, 0, 436207659, 0, 0, 0, 872415319, 0, 0, 
        0, 1744830638, 0, 0, 0, 3489661276, 0, 0, 0, 2684355257, 0, 0, 0, 1073743218, 0, 0, 
        0, 2147486436, 0, 0, 0, 5576, 0, 0, 0, 11152, 0, 0, 0, 22304, 0, 0, 
        0, 44608, 0, 0, 0, 89216, 0, 0, 0, 178432, 0, 0, 0, 356864, 0, 0, 
        0, 713728, 0, 0, 0, 1427456, 0, 0, 0, 2854912, 0, 0, 0, 5709824, 0, 0, 
        0, 11419648, 0, 0, 0, 22839296, 0, 0, 0, 45678592, 0, 0, 0, 91357184, 0, 0, 
        0, 182714369, 0, 0, 0, 365428738, 0, 0, 0, 147849217, 0, 0, 0, 295698434, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 490817699, 0, 0, 0, 981635398, 0, 0, 0, 1963270797, 0, 0, 0, 3926541594, 0, 
        0, 0, 3558115892, 0, 0, 0, 2821264488, 0, 0, 0, 1347561681, 0, 0, 0, 2695123362, 0, 
        0, 0, 1095279429, 0, 0, 0, 2190558858, 0, 0, 0, 86150421, 0, 0, 0, 172300842, 0, 
        0, 0, 344601685, 0, 0, 0, 689203370, 0, 0, 0, 1378406740, 0, 0, 0, 3104893450, 0, 
        0, 0, 1914819604, 0, 0, 0, 3829639209, 0, 0, 0, 3364311122, 0, 0, 0, 2433654948, 0, 
        0, 0, 572342600, 0, 0, 0, 1144685201, 0, 0, 0, 2289370402, 0, 0, 0, 283773509, 0, 
        0, 0, 567547018, 0, 0, 0, 1135094036, 0, 0, 0, 2270188072, 0, 0, 0, 245408849, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2731147994, 
        0, 0, 0, 1167328692, 0, 0, 0, 2334657385, 0, 0, 0, 374347474, 0, 0, 0, 748694948, 
        0, 0, 0, 1497389897, 0, 0, 0, 2994779795, 0, 0, 0, 1694592294, 0, 0, 0, 3389184589, 
        0, 0, 0, 2483401882, 0, 0, 0, 671836468, 0, 0, 0, 1343672936, 0, 0, 0, 2687345872, 
        0, 0, 0, 1079724449, 0, 0, 0, 2159448898, 0, 0, 0, 23930501, 0, 0, 0, 47861002, 
        0, 0, 0, 95722004, 0, 0, 0, 191444008, 0, 0, 0, 382888016, 0, 0, 0, 765776032, 
        0, 0, 0, 1531552064, 0, 0, 0, 341393499, 0, 0, 0, 682786998, 0, 0, 0, 1365573997, 
    },
    {
        0, 0, 0, 0, 2271571420, 0, 0, 0, 248175545, 0, 0, 0, 496351090, 0, 0, 0, 
        992702181, 0, 0, 0, 1985404363, 0, 0, 0, 3970808727, 0, 0, 0, 3646650159, 0, 0, 0, 
        2998333022, 0, 0, 0, 1701698748, 0, 0, 0, 3403397496, 0, 0, 0, 2511827697, 0, 0, 0, 
        728688099, 0, 0, 0, 1457376199, 0, 0, 0, 2914752399, 0, 0, 0, 1534537503, 0, 0, 0, 
        3069075006, 0, 0, 0, 1843182716, 0, 0, 0, 3686365432, 0, 0, 0, 3077763568, 0, 0, 0, 
        1860559841, 0, 0, 0, 3721119683, 0, 0, 0, 3147272070, 0, 0, 0, 1999576845, 0, 0, 0, 
        3999153690, 0, 0, 0, 3703340085, 0, 0, 0, 1042126263, 0, 0, 0, 2084252526, 0, 0, 0, 
        4168505053, 0, 0, 0, 4042042811, 0, 0, 0, 3789118327, 0, 0, 0, 3283269358, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 661652741, 0, 0, 
        0, 1323305483, 0, 0, 0, 2646610967, 0, 0, 0, 998254638, 0, 0, 0, 1996509277, 0, 0, 
        0, 3993018554, 0, 0, 0, 3691069813, 0, 0, 0, 3087172330, 0, 0, 0, 1879377365, 0, 0, 
        0, 3758754731, 0, 0, 0, 3222542166, 0, 0, 0, 2150117036, 0, 0, 0, 5266776, 0, 0, 
        0, 10533552, 0, 0, 0, 21067104, 0, 0, 0, 42134208, 0, 0, 0, 84268416, 0, 0, 
        0, 168536833, 0, 0, 0, 337073666, 0, 0, 0, 674147332, 0, 0, 0, 1348294664, 0, 0, 
        0, 2696589329, 0, 0, 0, 1098211362, 0, 0, 0, 2196422724, 0, 0, 0, 97878152, 0, 0, 
        0, 195756305, 0, 0, 0, 391512610, 0, 0, 0, 165413185, 0, 0, 0, 330826370, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2541187255, 0, 0, 0, 787407215, 0, 0, 0, 1574814430, 0, 0, 0, 3149628860, 0, 
        0, 0, 2004290425, 0, 0, 0, 4008580850, 0, 0, 0, 3722194405, 0, 0, 0, 3149421515, 0, 
        0, 0, 2003875734, 0, 0, 0, 4007751468, 0, 0, 0, 3720535640, 0, 0, 0, 3146103984, 0, 
        0, 0, 1997240673, 0, 0, 0, 3994481347, 0, 0, 0, 3693995398, 0, 0, 0, 791460795, 0, 
        0, 0, 1582921591, 0, 0, 0, 3165843182, 0, 0, 0, 2036719068, 0, 0, 0, 4073438136, 0, 
        0, 0, 3851908976, 0, 0, 0, 3408850657, 0, 0, 0, 2522734018, 0, 0, 0, 750500741, 0, 
        0, 0, 1501001483, 0, 0, 0, 3002002966, 0, 0, 0, 1709038637, 0, 0, 0, 3418077275, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3732057110, 
        0, 0, 0, 3169146925, 0, 0, 0, 2043326555, 0, 0, 0, 4086653111, 0, 0, 0, 3878338927, 
        0, 0, 0, 3461710558, 0, 0, 0, 2628453820, 0, 0, 0, 961940345, 0, 0, 0, 1923880691, 
        0, 0, 0, 3847761383, 0, 0, 0, 3400555471, 0, 0, 0, 2506143647, 0, 0, 0, 717319998, 
        0, 0, 0, 1434639996, 0, 0, 0, 2869279993, 0, 0, 0, 1443592691, 0, 0, 0, 2887185382, 
        0, 0, 0, 1479403468, 0, 0, 0, 2958806937, 0, 0, 0, 1622646578, 0, 0, 0, 3245293157, 
        0, 0, 0, 2195619018, 0, 0, 0, 3687732610, 0, 0, 0, 3080497925, 0, 0, 0, 1866028555, 
    },
    {
        0, 0, 0, 0, 1739616249, 0, 0, 0, 3479232498, 0, 0, 0, 2663497700, 0, 0, 0, 
        1032028104, 0, 0, 0, 2064056209, 0, 0, 0, 4128112418, 0, 0, 0, 3961257541, 0, 0, 0, 
        3627547787, 0, 0, 0, 2960128279, 0, 0, 0, 1625289262, 0, 0, 0, 3250578525, 0, 0, 0, 
        2206189754, 0, 0, 0, 117412213, 0, 0, 0, 234824426, 0, 0, 0, 469648853, 0, 0, 0, 
        939297707, 0, 0, 0, 1878595415, 0, 0, 0, 3757190830, 0, 0, 0, 3219414364, 0, 0, 0, 
        2143861433, 0, 0, 0, 4287722866, 0, 0, 0, 4280478436, 0, 0, 0, 4265989576, 0, 0, 0, 
        4237011857, 0, 0, 0, 4179056419, 0, 0, 0, 2510209471, 0, 0, 0, 725451647, 0, 0, 0, 
        1450903295, 0, 0, 0, 2901806591, 0, 0, 0, 1508645886, 0, 0, 0, 3017291772, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2815455249, 0, 0, 
        0, 1335943203, 0, 0, 0, 2671886407, 0, 0, 0, 1048805518, 0, 0, 0, 2097611036, 0, 0, 
        0, 4195222072, 0, 0, 0, 4095476849, 0, 0, 0, 3895986402, 0, 0, 0, 3497005508, 0, 0, 
        0, 2699043721, 0, 0, 0, 1103120146, 0, 0, 0, 2206240292, 0, 0, 0, 117513288, 0, 0, 
        0, 235026577, 0, 0, 0, 470053155, 0, 0, 0, 940106310, 0, 0, 0, 1880212621, 0, 0, 
        0, 3760425243, 0, 0, 0, 3225883190, 0, 0, 0, 2156799084, 0, 0, 0, 18630872, 0, 0, 
        0, 37261744, 0, 0, 0, 74523488, 0, 0, 0, 149046977, 0, 0, 0, 298093954, 0, 0, 
        0, 596187909, 0, 0, 0, 1192375818, 0, 0, 0, 703863812, 0, 0, 0, 1407727624, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2614536692, 0, 0, 0, 934106089, 0, 0, 0, 1868212179, 0, 0, 0, 3736424359, 0, 
        0, 0, 3177881422, 0, 0, 0, 2060795549, 0, 0, 0, 4121591099, 0, 0, 0, 3948214903, 0, 
        0, 0, 3601462510, 0, 0, 0, 2907957725, 0, 0, 0, 1520948154, 0, 0, 0, 3041896308, 0, 
        0, 0, 1788825320, 0, 0, 0, 3577650640, 0, 0, 0, 2860333984, 0, 0, 0, 3475824309, 0, 
        0, 0, 2656681322, 0, 0, 0, 1018395349, 0, 0, 0, 2036790698, 0, 0, 0, 4073581396, 0, 
        0, 0, 3852195497, 0, 0, 0, 3409423699, 0, 0, 0, 2523880103, 0, 0, 0, 752792911, 0, 
        0, 0, 1505585823, 0, 0, 0, 3011171646, 0, 0, 0, 1727375997, 0, 0, 0, 3454751994, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2033130968, 
        0, 0, 0, 4066261936, 0, 0, 0, 3837556576, 0, 0, 0, 3380145857, 0, 0, 0, 2465324418, 
        0, 0, 0, 635681541, 0, 0, 0, 1271363082, 0, 0, 0, 2542726165, 0, 0, 0, 790485035, 
        0, 0, 0, 1580970071, 0, 0, 0, 3161940143, 0, 0, 0, 2028912991, 0, 0, 0, 4057825983, 
        0, 0, 0, 3820684671, 0, 0, 0, 3346402046, 0, 0, 0, 2397836796, 0, 0, 0, 500706297, 
        0, 0, 0, 1001412595, 0, 0, 0, 2002825190, 0, 0, 0, 4005650380, 0, 0, 0, 3716333464, 
        0, 0, 0, 3137699633, 0, 0, 0, 254141371, 0, 0, 0, 508282742, 0, 0, 0, 1016565484, 
    },
    {
        0, 0, 0, 0, 1915396941, 0, 0, 0, 3830793883, 0, 0, 0, 3366620471, 0, 0, 0, 
        2438273647, 0, 0, 0, 581579999, 0, 0, 0, 1163159998, 0, 0, 0, 2326319996, 0, 0, 0, 
        357672696, 0, 0, 0, 715345393, 0, 0, 0, 1430690786, 0, 0, 0, 2861381572, 0, 0, 0, 
        1427795848, 0, 0, 0, 2855591696, 0, 0, 0, 1416216096, 0, 0, 0, 2832432193, 0, 0, 0, 
        1369897090, 0, 0, 0, 2739794180, 0, 0, 0, 1184621065, 0, 0, 0, 2369242131, 0, 0, 0, 
        443516967, 0, 0, 0, 887033934, 0, 0, 0, 1774067868, 0, 0, 0, 3548135736, 0, 0, 0, 
        2801304176, 0, 0, 0, 1307641056, 0, 0, 0, 3922242189, 0, 0, 0, 3549517082, 0, 0, 0, 
        2804066868, 0, 0, 0, 1313166441, 0, 0, 0, 2626332883, 0, 0, 0, 957698470, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1432822912, 0, 0, 
        0, 2865645824, 0, 0, 0, 1436324352, 0, 0, 0, 2872648704, 0, 0, 0, 1450330112, 0, 0, 
        0, 2900660224, 0, 0, 0, 1506353153, 0, 0, 0, 3012706307, 0, 0, 0, 1730445319, 0, 0, 
        0, 3460890639, 0, 0, 0, 2626813983, 0, 0, 0, 958660670, 0, 0, 0, 1917321341, 0, 0, 
        0, 3834642683, 0, 0, 0, 3374318071, 0, 0, 0, 2453668846, 0, 0, 0, 612370397, 0, 0, 
        0, 1224740795, 0, 0, 0, 2449481590, 0, 0, 0, 603995885, 0, 0, 0, 1207991771, 0, 0, 
        0, 2415983542, 0, 0, 0, 536999789, 0, 0, 0, 1073999578, 0, 0, 0, 2147999156, 0, 0, 
        0, 1031016, 0, 0, 0, 2062032, 0, 0, 0, 1431947552, 0, 0, 0, 2863895104, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2983242506, 0, 0, 0, 1671517716, 0, 0, 0, 3343035433, 0, 0, 0, 2391103570, 0, 
        0, 0, 487239844, 0, 0, 0, 974479689, 0, 0, 0, 1948959378, 0, 0, 0, 3897918757, 0, 
        0, 0, 3500870219, 0, 0, 0, 2706773142, 0, 0, 0, 1118578988, 0, 0, 0, 2237157976, 0, 
        0, 0, 179348657, 0, 0, 0, 358697315, 0, 0, 0, 717394631, 0, 0, 0, 3830812293, 0, 
        0, 0, 3366657290, 0, 0, 0, 2438347285, 0, 0, 0, 581727274, 0, 0, 0, 1163454549, 0, 
        0, 0, 2326909099, 0, 0, 0, 358850902, 0, 0, 0, 717701804, 0, 0, 0, 1435403608, 0, 
        0, 0, 2870807216, 0, 0, 0, 1446647137, 0, 0, 0, 2893294274, 0, 0, 0, 1491621253, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2199499341, 
        0, 0, 0, 104031387, 0, 0, 0, 208062775, 0, 0, 0, 416125551, 0, 0, 0, 832251102, 
        0, 0, 0, 1664502205, 0, 0, 0, 3329004410, 0, 0, 0, 2363041525, 0, 0, 0, 431115754, 
        0, 0, 0, 862231508, 0, 0, 0, 1724463016, 0, 0, 0, 3448926032, 0, 0, 0, 2602884769, 
        0, 0, 0, 910802242, 0, 0, 0, 1821604484, 0, 0, 0, 3643208968, 0, 0, 0, 2991450640, 
        0, 0, 0, 1687933984, 0, 0, 0, 3375867968, 0, 0, 0, 2456768640, 0, 0, 0, 618569985, 
        0, 0, 0, 1237139970, 0, 0, 0, 274937417, 0, 0, 0, 549874835, 0, 0, 0, 1099749670, 
    },
    {
        0, 0, 0, 0, 4038889453, 0, 0, 0, 3782811611, 0, 0, 0, 3270655926, 0, 0, 0, 
        2246344557, 0, 0, 0, 197721819, 0, 0, 0, 395443639, 0, 0, 0, 790887279, 0, 0, 0, 
        1581774559, 0, 0, 0, 3163549119, 0, 0, 0, 2032130942, 0, 0, 0, 4064261884, 0, 0, 0, 
        3833556473, 0, 0, 0, 3372145651, 0, 0, 0, 2449324007, 0, 0, 0, 603680719, 0, 0, 0, 
        1207361439, 0, 0, 0, 2414722878, 0, 0, 0, 534478461, 0, 0, 0, 1068956923, 0, 0, 0, 
        2137913847, 0, 0, 0, 4275827694, 0, 0, 0, 4256688093, 0, 0, 0, 4218408890, 0, 0, 0, 
        4141850484, 0, 0, 0, 3988733673, 0, 0, 0, 734196287, 0, 0, 0, 1468392575, 0, 0, 0, 
        2936785150, 0, 0, 0, 1578603005, 0, 0, 0, 3157206011, 0, 0, 0, 2019444726, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2740852545, 0, 0, 
        0, 1186737794, 0, 0, 0, 2373475589, 0, 0, 0, 451983883, 0, 0, 0, 903967767, 0, 0, 
        0, 1807935534, 0, 0, 0, 3615871068, 0, 0, 0, 2936774840, 0, 0, 0, 1578582385, 0, 0, 
        0, 3157164770, 0, 0, 0, 2019362244, 0, 0, 0, 4038724489, 0, 0, 0, 3782481683, 0, 0, 
        0, 3269996070, 0, 0, 0, 2245024844, 0, 0, 0, 195082393, 0, 0, 0, 390164786, 0, 0, 
        0, 780329572, 0, 0, 0, 1560659145, 0, 0, 0, 3121318290, 0, 0, 0, 1947669285, 0, 0, 
        0, 3895338570, 0, 0, 0, 3495709844, 0, 0, 0, 2696452393, 0, 0, 0, 1097937490, 0, 0, 
        0, 2195874980, 0, 0, 0, 96782664, 0, 0, 0, 2832696784, 0, 0, 0, 1370426272, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2797805596, 0, 0, 0, 1300643896, 0, 0, 0, 2601287792, 0, 0, 0, 907608289, 0, 
        0, 0, 1815216578, 0, 0, 0, 3630433157, 0, 0, 0, 2965899019, 0, 0, 0, 1636830742, 0, 
        0, 0, 3273661484, 0, 0, 0, 2252355672, 0, 0, 0, 209744048, 0, 0, 0, 419488096, 0, 
        0, 0, 838976192, 0, 0, 0, 1677952385, 0, 0, 0, 3355904770, 0, 0, 0, 919418393, 0, 
        0, 0, 1838836786, 0, 0, 0, 3677673572, 0, 0, 0, 3060379848, 0, 0, 0, 1825792400, 0, 
        0, 0, 3651584800, 0, 0, 0, 3008202304, 0, 0, 0, 1721437312, 0, 0, 0, 3442874624, 0, 
        0, 0, 2590781953, 0, 0, 0, 886596611, 0, 0, 0, 1773193223, 0, 0, 0, 3546386446, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4196822677, 
        0, 0, 0, 4098678059, 0, 0, 0, 3902388822, 0, 0, 0, 3509810348, 0, 0, 0, 2724653400, 
        0, 0, 0, 1154339505, 0, 0, 0, 2308679010, 0, 0, 0, 322390725, 0, 0, 0, 644781450, 
        0, 0, 0, 1289562901, 0, 0, 0, 2579125802, 0, 0, 0, 863284308, 0, 0, 0, 1726568616, 
        0, 0, 0, 3453137233, 0, 0, 0, 2611307171, 0, 0, 0, 927647046, 0, 0, 0, 1855294093, 
        0, 0, 0, 3710588186, 0, 0, 0, 3126209076, 0, 0, 0, 1957450856, 0, 0, 0, 3914901713, 
        0, 0, 0, 3534836131, 0, 0, 0, 1598344658, 0, 0, 0, 3196689317, 0, 0, 0, 2098411338, 
    },
    {
        0, 0, 0, 0, 3824344628, 0, 0, 0, 3353721960, 0, 0, 0, 2412476624, 0, 0, 0, 
        529985953, 0, 0, 0, 1059971907, 0, 0, 0, 2119943815, 0, 0, 0, 4239887631, 0, 0, 0, 
        4184807967, 0, 0, 0, 4074648638, 0, 0, 0, 3854329981, 0, 0, 0, 3413692666, 0, 0, 0, 
        2532418036, 0, 0, 0, 769868776, 0, 0, 0, 1539737553, 0, 0, 0, 3079475106, 0, 0, 0, 
        1863982917, 0, 0, 0, 3727965834, 0, 0, 0, 3160964373, 0, 0, 0, 2026961450, 0, 0, 0, 
        4053922901, 0, 0, 0, 3812878506, 0, 0, 0, 3330789716, 0, 0, 0, 2366612137, 0, 0, 0, 
        438256979, 0, 0, 0, 876513958, 0, 0, 0, 2341456760, 0, 0, 0, 387946225, 0, 0, 0, 
        775892451, 0, 0, 0, 1551784902, 0, 0, 0, 3103569805, 0, 0, 0, 1912172314, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3220345106, 0, 0, 
        0, 2145722916, 0, 0, 0, 4291445832, 0, 0, 0, 4287924368, 0, 0, 0, 4280881440, 0, 0, 
        0, 4266795584, 0, 0, 0, 4238623872, 0, 0, 0, 4182280448, 0, 0, 0, 4069593601, 0, 0, 
        0, 3844219907, 0, 0, 0, 3393472519, 0, 0, 0, 2491977742, 0, 0, 0, 688988188, 0, 0, 
        0, 1377976376, 0, 0, 0, 2755952753, 0, 0, 0, 1216938211, 0, 0, 0, 2433876422, 0, 0, 
        0, 572785549, 0, 0, 0, 1145571098, 0, 0, 0, 2291142197, 0, 0, 0, 287317098, 0, 0, 
        0, 574634197, 0, 0, 0, 1149268394, 0, 0, 0, 2298536789, 0, 0, 0, 302106282, 0, 0, 
        0, 604212565, 0, 0, 0, 1208425131, 0, 0, 0, 805086276, 0, 0, 0, 1610172553, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 3324387232, 0, 0, 0, 2353807168, 0, 0, 0, 412647041, 0, 0, 0, 825294082, 0, 
        0, 0, 1650588165, 0, 0, 0, 3301176331, 0, 0, 0, 2307385367, 0, 0, 0, 319803438, 0, 
        0, 0, 639606877, 0, 0, 0, 1279213754, 0, 0, 0, 2558427508, 0, 0, 0, 821887721, 0, 
        0, 0, 1643775442, 0, 0, 0, 3287550884, 0, 0, 0, 2280134472, 0, 0, 0, 3388354864, 0, 
        0, 0, 2481742433, 0, 0, 0, 668517571, 0, 0, 0, 1337035143, 0, 0, 0, 2674070287, 0, 
        0, 0, 1053173279, 0, 0, 0, 2106346559, 0, 0, 0, 4212693118, 0, 0, 0, 4130418941, 0, 
        0, 0, 3965870586, 0, 0, 0, 3636773876, 0, 0, 0, 2978580456, 0, 0, 0, 1662193616, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2034053848, 
        0, 0, 0, 4068107696, 0, 0, 0, 3841248097, 0, 0, 0, 3387528899, 0, 0, 0, 2480090502, 
        0, 0, 0, 665213709, 0, 0, 0, 1330427418, 0, 0, 0, 2660854837, 0, 0, 0, 1026742378, 
        0, 0, 0, 2053484756, 0, 0, 0, 4106969513, 0, 0, 0, 3918971730, 0, 0, 0, 3542976165, 
        0, 0, 0, 2790985034, 0, 0, 0, 1287002772, 0, 0, 0, 2574005545, 0, 0, 0, 853043794, 
        0, 0, 0, 1706087588, 0, 0, 0, 3412175176, 0, 0, 0, 2529383056, 0, 0, 0, 763798816, 
        0, 0, 0, 1527597633, 0, 0, 0, 3475482203, 0, 0, 0, 2655997110, 0, 0, 0, 1017026924, 
    },
    {
        0, 0, 0, 0, 1099834596, 0, 0, 0, 2199669192, 0, 0, 0, 104371089, 0, 0, 0, 
        208742178, 0, 0, 0, 417484356, 0, 0, 0, 834968712, 0, 0, 0, 1669937425, 0, 0, 0, 
        3339874850, 0, 0, 0, 2384782404, 0, 0, 0, 474597512, 0, 0, 0, 949195024, 0, 0, 0, 
        1898390048, 0, 0, 0, 3796780096, 0, 0, 0, 3298592897, 0, 0, 0, 2302218499, 0, 0, 0, 
        309469703, 0, 0, 0, 618939406, 0, 0, 0, 1237878812, 0, 0, 0, 2475757624, 0, 0, 0, 
        656547953, 0, 0, 0, 1313095907, 0, 0, 0, 2626191815, 0, 0, 0, 957416334, 0, 0, 0, 
        1914832669, 0, 0, 0, 3829665339, 0, 0, 0, 2298886291, 0, 0, 0, 302805287, 0, 0, 0, 
        605610574, 0, 0, 0, 1211221148, 0, 0, 0, 2422442297, 0, 0, 0, 549917298, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 348140706, 0, 0, 
        0, 696281412, 0, 0, 0, 1392562824, 0, 0, 0, 2785125649, 0, 0, 0, 1275284003, 0, 0, 
        0, 2550568007, 0, 0, 0, 806168719, 0, 0, 0, 1612337439, 0, 0, 0, 3224674878, 0, 0, 
        0, 2154382460, 0, 0, 0, 13797624, 0, 0, 0, 27595248, 0, 0, 0, 55190496, 0, 0, 
        0, 110380992, 0, 0, 0, 220761985, 0, 0, 0, 441523971, 0, 0, 0, 883047943, 0, 0, 
        0, 1766095886, 0, 0, 0, 3532191772, 0, 0, 0, 2769416249, 0, 0, 0, 1243865203, 0, 0, 
        0, 2487730406, 0, 0, 0, 680493516, 0, 0, 0, 1360987032, 0, 0, 0, 2721974065, 0, 0, 
        0, 1148980834, 0, 0, 0, 2297961669, 0, 0, 0, 87035176, 0, 0, 0, 174070353, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 470870896, 0, 0, 0, 941741792, 0, 0, 0, 1883483584, 0, 0, 0, 3766967168, 0, 
        0, 0, 3238967041, 0, 0, 0, 2182966786, 0, 0, 0, 70966277, 0, 0, 0, 141932555, 0, 
        0, 0, 283865111, 0, 0, 0, 567730223, 0, 0, 0, 1135460447, 0, 0, 0, 2270920895, 0, 
        0, 0, 246874494, 0, 0, 0, 493748989, 0, 0, 0, 987497979, 0, 0, 0, 1772675207, 0, 
        0, 0, 3545350414, 0, 0, 0, 2795733533, 0, 0, 0, 1296499770, 0, 0, 0, 2592999541, 0, 
        0, 0, 891031787, 0, 0, 0, 1782063574, 0, 0, 0, 3564127149, 0, 0, 0, 2833287003, 0, 
        0, 0, 1371606711, 0, 0, 0, 2743213422, 0, 0, 0, 1191459548, 0, 0, 0, 2382919096, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30521863, 
        0, 0, 0, 61043727, 0, 0, 0, 122087454, 0, 0, 0, 244174909, 0, 0, 0, 488349818, 
        0, 0, 0, 976699637, 0, 0, 0, 1953399275, 0, 0, 0, 3906798551, 0, 0, 0, 3518629806, 
        0, 0, 0, 2742292316, 0, 0, 0, 1189617336, 0, 0, 0, 2379234673, 0, 0, 0, 463502051, 
        0, 0, 0, 927004102, 0, 0, 0, 1854008205, 0, 0, 0, 3708016410, 0, 0, 0, 3121065525, 
        0, 0, 0, 1947163754, 0, 0, 0, 3894327508, 0, 0, 0, 3493687720, 0, 0, 0, 2692408145, 
        0, 0, 0, 1089848995, 0, 0, 0, 2151298880, 0, 0, 0, 7630465, 0, 0, 0, 15260931, 
    },
    {
        0, 0, 0, 0, 3400190380, 0, 0, 0, 2505413465, 0, 0, 0, 715859635, 0, 0, 0, 
        1431719270, 0, 0, 0, 2863438540, 0, 0, 0, 1431909784, 0, 0, 0, 2863819568, 0, 0, 0, 
        1432671840, 0, 0, 0, 2865343680, 0, 0, 0, 1435720064, 0, 0, 0, 2871440128, 0, 0, 0, 
        1447912961, 0, 0, 0, 2895825923, 0, 0, 0, 1496684550, 0, 0, 0, 2993369100, 0, 0, 0, 
        1691770904, 0, 0, 0, 3383541809, 0, 0, 0, 2472116322, 0, 0, 0, 649265349, 0, 0, 0, 
        1298530698, 0, 0, 0, 2597061396, 0, 0, 0, 899155496, 0, 0, 0, 1798310993, 0, 0, 0, 
        3596621986, 0, 0, 0, 2898276677, 0, 0, 0, 2469047078, 0, 0, 0, 643126861, 0, 0, 0, 
        1286253722, 0, 0, 0, 2572507445, 0, 0, 0, 850047595, 0, 0, 0, 1700095190, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2692483345, 0, 0, 
        0, 1089999394, 0, 0, 0, 2179998788, 0, 0, 0, 65030280, 0, 0, 0, 130060560, 0, 0, 
        0, 260121121, 0, 0, 0, 520242243, 0, 0, 0, 1040484486, 0, 0, 0, 2080968972, 0, 0, 
        0, 4161937944, 0, 0, 0, 4028908593, 0, 0, 0, 3762849891, 0, 0, 0, 3230732486, 0, 0, 
        0, 2166497676, 0, 0, 0, 38028056, 0, 0, 0, 76056112, 0, 0, 0, 152112225, 0, 0, 
        0, 304224450, 0, 0, 0, 608448901, 0, 0, 0, 1216897803, 0, 0, 0, 2433795606, 0, 0, 
        0, 572623917, 0, 0, 0, 1145247834, 0, 0, 0, 2290495669, 0, 0, 0, 286024042, 0, 0, 
        0, 572048085, 0, 0, 0, 1144096170, 0, 0, 0, 673120836, 0, 0, 0, 1346241672, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 27673132, 0, 0, 0, 55346265, 0, 0, 0, 110692530, 0, 0, 0, 221385060, 0, 
        0, 0, 442770121, 0, 0, 0, 885540243, 0, 0, 0, 1771080487, 0, 0, 0, 3542160975, 0, 
        0, 0, 2789354654, 0, 0, 0, 1283742012, 0, 0, 0, 2567484024, 0, 0, 0, 840000753, 0, 
        0, 0, 1680001507, 0, 0, 0, 3360003015, 0, 0, 0, 2425038735, 0, 0, 0, 548408626, 0, 
        0, 0, 1096817252, 0, 0, 0, 2193634504, 0, 0, 0, 92301712, 0, 0, 0, 184603425, 0, 
        0, 0, 369206850, 0, 0, 0, 738413700, 0, 0, 0, 1476827400, 0, 0, 0, 2953654801, 0, 
        0, 0, 1612342306, 0, 0, 0, 3224684613, 0, 0, 0, 2154401931, 0, 0, 0, 13836566, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33833481, 
        0, 0, 0, 67666962, 0, 0, 0, 135333924, 0, 0, 0, 270667848, 0, 0, 0, 541335697, 
        0, 0, 0, 1082671394, 0, 0, 0, 2165342788, 0, 0, 0, 35718281, 0, 0, 0, 71436563, 
        0, 0, 0, 142873126, 0, 0, 0, 285746252, 0, 0, 0, 571492505, 0, 0, 0, 1142985010, 
        0, 0, 0, 2285970021, 0, 0, 0, 276972746, 0, 0, 0, 553945492, 0, 0, 0, 1107890985, 
        0, 0, 0, 2215781970, 0, 0, 0, 136596644, 0, 0, 0, 273193289, 0, 0, 0, 546386578, 
        0, 0, 0, 1092773156, 0, 0, 0, 2151712833, 0, 0, 0, 8458370, 0, 0, 0, 16916740, 
    },
    {
        0, 0, 0, 0, 2928597988, 0, 0, 0, 1562228680, 0, 0, 0, 3124457360, 0, 0, 0, 
        1953947424, 0, 0, 0, 3907894849, 0, 0, 0, 3520822403, 0, 0, 0, 2746677510, 0, 0, 0, 
        1198387725, 0, 0, 0, 2396775450, 0, 0, 0, 498583604, 0, 0, 0, 997167209, 0, 0, 0, 
        1994334419, 0, 0, 0, 3988668839, 0, 0, 0, 3682370382, 0, 0, 0, 3069773468, 0, 0, 0, 
        1844579640, 0, 0, 0, 3689159280, 0, 0, 0, 3083351264, 0, 0, 0, 1871735233, 0, 0, 0, 
        3743470466, 0, 0, 0, 3191973636, 0, 0, 0, 2088979976, 0, 0, 0, 4177959953, 0, 0, 0, 
        4060952610, 0, 0, 0, 3826937925, 0, 0, 0, 1723480943, 0, 0, 0, 3446961887, 0, 0, 0, 
        2598956478, 0, 0, 0, 902945660, 0, 0, 0, 1805891321, 0, 0, 0, 3611782642, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1473249760, 0, 0, 
        0, 2946499520, 0, 0, 0, 1598031745, 0, 0, 0, 3196063490, 0, 0, 0, 2097159684, 0, 0, 
        0, 4194319368, 0, 0, 0, 4093671441, 0, 0, 0, 3892375586, 0, 0, 0, 3489783876, 0, 0, 
        0, 2684600457, 0, 0, 0, 1074233618, 0, 0, 0, 2148467236, 0, 0, 0, 1967176, 0, 0, 
        0, 3934352, 0, 0, 0, 7868704, 0, 0, 0, 15737408, 0, 0, 0, 31474816, 0, 0, 
        0, 62949632, 0, 0, 0, 125899264, 0, 0, 0, 251798529, 0, 0, 0, 503597059, 0, 0, 
        0, 1007194118, 0, 0, 0, 2014388236, 0, 0, 0, 4028776473, 0, 0, 0, 3762585651, 0, 0, 
        0, 3230204006, 0, 0, 0, 2165440716, 0, 0, 0, 1442054264, 0, 0, 0, 2884108528, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1749068055, 0, 0, 0, 3498136111, 0, 0, 0, 2701304927, 0, 0, 0, 1107642558, 0, 
        0, 0, 2215285117, 0, 0, 0, 135602938, 0, 0, 0, 271205877, 0, 0, 0, 542411755, 0, 
        0, 0, 1084823510, 0, 0, 0, 2169647020, 0, 0, 0, 44326744, 0, 0, 0, 88653489, 0, 
        0, 0, 177306978, 0, 0, 0, 354613956, 0, 0, 0, 709227913, 0, 0, 0, 1019953669, 0, 
        0, 0, 2039907338, 0, 0, 0, 4079814677, 0, 0, 0, 3864662058, 0, 0, 0, 3434356820, 0, 
        0, 0, 2573746345, 0, 0, 0, 852525394, 0, 0, 0, 1705050788, 0, 0, 0, 3410101576, 0, 
        0, 0, 2525235857, 0, 0, 0, 755504418, 0, 0, 0, 1511008837, 0, 0, 0, 3022017675, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67141650, 
        0, 0, 0, 134283300, 0, 0, 0, 268566600, 0, 0, 0, 537133200, 0, 0, 0, 1074266400, 
        0, 0, 0, 2148532800, 0, 0, 0, 2098304, 0, 0, 0, 4196609, 0, 0, 0, 8393218, 
        0, 0, 0, 16786436, 0, 0, 0, 33572873, 0, 0, 0, 67145746, 0, 0, 0, 134291492, 
        0, 0, 0, 268582984, 0, 0, 0, 537165968, 0, 0, 0, 1074331936, 0, 0, 0, 2148663872, 
        0, 0, 0, 2360448, 0, 0, 0, 4720897, 0, 0, 0, 9441794, 0, 0, 0, 18883588, 
        0, 0, 0, 37767176, 0, 0, 0, 8392706, 0, 0, 0, 16785412, 0, 0, 0, 33570825, 
    },
    {
        0, 0, 0, 0, 1874778401, 0, 0, 0, 3749556802, 0, 0, 0, 3204146308, 0, 0, 0, 
        2113325320, 0, 0, 0, 4226650640, 0, 0, 0, 4158333984, 0, 0, 0, 4021700672, 0, 0, 0, 
        3748434048, 0, 0, 0, 3201900800, 0, 0, 0, 2108834304, 0, 0, 0, 4217668608, 0, 0, 0, 
        4140369920, 0, 0, 0, 3985772545, 0, 0, 0, 3676577794, 0, 0, 0, 3058188292, 0, 0, 0, 
        1821409288, 0, 0, 0, 3642818577, 0, 0, 0, 2990669858, 0, 0, 0, 1686372420, 0, 0, 0, 
        3372744841, 0, 0, 0, 2450522386, 0, 0, 0, 606077476, 0, 0, 0, 1212154952, 0, 0, 0, 
        2424309905, 0, 0, 0, 553652514, 0, 0, 0, 767490916, 0, 0, 0, 1534981833, 0, 0, 0, 
        3069963666, 0, 0, 0, 1844960036, 0, 0, 0, 3689920072, 0, 0, 0, 3084872848, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1442838528, 0, 0, 
        0, 2885677056, 0, 0, 0, 1476386816, 0, 0, 0, 2952773632, 0, 0, 0, 1610579969, 0, 0, 
        0, 3221159938, 0, 0, 0, 2147352580, 0, 0, 0, 4294705160, 0, 0, 0, 4294443024, 0, 0, 
        0, 4293918752, 0, 0, 0, 4292870208, 0, 0, 0, 4290773120, 0, 0, 0, 4286578944, 0, 0, 
        0, 4278190592, 0, 0, 0, 4261413888, 0, 0, 0, 4227860480, 0, 0, 0, 4160753664, 0, 0, 
        0, 4026540033, 0, 0, 0, 3758112771, 0, 0, 0, 3221258246, 0, 0, 0, 2147549196, 0, 0, 
        0, 131096, 0, 0, 0, 262192, 0, 0, 0, 524384, 0, 0, 0, 1048768, 0, 0, 
        0, 2097536, 0, 0, 0, 4195072, 0, 0, 0, 1434451456, 0, 0, 0, 2868902912, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2164392972, 0, 0, 0, 33818648, 0, 0, 0, 67637296, 0, 0, 0, 135274592, 0, 
        0, 0, 270549185, 0, 0, 0, 541098371, 0, 0, 0, 1082196742, 0, 0, 0, 2164393484, 0, 
        0, 0, 33819672, 0, 0, 0, 67639344, 0, 0, 0, 135278688, 0, 0, 0, 270557377, 0, 
        0, 0, 541114755, 0, 0, 0, 1082229511, 0, 0, 0, 2164459022, 0, 0, 0, 2198079504, 0, 
        0, 0, 101191712, 0, 0, 0, 202383424, 0, 0, 0, 404766849, 0, 0, 0, 809533698, 0, 
        0, 0, 1619067396, 0, 0, 0, 3238134792, 0, 0, 0, 2181302288, 0, 0, 0, 67637280, 0, 
        0, 0, 135274560, 0, 0, 0, 270549121, 0, 0, 0, 541098243, 0, 0, 0, 1082196486, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2304, 
        0, 0, 0, 4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 0, 0, 0, 36864, 
        0, 0, 0, 73728, 0, 0, 0, 147456, 0, 0, 0, 294912, 0, 0, 0, 589824, 
        0, 0, 0, 1179648, 0, 0, 0, 2359296, 0, 0, 0, 4718593, 0, 0, 0, 9437186, 
        0, 0, 0, 18874372, 0, 0, 0, 37748744, 0, 0, 0, 75497488, 0, 0, 0, 150994976, 
        0, 0, 0, 301989953, 0, 0, 0, 603979906, 0, 0, 0, 1207959812, 0, 0, 0, 2415919624, 
        0, 0, 0, 536871952, 0, 0, 0, 1073742112, 0, 0, 0, 2147484224, 0, 0, 0, 1152, 
    },
    {
        0, 0, 0, 0, 882001920, 0, 0, 0, 1764003840, 0, 0, 0, 3528007680, 0, 0, 0, 
        2761048065, 0, 0, 0, 1227128834, 0, 0, 0, 2454257668, 0, 0, 0, 613548040, 0, 0, 0, 
        1227096080, 0, 0, 0, 2454192160, 0, 0, 0, 613417024, 0, 0, 0, 1226834048, 0, 0, 0, 
        2453668096, 0, 0, 0, 612368896, 0, 0, 0, 1224737792, 0, 0, 0, 2449475584, 0, 0, 0, 
        603983872, 0, 0, 0, 1207967744, 0, 0, 0, 2415935489, 0, 0, 0, 536903682, 0, 0, 0, 
        1073807364, 0, 0, 0, 2147614729, 0, 0, 0, 262162, 0, 0, 0, 524324, 0, 0, 0, 
        1048648, 0, 0, 0, 2097296, 0, 0, 0, 886196512, 0, 0, 0, 1772393024, 0, 0, 0, 
        3544786048, 0, 0, 0, 2794604800, 0, 0, 0, 1294242304, 0, 0, 0, 2588484608, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 
        0, 32, 0, 0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 
        0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 
        0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 
        0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 
        0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 
        0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 
        0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483652, 0, 0, 0, 8, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 
        0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 0, 0, 262152, 0, 
        0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 
        0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67108864, 0, 
        0, 0, 134217728, 0, 0, 0, 268435457, 0, 0, 0, 536870914, 0, 0, 0, 1073741828, 0, 
        0, 0, 2147483656, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 64, 0, 
        0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8390658, 
        0, 0, 0, 16781316, 0, 0, 0, 33562633, 0, 0, 0, 67125266, 0, 0, 0, 134250532, 
        0, 0, 0, 268501064, 0, 0, 0, 537002128, 0, 0, 0, 1074004256, 0, 0, 0, 2148008512, 
        0, 0, 0, 1049728, 0, 0, 0, 2099456, 0, 0, 0, 4198913, 0, 0, 0, 8397826, 
        0, 0, 0, 16795652, 0, 0, 0, 33591305, 0, 0, 0, 67182610, 0, 0, 0, 134365220, 
        0, 0, 0, 268730440, 0, 0, 0, 537460880, 0, 0, 0, 1074921760, 0, 0, 0, 2149843520, 
        0, 0, 0, 4719745, 0, 0, 0, 1048832, 0, 0, 0, 2097664, 0, 0, 0, 4195329, 
    },
    {
        0, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 
        8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 0, 
        131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 
        2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 
        33554433, 0, 0, 0, 67108866, 0, 0, 0, 134217732, 0, 0, 0, 268435464, 0, 0, 0, 
        536870928, 0, 0, 0, 1073741856, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 
        260, 0, 0, 0, 520, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 
        64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 
        0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 32, 0, 0, 0, 64, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 131092, 0, 0, 0, 262184, 0, 0, 0, 524368, 0, 0, 0, 1048736, 0, 
        0, 0, 2097472, 0, 0, 0, 4194944, 0, 0, 0, 8389888, 0, 0, 0, 16779776, 0, 
        0, 0, 33559552, 0, 0, 0, 67119104, 0, 0, 0, 134238208, 0, 0, 0, 268476416, 0, 
        0, 0, 536952832, 0, 0, 0, 1073905665, 0, 0, 0, 2147811330, 0, 0, 0, 524304, 0, 
        0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 0, 0, 8388864, 0, 
        0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67110912, 0, 0, 0, 134221824, 0, 
        0, 0, 268443649, 0, 0, 0, 536887298, 0, 0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144703526, 
        0, 0, 0, 289407053, 0, 0, 0, 578814107, 0, 0, 0, 1157628214, 0, 0, 0, 2315256429, 
        0, 0, 0, 335545562, 0, 0, 0, 671091124, 0, 0, 0, 1342182248, 0, 0, 0, 2684364496, 
        0, 0, 0, 1073761696, 0, 0, 0, 2147523392, 0, 0, 0, 79488, 0, 0, 0, 158976, 
        0, 0, 0, 317952, 0, 0, 0, 635904, 0, 0, 0, 1271808, 0, 0, 0, 2543616, 
        0, 0, 0, 5087233, 0, 0, 0, 10174466, 0, 0, 0, 20348932, 0, 0, 0, 40697864, 
        0, 0, 0, 81395729, 0, 0, 0, 18087940, 0, 0, 0, 36175881, 0, 0, 0, 72351763, 
    },
    {
        0, 0, 0, 0, 4160, 0, 0, 0, 8320, 0, 0, 0, 16640, 0, 0, 0, 
        33280, 0, 0, 0, 66560, 0, 0, 0, 133120, 0, 0, 0, 266240, 0, 0, 0, 
        532480, 0, 0, 0, 1064960, 0, 0, 0, 2129920, 0, 0, 0, 4259840, 0, 0, 0, 
        8519680, 0, 0, 0, 17039360, 0, 0, 0, 34078721, 0, 0, 0, 68157442, 0, 0, 0, 
        136314884, 0, 0, 0, 272629768, 0, 0, 0, 545259536, 0, 0, 0, 1090519072, 0, 0, 0, 
        2181038144, 0, 0, 0, 67108992, 0, 0, 0, 134217984, 0, 0, 0, 268435968, 0, 0, 0, 
        536871936, 0, 0, 0, 1073743872, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 
        260, 0, 0, 0, 520, 0, 0, 0, 1040, 0, 0, 0, 2080, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 2560, 0, 0, 0, 5120, 0, 0, 
        0, 10240, 0, 0, 0, 20480, 0, 0, 0, 40960, 0, 0, 0, 81920, 0, 0, 
        0, 163840, 0, 0, 0, 327680, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 335546385, 0, 0, 0, 671092770, 0, 0, 0, 1342185541, 0, 0, 0, 2684371082, 0, 
        0, 0, 1073774869, 0, 0, 0, 2147549738, 0, 0, 0, 132180, 0, 0, 0, 264360, 0, 
        0, 0, 528720, 0, 0, 0, 1057440, 0, 0, 0, 2114880, 0, 0, 0, 4229761, 0, 
        0, 0, 8459522, 0, 0, 0, 16919044, 0, 0, 0, 33838088, 0, 0, 0, 269000704, 0, 
        0, 0, 538001408, 0, 0, 0, 1076002817, 0, 0, 0, 2152005634, 0, 0, 0, 9043972, 0, 
        0, 0, 18087944, 0, 0, 0, 36175888, 0, 0, 0, 72351776, 0, 0, 0, 144703552, 0, 
        0, 0, 289407105, 0, 0, 0, 578814210, 0, 0, 0, 1157628420, 0, 0, 0, 2315256840, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135049252, 
        0, 0, 0, 270098504, 0, 0, 0, 540197008, 0, 0, 0, 1080394017, 0, 0, 0, 2160788035, 
        0, 0, 0, 26608774, 0, 0, 0, 53217549, 0, 0, 0, 106435098, 0, 0, 0, 212870196, 
        0, 0, 0, 425740393, 0, 0, 0, 851480786, 0, 0, 0, 1702961572, 0, 0, 0, 3405923145, 
        0, 0, 0, 2516878995, 0, 0, 0, 738790694, 0, 0, 0, 1477581388, 0, 0, 0, 2955162776, 
        0, 0, 0, 1615358257, 0, 0, 0, 3230716514, 0, 0, 0, 2166465732, 0, 0, 0, 37964168, 
        0, 0, 0, 75928336, 0, 0, 0, 16881156, 0, 0, 0, 33762313, 0, 0, 0, 67524626, 
    },
    {
        0, 0, 0, 0, 3162112, 0, 0, 0, 6324224, 0, 0, 0, 12648448, 0, 0, 0, 
        25296896, 0, 0, 0, 50593793, 0, 0, 0, 101187587, 0, 0, 0, 202375174, 0, 0, 0, 
        404750348, 0, 0, 0, 809500696, 0, 0, 0, 1619001392, 0, 0, 0, 3238002785, 0, 0, 0, 
        2181038274, 0, 0, 0, 67109252, 0, 0, 0, 134218504, 0, 0, 0, 268437008, 0, 0, 0, 
        536874016, 0, 0, 0, 1073748032, 0, 0, 0, 2147496065, 0, 0, 0, 24834, 0, 0, 0, 
        49668, 0, 0, 0, 99336, 0, 0, 0, 198672, 0, 0, 0, 397344, 0, 0, 0, 
        794688, 0, 0, 0, 1589376, 0, 0, 0, 49408, 0, 0, 0, 98816, 0, 0, 0, 
        197632, 0, 0, 0, 395264, 0, 0, 0, 790528, 0, 0, 0, 1581056, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8704, 0, 0, 
        0, 17408, 0, 0, 0, 34816, 0, 0, 0, 69632, 0, 0, 0, 139264, 0, 0, 
        0, 278528, 0, 0, 0, 557056, 0, 0, 0, 1114112, 0, 0, 0, 2228224, 0, 0, 
        0, 4456448, 0, 0, 0, 8912896, 0, 0, 0, 17825792, 0, 0, 0, 35651584, 0, 0, 
        0, 71303168, 0, 0, 0, 142606337, 0, 0, 0, 285212674, 0, 0, 0, 570425349, 0, 0, 
        0, 1140850698, 0, 0, 0, 2281701397, 0, 0, 0, 268435498, 0, 0, 0, 536870997, 0, 0, 
        0, 1073741994, 0, 0, 0, 2147483988, 0, 0, 0, 680, 0, 0, 0, 1360, 0, 0, 
        0, 2720, 0, 0, 0, 5440, 0, 0, 0, 2176, 0, 0, 0, 4352, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 539164932, 0, 0, 0, 1078329864, 0, 0, 0, 2156659728, 0, 0, 0, 18352160, 0, 
        0, 0, 36704320, 0, 0, 0, 73408640, 0, 0, 0, 146817280, 0, 0, 0, 293634560, 0, 
        0, 0, 587269120, 0, 0, 0, 1174538240, 0, 0, 0, 2349076480, 0, 0, 0, 403185665, 0, 
        0, 0, 806371331, 0, 0, 0, 1612742663, 0, 0, 0, 3225485326, 0, 0, 0, 2694906136, 0, 
        0, 0, 1094844976, 0, 0, 0, 2189689952, 0, 0, 0, 84412608, 0, 0, 0, 168825216, 0, 
        0, 0, 337650433, 0, 0, 0, 675300866, 0, 0, 0, 1350601732, 0, 0, 0, 2701203464, 0, 
        0, 0, 1107439632, 0, 0, 0, 2214879264, 0, 0, 0, 134791233, 0, 0, 0, 269582466, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3961969350, 
        0, 0, 0, 3628971405, 0, 0, 0, 2962975514, 0, 0, 0, 1630983732, 0, 0, 0, 3261967464, 
        0, 0, 0, 2228967633, 0, 0, 0, 162967970, 0, 0, 0, 325935940, 0, 0, 0, 651871880, 
        0, 0, 0, 1303743760, 0, 0, 0, 2607487520, 0, 0, 0, 920007744, 0, 0, 0, 1840015488, 
        0, 0, 0, 3680030976, 0, 0, 0, 3065094657, 0, 0, 0, 1835222019, 0, 0, 0, 3670444038, 
        0, 0, 0, 3045920780, 0, 0, 0, 1796874265, 0, 0, 0, 3593748531, 0, 0, 0, 2892529767, 
        0, 0, 0, 1490092239, 0, 0, 0, 1568987992, 0, 0, 0, 3137975985, 0, 0, 0, 1980984675, 
    },
    {
        0, 0, 0, 0, 2554888269, 0, 0, 0, 814809242, 0, 0, 0, 1629618484, 0, 0, 0, 
        3259236968, 0, 0, 0, 2223506641, 0, 0, 0, 152045986, 0, 0, 0, 304091973, 0, 0, 0, 
        608183946, 0, 0, 0, 1216367892, 0, 0, 0, 2432735785, 0, 0, 0, 570504275, 0, 0, 0, 
        1141008550, 0, 0, 0, 2282017101, 0, 0, 0, 269066906, 0, 0, 0, 538133812, 0, 0, 0, 
        1076267624, 0, 0, 0, 2152535249, 0, 0, 0, 10103202, 0, 0, 0, 20206404, 0, 0, 0, 
        40412809, 0, 0, 0, 80825618, 0, 0, 0, 161651236, 0, 0, 0, 323302473, 0, 0, 0, 
        646604947, 0, 0, 0, 1293209894, 0, 0, 0, 39920129, 0, 0, 0, 79840258, 0, 0, 0, 
        159680516, 0, 0, 0, 319361033, 0, 0, 0, 638722067, 0, 0, 0, 1277444134, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134299649, 0, 0, 
        0, 268599298, 0, 0, 0, 537198597, 0, 0, 0, 1074397194, 0, 0, 0, 2148794388, 0, 0, 
        0, 2621480, 0, 0, 0, 5242960, 0, 0, 0, 10485920, 0, 0, 0, 20971840, 0, 0, 
        0, 41943680, 0, 0, 0, 83887360, 0, 0, 0, 167774721, 0, 0, 0, 335549442, 0, 0, 
        0, 671098884, 0, 0, 0, 1342197768, 0, 0, 0, 2684395537, 0, 0, 0, 1073823778, 0, 0, 
        0, 2147647556, 0, 0, 0, 327816, 0, 0, 0, 655632, 0, 0, 0, 1311264, 0, 0, 
        0, 2622528, 0, 0, 0, 5245056, 0, 0, 0, 10490112, 0, 0, 0, 20980224, 0, 0, 
        0, 41960448, 0, 0, 0, 83920896, 0, 0, 0, 33574912, 0, 0, 0, 67149824, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 490817699, 0, 0, 0, 981635398, 0, 0, 0, 1963270797, 0, 0, 0, 3926541594, 0, 
        0, 0, 3558115892, 0, 0, 0, 2821264488, 0, 0, 0, 1347561681, 0, 0, 0, 2695123362, 0, 
        0, 0, 1095279429, 0, 0, 0, 2190558858, 0, 0, 0, 86150421, 0, 0, 0, 172300842, 0, 
        0, 0, 344601685, 0, 0, 0, 689203370, 0, 0, 0, 1378406740, 0, 0, 0, 3104893450, 0, 
        0, 0, 1914819604, 0, 0, 0, 3829639209, 0, 0, 0, 3364311122, 0, 0, 0, 2433654948, 0, 
        0, 0, 572342600, 0, 0, 0, 1144685201, 0, 0, 0, 2289370402, 0, 0, 0, 283773509, 0, 
        0, 0, 567547018, 0, 0, 0, 1135094036, 0, 0, 0, 2270188072, 0, 0, 0, 245408849, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3548126500, 
        0, 0, 0, 2801285704, 0, 0, 0, 1307604113, 0, 0, 0, 2615208226, 0, 0, 0, 935449156, 
        0, 0, 0, 1870898313, 0, 0, 0, 3741796627, 0, 0, 0, 3188625959, 0, 0, 0, 2082284622, 
        0, 0, 0, 4164569244, 0, 0, 0, 4034171193, 0, 0, 0, 3773375091, 0, 0, 0, 3251782887, 
        0, 0, 0, 2208598479, 0, 0, 0, 122229662, 0, 0, 0, 244459325, 0, 0, 0, 488918650, 
        0, 0, 0, 977837300, 0, 0, 0, 1955674600, 0, 0, 0, 3911349200, 0, 0, 0, 3527731104, 
        0, 0, 0, 2760494912, 0, 0, 0, 2590999460, 0, 0, 0, 887031625, 0, 0, 0, 1774063250, 
    },
    {
        0, 0, 0, 0, 1164254896, 0, 0, 0, 2328509792, 0, 0, 0, 362052288, 0, 0, 0, 
        724104577, 0, 0, 0, 1448209155, 0, 0, 0, 2896418311, 0, 0, 0, 1497869326, 0, 0, 0, 
        2995738652, 0, 0, 0, 1696510008, 0, 0, 0, 3393020016, 0, 0, 0, 2491072737, 0, 0, 0, 
        687178178, 0, 0, 0, 1374356356, 0, 0, 0, 2748712712, 0, 0, 0, 1202458129, 0, 0, 0, 
        2404916258, 0, 0, 0, 514865221, 0, 0, 0, 1029730442, 0, 0, 0, 2059460885, 0, 0, 0, 
        4118921771, 0, 0, 0, 3942876246, 0, 0, 0, 3590785196, 0, 0, 0, 2886603097, 0, 0, 0, 
        1478238898, 0, 0, 0, 2956477797, 0, 0, 0, 622171258, 0, 0, 0, 1244342517, 0, 0, 0, 
        2488685035, 0, 0, 0, 682402774, 0, 0, 0, 1364805548, 0, 0, 0, 2729611096, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 336678914, 0, 0, 
        0, 673357828, 0, 0, 0, 1346715656, 0, 0, 0, 2693431313, 0, 0, 0, 1091895330, 0, 0, 
        0, 2183790660, 0, 0, 0, 72614024, 0, 0, 0, 145228049, 0, 0, 0, 290456098, 0, 0, 
        0, 580912197, 0, 0, 0, 1161824394, 0, 0, 0, 2323648789, 0, 0, 0, 352330282, 0, 0, 
        0, 704660564, 0, 0, 0, 1409321128, 0, 0, 0, 2818642256, 0, 0, 0, 1342317216, 0, 0, 
        0, 2684634433, 0, 0, 0, 1074301570, 0, 0, 0, 2148603140, 0, 0, 0, 2238984, 0, 0, 
        0, 4477968, 0, 0, 0, 8955936, 0, 0, 0, 17911872, 0, 0, 0, 35823744, 0, 0, 
        0, 71647488, 0, 0, 0, 143294977, 0, 0, 0, 84169728, 0, 0, 0, 168339457, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2541187255, 0, 0, 0, 787407215, 0, 0, 0, 1574814430, 0, 0, 0, 3149628860, 0, 
        0, 0, 2004290425, 0, 0, 0, 4008580850, 0, 0, 0, 3722194405, 0, 0, 0, 3149421515, 0, 
        0, 0, 2003875734, 0, 0, 0, 4007751468, 0, 0, 0, 3720535640, 0, 0, 0, 3146103984, 0, 
        0, 0, 1997240673, 0, 0, 0, 3994481347, 0, 0, 0, 3693995398, 0, 0, 0, 791460795, 0, 
        0, 0, 1582921591, 0, 0, 0, 3165843182, 0, 0, 0, 2036719068, 0, 0, 0, 4073438136, 0, 
        0, 0, 3851908976, 0, 0, 0, 3408850657, 0, 0, 0, 2522734018, 0, 0, 0, 750500741, 0, 
        0, 0, 1501001483, 0, 0, 0, 3002002966, 0, 0, 0, 1709038637, 0, 0, 0, 3418077275, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 357270623, 
        0, 0, 0, 714541247, 0, 0, 0, 1429082494, 0, 0, 0, 2858164988, 0, 0, 0, 1421362680, 
        0, 0, 0, 2842725361, 0, 0, 0, 1390483426, 0, 0, 0, 2780966853, 0, 0, 0, 1266966411, 
        0, 0, 0, 2533932823, 0, 0, 0, 772898351, 0, 0, 0, 1545796702, 0, 0, 0, 3091593405, 
        0, 0, 0, 1888219514, 0, 0, 0, 3776439028, 0, 0, 0, 3257910761, 0, 0, 0, 2220854227, 
        0, 0, 0, 146741158, 0, 0, 0, 293482317, 0, 0, 0, 586964634, 0, 0, 0, 1173929269, 
        0, 0, 0, 2347858538, 0, 0, 0, 44658827, 0, 0, 0, 89317655, 0, 0, 0, 178635311, 
    },
    {
        0, 0, 0, 0, 126298325, 0, 0, 0, 252596651, 0, 0, 0, 505193303, 0, 0, 0, 
        1010386606, 0, 0, 0, 2020773212, 0, 0, 0, 4041546425, 0, 0, 0, 3788125555, 0, 0, 0, 
        3281283814, 0, 0, 0, 2267600332, 0, 0, 0, 240233369, 0, 0, 0, 480466738, 0, 0, 0, 
        960933476, 0, 0, 0, 1921866953, 0, 0, 0, 3843733907, 0, 0, 0, 3392500518, 0, 0, 0, 
        2490033741, 0, 0, 0, 685100186, 0, 0, 0, 1370200372, 0, 0, 0, 2740400744, 0, 0, 0, 
        1185834193, 0, 0, 0, 2371668387, 0, 0, 0, 448369479, 0, 0, 0, 896738958, 0, 0, 0, 
        1793477917, 0, 0, 0, 3586955835, 0, 0, 0, 2887654563, 0, 0, 0, 1480341830, 0, 0, 0, 
        2960683661, 0, 0, 0, 1626400026, 0, 0, 0, 3252800053, 0, 0, 0, 2210632810, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 339960066, 0, 0, 
        0, 679920132, 0, 0, 0, 1359840264, 0, 0, 0, 2719680529, 0, 0, 0, 1144393762, 0, 0, 
        0, 2288787525, 0, 0, 0, 282607754, 0, 0, 0, 565215509, 0, 0, 0, 1130431018, 0, 0, 
        0, 2260862036, 0, 0, 0, 226756777, 0, 0, 0, 453513555, 0, 0, 0, 907027111, 0, 0, 
        0, 1814054222, 0, 0, 0, 3628108445, 0, 0, 0, 2961249595, 0, 0, 0, 1627531895, 0, 0, 
        0, 3255063790, 0, 0, 0, 2215160284, 0, 0, 0, 135353273, 0, 0, 0, 270706546, 0, 0, 
        0, 541413093, 0, 0, 0, 1082826186, 0, 0, 0, 2165652372, 0, 0, 0, 36337448, 0, 0, 
        0, 72674896, 0, 0, 0, 145349793, 0, 0, 0, 84990016, 0, 0, 0, 169980033, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2614536692, 0, 0, 0, 934106089, 0, 0, 0, 1868212179, 0, 0, 0, 3736424359, 0, 
        0, 0, 3177881422, 0, 0, 0, 2060795549, 0, 0, 0, 4121591099, 0, 0, 0, 3948214903, 0, 
        0, 0, 3601462510, 0, 0, 0, 2907957725, 0, 0, 0, 1520948154, 0, 0, 0, 3041896308, 0, 
        0, 0, 1788825320, 0, 0, 0, 3577650640, 0, 0, 0, 2860333984, 0, 0, 0, 3475824309, 0, 
        0, 0, 2656681322, 0, 0, 0, 1018395349, 0, 0, 0, 2036790698, 0, 0, 0, 4073581396, 0, 
        0, 0, 3852195497, 0, 0, 0, 3409423699, 0, 0, 0, 2523880103, 0, 0, 0, 752792911, 0, 
        0, 0, 1505585823, 0, 0, 0, 3011171646, 0, 0, 0, 1727375997, 0, 0, 0, 3454751994, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3265725291, 
        0, 0, 0, 2236483287, 0, 0, 0, 177999279, 0, 0, 0, 355998558, 0, 0, 0, 711997116, 
        0, 0, 0, 1423994233, 0, 0, 0, 2847988467, 0, 0, 0, 1401009639, 0, 0, 0, 2802019279, 
        0, 0, 0, 1309071263, 0, 0, 0, 2618142526, 0, 0, 0, 941317756, 0, 0, 0, 1882635512, 
        0, 0, 0, 3765271025, 0, 0, 0, 3235574755, 0, 0, 0, 2176182214, 0, 0, 0, 57397132, 
        0, 0, 0, 114794264, 0, 0, 0, 229588528, 0, 0, 0, 459177056, 0, 0, 0, 918354113, 
        0, 0, 0, 1836708227, 0, 0, 0, 408215661, 0, 0, 0, 816431322, 0, 0, 0, 1632862645, 
    },
    {
        0, 0, 0, 0, 3480795388, 0, 0, 0, 2666623480, 0, 0, 0, 1038279664, 0, 0, 0, 
        2076559329, 0, 0, 0, 4153118658, 0, 0, 0, 4011270020, 0, 0, 0, 3727572744, 0, 0, 0, 
        3160178193, 0, 0, 0, 2025389090, 0, 0, 0, 4050778181, 0, 0, 0, 3806589066, 0, 0, 0, 
        3318210837, 0, 0, 0, 2341454378, 0, 0, 0, 387941461, 0, 0, 0, 775882923, 0, 0, 0, 
        1551765846, 0, 0, 0, 3103531693, 0, 0, 0, 1912096090, 0, 0, 0, 3824192180, 0, 0, 0, 
        3353417064, 0, 0, 0, 2411866832, 0, 0, 0, 528766369, 0, 0, 0, 1057532739, 0, 0, 0, 
        2115065479, 0, 0, 0, 4230130959, 0, 0, 0, 926802659, 0, 0, 0, 1853605319, 0, 0, 0, 
        3707210639, 0, 0, 0, 3119453983, 0, 0, 0, 1943940671, 0, 0, 0, 3887881342, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1457526048, 0, 0, 
        0, 2915052096, 0, 0, 0, 1535136897, 0, 0, 0, 3070273795, 0, 0, 0, 1845580294, 0, 0, 
        0, 3691160589, 0, 0, 0, 3087353882, 0, 0, 0, 1879740469, 0, 0, 0, 3759480939, 0, 0, 
        0, 3223994582, 0, 0, 0, 2153021868, 0, 0, 0, 11076440, 0, 0, 0, 22152880, 0, 0, 
        0, 44305760, 0, 0, 0, 88611520, 0, 0, 0, 177223041, 0, 0, 0, 354446082, 0, 0, 
        0, 708892164, 0, 0, 0, 1417784328, 0, 0, 0, 2835568656, 0, 0, 0, 1376170016, 0, 0, 
        0, 2752340033, 0, 0, 0, 1209712771, 0, 0, 0, 2419425542, 0, 0, 0, 543883789, 0, 0, 
        0, 1087767578, 0, 0, 0, 2175535156, 0, 0, 0, 1438123336, 0, 0, 0, 2876246672, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2983242506, 0, 0, 0, 1671517716, 0, 0, 0, 3343035433, 0, 0, 0, 2391103570, 0, 
        0, 0, 487239844, 0, 0, 0, 974479689, 0, 0, 0, 1948959378, 0, 0, 0, 3897918757, 0, 
        0, 0, 3500870219, 0, 0, 0, 2706773142, 0, 0, 0, 1118578988, 0, 0, 0, 2237157976, 0, 
        0, 0, 179348657, 0, 0, 0, 358697315, 0, 0, 0, 717394631, 0, 0, 0, 3830812293, 0, 
        0, 0, 3366657290, 0, 0, 0, 2438347285, 0, 0, 0, 581727274, 0, 0, 0, 1163454549, 0, 
        0, 0, 2326909099, 0, 0, 0, 358850902, 0, 0, 0, 717701804, 0, 0, 0, 1435403608, 0, 
        0, 0, 2870807216, 0, 0, 0, 1446647137, 0, 0, 0, 2893294274, 0, 0, 0, 1491621253, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3612118070, 
        0, 0, 0, 2929268845, 0, 0, 0, 1563570394, 0, 0, 0, 3127140788, 0, 0, 0, 1959314281, 
        0, 0, 0, 3918628562, 0, 0, 0, 3542289829, 0, 0, 0, 2789612362, 0, 0, 0, 1284257428, 
        0, 0, 0, 2568514856, 0, 0, 0, 842062417, 0, 0, 0, 1684124835, 0, 0, 0, 3368249671, 
        0, 0, 0, 2441532046, 0, 0, 0, 588096797, 0, 0, 0, 1176193595, 0, 0, 0, 2352387190, 
        0, 0, 0, 409807085, 0, 0, 0, 819614171, 0, 0, 0, 1639228342, 0, 0, 0, 3278456684, 
        0, 0, 0, 2261946072, 0, 0, 0, 3672740230, 0, 0, 0, 3050513165, 0, 0, 0, 1806059035, 
    },
    {
        0, 0, 0, 0, 460238757, 0, 0, 0, 920477515, 0, 0, 0, 1840955030, 0, 0, 0, 
        3681910060, 0, 0, 0, 3068852824, 0, 0, 0, 1842738352, 0, 0, 0, 3685476704, 0, 0, 0, 
        3075986112, 0, 0, 0, 1857004929, 0, 0, 0, 3714009859, 0, 0, 0, 3133052422, 0, 0, 0, 
        1971137548, 0, 0, 0, 3942275096, 0, 0, 0, 3589582897, 0, 0, 0, 2884198498, 0, 0, 0, 
        1473429701, 0, 0, 0, 2946859402, 0, 0, 0, 1598751509, 0, 0, 0, 3197503018, 0, 0, 0, 
        2100038740, 0, 0, 0, 4200077480, 0, 0, 0, 4105187665, 0, 0, 0, 3915408035, 0, 0, 0, 
        3535848774, 0, 0, 0, 2776730253, 0, 0, 0, 1349368510, 0, 0, 0, 2698737021, 0, 0, 0, 
        1102506746, 0, 0, 0, 2205013492, 0, 0, 0, 115059689, 0, 0, 0, 230119378, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4124527681, 0, 0, 
        0, 3954088066, 0, 0, 0, 3613208836, 0, 0, 0, 2931450376, 0, 0, 0, 1567933457, 0, 0, 
        0, 3135866914, 0, 0, 0, 1976766533, 0, 0, 0, 3953533066, 0, 0, 0, 3612098836, 0, 0, 
        0, 2929230376, 0, 0, 0, 1563493457, 0, 0, 0, 3126986914, 0, 0, 0, 1959006533, 0, 0, 
        0, 3918013066, 0, 0, 0, 3541058836, 0, 0, 0, 2787150377, 0, 0, 0, 1279333459, 0, 0, 
        0, 2558666919, 0, 0, 0, 822366543, 0, 0, 0, 1644733087, 0, 0, 0, 3289466174, 0, 0, 
        0, 2283965053, 0, 0, 0, 272962810, 0, 0, 0, 545925621, 0, 0, 0, 1091851242, 0, 0, 
        0, 2183702484, 0, 0, 0, 72437672, 0, 0, 0, 4252357392, 0, 0, 0, 4209747488, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2797805596, 0, 0, 0, 1300643896, 0, 0, 0, 2601287792, 0, 0, 0, 907608289, 0, 
        0, 0, 1815216578, 0, 0, 0, 3630433157, 0, 0, 0, 2965899019, 0, 0, 0, 1636830742, 0, 
        0, 0, 3273661484, 0, 0, 0, 2252355672, 0, 0, 0, 209744048, 0, 0, 0, 419488096, 0, 
        0, 0, 838976192, 0, 0, 0, 1677952385, 0, 0, 0, 3355904770, 0, 0, 0, 919418393, 0, 
        0, 0, 1838836786, 0, 0, 0, 3677673572, 0, 0, 0, 3060379848, 0, 0, 0, 1825792400, 0, 
        0, 0, 3651584800, 0, 0, 0, 3008202304, 0, 0, 0, 1721437312, 0, 0, 0, 3442874624, 0, 
        0, 0, 2590781953, 0, 0, 0, 886596611, 0, 0, 0, 1773193223, 0, 0, 0, 3546386446, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 490940283, 
        0, 0, 0, 981880567, 0, 0, 0, 1963761134, 0, 0, 0, 3927522269, 0, 0, 0, 3560077242, 
        0, 0, 0, 2825187189, 0, 0, 0, 1355407083, 0, 0, 0, 2710814166, 0, 0, 0, 1126661037, 
        0, 0, 0, 2253322074, 0, 0, 0, 211676852, 0, 0, 0, 423353704, 0, 0, 0, 846707408, 
        0, 0, 0, 1693414817, 0, 0, 0, 3386829635, 0, 0, 0, 2478691975, 0, 0, 0, 662416654, 
        0, 0, 0, 1324833308, 0, 0, 0, 2649666617, 0, 0, 0, 1004365938, 0, 0, 0, 2008731877, 
        0, 0, 0, 4017463754, 0, 0, 0, 3282593007, 0, 0, 0, 2270218718, 0, 0, 0, 245470141, 
    },
    {
        0, 0, 0, 0, 1980210557, 0, 0, 0, 3960421115, 0, 0, 0, 3625874935, 0, 0, 0, 
        2956782575, 0, 0, 0, 1618597854, 0, 0, 0, 3237195709, 0, 0, 0, 2179424123, 0, 0, 0, 
        63880951, 0, 0, 0, 127761903, 0, 0, 0, 255523807, 0, 0, 0, 511047615, 0, 0, 0, 
        1022095230, 0, 0, 0, 2044190460, 0, 0, 0, 4088380920, 0, 0, 0, 3881794544, 0, 0, 0, 
        3468621792, 0, 0, 0, 2642276289, 0, 0, 0, 989585283, 0, 0, 0, 1979170566, 0, 0, 0, 
        3958341132, 0, 0, 0, 3621714968, 0, 0, 0, 2948462640, 0, 0, 0, 1601957985, 0, 0, 0, 
        3203915970, 0, 0, 0, 2112864644, 0, 0, 0, 2379751029, 0, 0, 0, 464534763, 0, 0, 0, 
        929069527, 0, 0, 0, 1858139055, 0, 0, 0, 3716278111, 0, 0, 0, 3137588926, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3560175108, 0, 0, 
        0, 2825382920, 0, 0, 0, 1355798544, 0, 0, 0, 2711597089, 0, 0, 0, 1128226882, 0, 0, 
        0, 2256453764, 0, 0, 0, 217940233, 0, 0, 0, 435880467, 0, 0, 0, 871760935, 0, 0, 
        0, 1743521871, 0, 0, 0, 3487043743, 0, 0, 0, 2679120191, 0, 0, 0, 1063273086, 0, 0, 
        0, 2126546172, 0, 0, 0, 4253092344, 0, 0, 0, 4211217392, 0, 0, 0, 4127467489, 0, 0, 
        0, 3959967682, 0, 0, 0, 3624968069, 0, 0, 0, 2954968843, 0, 0, 0, 1614970391, 0, 0, 
        0, 3229940782, 0, 0, 0, 2164914268, 0, 0, 0, 34861240, 0, 0, 0, 69722480, 0, 0, 
        0, 139444961, 0, 0, 0, 278889922, 0, 0, 0, 4111269249, 0, 0, 0, 3927571202, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 3324387232, 0, 0, 0, 2353807168, 0, 0, 0, 412647041, 0, 0, 0, 825294082, 0, 
        0, 0, 1650588165, 0, 0, 0, 3301176331, 0, 0, 0, 2307385367, 0, 0, 0, 319803438, 0, 
        0, 0, 639606877, 0, 0, 0, 1279213754, 0, 0, 0, 2558427508, 0, 0, 0, 821887721, 0, 
        0, 0, 1643775442, 0, 0, 0, 3287550884, 0, 0, 0, 2280134472, 0, 0, 0, 3388354864, 0, 
        0, 0, 2481742433, 0, 0, 0, 668517571, 0, 0, 0, 1337035143, 0, 0, 0, 2674070287, 0, 
        0, 0, 1053173279, 0, 0, 0, 2106346559, 0, 0, 0, 4212693118, 0, 0, 0, 4130418941, 0, 
        0, 0, 3965870586, 0, 0, 0, 3636773876, 0, 0, 0, 2978580456, 0, 0, 0, 1662193616, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42029323, 
        0, 0, 0, 84058646, 0, 0, 0, 168117293, 0, 0, 0, 336234586, 0, 0, 0, 672469172, 
        0, 0, 0, 1344938344, 0, 0, 0, 2689876689, 0, 0, 0, 1084786082, 0, 0, 0, 2169572165, 
        0, 0, 0, 44177035, 0, 0, 0, 88354071, 0, 0, 0, 176708143, 0, 0, 0, 353416286, 
        0, 0, 0, 706832573, 0, 0, 0, 1413665147, 0, 0, 0, 2827330294, 0, 0, 0, 1359693292, 
        0, 0, 0, 2719386585, 0, 0, 0, 1143805874, 0, 0, 0, 2287611749, 0, 0, 0, 280256202, 
        0, 0, 0, 560512405, 0, 0, 0, 1078995489, 0, 0, 0, 2157990978, 0, 0, 0, 21014661, 
    },
    {
        0, 0, 0, 0, 893107048, 0, 0, 0, 1786214097, 0, 0, 0, 3572428195, 0, 0, 0, 
        2849889095, 0, 0, 0, 1404810895, 0, 0, 0, 2809621790, 0, 0, 0, 1324276285, 0, 0, 0, 
        2648552571, 0, 0, 0, 1002137847, 0, 0, 0, 2004275695, 0, 0, 0, 4008551390, 0, 0, 0, 
        3722135485, 0, 0, 0, 3149303674, 0, 0, 0, 2003640053, 0, 0, 0, 4007280106, 0, 0, 0, 
        3719592917, 0, 0, 0, 3144218538, 0, 0, 0, 1993469781, 0, 0, 0, 3986939563, 0, 0, 0, 
        3678911830, 0, 0, 0, 3062856364, 0, 0, 0, 1830745432, 0, 0, 0, 3661490864, 0, 0, 0, 
        3028014433, 0, 0, 0, 1761061570, 0, 0, 0, 3839160045, 0, 0, 0, 3383352795, 0, 0, 0, 
        2471738294, 0, 0, 0, 648509293, 0, 0, 0, 1297018586, 0, 0, 0, 2594037172, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3625984309, 0, 0, 
        0, 2957001323, 0, 0, 0, 1619035351, 0, 0, 0, 3238070702, 0, 0, 0, 2181174108, 0, 0, 
        0, 67380920, 0, 0, 0, 134761841, 0, 0, 0, 269523682, 0, 0, 0, 539047365, 0, 0, 
        0, 1078094730, 0, 0, 0, 2156189460, 0, 0, 0, 17411624, 0, 0, 0, 34823248, 0, 0, 
        0, 69646496, 0, 0, 0, 139292993, 0, 0, 0, 278585986, 0, 0, 0, 557171973, 0, 0, 
        0, 1114343946, 0, 0, 0, 2228687892, 0, 0, 0, 162408489, 0, 0, 0, 324816978, 0, 0, 
        0, 649633957, 0, 0, 0, 1299267915, 0, 0, 0, 2598535831, 0, 0, 0, 902104367, 0, 0, 
        0, 1804208734, 0, 0, 0, 3608417468, 0, 0, 0, 1980237901, 0, 0, 0, 3960475802, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 470870896, 0, 0, 0, 941741792, 0, 0, 0, 1883483584, 0, 0, 0, 3766967168, 0, 
        0, 0, 3238967041, 0, 0, 0, 2182966786, 0, 0, 0, 70966277, 0, 0, 0, 141932555, 0, 
        0, 0, 283865111, 0, 0, 0, 567730223, 0, 0, 0, 1135460447, 0, 0, 0, 2270920895, 0, 
        0, 0, 246874494, 0, 0, 0, 493748989, 0, 0, 0, 987497979, 0, 0, 0, 1772675207, 0, 
        0, 0, 3545350414, 0, 0, 0, 2795733533, 0, 0, 0, 1296499770, 0, 0, 0, 2592999541, 0, 
        0, 0, 891031787, 0, 0, 0, 1782063574, 0, 0, 0, 3564127149, 0, 0, 0, 2833287003, 0, 
        0, 0, 1371606711, 0, 0, 0, 2743213422, 0, 0, 0, 1191459548, 0, 0, 0, 2382919096, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 537135248, 
        0, 0, 0, 1074270496, 0, 0, 0, 2148540992, 0, 0, 0, 2114688, 0, 0, 0, 4229377, 
        0, 0, 0, 8458754, 0, 0, 0, 16917508, 0, 0, 0, 33835017, 0, 0, 0, 67670034, 
        0, 0, 0, 135340068, 0, 0, 0, 270680136, 0, 0, 0, 541360273, 0, 0, 0, 1082720546, 
        0, 0, 0, 2165441092, 0, 0, 0, 35914889, 0, 0, 0, 71829779, 0, 0, 0, 143659558, 
        0, 0, 0, 287319116, 0, 0, 0, 574638232, 0, 0, 0, 1149276464, 0, 0, 0, 2298552928, 
        0, 0, 0, 302138561, 0, 0, 0, 67141906, 0, 0, 0, 134283812, 0, 0, 0, 268567624, 
    },
    {
        0, 0, 0, 0, 2113541784, 0, 0, 0, 4227083568, 0, 0, 0, 4159199840, 0, 0, 0, 
        4023432384, 0, 0, 0, 3751897472, 0, 0, 0, 3208827648, 0, 0, 0, 2122688001, 0, 0, 0, 
        4245376003, 0, 0, 0, 4195784710, 0, 0, 0, 4096602125, 0, 0, 0, 3898236955, 0, 0, 0, 
        3501506615, 0, 0, 0, 2708045935, 0, 0, 0, 1121124575, 0, 0, 0, 2242249151, 0, 0, 0, 
        189531007, 0, 0, 0, 379062015, 0, 0, 0, 758124030, 0, 0, 0, 1516248061, 0, 0, 0, 
        3032496123, 0, 0, 0, 1770024950, 0, 0, 0, 3540049900, 0, 0, 0, 2785132504, 0, 0, 0, 
        1275297712, 0, 0, 0, 2550595425, 0, 0, 0, 1308092506, 0, 0, 0, 2616185012, 0, 0, 0, 
        937402729, 0, 0, 0, 1874805459, 0, 0, 0, 3749610918, 0, 0, 0, 3204254540, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99817600, 0, 0, 
        0, 199635201, 0, 0, 0, 399270402, 0, 0, 0, 798540804, 0, 0, 0, 1597081609, 0, 0, 
        0, 3194163218, 0, 0, 0, 2093359140, 0, 0, 0, 4186718280, 0, 0, 0, 4078469265, 0, 0, 
        0, 3861971235, 0, 0, 0, 3428975175, 0, 0, 0, 2562983055, 0, 0, 0, 830998815, 0, 0, 
        0, 1661997631, 0, 0, 0, 3323995262, 0, 0, 0, 2353023229, 0, 0, 0, 411079163, 0, 0, 
        0, 822158327, 0, 0, 0, 1644316655, 0, 0, 0, 3288633310, 0, 0, 0, 2282299325, 0, 0, 
        0, 269631354, 0, 0, 0, 539262709, 0, 0, 0, 1078525418, 0, 0, 0, 2157050836, 0, 0, 
        0, 19134376, 0, 0, 0, 38268752, 0, 0, 0, 24954400, 0, 0, 0, 49908800, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 27673132, 0, 0, 0, 55346265, 0, 0, 0, 110692530, 0, 0, 0, 221385060, 0, 
        0, 0, 442770121, 0, 0, 0, 885540243, 0, 0, 0, 1771080487, 0, 0, 0, 3542160975, 0, 
        0, 0, 2789354654, 0, 0, 0, 1283742012, 0, 0, 0, 2567484024, 0, 0, 0, 840000753, 0, 
        0, 0, 1680001507, 0, 0, 0, 3360003015, 0, 0, 0, 2425038735, 0, 0, 0, 548408626, 0, 
        0, 0, 1096817252, 0, 0, 0, 2193634504, 0, 0, 0, 92301712, 0, 0, 0, 184603425, 0, 
        0, 0, 369206850, 0, 0, 0, 738413700, 0, 0, 0, 1476827400, 0, 0, 0, 2953654801, 0, 
        0, 0, 1612342306, 0, 0, 0, 3224684613, 0, 0, 0, 2154401931, 0, 0, 0, 13836566, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1048576, 
        0, 0, 0, 2097152, 0, 0, 0, 4194305, 0, 0, 0, 8388610, 0, 0, 0, 16777220, 
        0, 0, 0, 33554441, 0, 0, 0, 67108882, 0, 0, 0, 134217764, 0, 0, 0, 268435528, 
        0, 0, 0, 536871056, 0, 0, 0, 1073742112, 0, 0, 0, 2147484224, 0, 0, 0, 1152, 
        0, 0, 0, 2304, 0, 0, 0, 4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 
        0, 0, 0, 36864, 0, 0, 0, 73728, 0, 0, 0, 147456, 0, 0, 0, 294912, 
        0, 0, 0, 589824, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 
    },
    {
        0, 0, 0, 0, 307855197, 0, 0, 0, 615710394, 0, 0, 0, 1231420788, 0, 0, 0, 
        2462841576, 0, 0, 0, 630715856, 0, 0, 0, 1261431713, 0, 0, 0, 2522863426, 0, 0, 0, 
        750759556, 0, 0, 0, 1501519112, 0, 0, 0, 3003038224, 0, 0, 0, 1711109152, 0, 0, 0, 
        3422218304, 0, 0, 0, 2549469312, 0, 0, 0, 803971329, 0, 0, 0, 1607942659, 0, 0, 0, 
        3215885318, 0, 0, 0, 2136803341, 0, 0, 0, 4273606682, 0, 0, 0, 4252246069, 0, 0, 0, 
        4209524842, 0, 0, 0, 4124082389, 0, 0, 0, 3953197482, 0, 0, 0, 3611427668, 0, 0, 0, 
        2927888040, 0, 0, 0, 1560808784, 0, 0, 0, 2823382525, 0, 0, 0, 1351797754, 0, 0, 0, 
        2703595509, 0, 0, 0, 1112223723, 0, 0, 0, 2224447447, 0, 0, 0, 153927598, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1409835056, 0, 0, 
        0, 2819670112, 0, 0, 0, 1344372928, 0, 0, 0, 2688745857, 0, 0, 0, 1082524418, 0, 0, 
        0, 2165048836, 0, 0, 0, 35130376, 0, 0, 0, 70260752, 0, 0, 0, 140521505, 0, 0, 
        0, 281043010, 0, 0, 0, 562086021, 0, 0, 0, 1124172042, 0, 0, 0, 2248344084, 0, 0, 
        0, 201720873, 0, 0, 0, 403441747, 0, 0, 0, 806883495, 0, 0, 0, 1613766991, 0, 0, 
        0, 3227533982, 0, 0, 0, 2160100668, 0, 0, 0, 25234040, 0, 0, 0, 50468080, 0, 0, 
        0, 100936160, 0, 0, 0, 201872321, 0, 0, 0, 403744643, 0, 0, 0, 807489287, 0, 0, 
        0, 1614978575, 0, 0, 0, 3229957150, 0, 0, 0, 3573684236, 0, 0, 0, 2852401176, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1749068055, 0, 0, 0, 3498136111, 0, 0, 0, 2701304927, 0, 0, 0, 1107642558, 0, 
        0, 0, 2215285117, 0, 0, 0, 135602938, 0, 0, 0, 271205877, 0, 0, 0, 542411755, 0, 
        0, 0, 1084823510, 0, 0, 0, 2169647020, 0, 0, 0, 44326744, 0, 0, 0, 88653489, 0, 
        0, 0, 177306978, 0, 0, 0, 354613956, 0, 0, 0, 709227913, 0, 0, 0, 1019953669, 0, 
        0, 0, 2039907338, 0, 0, 0, 4079814677, 0, 0, 0, 3864662058, 0, 0, 0, 3434356820, 0, 
        0, 0, 2573746345, 0, 0, 0, 852525394, 0, 0, 0, 1705050788, 0, 0, 0, 3410101576, 0, 
        0, 0, 2525235857, 0, 0, 0, 755504418, 0, 0, 0, 1511008837, 0, 0, 0, 3022017675, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33280, 
        0, 0, 0, 66560, 0, 0, 0, 133120, 0, 0, 0, 266240, 0, 0, 0, 532480, 
        0, 0, 0, 1064960, 0, 0, 0, 2129920, 0, 0, 0, 4259841, 0, 0, 0, 8519682, 
        0, 0, 0, 17039364, 0, 0, 0, 34078729, 0, 0, 0, 68157458, 0, 0, 0, 136314916, 
        0, 0, 0, 272629833, 0, 0, 0, 545259666, 0, 0, 0, 1090519332, 0, 0, 0, 2181038665, 
        0, 0, 0, 67110034, 0, 0, 0, 134220068, 0, 0, 0, 268440136, 0, 0, 0, 536880272, 
        0, 0, 0, 1073760544, 0, 0, 0, 2147487808, 0, 0, 0, 8320, 0, 0, 0, 16640, 
    },
    {
        0, 0, 0, 0, 1769338744, 0, 0, 0, 3538677488, 0, 0, 0, 2782387681, 0, 0, 0, 
        1269808067, 0, 0, 0, 2539616134, 0, 0, 0, 784264973, 0, 0, 0, 1568529946, 0, 0, 0, 
        3137059892, 0, 0, 0, 1979152488, 0, 0, 0, 3958304976, 0, 0, 0, 3621642656, 0, 0, 0, 
        2948318016, 0, 0, 0, 1601668737, 0, 0, 0, 3203337474, 0, 0, 0, 2111707652, 0, 0, 0, 
        4223415304, 0, 0, 0, 4151863312, 0, 0, 0, 4008759328, 0, 0, 0, 3722551361, 0, 0, 0, 
        3150135426, 0, 0, 0, 2005303557, 0, 0, 0, 4010607114, 0, 0, 0, 3726246932, 0, 0, 0, 
        3157526569, 0, 0, 0, 2020085842, 0, 0, 0, 2577782749, 0, 0, 0, 860598203, 0, 0, 0, 
        1721196407, 0, 0, 0, 3442392815, 0, 0, 0, 2589818334, 0, 0, 0, 884669372, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1430273920, 0, 0, 
        0, 2860547840, 0, 0, 0, 1426128384, 0, 0, 0, 2852256768, 0, 0, 0, 1409546240, 0, 0, 
        0, 2819092480, 0, 0, 0, 1343217664, 0, 0, 0, 2686435329, 0, 0, 0, 1077903362, 0, 0, 
        0, 2155806724, 0, 0, 0, 16646152, 0, 0, 0, 33292304, 0, 0, 0, 66584608, 0, 0, 
        0, 133169216, 0, 0, 0, 266338433, 0, 0, 0, 532676867, 0, 0, 0, 1065353734, 0, 0, 
        0, 2130707468, 0, 0, 0, 4261414936, 0, 0, 0, 4227862576, 0, 0, 0, 4160757856, 0, 0, 
        0, 4026548417, 0, 0, 0, 3758129539, 0, 0, 0, 3221291782, 0, 0, 0, 2147616268, 0, 0, 
        0, 265240, 0, 0, 0, 530480, 0, 0, 0, 1431310304, 0, 0, 0, 2862620608, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2164392972, 0, 0, 0, 33818648, 0, 0, 0, 67637296, 0, 0, 0, 135274592, 0, 
        0, 0, 270549185, 0, 0, 0, 541098371, 0, 0, 0, 1082196742, 0, 0, 0, 2164393484, 0, 
        0, 0, 33819672, 0, 0, 0, 67639344, 0, 0, 0, 135278688, 0, 0, 0, 270557377, 0, 
        0, 0, 541114755, 0, 0, 0, 1082229511, 0, 0, 0, 2164459022, 0, 0, 0, 2198079504, 0, 
        0, 0, 101191712, 0, 0, 0, 202383424, 0, 0, 0, 404766849, 0, 0, 0, 809533698, 0, 
        0, 0, 1619067396, 0, 0, 0, 3238134792, 0, 0, 0, 2181302288, 0, 0, 0, 67637280, 0, 
        0, 0, 135274560, 0, 0, 0, 270549121, 0, 0, 0, 541098243, 0, 0, 0, 1082196486, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180224, 
        0, 0, 0, 360448, 0, 0, 0, 720896, 0, 0, 0, 1441792, 0, 0, 0, 2883584, 
        0, 0, 0, 5767169, 0, 0, 0, 11534338, 0, 0, 0, 23068677, 0, 0, 0, 46137354, 
        0, 0, 0, 92274708, 0, 0, 0, 184549417, 0, 0, 0, 369098835, 0, 0, 0, 738197670, 
        0, 0, 0, 1476395340, 0, 0, 0, 2952790680, 0, 0, 0, 1610614064, 0, 0, 0, 3221228128, 
        0, 0, 0, 2147488960, 0, 0, 0, 10624, 0, 0, 0, 21248, 0, 0, 0, 42496, 
        0, 0, 0, 84992, 0, 0, 0, 22528, 0, 0, 0, 45056, 0, 0, 0, 90112, 
    },
    {
        0, 0, 0, 0, 2045181768, 0, 0, 0, 4090363536, 0, 0, 0, 3885759776, 0, 0, 0, 
        3476552256, 0, 0, 0, 2658137216, 0, 0, 0, 1021307136, 0, 0, 0, 2042614272, 0, 0, 0, 
        4085228544, 0, 0, 0, 3875489792, 0, 0, 0, 3456012289, 0, 0, 0, 2617057282, 0, 0, 0, 
        939147269, 0, 0, 0, 1878294539, 0, 0, 0, 3756589078, 0, 0, 0, 3218210860, 0, 0, 0, 
        2141454425, 0, 0, 0, 4282908850, 0, 0, 0, 4270850404, 0, 0, 0, 4246733513, 0, 0, 0, 
        4198499730, 0, 0, 0, 4102032165, 0, 0, 0, 3909097035, 0, 0, 0, 3523226774, 0, 0, 0, 
        2751486253, 0, 0, 0, 1208005210, 0, 0, 0, 3924270077, 0, 0, 0, 3553572858, 0, 0, 0, 
        2812178420, 0, 0, 0, 1329389545, 0, 0, 0, 2658779090, 0, 0, 0, 1022590884, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4294705152, 0, 0, 
        0, 4294443008, 0, 0, 0, 4293918720, 0, 0, 0, 4292870144, 0, 0, 0, 4290772992, 0, 0, 
        0, 4286578688, 0, 0, 0, 4278190080, 0, 0, 0, 4261412864, 0, 0, 0, 4227858432, 0, 0, 
        0, 4160749568, 0, 0, 0, 4026531841, 0, 0, 0, 3758096387, 0, 0, 0, 3221225478, 0, 0, 
        0, 2147483660, 0, 0, 0, 24, 0, 0, 0, 48, 0, 0, 0, 96, 0, 0, 
        0, 192, 0, 0, 0, 384, 0, 0, 0, 768, 0, 0, 0, 1536, 0, 0, 
        0, 3072, 0, 0, 0, 6144, 0, 0, 0, 12288, 0, 0, 0, 24576, 0, 0, 
        0, 49152, 0, 0, 0, 98304, 0, 0, 0, 4294901760, 0, 0, 0, 4294836224, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 
        0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 0, 0, 262152, 0, 
        0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 
        0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67108864, 0, 
        0, 0, 134217728, 0, 0, 0, 268435457, 0, 0, 0, 536870914, 0, 0, 0, 1073741828, 0, 
        0, 0, 2147483656, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 64, 0, 
        0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37905416, 
        0, 0, 0, 75810832, 0, 0, 0, 151621664, 0, 0, 0, 303243329, 0, 0, 0, 606486658, 
        0, 0, 0, 1212973317, 0, 0, 0, 2425946634, 0, 0, 0, 556925972, 0, 0, 0, 1113851944, 
        0, 0, 0, 2227703889, 0, 0, 0, 160440482, 0, 0, 0, 320880965, 0, 0, 0, 641761930, 
        0, 0, 0, 1283523860, 0, 0, 0, 2567047720, 0, 0, 0, 839128145, 0, 0, 0, 1678256290, 
        0, 0, 0, 3356512580, 0, 0, 0, 2418057864, 0, 0, 0, 541148433, 0, 0, 0, 1082296866, 
        0, 0, 0, 2164593732, 0, 0, 0, 4738177, 0, 0, 0, 9476354, 0, 0, 0, 18952708, 
    },
    {
        0, 0, 0, 0, 698651200, 0, 0, 0, 1397302401, 0, 0, 0, 2794604802, 0, 0, 0, 
        1294242308, 0, 0, 0, 2588484616, 0, 0, 0, 882001936, 0, 0, 0, 1764003872, 0, 0, 0, 
        3528007744, 0, 0, 0, 2761048193, 0, 0, 0, 1227129090, 0, 0, 0, 2454258180, 0, 0, 0, 
        613549064, 0, 0, 0, 1227098128, 0, 0, 0, 2454196256, 0, 0, 0, 613425216, 0, 0, 0, 
        1226850432, 0, 0, 0, 2453700864, 0, 0, 0, 612434432, 0, 0, 0, 1224868864, 0, 0, 0, 
        2449737728, 0, 0, 0, 604508160, 0, 0, 0, 1209016320, 0, 0, 0, 2418032641, 0, 0, 0, 
        541097986, 0, 0, 0, 1082195972, 0, 0, 0, 2829488713, 0, 0, 0, 1364010130, 0, 0, 0, 
        2728020260, 0, 0, 0, 1161073224, 0, 0, 0, 2322146448, 0, 0, 0, 349325600, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 
        0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 
        0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 
        0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 
        0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 
        0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554432, 0, 0, 
        0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 0, 536870917, 0, 0, 
        0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 131092, 0, 0, 0, 262184, 0, 0, 0, 524368, 0, 0, 0, 1048736, 0, 
        0, 0, 2097472, 0, 0, 0, 4194944, 0, 0, 0, 8389888, 0, 0, 0, 16779776, 0, 
        0, 0, 33559552, 0, 0, 0, 67119104, 0, 0, 0, 134238208, 0, 0, 0, 268476416, 0, 
        0, 0, 536952832, 0, 0, 0, 1073905665, 0, 0, 0, 2147811330, 0, 0, 0, 524304, 0, 
        0, 0, 1048608, 0, 0, 0, 2097216, 0, 0, 0, 4194432, 0, 0, 0, 8388864, 0, 
        0, 0, 16777728, 0, 0, 0, 33555456, 0, 0, 0, 67110912, 0, 0, 0, 134221824, 0, 
        0, 0, 268443649, 0, 0, 0, 536887298, 0, 0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2731147994, 
        0, 0, 0, 1167328692, 0, 0, 0, 2334657385, 0, 0, 0, 374347474, 0, 0, 0, 748694948, 
        0, 0, 0, 1497389897, 0, 0, 0, 2994779795, 0, 0, 0, 1694592294, 0, 0, 0, 3389184589, 
        0, 0, 0, 2483401882, 0, 0, 0, 671836468, 0, 0, 0, 1343672936, 0, 0, 0, 2687345872, 
        0, 0, 0, 1079724449, 0, 0, 0, 2159448898, 0, 0, 0, 23930501, 0, 0, 0, 47861002, 
        0, 0, 0, 95722004, 0, 0, 0, 191444008, 0, 0, 0, 382888016, 0, 0, 0, 765776032, 
        0, 0, 0, 1531552064, 0, 0, 0, 341393499, 0, 0, 0, 682786998, 0, 0, 0, 1365573997, 
    },
    {
        0, 0, 0, 0, 1226833920, 0, 0, 0, 2453667840, 0, 0, 0, 612368384, 0, 0, 0, 
        1224736768, 0, 0, 0, 2449473536, 0, 0, 0, 603979776, 0, 0, 0, 1207959552, 0, 0, 0, 
        2415919105, 0, 0, 0, 536870914, 0, 0, 0, 1073741828, 0, 0, 0, 2147483657, 0, 0, 0, 
        18, 0, 0, 0, 36, 0, 0, 0, 72, 0, 0, 0, 144, 0, 0, 0, 
        288, 0, 0, 0, 576, 0, 0, 0, 1152, 0, 0, 0, 2304, 0, 0, 0, 
        4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 0, 0, 0, 36864, 0, 0, 0, 
        73728, 0, 0, 0, 147456, 0, 0, 0, 1227128832, 0, 0, 0, 2454257664, 0, 0, 0, 
        613548032, 0, 0, 0, 1227096064, 0, 0, 0, 2454192128, 0, 0, 0, 613416960, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 335546385, 0, 0, 0, 671092770, 0, 0, 0, 1342185541, 0, 0, 0, 2684371082, 0, 
        0, 0, 1073774869, 0, 0, 0, 2147549738, 0, 0, 0, 132180, 0, 0, 0, 264360, 0, 
        0, 0, 528720, 0, 0, 0, 1057440, 0, 0, 0, 2114880, 0, 0, 0, 4229761, 0, 
        0, 0, 8459522, 0, 0, 0, 16919044, 0, 0, 0, 33838088, 0, 0, 0, 269000704, 0, 
        0, 0, 538001408, 0, 0, 0, 1076002817, 0, 0, 0, 2152005634, 0, 0, 0, 9043972, 0, 
        0, 0, 18087944, 0, 0, 0, 36175888, 0, 0, 0, 72351776, 0, 0, 0, 144703552, 0, 
        0, 0, 289407105, 0, 0, 0, 578814210, 0, 0, 0, 1157628420, 0, 0, 0, 2315256840, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3732057110, 
        0, 0, 0, 3169146925, 0, 0, 0, 2043326555, 0, 0, 0, 4086653111, 0, 0, 0, 3878338927, 
        0, 0, 0, 3461710558, 0, 0, 0, 2628453820, 0, 0, 0, 961940345, 0, 0, 0, 1923880691, 
        0, 0, 0, 3847761383, 0, 0, 0, 3400555471, 0, 0, 0, 2506143647, 0, 0, 0, 717319998, 
        0, 0, 0, 1434639996, 0, 0, 0, 2869279993, 0, 0, 0, 1443592691, 0, 0, 0, 2887185382, 
        0, 0, 0, 1479403468, 0, 0, 0, 2958806937, 0, 0, 0, 1622646578, 0, 0, 0, 3245293157, 
        0, 0, 0, 2195619018, 0, 0, 0, 3687732610, 0, 0, 0, 3080497925, 0, 0, 0, 1866028555, 
    },
    {
        0, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 
        4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554433, 0, 0, 0, 
        67108866, 0, 0, 0, 134217732, 0, 0, 0, 268435464, 0, 0, 0, 536870928, 0, 0, 0, 
        1073741856, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 260, 0, 0, 0, 
        520, 0, 0, 0, 1040, 0, 0, 0, 2080, 0, 0, 0, 4160, 0, 0, 0, 
        8320, 0, 0, 0, 16640, 0, 0, 0, 33280, 0, 0, 0, 66560, 0, 0, 0, 
        133120, 0, 0, 0, 266240, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 
        32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 2560, 0, 0, 0, 5120, 0, 0, 
        0, 10240, 0, 0, 0, 20480, 0, 0, 0, 40960, 0, 0, 0, 81920, 0, 0, 
        0, 163840, 0, 0, 0, 327680, 0, 0, 0, 655360, 0, 0, 0, 1310720, 0, 0, 
        0, 2621440, 0, 0, 0, 5242880, 0, 0, 0, 10485760, 0, 0, 0, 20971520, 0, 0, 
        0, 41943040, 0, 0, 0, 83886080, 0, 0, 0, 167772161, 0, 0, 0, 335544322, 0, 0, 
        0, 671088644, 0, 0, 0, 1342177288, 0, 0, 0, 2684354577, 0, 0, 0, 1073741858, 0, 0, 
        0, 2147483716, 0, 0, 0, 136, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 539164932, 0, 0, 0, 1078329864, 0, 0, 0, 2156659728, 0, 0, 0, 18352160, 0, 
        0, 0, 36704320, 0, 0, 0, 73408640, 0, 0, 0, 146817280, 0, 0, 0, 293634560, 0, 
        0, 0, 587269120, 0, 0, 0, 1174538240, 0, 0, 0, 2349076480, 0, 0, 0, 403185665, 0, 
        0, 0, 806371331, 0, 0, 0, 1612742663, 0, 0, 0, 3225485326, 0, 0, 0, 2694906136, 0, 
        0, 0, 1094844976, 0, 0, 0, 2189689952, 0, 0, 0, 84412608, 0, 0, 0, 168825216, 0, 
        0, 0, 337650433, 0, 0, 0, 675300866, 0, 0, 0, 1350601732, 0, 0, 0, 2701203464, 0, 
        0, 0, 1107439632, 0, 0, 0, 2214879264, 0, 0, 0, 134791233, 0, 0, 0, 269582466, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2033130968, 
        0, 0, 0, 4066261936, 0, 0, 0, 3837556576, 0, 0, 0, 3380145857, 0, 0, 0, 2465324418, 
        0, 0, 0, 635681541, 0, 0, 0, 1271363082, 0, 0, 0, 2542726165, 0, 0, 0, 790485035, 
        0, 0, 0, 1580970071, 0, 0, 0, 3161940143, 0, 0, 0, 2028912991, 0, 0, 0, 4057825983, 
        0, 0, 0, 3820684671, 0, 0, 0, 3346402046, 0, 0, 0, 2397836796, 0, 0, 0, 500706297, 
        0, 0, 0, 1001412595, 0, 0, 0, 2002825190, 0, 0, 0, 4005650380, 0, 0, 0, 3716333464, 
        0, 0, 0, 3137699633, 0, 0, 0, 254141371, 0, 0, 0, 508282742, 0, 0, 0, 1016565484, 
    },
};

// clang-format on
// clang-format off
static const __device__ unsigned int d_lfsr113_sequence_jump_matrices[LFSR113_JUMP_MATRICES][LFSR113_SIZE] = {
    {
        0, 0, 0, 0, 2928597988, 0, 0, 0, 1562228680, 0, 0, 0, 3124457360, 0, 0, 0, 
        1953947424, 0, 0, 0, 3907894849, 0, 0, 0, 3520822403, 0, 0, 0, 2746677510, 0, 0, 0, 
        1198387725, 0, 0, 0, 2396775450, 0, 0, 0, 498583604, 0, 0, 0, 997167209, 0, 0, 0, 
        1994334419, 0, 0, 0, 3988668839, 0, 0, 0, 3682370382, 0, 0, 0, 3069773468, 0, 0, 0, 
        1844579640, 0, 0, 0, 3689159280, 0, 0, 0, 3083351264, 0, 0, 0, 1871735233, 0, 0, 0, 
        3743470466, 0, 0, 0, 3191973636, 0, 0, 0, 2088979976, 0, 0, 0, 4177959953, 0, 0, 0, 
        4060952610, 0, 0, 0, 3826937925, 0, 0, 0, 1723480943, 0, 0, 0, 3446961887, 0, 0, 0, 
        2598956478, 0, 0, 0, 902945660, 0, 0, 0, 1805891321, 0, 0, 0, 3611782642, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1442838528, 0, 0, 
        0, 2885677056, 0, 0, 0, 1476386816, 0, 0, 0, 2952773632, 0, 0, 0, 1610579969, 0, 0, 
        0, 3221159938, 0, 0, 0, 2147352580, 0, 0, 0, 4294705160, 0, 0, 0, 4294443024, 0, 0, 
        0, 4293918752, 0, 0, 0, 4292870208, 0, 0, 0, 4290773120, 0, 0, 0, 4286578944, 0, 0, 
        0, 4278190592, 0, 0, 0, 4261413888, 0, 0, 0, 4227860480, 0, 0, 0, 4160753664, 0, 0, 
        0, 4026540033, 0, 0, 0, 3758112771, 0, 0, 0, 3221258246, 0, 0, 0, 2147549196, 0, 0, 
        0, 131096, 0, 0, 0, 262192, 0, 0, 0, 524384, 0, 0, 0, 1048768, 0, 0, 
        0, 2097536, 0, 0, 0, 4195072, 0, 0, 0, 1434451456, 0, 0, 0, 2868902912, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 536903683, 0, 0, 0, 1073807366, 0, 0, 0, 2147614732, 0, 0, 0, 262168, 0, 
        0, 0, 524336, 0, 0, 0, 1048672, 0, 0, 0, 2097344, 0, 0, 0, 4194688, 0, 
        0, 0, 8389376, 0, 0, 0, 16778752, 0, 0, 0, 33557504, 0, 0, 0, 67115008, 0, 
        0, 0, 134230016, 0, 0, 0, 268460033, 0, 0, 0, 536920067, 0, 0, 0, 1610678276, 0, 
        0, 0, 3221356552, 0, 0, 0, 2147745808, 0, 0, 0, 524320, 0, 0, 0, 1048640, 0, 
        0, 0, 2097280, 0, 0, 0, 4194560, 0, 0, 0, 8389120, 0, 0, 0, 16778240, 0, 
        0, 0, 33556480, 0, 0, 0, 67112960, 0, 0, 0, 134225920, 0, 0, 0, 268451841, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144703526, 
        0, 0, 0, 289407053, 0, 0, 0, 578814107, 0, 0, 0, 1157628214, 0, 0, 0, 2315256429, 
        0, 0, 0, 335545562, 0, 0, 0, 671091124, 0, 0, 0, 1342182248, 0, 0, 0, 2684364496, 
        0, 0, 0, 1073761696, 0, 0, 0, 2147523392, 0, 0, 0, 79488, 0, 0, 0, 158976, 
        0, 0, 0, 317952, 0, 0, 0, 635904, 0, 0, 0, 1271808, 0, 0, 0, 2543616, 
        0, 0, 0, 5087233, 0, 0, 0, 10174466, 0, 0, 0, 20348932, 0, 0, 0, 40697864, 
        0, 0, 0, 81395729, 0, 0, 0, 18087940, 0, 0, 0, 36175881, 0, 0, 0, 72351763, 
    },
    {
        0, 0, 0, 0, 1874778401, 0, 0, 0, 3749556802, 0, 0, 0, 3204146308, 0, 0, 0, 
        2113325320, 0, 0, 0, 4226650640, 0, 0, 0, 4158333984, 0, 0, 0, 4021700672, 0, 0, 0, 
        3748434048, 0, 0, 0, 3201900800, 0, 0, 0, 2108834304, 0, 0, 0, 4217668608, 0, 0, 0, 
        4140369920, 0, 0, 0, 3985772545, 0, 0, 0, 3676577794, 0, 0, 0, 3058188292, 0, 0, 0, 
        1821409288, 0, 0, 0, 3642818577, 0, 0, 0, 2990669858, 0, 0, 0, 1686372420, 0, 0, 0, 
        3372744841, 0, 0, 0, 2450522386, 0, 0, 0, 606077476, 0, 0, 0, 1212154952, 0, 0, 0, 
        2424309905, 0, 0, 0, 553652514, 0, 0, 0, 767490916, 0, 0, 0, 1534981833, 0, 0, 0, 
        3069963666, 0, 0, 0, 1844960036, 0, 0, 0, 3689920072, 0, 0, 0, 3084872848, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 
        0, 32, 0, 0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 
        0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 
        0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 
        0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 
        0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 
        0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 
        0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483652, 0, 0, 0, 8, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 262152, 0, 0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 
        0, 0, 4194432, 0, 0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 
        0, 0, 67110912, 0, 0, 0, 134221824, 0, 0, 0, 268443649, 0, 0, 0, 536887298, 0, 
        0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 0, 0, 131092, 0, 0, 0, 32, 0, 
        0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 
        0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 
        0, 0, 16384, 0, 0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135049252, 
        0, 0, 0, 270098504, 0, 0, 0, 540197008, 0, 0, 0, 1080394017, 0, 0, 0, 2160788035, 
        0, 0, 0, 26608774, 0, 0, 0, 53217549, 0, 0, 0, 106435098, 0, 0, 0, 212870196, 
        0, 0, 0, 425740393, 0, 0, 0, 851480786, 0, 0, 0, 1702961572, 0, 0, 0, 3405923145, 
        0, 0, 0, 2516878995, 0, 0, 0, 738790694, 0, 0, 0, 1477581388, 0, 0, 0, 2955162776, 
        0, 0, 0, 1615358257, 0, 0, 0, 3230716514, 0, 0, 0, 2166465732, 0, 0, 0, 37964168, 
        0, 0, 0, 75928336, 0, 0, 0, 16881156, 0, 0, 0, 33762313, 0, 0, 0, 67524626, 
    },
    {
        0, 0, 0, 0, 882001920, 0, 0, 0, 1764003840, 0, 0, 0, 3528007680, 0, 0, 0, 
        2761048065, 0, 0, 0, 1227128834, 0, 0, 0, 2454257668, 0, 0, 0, 613548040, 0, 0, 0, 
        1227096080, 0, 0, 0, 2454192160, 0, 0, 0, 613417024, 0, 0, 0, 1226834048, 0, 0, 0, 
        2453668096, 0, 0, 0, 612368896, 0, 0, 0, 1224737792, 0, 0, 0, 2449475584, 0, 0, 0, 
        603983872, 0, 0, 0, 1207967744, 0, 0, 0, 2415935489, 0, 0, 0, 536903682, 0, 0, 0, 
        1073807364, 0, 0, 0, 2147614729, 0, 0, 0, 262162, 0, 0, 0, 524324, 0, 0, 0, 
        1048648, 0, 0, 0, 2097296, 0, 0, 0, 886196512, 0, 0, 0, 1772393024, 0, 0, 0, 
        3544786048, 0, 0, 0, 2794604800, 0, 0, 0, 1294242304, 0, 0, 0, 2588484608, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 
        0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 32, 0, 0, 0, 64, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1073774613, 0, 0, 0, 2147549226, 0, 0, 0, 131156, 0, 0, 0, 262312, 0, 
        0, 0, 524624, 0, 0, 0, 1049248, 0, 0, 0, 2098496, 0, 0, 0, 4196992, 0, 
        0, 0, 8393984, 0, 0, 0, 16787968, 0, 0, 0, 33575936, 0, 0, 0, 67151873, 0, 
        0, 0, 134303746, 0, 0, 0, 268607492, 0, 0, 0, 537214984, 0, 0, 0, 655364, 0, 
        0, 0, 1310728, 0, 0, 0, 2621456, 0, 0, 0, 5242912, 0, 0, 0, 10485824, 0, 
        0, 0, 20971648, 0, 0, 0, 41943296, 0, 0, 0, 83886592, 0, 0, 0, 167773184, 0, 
        0, 0, 335546369, 0, 0, 0, 671092738, 0, 0, 0, 1342185477, 0, 0, 0, 2684370954, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3961969350, 
        0, 0, 0, 3628971405, 0, 0, 0, 2962975514, 0, 0, 0, 1630983732, 0, 0, 0, 3261967464, 
        0, 0, 0, 2228967633, 0, 0, 0, 162967970, 0, 0, 0, 325935940, 0, 0, 0, 651871880, 
        0, 0, 0, 1303743760, 0, 0, 0, 2607487520, 0, 0, 0, 920007744, 0, 0, 0, 1840015488, 
        0, 0, 0, 3680030976, 0, 0, 0, 3065094657, 0, 0, 0, 1835222019, 0, 0, 0, 3670444038, 
        0, 0, 0, 3045920780, 0, 0, 0, 1796874265, 0, 0, 0, 3593748531, 0, 0, 0, 2892529767, 
        0, 0, 0, 1490092239, 0, 0, 0, 1568987992, 0, 0, 0, 3137975985, 0, 0, 0, 1980984675, 
    },
    {
        0, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 
        8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 0, 
        131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 
        2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 
        33554433, 0, 0, 0, 67108866, 0, 0, 0, 134217732, 0, 0, 0, 268435464, 0, 0, 0, 
        536870928, 0, 0, 0, 1073741856, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 
        260, 0, 0, 0, 520, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 
        64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 2560, 0, 0, 0, 5120, 0, 0, 
        0, 10240, 0, 0, 0, 20480, 0, 0, 0, 40960, 0, 0, 0, 81920, 0, 0, 
        0, 163840, 0, 0, 0, 327680, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 18087960, 0, 0, 0, 36175920, 0, 0, 0, 72351840, 0, 0, 0, 144703680, 0, 
        0, 0, 289407361, 0, 0, 0, 578814722, 0, 0, 0, 1157629444, 0, 0, 0, 2315258888, 0, 
        0, 0, 335550481, 0, 0, 0, 671100962, 0, 0, 0, 1342201925, 0, 0, 0, 2684403851, 0, 
        0, 0, 1073840407, 0, 0, 0, 2147680814, 0, 0, 0, 394332, 0, 0, 0, 18352288, 0, 
        0, 0, 36704576, 0, 0, 0, 73409152, 0, 0, 0, 146818304, 0, 0, 0, 293636608, 0, 
        0, 0, 587273216, 0, 0, 0, 1174546432, 0, 0, 0, 2349092864, 0, 0, 0, 403218432, 0, 
        0, 0, 806436865, 0, 0, 0, 1612873731, 0, 0, 0, 3225747462, 0, 0, 0, 2156527628, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3548126500, 
        0, 0, 0, 2801285704, 0, 0, 0, 1307604113, 0, 0, 0, 2615208226, 0, 0, 0, 935449156, 
        0, 0, 0, 1870898313, 0, 0, 0, 3741796627, 0, 0, 0, 3188625959, 0, 0, 0, 2082284622, 
        0, 0, 0, 4164569244, 0, 0, 0, 4034171193, 0, 0, 0, 3773375091, 0, 0, 0, 3251782887, 
        0, 0, 0, 2208598479, 0, 0, 0, 122229662, 0, 0, 0, 244459325, 0, 0, 0, 488918650, 
        0, 0, 0, 977837300, 0, 0, 0, 1955674600, 0, 0, 0, 3911349200, 0, 0, 0, 3527731104, 
        0, 0, 0, 2760494912, 0, 0, 0, 2590999460, 0, 0, 0, 887031625, 0, 0, 0, 1774063250, 
    },
    {
        0, 0, 0, 0, 4160, 0, 0, 0, 8320, 0, 0, 0, 16640, 0, 0, 0, 
        33280, 0, 0, 0, 66560, 0, 0, 0, 133120, 0, 0, 0, 266240, 0, 0, 0, 
        532480, 0, 0, 0, 1064960, 0, 0, 0, 2129920, 0, 0, 0, 4259840, 0, 0, 0, 
        8519680, 0, 0, 0, 17039360, 0, 0, 0, 34078721, 0, 0, 0, 68157442, 0, 0, 0, 
        136314884, 0, 0, 0, 272629768, 0, 0, 0, 545259536, 0, 0, 0, 1090519072, 0, 0, 0, 
        2181038144, 0, 0, 0, 67108992, 0, 0, 0, 134217984, 0, 0, 0, 268435968, 0, 0, 0, 
        536871936, 0, 0, 0, 1073743872, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 
        260, 0, 0, 0, 520, 0, 0, 0, 1040, 0, 0, 0, 2080, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8704, 0, 0, 
        0, 17408, 0, 0, 0, 34816, 0, 0, 0, 69632, 0, 0, 0, 139264, 0, 0, 
        0, 278528, 0, 0, 0, 557056, 0, 0, 0, 1114112, 0, 0, 0, 2228224, 0, 0, 
        0, 4456448, 0, 0, 0, 8912896, 0, 0, 0, 17825792, 0, 0, 0, 35651584, 0, 0, 
        0, 71303168, 0, 0, 0, 142606337, 0, 0, 0, 285212674, 0, 0, 0, 570425349, 0, 0, 
        0, 1140850698, 0, 0, 0, 2281701397, 0, 0, 0, 268435498, 0, 0, 0, 536870997, 0, 0, 
        0, 1073741994, 0, 0, 0, 2147483988, 0, 0, 0, 680, 0, 0, 0, 1360, 0, 0, 
        0, 2720, 0, 0, 0, 5440, 0, 0, 0, 2176, 0, 0, 0, 4352, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1417720836, 0, 0, 0, 2835441672, 0, 0, 0, 1375916048, 0, 0, 0, 2751832097, 0, 
        0, 0, 1208696898, 0, 0, 0, 2417393796, 0, 0, 0, 539820296, 0, 0, 0, 1079640592, 0, 
        0, 0, 2159281184, 0, 0, 0, 23595072, 0, 0, 0, 47190144, 0, 0, 0, 94380288, 0, 
        0, 0, 188760576, 0, 0, 0, 377521152, 0, 0, 0, 755042304, 0, 0, 0, 243442693, 0, 
        0, 0, 486885387, 0, 0, 0, 973770774, 0, 0, 0, 1947541549, 0, 0, 0, 3895083098, 0, 
        0, 0, 3495198900, 0, 0, 0, 2695430504, 0, 0, 0, 1095893712, 0, 0, 0, 2191787424, 0, 
        0, 0, 88607552, 0, 0, 0, 177215104, 0, 0, 0, 354430209, 0, 0, 0, 708860418, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 357270623, 
        0, 0, 0, 714541247, 0, 0, 0, 1429082494, 0, 0, 0, 2858164988, 0, 0, 0, 1421362680, 
        0, 0, 0, 2842725361, 0, 0, 0, 1390483426, 0, 0, 0, 2780966853, 0, 0, 0, 1266966411, 
        0, 0, 0, 2533932823, 0, 0, 0, 772898351, 0, 0, 0, 1545796702, 0, 0, 0, 3091593405, 
        0, 0, 0, 1888219514, 0, 0, 0, 3776439028, 0, 0, 0, 3257910761, 0, 0, 0, 2220854227, 
        0, 0, 0, 146741158, 0, 0, 0, 293482317, 0, 0, 0, 586964634, 0, 0, 0, 1173929269, 
        0, 0, 0, 2347858538, 0, 0, 0, 44658827, 0, 0, 0, 89317655, 0, 0, 0, 178635311, 
    },
    {
        0, 0, 0, 0, 3162112, 0, 0, 0, 6324224, 0, 0, 0, 12648448, 0, 0, 0, 
        25296896, 0, 0, 0, 50593793, 0, 0, 0, 101187587, 0, 0, 0, 202375174, 0, 0, 0, 
        404750348, 0, 0, 0, 809500696, 0, 0, 0, 1619001392, 0, 0, 0, 3238002785, 0, 0, 0, 
        2181038274, 0, 0, 0, 67109252, 0, 0, 0, 134218504, 0, 0, 0, 268437008, 0, 0, 0, 
        536874016, 0, 0, 0, 1073748032, 0, 0, 0, 2147496065, 0, 0, 0, 24834, 0, 0, 0, 
        49668, 0, 0, 0, 99336, 0, 0, 0, 198672, 0, 0, 0, 397344, 0, 0, 0, 
        794688, 0, 0, 0, 1589376, 0, 0, 0, 49408, 0, 0, 0, 98816, 0, 0, 0, 
        197632, 0, 0, 0, 395264, 0, 0, 0, 790528, 0, 0, 0, 1581056, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134299649, 0, 0, 
        0, 268599298, 0, 0, 0, 537198597, 0, 0, 0, 1074397194, 0, 0, 0, 2148794388, 0, 0, 
        0, 2621480, 0, 0, 0, 5242960, 0, 0, 0, 10485920, 0, 0, 0, 20971840, 0, 0, 
        0, 41943680, 0, 0, 0, 83887360, 0, 0, 0, 167774721, 0, 0, 0, 335549442, 0, 0, 
        0, 671098884, 0, 0, 0, 1342197768, 0, 0, 0, 2684395537, 0, 0, 0, 1073823778, 0, 0, 
        0, 2147647556, 0, 0, 0, 327816, 0, 0, 0, 655632, 0, 0, 0, 1311264, 0, 0, 
        0, 2622528, 0, 0, 0, 5245056, 0, 0, 0, 10490112, 0, 0, 0, 20980224, 0, 0, 
        0, 41960448, 0, 0, 0, 83920896, 0, 0, 0, 33574912, 0, 0, 0, 67149824, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 844445257, 0, 0, 0, 1688890514, 0, 0, 0, 3377781029, 0, 0, 0, 2460594762, 0, 
        0, 0, 626222228, 0, 0, 0, 1252444457, 0, 0, 0, 2504888914, 0, 0, 0, 714810532, 0, 
        0, 0, 1429621065, 0, 0, 0, 2859242131, 0, 0, 0, 1423516967, 0, 0, 0, 2847033934, 0, 
        0, 0, 1399100572, 0, 0, 0, 2798201144, 0, 0, 0, 1301434992, 0, 0, 0, 2842792617, 0, 
        0, 0, 1390617939, 0, 0, 0, 2781235878, 0, 0, 0, 1267504461, 0, 0, 0, 2535008923, 0, 
        0, 0, 775050550, 0, 0, 0, 1550101100, 0, 0, 0, 3100202201, 0, 0, 0, 1905437106, 0, 
        0, 0, 3810874212, 0, 0, 0, 3326781129, 0, 0, 0, 2358594962, 0, 0, 0, 422222628, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3265725291, 
        0, 0, 0, 2236483287, 0, 0, 0, 177999279, 0, 0, 0, 355998558, 0, 0, 0, 711997116, 
        0, 0, 0, 1423994233, 0, 0, 0, 2847988467, 0, 0, 0, 1401009639, 0, 0, 0, 2802019279, 
        0, 0, 0, 1309071263, 0, 0, 0, 2618142526, 0, 0, 0, 941317756, 0, 0, 0, 1882635512, 
        0, 0, 0, 3765271025, 0, 0, 0, 3235574755, 0, 0, 0, 2176182214, 0, 0, 0, 57397132, 
        0, 0, 0, 114794264, 0, 0, 0, 229588528, 0, 0, 0, 459177056, 0, 0, 0, 918354113, 
        0, 0, 0, 1836708227, 0, 0, 0, 408215661, 0, 0, 0, 816431322, 0, 0, 0, 1632862645, 
    },
    {
        0, 0, 0, 0, 2554888269, 0, 0, 0, 814809242, 0, 0, 0, 1629618484, 0, 0, 0, 
        3259236968, 0, 0, 0, 2223506641, 0, 0, 0, 152045986, 0, 0, 0, 304091973, 0, 0, 0, 
        608183946, 0, 0, 0, 1216367892, 0, 0, 0, 2432735785, 0, 0, 0, 570504275, 0, 0, 0, 
        1141008550, 0, 0, 0, 2282017101, 0, 0, 0, 269066906, 0, 0, 0, 538133812, 0, 0, 0, 
        1076267624, 0, 0, 0, 2152535249, 0, 0, 0, 10103202, 0, 0, 0, 20206404, 0, 0, 0, 
        40412809, 0, 0, 0, 80825618, 0, 0, 0, 161651236, 0, 0, 0, 323302473, 0, 0, 0, 
        646604947, 0, 0, 0, 1293209894, 0, 0, 0, 39920129, 0, 0, 0, 79840258, 0, 0, 0, 
        159680516, 0, 0, 0, 319361033, 0, 0, 0, 638722067, 0, 0, 0, 1277444134, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 336678914, 0, 0, 
        0, 673357828, 0, 0, 0, 1346715656, 0, 0, 0, 2693431313, 0, 0, 0, 1091895330, 0, 0, 
        0, 2183790660, 0, 0, 0, 72614024, 0, 0, 0, 145228049, 0, 0, 0, 290456098, 0, 0, 
        0, 580912197, 0, 0, 0, 1161824394, 0, 0, 0, 2323648789, 0, 0, 0, 352330282, 0, 0, 
        0, 704660564, 0, 0, 0, 1409321128, 0, 0, 0, 2818642256, 0, 0, 0, 1342317216, 0, 0, 
        0, 2684634433, 0, 0, 0, 1074301570, 0, 0, 0, 2148603140, 0, 0, 0, 2238984, 0, 0, 
        0, 4477968, 0, 0, 0, 8955936, 0, 0, 0, 17911872, 0, 0, 0, 35823744, 0, 0, 
        0, 71647488, 0, 0, 0, 143294977, 0, 0, 0, 84169728, 0, 0, 0, 168339457, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 3001529316, 0, 0, 0, 1708091336, 0, 0, 0, 3416182673, 0, 0, 0, 2537398050, 0, 
        0, 0, 779828804, 0, 0, 0, 1559657609, 0, 0, 0, 3119315218, 0, 0, 0, 1943663140, 0, 
        0, 0, 3887326281, 0, 0, 0, 3479685267, 0, 0, 0, 2664403238, 0, 0, 0, 1033839181, 0, 
        0, 0, 2067678363, 0, 0, 0, 4135356726, 0, 0, 0, 3975746156, 0, 0, 0, 1796577085, 0, 
        0, 0, 3593154171, 0, 0, 0, 2891341046, 0, 0, 0, 1487714796, 0, 0, 0, 2975429593, 0, 
        0, 0, 1655891891, 0, 0, 0, 3311783783, 0, 0, 0, 2328600271, 0, 0, 0, 362233247, 0, 
        0, 0, 724466494, 0, 0, 0, 1448932988, 0, 0, 0, 2897865977, 0, 0, 0, 1500764658, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3612118070, 
        0, 0, 0, 2929268845, 0, 0, 0, 1563570394, 0, 0, 0, 3127140788, 0, 0, 0, 1959314281, 
        0, 0, 0, 3918628562, 0, 0, 0, 3542289829, 0, 0, 0, 2789612362, 0, 0, 0, 1284257428, 
        0, 0, 0, 2568514856, 0, 0, 0, 842062417, 0, 0, 0, 1684124835, 0, 0, 0, 3368249671, 
        0, 0, 0, 2441532046, 0, 0, 0, 588096797, 0, 0, 0, 1176193595, 0, 0, 0, 2352387190, 
        0, 0, 0, 409807085, 0, 0, 0, 819614171, 0, 0, 0, 1639228342, 0, 0, 0, 3278456684, 
        0, 0, 0, 2261946072, 0, 0, 0, 3672740230, 0, 0, 0, 3050513165, 0, 0, 0, 1806059035, 
    },
    {
        0, 0, 0, 0, 1164254896, 0, 0, 0, 2328509792, 0, 0, 0, 362052288, 0, 0, 0, 
        724104577, 0, 0, 0, 1448209155, 0, 0, 0, 2896418311, 0, 0, 0, 1497869326, 0, 0, 0, 
        2995738652, 0, 0, 0, 1696510008, 0, 0, 0, 3393020016, 0, 0, 0, 2491072737, 0, 0, 0, 
        687178178, 0, 0, 0, 1374356356, 0, 0, 0, 2748712712, 0, 0, 0, 1202458129, 0, 0, 0, 
        2404916258, 0, 0, 0, 514865221, 0, 0, 0, 1029730442, 0, 0, 0, 2059460885, 0, 0, 0, 
        4118921771, 0, 0, 0, 3942876246, 0, 0, 0, 3590785196, 0, 0, 0, 2886603097, 0, 0, 0, 
        1478238898, 0, 0, 0, 2956477797, 0, 0, 0, 622171258, 0, 0, 0, 1244342517, 0, 0, 0, 
        2488685035, 0, 0, 0, 682402774, 0, 0, 0, 1364805548, 0, 0, 0, 2729611096, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 339960066, 0, 0, 
        0, 679920132, 0, 0, 0, 1359840264, 0, 0, 0, 2719680529, 0, 0, 0, 1144393762, 0, 0, 
        0, 2288787525, 0, 0, 0, 282607754, 0, 0, 0, 565215509, 0, 0, 0, 1130431018, 0, 0, 
        0, 2260862036, 0, 0, 0, 226756777, 0, 0, 0, 453513555, 0, 0, 0, 907027111, 0, 0, 
        0, 1814054222, 0, 0, 0, 3628108445, 0, 0, 0, 2961249595, 0, 0, 0, 1627531895, 0, 0, 
        0, 3255063790, 0, 0, 0, 2215160284, 0, 0, 0, 135353273, 0, 0, 0, 270706546, 0, 0, 
        0, 541413093, 0, 0, 0, 1082826186, 0, 0, 0, 2165652372, 0, 0, 0, 36337448, 0, 0, 
        0, 72674896, 0, 0, 0, 145349793, 0, 0, 0, 84990016, 0, 0, 0, 169980033, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2938358989, 0, 0, 0, 1581750682, 0, 0, 0, 3163501365, 0, 0, 0, 2032035435, 0, 
        0, 0, 4064070870, 0, 0, 0, 3833174445, 0, 0, 0, 3371381594, 0, 0, 0, 2447795893, 0, 
        0, 0, 600624491, 0, 0, 0, 1201248983, 0, 0, 0, 2402497966, 0, 0, 0, 510028637, 0, 
        0, 0, 1020057274, 0, 0, 0, 2040114548, 0, 0, 0, 4080229097, 0, 0, 0, 1229289758, 0, 
        0, 0, 2458579516, 0, 0, 0, 622191737, 0, 0, 0, 1244383475, 0, 0, 0, 2488766950, 0, 
        0, 0, 682566604, 0, 0, 0, 1365133209, 0, 0, 0, 2730266419, 0, 0, 0, 1165565542, 0, 
        0, 0, 2331131084, 0, 0, 0, 367294873, 0, 0, 0, 734589747, 0, 0, 0, 1469179494, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 490940283, 
        0, 0, 0, 981880567, 0, 0, 0, 1963761134, 0, 0, 0, 3927522269, 0, 0, 0, 3560077242, 
        0, 0, 0, 2825187189, 0, 0, 0, 1355407083, 0, 0, 0, 2710814166, 0, 0, 0, 1126661037, 
        0, 0, 0, 2253322074, 0, 0, 0, 211676852, 0, 0, 0, 423353704, 0, 0, 0, 846707408, 
        0, 0, 0, 1693414817, 0, 0, 0, 3386829635, 0, 0, 0, 2478691975, 0, 0, 0, 662416654, 
        0, 0, 0, 1324833308, 0, 0, 0, 2649666617, 0, 0, 0, 1004365938, 0, 0, 0, 2008731877, 
        0, 0, 0, 4017463754, 0, 0, 0, 3282593007, 0, 0, 0, 2270218718, 0, 0, 0, 245470141, 
    },
    {
        0, 0, 0, 0, 126298325, 0, 0, 0, 252596651, 0, 0, 0, 505193303, 0, 0, 0, 
        1010386606, 0, 0, 0, 2020773212, 0, 0, 0, 4041546425, 0, 0, 0, 3788125555, 0, 0, 0, 
        3281283814, 0, 0, 0, 2267600332, 0, 0, 0, 240233369, 0, 0, 0, 480466738, 0, 0, 0, 
        960933476, 0, 0, 0, 1921866953, 0, 0, 0, 3843733907, 0, 0, 0, 3392500518, 0, 0, 0, 
        2490033741, 0, 0, 0, 685100186, 0, 0, 0, 1370200372, 0, 0, 0, 2740400744, 0, 0, 0, 
        1185834193, 0, 0, 0, 2371668387, 0, 0, 0, 448369479, 0, 0, 0, 896738958, 0, 0, 0, 
        1793477917, 0, 0, 0, 3586955835, 0, 0, 0, 2887654563, 0, 0, 0, 1480341830, 0, 0, 0, 
        2960683661, 0, 0, 0, 1626400026, 0, 0, 0, 3252800053, 0, 0, 0, 2210632810, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1457526048, 0, 0, 
        0, 2915052096, 0, 0, 0, 1535136897, 0, 0, 0, 3070273795, 0, 0, 0, 1845580294, 0, 0, 
        0, 3691160589, 0, 0, 0, 3087353882, 0, 0, 0, 1879740469, 0, 0, 0, 3759480939, 0, 0, 
        0, 3223994582, 0, 0, 0, 2153021868, 0, 0, 0, 11076440, 0, 0, 0, 22152880, 0, 0, 
        0, 44305760, 0, 0, 0, 88611520, 0, 0, 0, 177223041, 0, 0, 0, 354446082, 0, 0, 
        0, 708892164, 0, 0, 0, 1417784328, 0, 0, 0, 2835568656, 0, 0, 0, 1376170016, 0, 0, 
        0, 2752340033, 0, 0, 0, 1209712771, 0, 0, 0, 2419425542, 0, 0, 0, 543883789, 0, 0, 
        0, 1087767578, 0, 0, 0, 2175535156, 0, 0, 0, 1438123336, 0, 0, 0, 2876246672, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1801783692, 0, 0, 0, 3603567385, 0, 0, 0, 2912167474, 0, 0, 0, 1529367653, 0, 
        0, 0, 3058735306, 0, 0, 0, 1822503316, 0, 0, 0, 3645006633, 0, 0, 0, 2995045970, 0, 
        0, 0, 1695124645, 0, 0, 0, 3390249290, 0, 0, 0, 2485531285, 0, 0, 0, 676095274, 0, 
        0, 0, 1352190548, 0, 0, 0, 2704381097, 0, 0, 0, 1113794898, 0, 0, 0, 4020460328, 0, 
        0, 0, 3745953360, 0, 0, 0, 3196939425, 0, 0, 0, 2098911554, 0, 0, 0, 4197823108, 0, 
        0, 0, 4100678921, 0, 0, 0, 3906390547, 0, 0, 0, 3517813798, 0, 0, 0, 2740660300, 0, 
        0, 0, 1186353304, 0, 0, 0, 2372706609, 0, 0, 0, 450445923, 0, 0, 0, 900891846, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42029323, 
        0, 0, 0, 84058646, 0, 0, 0, 168117293, 0, 0, 0, 336234586, 0, 0, 0, 672469172, 
        0, 0, 0, 1344938344, 0, 0, 0, 2689876689, 0, 0, 0, 1084786082, 0, 0, 0, 2169572165, 
        0, 0, 0, 44177035, 0, 0, 0, 88354071, 0, 0, 0, 176708143, 0, 0, 0, 353416286, 
        0, 0, 0, 706832573, 0, 0, 0, 1413665147, 0, 0, 0, 2827330294, 0, 0, 0, 1359693292, 
        0, 0, 0, 2719386585, 0, 0, 0, 1143805874, 0, 0, 0, 2287611749, 0, 0, 0, 280256202, 
        0, 0, 0, 560512405, 0, 0, 0, 1078995489, 0, 0, 0, 2157990978, 0, 0, 0, 21014661, 
    },
    {
        0, 0, 0, 0, 3480795388, 0, 0, 0, 2666623480, 0, 0, 0, 1038279664, 0, 0, 0, 
        2076559329, 0, 0, 0, 4153118658, 0, 0, 0, 4011270020, 0, 0, 0, 3727572744, 0, 0, 0, 
        3160178193, 0, 0, 0, 2025389090, 0, 0, 0, 4050778181, 0, 0, 0, 3806589066, 0, 0, 0, 
        3318210837, 0, 0, 0, 2341454378, 0, 0, 0, 387941461, 0, 0, 0, 775882923, 0, 0, 0, 
        1551765846, 0, 0, 0, 3103531693, 0, 0, 0, 1912096090, 0, 0, 0, 3824192180, 0, 0, 0, 
        3353417064, 0, 0, 0, 2411866832, 0, 0, 0, 528766369, 0, 0, 0, 1057532739, 0, 0, 0, 
        2115065479, 0, 0, 0, 4230130959, 0, 0, 0, 926802659, 0, 0, 0, 1853605319, 0, 0, 0, 
        3707210639, 0, 0, 0, 3119453983, 0, 0, 0, 1943940671, 0, 0, 0, 3887881342, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4124527681, 0, 0, 
        0, 3954088066, 0, 0, 0, 3613208836, 0, 0, 0, 2931450376, 0, 0, 0, 1567933457, 0, 0, 
        0, 3135866914, 0, 0, 0, 1976766533, 0, 0, 0, 3953533066, 0, 0, 0, 3612098836, 0, 0, 
        0, 2929230376, 0, 0, 0, 1563493457, 0, 0, 0, 3126986914, 0, 0, 0, 1959006533, 0, 0, 
        0, 3918013066, 0, 0, 0, 3541058836, 0, 0, 0, 2787150377, 0, 0, 0, 1279333459, 0, 0, 
        0, 2558666919, 0, 0, 0, 822366543, 0, 0, 0, 1644733087, 0, 0, 0, 3289466174, 0, 0, 
        0, 2283965053, 0, 0, 0, 272962810, 0, 0, 0, 545925621, 0, 0, 0, 1091851242, 0, 0, 
        0, 2183702484, 0, 0, 0, 72437672, 0, 0, 0, 4252357392, 0, 0, 0, 4209747488, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2656366736, 0, 0, 0, 1017766176, 0, 0, 0, 2035532352, 0, 0, 0, 4071064704, 0, 
        0, 0, 3847162112, 0, 0, 0, 3399356928, 0, 0, 0, 2503746561, 0, 0, 0, 712525826, 0, 
        0, 0, 1425051652, 0, 0, 0, 2850103304, 0, 0, 0, 1405239313, 0, 0, 0, 2810478627, 0, 
        0, 0, 1325989958, 0, 0, 0, 2651979917, 0, 0, 0, 1008992539, 0, 0, 0, 3860656807, 0, 
        0, 0, 3426346319, 0, 0, 0, 2557725342, 0, 0, 0, 820483388, 0, 0, 0, 1640966776, 0, 
        0, 0, 3281933552, 0, 0, 0, 2268899809, 0, 0, 0, 242832322, 0, 0, 0, 485664644, 0, 
        0, 0, 971329289, 0, 0, 0, 1942658578, 0, 0, 0, 3885317156, 0, 0, 0, 3475667016, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 537135248, 
        0, 0, 0, 1074270496, 0, 0, 0, 2148540992, 0, 0, 0, 2114688, 0, 0, 0, 4229377, 
        0, 0, 0, 8458754, 0, 0, 0, 16917508, 0, 0, 0, 33835017, 0, 0, 0, 67670034, 
        0, 0, 0, 135340068, 0, 0, 0, 270680136, 0, 0, 0, 541360273, 0, 0, 0, 1082720546, 
        0, 0, 0, 2165441092, 0, 0, 0, 35914889, 0, 0, 0, 71829779, 0, 0, 0, 143659558, 
        0, 0, 0, 287319116, 0, 0, 0, 574638232, 0, 0, 0, 1149276464, 0, 0, 0, 2298552928, 
        0, 0, 0, 302138561, 0, 0, 0, 67141906, 0, 0, 0, 134283812, 0, 0, 0, 268567624, 
    },
    {
        0, 0, 0, 0, 460238757, 0, 0, 0, 920477515, 0, 0, 0, 1840955030, 0, 0, 0, 
        3681910060, 0, 0, 0, 3068852824, 0, 0, 0, 1842738352, 0, 0, 0, 3685476704, 0, 0, 0, 
        3075986112, 0, 0, 0, 1857004929, 0, 0, 0, 3714009859, 0, 0, 0, 3133052422, 0, 0, 0, 
        1971137548, 0, 0, 0, 3942275096, 0, 0, 0, 3589582897, 0, 0, 0, 2884198498, 0, 0, 0, 
        1473429701, 0, 0, 0, 2946859402, 0, 0, 0, 1598751509, 0, 0, 0, 3197503018, 0, 0, 0, 
        2100038740, 0, 0, 0, 4200077480, 0, 0, 0, 4105187665, 0, 0, 0, 3915408035, 0, 0, 0, 
        3535848774, 0, 0, 0, 2776730253, 0, 0, 0, 1349368510, 0, 0, 0, 2698737021, 0, 0, 0, 
        1102506746, 0, 0, 0, 2205013492, 0, 0, 0, 115059689, 0, 0, 0, 230119378, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3560175108, 0, 0, 
        0, 2825382920, 0, 0, 0, 1355798544, 0, 0, 0, 2711597089, 0, 0, 0, 1128226882, 0, 0, 
        0, 2256453764, 0, 0, 0, 217940233, 0, 0, 0, 435880467, 0, 0, 0, 871760935, 0, 0, 
        0, 1743521871, 0, 0, 0, 3487043743, 0, 0, 0, 2679120191, 0, 0, 0, 1063273086, 0, 0, 
        0, 2126546172, 0, 0, 0, 4253092344, 0, 0, 0, 4211217392, 0, 0, 0, 4127467489, 0, 0, 
        0, 3959967682, 0, 0, 0, 3624968069, 0, 0, 0, 2954968843, 0, 0, 0, 1614970391, 0, 0, 
        0, 3229940782, 0, 0, 0, 2164914268, 0, 0, 0, 34861240, 0, 0, 0, 69722480, 0, 0, 
        0, 139444961, 0, 0, 0, 278889922, 0, 0, 0, 4111269249, 0, 0, 0, 3927571202, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2424557694, 0, 0, 0, 554148093, 0, 0, 0, 1108296186, 0, 0, 0, 2216592373, 0, 
        0, 0, 138217450, 0, 0, 0, 276434901, 0, 0, 0, 552869802, 0, 0, 0, 1105739604, 0, 
        0, 0, 2211479208, 0, 0, 0, 127991121, 0, 0, 0, 255982243, 0, 0, 0, 511964486, 0, 
        0, 0, 1023928972, 0, 0, 0, 2047857944, 0, 0, 0, 4095715888, 0, 0, 0, 2025620510, 0, 
        0, 0, 4051241021, 0, 0, 0, 3807514746, 0, 0, 0, 3320062196, 0, 0, 0, 2345157096, 0, 
        0, 0, 395346896, 0, 0, 0, 790693792, 0, 0, 0, 1581387585, 0, 0, 0, 3162775171, 0, 
        0, 0, 2030583047, 0, 0, 0, 4061166095, 0, 0, 0, 3827364895, 0, 0, 0, 3359762495, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1048576, 
        0, 0, 0, 2097152, 0, 0, 0, 4194305, 0, 0, 0, 8388610, 0, 0, 0, 16777220, 
        0, 0, 0, 33554441, 0, 0, 0, 67108882, 0, 0, 0, 134217764, 0, 0, 0, 268435528, 
        0, 0, 0, 536871056, 0, 0, 0, 1073742112, 0, 0, 0, 2147484224, 0, 0, 0, 1152, 
        0, 0, 0, 2304, 0, 0, 0, 4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 
        0, 0, 0, 36864, 0, 0, 0, 73728, 0, 0, 0, 147456, 0, 0, 0, 294912, 
        0, 0, 0, 589824, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 
    },
    {
        0, 0, 0, 0, 1980210557, 0, 0, 0, 3960421115, 0, 0, 0, 3625874935, 0, 0, 0, 
        2956782575, 0, 0, 0, 1618597854, 0, 0, 0, 3237195709, 0, 0, 0, 2179424123, 0, 0, 0, 
        63880951, 0, 0, 0, 127761903, 0, 0, 0, 255523807, 0, 0, 0, 511047615, 0, 0, 0, 
        1022095230, 0, 0, 0, 2044190460, 0, 0, 0, 4088380920, 0, 0, 0, 3881794544, 0, 0, 0, 
        3468621792, 0, 0, 0, 2642276289, 0, 0, 0, 989585283, 0, 0, 0, 1979170566, 0, 0, 0, 
        3958341132, 0, 0, 0, 3621714968, 0, 0, 0, 2948462640, 0, 0, 0, 1601957985, 0, 0, 0, 
        3203915970, 0, 0, 0, 2112864644, 0, 0, 0, 2379751029, 0, 0, 0, 464534763, 0, 0, 0, 
        929069527, 0, 0, 0, 1858139055, 0, 0, 0, 3716278111, 0, 0, 0, 3137588926, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3625984309, 0, 0, 
        0, 2957001323, 0, 0, 0, 1619035351, 0, 0, 0, 3238070702, 0, 0, 0, 2181174108, 0, 0, 
        0, 67380920, 0, 0, 0, 134761841, 0, 0, 0, 269523682, 0, 0, 0, 539047365, 0, 0, 
        0, 1078094730, 0, 0, 0, 2156189460, 0, 0, 0, 17411624, 0, 0, 0, 34823248, 0, 0, 
        0, 69646496, 0, 0, 0, 139292993, 0, 0, 0, 278585986, 0, 0, 0, 557171973, 0, 0, 
        0, 1114343946, 0, 0, 0, 2228687892, 0, 0, 0, 162408489, 0, 0, 0, 324816978, 0, 0, 
        0, 649633957, 0, 0, 0, 1299267915, 0, 0, 0, 2598535831, 0, 0, 0, 902104367, 0, 0, 
        0, 1804208734, 0, 0, 0, 3608417468, 0, 0, 0, 1980237901, 0, 0, 0, 3960475802, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 70539992, 0, 0, 0, 141079985, 0, 0, 0, 282159971, 0, 0, 0, 564319943, 0, 
        0, 0, 1128639887, 0, 0, 0, 2257279774, 0, 0, 0, 219592253, 0, 0, 0, 439184507, 0, 
        0, 0, 878369014, 0, 0, 0, 1756738029, 0, 0, 0, 3513476059, 0, 0, 0, 2731984823, 0, 
        0, 0, 1169002351, 0, 0, 0, 2338004702, 0, 0, 0, 381042109, 0, 0, 0, 693641634, 0, 
        0, 0, 1387283269, 0, 0, 0, 2774566539, 0, 0, 0, 1254165782, 0, 0, 0, 2508331565, 0, 
        0, 0, 721695834, 0, 0, 0, 1443391669, 0, 0, 0, 2886783339, 0, 0, 0, 1478599382, 0, 
        0, 0, 2957198765, 0, 0, 0, 1619430235, 0, 0, 0, 3238860470, 0, 0, 0, 2182753644, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33280, 
        0, 0, 0, 66560, 0, 0, 0, 133120, 0, 0, 0, 266240, 0, 0, 0, 532480, 
        0, 0, 0, 1064960, 0, 0, 0, 2129920, 0, 0, 0, 4259841, 0, 0, 0, 8519682, 
        0, 0, 0, 17039364, 0, 0, 0, 34078729, 0, 0, 0, 68157458, 0, 0, 0, 136314916, 
        0, 0, 0, 272629833, 0, 0, 0, 545259666, 0, 0, 0, 1090519332, 0, 0, 0, 2181038665, 
        0, 0, 0, 67110034, 0, 0, 0, 134220068, 0, 0, 0, 268440136, 0, 0, 0, 536880272, 
        0, 0, 0, 1073760544, 0, 0, 0, 2147487808, 0, 0, 0, 8320, 0, 0, 0, 16640, 
    },
    {
        0, 0, 0, 0, 893107048, 0, 0, 0, 1786214097, 0, 0, 0, 3572428195, 0, 0, 0, 
        2849889095, 0, 0, 0, 1404810895, 0, 0, 0, 2809621790, 0, 0, 0, 1324276285, 0, 0, 0, 
        2648552571, 0, 0, 0, 1002137847, 0, 0, 0, 2004275695, 0, 0, 0, 4008551390, 0, 0, 0, 
        3722135485, 0, 0, 0, 3149303674, 0, 0, 0, 2003640053, 0, 0, 0, 4007280106, 0, 0, 0, 
        3719592917, 0, 0, 0, 3144218538, 0, 0, 0, 1993469781, 0, 0, 0, 3986939563, 0, 0, 0, 
        3678911830, 0, 0, 0, 3062856364, 0, 0, 0, 1830745432, 0, 0, 0, 3661490864, 0, 0, 0, 
        3028014433, 0, 0, 0, 1761061570, 0, 0, 0, 3839160045, 0, 0, 0, 3383352795, 0, 0, 0, 
        2471738294, 0, 0, 0, 648509293, 0, 0, 0, 1297018586, 0, 0, 0, 2594037172, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99817600, 0, 0, 
        0, 199635201, 0, 0, 0, 399270402, 0, 0, 0, 798540804, 0, 0, 0, 1597081609, 0, 0, 
        0, 3194163218, 0, 0, 0, 2093359140, 0, 0, 0, 4186718280, 0, 0, 0, 4078469265, 0, 0, 
        0, 3861971235, 0, 0, 0, 3428975175, 0, 0, 0, 2562983055, 0, 0, 0, 830998815, 0, 0, 
        0, 1661997631, 0, 0, 0, 3323995262, 0, 0, 0, 2353023229, 0, 0, 0, 411079163, 0, 0, 
        0, 822158327, 0, 0, 0, 1644316655, 0, 0, 0, 3288633310, 0, 0, 0, 2282299325, 0, 0, 
        0, 269631354, 0, 0, 0, 539262709, 0, 0, 0, 1078525418, 0, 0, 0, 2157050836, 0, 0, 
        0, 19134376, 0, 0, 0, 38268752, 0, 0, 0, 24954400, 0, 0, 0, 49908800, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1770227281, 0, 0, 0, 3540454563, 0, 0, 0, 2785941830, 0, 0, 0, 1276916364, 0, 
        0, 0, 2553832729, 0, 0, 0, 812698162, 0, 0, 0, 1625396325, 0, 0, 0, 3250792650, 0, 
        0, 0, 2206618004, 0, 0, 0, 118268713, 0, 0, 0, 236537426, 0, 0, 0, 473074852, 0, 
        0, 0, 946149705, 0, 0, 0, 1892299411, 0, 0, 0, 3784598822, 0, 0, 0, 2863352860, 0, 
        0, 0, 1431738424, 0, 0, 0, 2863476848, 0, 0, 0, 1431986401, 0, 0, 0, 2863972803, 0, 
        0, 0, 1432978310, 0, 0, 0, 2865956620, 0, 0, 0, 1436945945, 0, 0, 0, 2873891890, 0, 
        0, 0, 1452816485, 0, 0, 0, 2905632970, 0, 0, 0, 1516298644, 0, 0, 0, 3032597288, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180224, 
        0, 0, 0, 360448, 0, 0, 0, 720896, 0, 0, 0, 1441792, 0, 0, 0, 2883584, 
        0, 0, 0, 5767169, 0, 0, 0, 11534338, 0, 0, 0, 23068677, 0, 0, 0, 46137354, 
        0, 0, 0, 92274708, 0, 0, 0, 184549417, 0, 0, 0, 369098835, 0, 0, 0, 738197670, 
        0, 0, 0, 1476395340, 0, 0, 0, 2952790680, 0, 0, 0, 1610614064, 0, 0, 0, 3221228128, 
        0, 0, 0, 2147488960, 0, 0, 0, 10624, 0, 0, 0, 21248, 0, 0, 0, 42496, 
        0, 0, 0, 84992, 0, 0, 0, 22528, 0, 0, 0, 45056, 0, 0, 0, 90112, 
    },
    {
        0, 0, 0, 0, 2113541784, 0, 0, 0, 4227083568, 0, 0, 0, 4159199840, 0, 0, 0, 
        4023432384, 0, 0, 0, 3751897472, 0, 0, 0, 3208827648, 0, 0, 0, 2122688001, 0, 0, 0, 
        4245376003, 0, 0, 0, 4195784710, 0, 0, 0, 4096602125, 0, 0, 0, 3898236955, 0, 0, 0, 
        3501506615, 0, 0, 0, 2708045935, 0, 0, 0, 1121124575, 0, 0, 0, 2242249151, 0, 0, 0, 
        189531007, 0, 0, 0, 379062015, 0, 0, 0, 758124030, 0, 0, 0, 1516248061, 0, 0, 0, 
        3032496123, 0, 0, 0, 1770024950, 0, 0, 0, 3540049900, 0, 0, 0, 2785132504, 0, 0, 0, 
        1275297712, 0, 0, 0, 2550595425, 0, 0, 0, 1308092506, 0, 0, 0, 2616185012, 0, 0, 0, 
        937402729, 0, 0, 0, 1874805459, 0, 0, 0, 3749610918, 0, 0, 0, 3204254540, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1409835056, 0, 0, 
        0, 2819670112, 0, 0, 0, 1344372928, 0, 0, 0, 2688745857, 0, 0, 0, 1082524418, 0, 0, 
        0, 2165048836, 0, 0, 0, 35130376, 0, 0, 0, 70260752, 0, 0, 0, 140521505, 0, 0, 
        0, 281043010, 0, 0, 0, 562086021, 0, 0, 0, 1124172042, 0, 0, 0, 2248344084, 0, 0, 
        0, 201720873, 0, 0, 0, 403441747, 0, 0, 0, 806883495, 0, 0, 0, 1613766991, 0, 0, 
        0, 3227533982, 0, 0, 0, 2160100668, 0, 0, 0, 25234040, 0, 0, 0, 50468080, 0, 0, 
        0, 100936160, 0, 0, 0, 201872321, 0, 0, 0, 403744643, 0, 0, 0, 807489287, 0, 0, 
        0, 1614978575, 0, 0, 0, 3229957150, 0, 0, 0, 3573684236, 0, 0, 0, 2852401176, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 302254233, 0, 0, 0, 604508466, 0, 0, 0, 1209016932, 0, 0, 0, 2418033865, 0, 
        0, 0, 541100435, 0, 0, 0, 1082200870, 0, 0, 0, 2164401740, 0, 0, 0, 33836184, 0, 
        0, 0, 67672369, 0, 0, 0, 135344738, 0, 0, 0, 270689477, 0, 0, 0, 541378955, 0, 
        0, 0, 1082757911, 0, 0, 0, 2165515822, 0, 0, 0, 36064348, 0, 0, 0, 373854240, 0, 
        0, 0, 747708480, 0, 0, 0, 1495416961, 0, 0, 0, 2990833922, 0, 0, 0, 1686700548, 0, 
        0, 0, 3373401096, 0, 0, 0, 2451834897, 0, 0, 0, 608702498, 0, 0, 0, 1217404996, 0, 
        0, 0, 2434809993, 0, 0, 0, 574652691, 0, 0, 0, 1149305382, 0, 0, 0, 2298610764, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37905416, 
        0, 0, 0, 75810832, 0, 0, 0, 151621664, 0, 0, 0, 303243329, 0, 0, 0, 606486658, 
        0, 0, 0, 1212973317, 0, 0, 0, 2425946634, 0, 0, 0, 556925972, 0, 0, 0, 1113851944, 
        0, 0, 0, 2227703889, 0, 0, 0, 160440482, 0, 0, 0, 320880965, 0, 0, 0, 641761930, 
        0, 0, 0, 1283523860, 0, 0, 0, 2567047720, 0, 0, 0, 839128145, 0, 0, 0, 1678256290, 
        0, 0, 0, 3356512580, 0, 0, 0, 2418057864, 0, 0, 0, 541148433, 0, 0, 0, 1082296866, 
        0, 0, 0, 2164593732, 0, 0, 0, 4738177, 0, 0, 0, 9476354, 0, 0, 0, 18952708, 
    },
    {
        0, 0, 0, 0, 307855197, 0, 0, 0, 615710394, 0, 0, 0, 1231420788, 0, 0, 0, 
        2462841576, 0, 0, 0, 630715856, 0, 0, 0, 1261431713, 0, 0, 0, 2522863426, 0, 0, 0, 
        750759556, 0, 0, 0, 1501519112, 0, 0, 0, 3003038224, 0, 0, 0, 1711109152, 0, 0, 0, 
        3422218304, 0, 0, 0, 2549469312, 0, 0, 0, 803971329, 0, 0, 0, 1607942659, 0, 0, 0, 
        3215885318, 0, 0, 0, 2136803341, 0, 0, 0, 4273606682, 0, 0, 0, 4252246069, 0, 0, 0, 
        4209524842, 0, 0, 0, 4124082389, 0, 0, 0, 3953197482, 0, 0, 0, 3611427668, 0, 0, 0, 
        2927888040, 0, 0, 0, 1560808784, 0, 0, 0, 2823382525, 0, 0, 0, 1351797754, 0, 0, 0, 
        2703595509, 0, 0, 0, 1112223723, 0, 0, 0, 2224447447, 0, 0, 0, 153927598, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1430273920, 0, 0, 
        0, 2860547840, 0, 0, 0, 1426128384, 0, 0, 0, 2852256768, 0, 0, 0, 1409546240, 0, 0, 
        0, 2819092480, 0, 0, 0, 1343217664, 0, 0, 0, 2686435329, 0, 0, 0, 1077903362, 0, 0, 
        0, 2155806724, 0, 0, 0, 16646152, 0, 0, 0, 33292304, 0, 0, 0, 66584608, 0, 0, 
        0, 133169216, 0, 0, 0, 266338433, 0, 0, 0, 532676867, 0, 0, 0, 1065353734, 0, 0, 
        0, 2130707468, 0, 0, 0, 4261414936, 0, 0, 0, 4227862576, 0, 0, 0, 4160757856, 0, 0, 
        0, 4026548417, 0, 0, 0, 3758129539, 0, 0, 0, 3221291782, 0, 0, 0, 2147616268, 0, 0, 
        0, 265240, 0, 0, 0, 530480, 0, 0, 0, 1431310304, 0, 0, 0, 2862620608, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 536903683, 0, 0, 0, 1073807366, 0, 0, 0, 2147614732, 0, 0, 0, 262168, 0, 
        0, 0, 524336, 0, 0, 0, 1048672, 0, 0, 0, 2097344, 0, 0, 0, 4194688, 0, 
        0, 0, 8389376, 0, 0, 0, 16778752, 0, 0, 0, 33557504, 0, 0, 0, 67115008, 0, 
        0, 0, 134230016, 0, 0, 0, 268460033, 0, 0, 0, 536920067, 0, 0, 0, 1610678276, 0, 
        0, 0, 3221356552, 0, 0, 0, 2147745808, 0, 0, 0, 524320, 0, 0, 0, 1048640, 0, 
        0, 0, 2097280, 0, 0, 0, 4194560, 0, 0, 0, 8389120, 0, 0, 0, 16778240, 0, 
        0, 0, 33556480, 0, 0, 0, 67112960, 0, 0, 0, 134225920, 0, 0, 0, 268451841, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2731147994, 
        0, 0, 0, 1167328692, 0, 0, 0, 2334657385, 0, 0, 0, 374347474, 0, 0, 0, 748694948, 
        0, 0, 0, 1497389897, 0, 0, 0, 2994779795, 0, 0, 0, 1694592294, 0, 0, 0, 3389184589, 
        0, 0, 0, 2483401882, 0, 0, 0, 671836468, 0, 0, 0, 1343672936, 0, 0, 0, 2687345872, 
        0, 0, 0, 1079724449, 0, 0, 0, 2159448898, 0, 0, 0, 23930501, 0, 0, 0, 47861002, 
        0, 0, 0, 95722004, 0, 0, 0, 191444008, 0, 0, 0, 382888016, 0, 0, 0, 765776032, 
        0, 0, 0, 1531552064, 0, 0, 0, 341393499, 0, 0, 0, 682786998, 0, 0, 0, 1365573997, 
    },
    {
        0, 0, 0, 0, 1769338744, 0, 0, 0, 3538677488, 0, 0, 0, 2782387681, 0, 0, 0, 
        1269808067, 0, 0, 0, 2539616134, 0, 0, 0, 784264973, 0, 0, 0, 1568529946, 0, 0, 0, 
        3137059892, 0, 0, 0, 1979152488, 0, 0, 0, 3958304976, 0, 0, 0, 3621642656, 0, 0, 0, 
        2948318016, 0, 0, 0, 1601668737, 0, 0, 0, 3203337474, 0, 0, 0, 2111707652, 0, 0, 0, 
        4223415304, 0, 0, 0, 4151863312, 0, 0, 0, 4008759328, 0, 0, 0, 3722551361, 0, 0, 0, 
        3150135426, 0, 0, 0, 2005303557, 0, 0, 0, 4010607114, 0, 0, 0, 3726246932, 0, 0, 0, 
        3157526569, 0, 0, 0, 2020085842, 0, 0, 0, 2577782749, 0, 0, 0, 860598203, 0, 0, 0, 
        1721196407, 0, 0, 0, 3442392815, 0, 0, 0, 2589818334, 0, 0, 0, 884669372, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4294705152, 0, 0, 
        0, 4294443008, 0, 0, 0, 4293918720, 0, 0, 0, 4292870144, 0, 0, 0, 4290772992, 0, 0, 
        0, 4286578688, 0, 0, 0, 4278190080, 0, 0, 0, 4261412864, 0, 0, 0, 4227858432, 0, 0, 
        0, 4160749568, 0, 0, 0, 4026531841, 0, 0, 0, 3758096387, 0, 0, 0, 3221225478, 0, 0, 
        0, 2147483660, 0, 0, 0, 24, 0, 0, 0, 48, 0, 0, 0, 96, 0, 0, 
        0, 192, 0, 0, 0, 384, 0, 0, 0, 768, 0, 0, 0, 1536, 0, 0, 
        0, 3072, 0, 0, 0, 6144, 0, 0, 0, 12288, 0, 0, 0, 24576, 0, 0, 
        0, 49152, 0, 0, 0, 98304, 0, 0, 0, 4294901760, 0, 0, 0, 4294836224, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 262152, 0, 0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 
        0, 0, 4194432, 0, 0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 
        0, 0, 67110912, 0, 0, 0, 134221824, 0, 0, 0, 268443649, 0, 0, 0, 536887298, 0, 
        0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 0, 0, 131092, 0, 0, 0, 32, 0, 
        0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 
        0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 
        0, 0, 16384, 0, 0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3732057110, 
        0, 0, 0, 3169146925, 0, 0, 0, 2043326555, 0, 0, 0, 4086653111, 0, 0, 0, 3878338927, 
        0, 0, 0, 3461710558, 0, 0, 0, 2628453820, 0, 0, 0, 961940345, 0, 0, 0, 1923880691, 
        0, 0, 0, 3847761383, 0, 0, 0, 3400555471, 0, 0, 0, 2506143647, 0, 0, 0, 717319998, 
        0, 0, 0, 1434639996, 0, 0, 0, 2869279993, 0, 0, 0, 1443592691, 0, 0, 0, 2887185382, 
        0, 0, 0, 1479403468, 0, 0, 0, 2958806937, 0, 0, 0, 1622646578, 0, 0, 0, 3245293157, 
        0, 0, 0, 2195619018, 0, 0, 0, 3687732610, 0, 0, 0, 3080497925, 0, 0, 0, 1866028555, 
    },
    {
        0, 0, 0, 0, 2045181768, 0, 0, 0, 4090363536, 0, 0, 0, 3885759776, 0, 0, 0, 
        3476552256, 0, 0, 0, 2658137216, 0, 0, 0, 1021307136, 0, 0, 0, 2042614272, 0, 0, 0, 
        4085228544, 0, 0, 0, 3875489792, 0, 0, 0, 3456012289, 0, 0, 0, 2617057282, 0, 0, 0, 
        939147269, 0, 0, 0, 1878294539, 0, 0, 0, 3756589078, 0, 0, 0, 3218210860, 0, 0, 0, 
        2141454425, 0, 0, 0, 4282908850, 0, 0, 0, 4270850404, 0, 0, 0, 4246733513, 0, 0, 0, 
        4198499730, 0, 0, 0, 4102032165, 0, 0, 0, 3909097035, 0, 0, 0, 3523226774, 0, 0, 0, 
        2751486253, 0, 0, 0, 1208005210, 0, 0, 0, 3924270077, 0, 0, 0, 3553572858, 0, 0, 0, 
        2812178420, 0, 0, 0, 1329389545, 0, 0, 0, 2658779090, 0, 0, 0, 1022590884, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 
        0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 
        0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 
        0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 
        0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 
        0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554432, 0, 0, 
        0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 0, 536870917, 0, 0, 
        0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1073774613, 0, 0, 0, 2147549226, 0, 0, 0, 131156, 0, 0, 0, 262312, 0, 
        0, 0, 524624, 0, 0, 0, 1049248, 0, 0, 0, 2098496, 0, 0, 0, 4196992, 0, 
        0, 0, 8393984, 0, 0, 0, 16787968, 0, 0, 0, 33575936, 0, 0, 0, 67151873, 0, 
        0, 0, 134303746, 0, 0, 0, 268607492, 0, 0, 0, 537214984, 0, 0, 0, 655364, 0, 
        0, 0, 1310728, 0, 0, 0, 2621456, 0, 0, 0, 5242912, 0, 0, 0, 10485824, 0, 
        0, 0, 20971648, 0, 0, 0, 41943296, 0, 0, 0, 83886592, 0, 0, 0, 167773184, 0, 
        0, 0, 335546369, 0, 0, 0, 671092738, 0, 0, 0, 1342185477, 0, 0, 0, 2684370954, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2033130968, 
        0, 0, 0, 4066261936, 0, 0, 0, 3837556576, 0, 0, 0, 3380145857, 0, 0, 0, 2465324418, 
        0, 0, 0, 635681541, 0, 0, 0, 1271363082, 0, 0, 0, 2542726165, 0, 0, 0, 790485035, 
        0, 0, 0, 1580970071, 0, 0, 0, 3161940143, 0, 0, 0, 2028912991, 0, 0, 0, 4057825983, 
        0, 0, 0, 3820684671, 0, 0, 0, 3346402046, 0, 0, 0, 2397836796, 0, 0, 0, 500706297, 
        0, 0, 0, 1001412595, 0, 0, 0, 2002825190, 0, 0, 0, 4005650380, 0, 0, 0, 3716333464, 
        0, 0, 0, 3137699633, 0, 0, 0, 254141371, 0, 0, 0, 508282742, 0, 0, 0, 1016565484, 
    },
    {
        0, 0, 0, 0, 698651200, 0, 0, 0, 1397302401, 0, 0, 0, 2794604802, 0, 0, 0, 
        1294242308, 0, 0, 0, 2588484616, 0, 0, 0, 882001936, 0, 0, 0, 1764003872, 0, 0, 0, 
        3528007744, 0, 0, 0, 2761048193, 0, 0, 0, 1227129090, 0, 0, 0, 2454258180, 0, 0, 0, 
        613549064, 0, 0, 0, 1227098128, 0, 0, 0, 2454196256, 0, 0, 0, 613425216, 0, 0, 0, 
        1226850432, 0, 0, 0, 2453700864, 0, 0, 0, 612434432, 0, 0, 0, 1224868864, 0, 0, 0, 
        2449737728, 0, 0, 0, 604508160, 0, 0, 0, 1209016320, 0, 0, 0, 2418032641, 0, 0, 0, 
        541097986, 0, 0, 0, 1082195972, 0, 0, 0, 2829488713, 0, 0, 0, 1364010130, 0, 0, 0, 
        2728020260, 0, 0, 0, 1161073224, 0, 0, 0, 2322146448, 0, 0, 0, 349325600, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 18087960, 0, 0, 0, 36175920, 0, 0, 0, 72351840, 0, 0, 0, 144703680, 0, 
        0, 0, 289407361, 0, 0, 0, 578814722, 0, 0, 0, 1157629444, 0, 0, 0, 2315258888, 0, 
        0, 0, 335550481, 0, 0, 0, 671100962, 0, 0, 0, 1342201925, 0, 0, 0, 2684403851, 0, 
        0, 0, 1073840407, 0, 0, 0, 2147680814, 0, 0, 0, 394332, 0, 0, 0, 18352288, 0, 
        0, 0, 36704576, 0, 0, 0, 73409152, 0, 0, 0, 146818304, 0, 0, 0, 293636608, 0, 
        0, 0, 587273216, 0, 0, 0, 1174546432, 0, 0, 0, 2349092864, 0, 0, 0, 403218432, 0, 
        0, 0, 806436865, 0, 0, 0, 1612873731, 0, 0, 0, 3225747462, 0, 0, 0, 2156527628, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2199499341, 
        0, 0, 0, 104031387, 0, 0, 0, 208062775, 0, 0, 0, 416125551, 0, 0, 0, 832251102, 
        0, 0, 0, 1664502205, 0, 0, 0, 3329004410, 0, 0, 0, 2363041525, 0, 0, 0, 431115754, 
        0, 0, 0, 862231508, 0, 0, 0, 1724463016, 0, 0, 0, 3448926032, 0, 0, 0, 2602884769, 
        0, 0, 0, 910802242, 0, 0, 0, 1821604484, 0, 0, 0, 3643208968, 0, 0, 0, 2991450640, 
        0, 0, 0, 1687933984, 0, 0, 0, 3375867968, 0, 0, 0, 2456768640, 0, 0, 0, 618569985, 
        0, 0, 0, 1237139970, 0, 0, 0, 274937417, 0, 0, 0, 549874835, 0, 0, 0, 1099749670, 
    },
    {
        0, 0, 0, 0, 1226833920, 0, 0, 0, 2453667840, 0, 0, 0, 612368384, 0, 0, 0, 
        1224736768, 0, 0, 0, 2449473536, 0, 0, 0, 603979776, 0, 0, 0, 1207959552, 0, 0, 0, 
        2415919105, 0, 0, 0, 536870914, 0, 0, 0, 1073741828, 0, 0, 0, 2147483657, 0, 0, 0, 
        18, 0, 0, 0, 36, 0, 0, 0, 72, 0, 0, 0, 144, 0, 0, 0, 
        288, 0, 0, 0, 576, 0, 0, 0, 1152, 0, 0, 0, 2304, 0, 0, 0, 
        4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 0, 0, 0, 36864, 0, 0, 0, 
        73728, 0, 0, 0, 147456, 0, 0, 0, 1227128832, 0, 0, 0, 2454257664, 0, 0, 0, 
        613548032, 0, 0, 0, 1227096064, 0, 0, 0, 2454192128, 0, 0, 0, 613416960, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 2560, 0, 0, 0, 5120, 0, 0, 
        0, 10240, 0, 0, 0, 20480, 0, 0, 0, 40960, 0, 0, 0, 81920, 0, 0, 
        0, 163840, 0, 0, 0, 327680, 0, 0, 0, 655360, 0, 0, 0, 1310720, 0, 0, 
        0, 2621440, 0, 0, 0, 5242880, 0, 0, 0, 10485760, 0, 0, 0, 20971520, 0, 0, 
        0, 41943040, 0, 0, 0, 83886080, 0, 0, 0, 167772161, 0, 0, 0, 335544322, 0, 0, 
        0, 671088644, 0, 0, 0, 1342177288, 0, 0, 0, 2684354577, 0, 0, 0, 1073741858, 0, 0, 
        0, 2147483716, 0, 0, 0, 136, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1417720836, 0, 0, 0, 2835441672, 0, 0, 0, 1375916048, 0, 0, 0, 2751832097, 0, 
        0, 0, 1208696898, 0, 0, 0, 2417393796, 0, 0, 0, 539820296, 0, 0, 0, 1079640592, 0, 
        0, 0, 2159281184, 0, 0, 0, 23595072, 0, 0, 0, 47190144, 0, 0, 0, 94380288, 0, 
        0, 0, 188760576, 0, 0, 0, 377521152, 0, 0, 0, 755042304, 0, 0, 0, 243442693, 0, 
        0, 0, 486885387, 0, 0, 0, 973770774, 0, 0, 0, 1947541549, 0, 0, 0, 3895083098, 0, 
        0, 0, 3495198900, 0, 0, 0, 2695430504, 0, 0, 0, 1095893712, 0, 0, 0, 2191787424, 0, 
        0, 0, 88607552, 0, 0, 0, 177215104, 0, 0, 0, 354430209, 0, 0, 0, 708860418, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4196822677, 
        0, 0, 0, 4098678059, 0, 0, 0, 3902388822, 0, 0, 0, 3509810348, 0, 0, 0, 2724653400, 
        0, 0, 0, 1154339505, 0, 0, 0, 2308679010, 0, 0, 0, 322390725, 0, 0, 0, 644781450, 
        0, 0, 0, 1289562901, 0, 0, 0, 2579125802, 0, 0, 0, 863284308, 0, 0, 0, 1726568616, 
        0, 0, 0, 3453137233, 0, 0, 0, 2611307171, 0, 0, 0, 927647046, 0, 0, 0, 1855294093, 
        0, 0, 0, 3710588186, 0, 0, 0, 3126209076, 0, 0, 0, 1957450856, 0, 0, 0, 3914901713, 
        0, 0, 0, 3534836131, 0, 0, 0, 1598344658, 0, 0, 0, 3196689317, 0, 0, 0, 2098411338, 
    },
    {
        0, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 
        4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554433, 0, 0, 0, 
        67108866, 0, 0, 0, 134217732, 0, 0, 0, 268435464, 0, 0, 0, 536870928, 0, 0, 0, 
        1073741856, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 260, 0, 0, 0, 
        520, 0, 0, 0, 1040, 0, 0, 0, 2080, 0, 0, 0, 4160, 0, 0, 0, 
        8320, 0, 0, 0, 16640, 0, 0, 0, 33280, 0, 0, 0, 66560, 0, 0, 0, 
        133120, 0, 0, 0, 266240, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 
        32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8421376, 0, 0, 
        0, 16842752, 0, 0, 0, 33685504, 0, 0, 0, 67371008, 0, 0, 0, 134742017, 0, 0, 
        0, 269484034, 0, 0, 0, 538968069, 0, 0, 0, 1077936138, 0, 0, 0, 2155872276, 0, 0, 
        0, 16777256, 0, 0, 0, 33554512, 0, 0, 0, 67109024, 0, 0, 0, 134218049, 0, 0, 
        0, 268436098, 0, 0, 0, 536872197, 0, 0, 0, 1073744394, 0, 0, 0, 2147488788, 0, 0, 
        0, 10280, 0, 0, 0, 20560, 0, 0, 0, 41120, 0, 0, 0, 82240, 0, 0, 
        0, 164480, 0, 0, 0, 328960, 0, 0, 0, 657920, 0, 0, 0, 1315840, 0, 0, 
        0, 2631680, 0, 0, 0, 5263360, 0, 0, 0, 2105344, 0, 0, 0, 4210688, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 844445257, 0, 0, 0, 1688890514, 0, 0, 0, 3377781029, 0, 0, 0, 2460594762, 0, 
        0, 0, 626222228, 0, 0, 0, 1252444457, 0, 0, 0, 2504888914, 0, 0, 0, 714810532, 0, 
        0, 0, 1429621065, 0, 0, 0, 2859242131, 0, 0, 0, 1423516967, 0, 0, 0, 2847033934, 0, 
        0, 0, 1399100572, 0, 0, 0, 2798201144, 0, 0, 0, 1301434992, 0, 0, 0, 2842792617, 0, 
        0, 0, 1390617939, 0, 0, 0, 2781235878, 0, 0, 0, 1267504461, 0, 0, 0, 2535008923, 0, 
        0, 0, 775050550, 0, 0, 0, 1550101100, 0, 0, 0, 3100202201, 0, 0, 0, 1905437106, 0, 
        0, 0, 3810874212, 0, 0, 0, 3326781129, 0, 0, 0, 2358594962, 0, 0, 0, 422222628, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2034053848, 
        0, 0, 0, 4068107696, 0, 0, 0, 3841248097, 0, 0, 0, 3387528899, 0, 0, 0, 2480090502, 
        0, 0, 0, 665213709, 0, 0, 0, 1330427418, 0, 0, 0, 2660854837, 0, 0, 0, 1026742378, 
        0, 0, 0, 2053484756, 0, 0, 0, 4106969513, 0, 0, 0, 3918971730, 0, 0, 0, 3542976165, 
        0, 0, 0, 2790985034, 0, 0, 0, 1287002772, 0, 0, 0, 2574005545, 0, 0, 0, 853043794, 
        0, 0, 0, 1706087588, 0, 0, 0, 3412175176, 0, 0, 0, 2529383056, 0, 0, 0, 763798816, 
        0, 0, 0, 1527597633, 0, 0, 0, 3475482203, 0, 0, 0, 2655997110, 0, 0, 0, 1017026924, 
    },
    {
        0, 0, 0, 0, 8390656, 0, 0, 0, 16781312, 0, 0, 0, 33562625, 0, 0, 0, 
        67125250, 0, 0, 0, 134250500, 0, 0, 0, 268501000, 0, 0, 0, 537002000, 0, 0, 0, 
        1074004000, 0, 0, 0, 2148008001, 0, 0, 0, 1048706, 0, 0, 0, 2097412, 0, 0, 0, 
        4194824, 0, 0, 0, 8389648, 0, 0, 0, 16779296, 0, 0, 0, 33558593, 0, 0, 0, 
        67117186, 0, 0, 0, 134234372, 0, 0, 0, 268468744, 0, 0, 0, 536937488, 0, 0, 0, 
        1073874976, 0, 0, 0, 2147749953, 0, 0, 0, 532610, 0, 0, 0, 1065220, 0, 0, 0, 
        2130440, 0, 0, 0, 4260880, 0, 0, 0, 131104, 0, 0, 0, 262208, 0, 0, 0, 
        524416, 0, 0, 0, 1048832, 0, 0, 0, 2097664, 0, 0, 0, 4195328, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 591396869, 0, 0, 
        0, 1182793738, 0, 0, 0, 2365587477, 0, 0, 0, 436207659, 0, 0, 0, 872415319, 0, 0, 
        0, 1744830638, 0, 0, 0, 3489661276, 0, 0, 0, 2684355257, 0, 0, 0, 1073743218, 0, 0, 
        0, 2147486436, 0, 0, 0, 5576, 0, 0, 0, 11152, 0, 0, 0, 22304, 0, 0, 
        0, 44608, 0, 0, 0, 89216, 0, 0, 0, 178432, 0, 0, 0, 356864, 0, 0, 
        0, 713728, 0, 0, 0, 1427456, 0, 0, 0, 2854912, 0, 0, 0, 5709824, 0, 0, 
        0, 11419648, 0, 0, 0, 22839296, 0, 0, 0, 45678592, 0, 0, 0, 91357184, 0, 0, 
        0, 182714369, 0, 0, 0, 365428738, 0, 0, 0, 147849217, 0, 0, 0, 295698434, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 3001529316, 0, 0, 0, 1708091336, 0, 0, 0, 3416182673, 0, 0, 0, 2537398050, 0, 
        0, 0, 779828804, 0, 0, 0, 1559657609, 0, 0, 0, 3119315218, 0, 0, 0, 1943663140, 0, 
        0, 0, 3887326281, 0, 0, 0, 3479685267, 0, 0, 0, 2664403238, 0, 0, 0, 1033839181, 0, 
        0, 0, 2067678363, 0, 0, 0, 4135356726, 0, 0, 0, 3975746156, 0, 0, 0, 1796577085, 0, 
        0, 0, 3593154171, 0, 0, 0, 2891341046, 0, 0, 0, 1487714796, 0, 0, 0, 2975429593, 0, 
        0, 0, 1655891891, 0, 0, 0, 3311783783, 0, 0, 0, 2328600271, 0, 0, 0, 362233247, 0, 
        0, 0, 724466494, 0, 0, 0, 1448932988, 0, 0, 0, 2897865977, 0, 0, 0, 1500764658, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30521863, 
        0, 0, 0, 61043727, 0, 0, 0, 122087454, 0, 0, 0, 244174909, 0, 0, 0, 488349818, 
        0, 0, 0, 976699637, 0, 0, 0, 1953399275, 0, 0, 0, 3906798551, 0, 0, 0, 3518629806, 
        0, 0, 0, 2742292316, 0, 0, 0, 1189617336, 0, 0, 0, 2379234673, 0, 0, 0, 463502051, 
        0, 0, 0, 927004102, 0, 0, 0, 1854008205, 0, 0, 0, 3708016410, 0, 0, 0, 3121065525, 
        0, 0, 0, 1947163754, 0, 0, 0, 3894327508, 0, 0, 0, 3493687720, 0, 0, 0, 2692408145, 
        0, 0, 0, 1089848995, 0, 0, 0, 2151298880, 0, 0, 0, 7630465, 0, 0, 0, 15260931, 
    },
    {
        0, 0, 0, 0, 134300932, 0, 0, 0, 268601864, 0, 0, 0, 537203728, 0, 0, 0, 
        1074407456, 0, 0, 0, 2148814913, 0, 0, 0, 2662530, 0, 0, 0, 5325060, 0, 0, 0, 
        10650120, 0, 0, 0, 21300240, 0, 0, 0, 42600481, 0, 0, 0, 85200962, 0, 0, 0, 
        170401925, 0, 0, 0, 340803850, 0, 0, 0, 681607700, 0, 0, 0, 1363215400, 0, 0, 0, 
        2726430800, 0, 0, 0, 1157894304, 0, 0, 0, 2315788608, 0, 0, 0, 336609920, 0, 0, 0, 
        673219840, 0, 0, 0, 1346439680, 0, 0, 0, 2692879361, 0, 0, 0, 1090791426, 0, 0, 0, 
        2181582852, 0, 0, 0, 68198408, 0, 0, 0, 2098452, 0, 0, 0, 4196904, 0, 0, 0, 
        8393808, 0, 0, 0, 16787616, 0, 0, 0, 33575233, 0, 0, 0, 67150466, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 661652741, 0, 0, 
        0, 1323305483, 0, 0, 0, 2646610967, 0, 0, 0, 998254638, 0, 0, 0, 1996509277, 0, 0, 
        0, 3993018554, 0, 0, 0, 3691069813, 0, 0, 0, 3087172330, 0, 0, 0, 1879377365, 0, 0, 
        0, 3758754731, 0, 0, 0, 3222542166, 0, 0, 0, 2150117036, 0, 0, 0, 5266776, 0, 0, 
        0, 10533552, 0, 0, 0, 21067104, 0, 0, 0, 42134208, 0, 0, 0, 84268416, 0, 0, 
        0, 168536833, 0, 0, 0, 337073666, 0, 0, 0, 674147332, 0, 0, 0, 1348294664, 0, 0, 
        0, 2696589329, 0, 0, 0, 1098211362, 0, 0, 0, 2196422724, 0, 0, 0, 97878152, 0, 0, 
        0, 195756305, 0, 0, 0, 391512610, 0, 0, 0, 165413185, 0, 0, 0, 330826370, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2938358989, 0, 0, 0, 1581750682, 0, 0, 0, 3163501365, 0, 0, 0, 2032035435, 0, 
        0, 0, 4064070870, 0, 0, 0, 3833174445, 0, 0, 0, 3371381594, 0, 0, 0, 2447795893, 0, 
        0, 0, 600624491, 0, 0, 0, 1201248983, 0, 0, 0, 2402497966, 0, 0, 0, 510028637, 0, 
        0, 0, 1020057274, 0, 0, 0, 2040114548, 0, 0, 0, 4080229097, 0, 0, 0, 1229289758, 0, 
        0, 0, 2458579516, 0, 0, 0, 622191737, 0, 0, 0, 1244383475, 0, 0, 0, 2488766950, 0, 
        0, 0, 682566604, 0, 0, 0, 1365133209, 0, 0, 0, 2730266419, 0, 0, 0, 1165565542, 0, 
        0, 0, 2331131084, 0, 0, 0, 367294873, 0, 0, 0, 734589747, 0, 0, 0, 1469179494, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33833481, 
        0, 0, 0, 67666962, 0, 0, 0, 135333924, 0, 0, 0, 270667848, 0, 0, 0, 541335697, 
        0, 0, 0, 1082671394, 0, 0, 0, 2165342788, 0, 0, 0, 35718281, 0, 0, 0, 71436563, 
        0, 0, 0, 142873126, 0, 0, 0, 285746252, 0, 0, 0, 571492505, 0, 0, 0, 1142985010, 
        0, 0, 0, 2285970021, 0, 0, 0, 276972746, 0, 0, 0, 553945492, 0, 0, 0, 1107890985, 
        0, 0, 0, 2215781970, 0, 0, 0, 136596644, 0, 0, 0, 273193289, 0, 0, 0, 546386578, 
        0, 0, 0, 1092773156, 0, 0, 0, 2151712833, 0, 0, 0, 8458370, 0, 0, 0, 16916740, 
    },
    {
        0, 0, 0, 0, 826542200, 0, 0, 0, 1653084401, 0, 0, 0, 3306168803, 0, 0, 0, 
        2317370310, 0, 0, 0, 339773324, 0, 0, 0, 679546648, 0, 0, 0, 1359093296, 0, 0, 0, 
        2718186592, 0, 0, 0, 1141405888, 0, 0, 0, 2282811777, 0, 0, 0, 270656258, 0, 0, 0, 
        541312516, 0, 0, 0, 1082625032, 0, 0, 0, 2165250065, 0, 0, 0, 35532835, 0, 0, 0, 
        71065670, 0, 0, 0, 142131340, 0, 0, 0, 284262680, 0, 0, 0, 568525360, 0, 0, 0, 
        1137050721, 0, 0, 0, 2274101442, 0, 0, 0, 253235589, 0, 0, 0, 506471179, 0, 0, 0, 
        1012942358, 0, 0, 0, 2025884716, 0, 0, 0, 3234140193, 0, 0, 0, 2173313091, 0, 0, 0, 
        51658887, 0, 0, 0, 103317775, 0, 0, 0, 206635550, 0, 0, 0, 413271100, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2815455249, 0, 0, 
        0, 1335943203, 0, 0, 0, 2671886407, 0, 0, 0, 1048805518, 0, 0, 0, 2097611036, 0, 0, 
        0, 4195222072, 0, 0, 0, 4095476849, 0, 0, 0, 3895986402, 0, 0, 0, 3497005508, 0, 0, 
        0, 2699043721, 0, 0, 0, 1103120146, 0, 0, 0, 2206240292, 0, 0, 0, 117513288, 0, 0, 
        0, 235026577, 0, 0, 0, 470053155, 0, 0, 0, 940106310, 0, 0, 0, 1880212621, 0, 0, 
        0, 3760425243, 0, 0, 0, 3225883190, 0, 0, 0, 2156799084, 0, 0, 0, 18630872, 0, 0, 
        0, 37261744, 0, 0, 0, 74523488, 0, 0, 0, 149046977, 0, 0, 0, 298093954, 0, 0, 
        0, 596187909, 0, 0, 0, 1192375818, 0, 0, 0, 703863812, 0, 0, 0, 1407727624, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1801783692, 0, 0, 0, 3603567385, 0, 0, 0, 2912167474, 0, 0, 0, 1529367653, 0, 
        0, 0, 3058735306, 0, 0, 0, 1822503316, 0, 0, 0, 3645006633, 0, 0, 0, 2995045970, 0, 
        0, 0, 1695124645, 0, 0, 0, 3390249290, 0, 0, 0, 2485531285, 0, 0, 0, 676095274, 0, 
        0, 0, 1352190548, 0, 0, 0, 2704381097, 0, 0, 0, 1113794898, 0, 0, 0, 4020460328, 0, 
        0, 0, 3745953360, 0, 0, 0, 3196939425, 0, 0, 0, 2098911554, 0, 0, 0, 4197823108, 0, 
        0, 0, 4100678921, 0, 0, 0, 3906390547, 0, 0, 0, 3517813798, 0, 0, 0, 2740660300, 0, 
        0, 0, 1186353304, 0, 0, 0, 2372706609, 0, 0, 0, 450445923, 0, 0, 0, 900891846, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67141650, 
        0, 0, 0, 134283300, 0, 0, 0, 268566600, 0, 0, 0, 537133200, 0, 0, 0, 1074266400, 
        0, 0, 0, 2148532800, 0, 0, 0, 2098304, 0, 0, 0, 4196609, 0, 0, 0, 8393218, 
        0, 0, 0, 16786436, 0, 0, 0, 33572873, 0, 0, 0, 67145746, 0, 0, 0, 134291492, 
        0, 0, 0, 268582984, 0, 0, 0, 537165968, 0, 0, 0, 1074331936, 0, 0, 0, 2148663872, 
        0, 0, 0, 2360448, 0, 0, 0, 4720897, 0, 0, 0, 9441794, 0, 0, 0, 18883588, 
        0, 0, 0, 37767176, 0, 0, 0, 8392706, 0, 0, 0, 16785412, 0, 0, 0, 33570825, 
    },
    {
        0, 0, 0, 0, 2499687121, 0, 0, 0, 704406946, 0, 0, 0, 1408813893, 0, 0, 0, 
        2817627786, 0, 0, 0, 1340288277, 0, 0, 0, 2680576554, 0, 0, 0, 1066185813, 0, 0, 0, 
        2132371627, 0, 0, 0, 4264743254, 0, 0, 0, 4234519213, 0, 0, 0, 4174071131, 0, 0, 0, 
        4053174967, 0, 0, 0, 3811382638, 0, 0, 0, 3327797980, 0, 0, 0, 2360628665, 0, 0, 0, 
        426290034, 0, 0, 0, 852580069, 0, 0, 0, 1705160138, 0, 0, 0, 3410320276, 0, 0, 0, 
        2525673256, 0, 0, 0, 756379216, 0, 0, 0, 1512758433, 0, 0, 0, 3025516867, 0, 0, 0, 
        1756066438, 0, 0, 0, 3512132877, 0, 0, 0, 911472843, 0, 0, 0, 1822945686, 0, 0, 0, 
        3645891373, 0, 0, 0, 2996815450, 0, 0, 0, 1698663604, 0, 0, 0, 3397327208, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1432822912, 0, 0, 
        0, 2865645824, 0, 0, 0, 1436324352, 0, 0, 0, 2872648704, 0, 0, 0, 1450330112, 0, 0, 
        0, 2900660224, 0, 0, 0, 1506353153, 0, 0, 0, 3012706307, 0, 0, 0, 1730445319, 0, 0, 
        0, 3460890639, 0, 0, 0, 2626813983, 0, 0, 0, 958660670, 0, 0, 0, 1917321341, 0, 0, 
        0, 3834642683, 0, 0, 0, 3374318071, 0, 0, 0, 2453668846, 0, 0, 0, 612370397, 0, 0, 
        0, 1224740795, 0, 0, 0, 2449481590, 0, 0, 0, 603995885, 0, 0, 0, 1207991771, 0, 0, 
        0, 2415983542, 0, 0, 0, 536999789, 0, 0, 0, 1073999578, 0, 0, 0, 2147999156, 0, 0, 
        0, 1031016, 0, 0, 0, 2062032, 0, 0, 0, 1431947552, 0, 0, 0, 2863895104, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2656366736, 0, 0, 0, 1017766176, 0, 0, 0, 2035532352, 0, 0, 0, 4071064704, 0, 
        0, 0, 3847162112, 0, 0, 0, 3399356928, 0, 0, 0, 2503746561, 0, 0, 0, 712525826, 0, 
        0, 0, 1425051652, 0, 0, 0, 2850103304, 0, 0, 0, 1405239313, 0, 0, 0, 2810478627, 0, 
        0, 0, 1325989958, 0, 0, 0, 2651979917, 0, 0, 0, 1008992539, 0, 0, 0, 3860656807, 0, 
        0, 0, 3426346319, 0, 0, 0, 2557725342, 0, 0, 0, 820483388, 0, 0, 0, 1640966776, 0, 
        0, 0, 3281933552, 0, 0, 0, 2268899809, 0, 0, 0, 242832322, 0, 0, 0, 485664644, 0, 
        0, 0, 971329289, 0, 0, 0, 1942658578, 0, 0, 0, 3885317156, 0, 0, 0, 3475667016, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2304, 
        0, 0, 0, 4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 0, 0, 0, 36864, 
        0, 0, 0, 73728, 0, 0, 0, 147456, 0, 0, 0, 294912, 0, 0, 0, 589824, 
        0, 0, 0, 1179648, 0, 0, 0, 2359296, 0, 0, 0, 4718593, 0, 0, 0, 9437186, 
        0, 0, 0, 18874372, 0, 0, 0, 37748744, 0, 0, 0, 75497488, 0, 0, 0, 150994976, 
        0, 0, 0, 301989953, 0, 0, 0, 603979906, 0, 0, 0, 1207959812, 0, 0, 0, 2415919624, 
        0, 0, 0, 536871952, 0, 0, 0, 1073742112, 0, 0, 0, 2147484224, 0, 0, 0, 1152, 
    },
    {
        0, 0, 0, 0, 2271571420, 0, 0, 0, 248175545, 0, 0, 0, 496351090, 0, 0, 0, 
        992702181, 0, 0, 0, 1985404363, 0, 0, 0, 3970808727, 0, 0, 0, 3646650159, 0, 0, 0, 
        2998333022, 0, 0, 0, 1701698748, 0, 0, 0, 3403397496, 0, 0, 0, 2511827697, 0, 0, 0, 
        728688099, 0, 0, 0, 1457376199, 0, 0, 0, 2914752399, 0, 0, 0, 1534537503, 0, 0, 0, 
        3069075006, 0, 0, 0, 1843182716, 0, 0, 0, 3686365432, 0, 0, 0, 3077763568, 0, 0, 0, 
        1860559841, 0, 0, 0, 3721119683, 0, 0, 0, 3147272070, 0, 0, 0, 1999576845, 0, 0, 0, 
        3999153690, 0, 0, 0, 3703340085, 0, 0, 0, 1042126263, 0, 0, 0, 2084252526, 0, 0, 0, 
        4168505053, 0, 0, 0, 4042042811, 0, 0, 0, 3789118327, 0, 0, 0, 3283269358, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2740852545, 0, 0, 
        0, 1186737794, 0, 0, 0, 2373475589, 0, 0, 0, 451983883, 0, 0, 0, 903967767, 0, 0, 
        0, 1807935534, 0, 0, 0, 3615871068, 0, 0, 0, 2936774840, 0, 0, 0, 1578582385, 0, 0, 
        0, 3157164770, 0, 0, 0, 2019362244, 0, 0, 0, 4038724489, 0, 0, 0, 3782481683, 0, 0, 
        0, 3269996070, 0, 0, 0, 2245024844, 0, 0, 0, 195082393, 0, 0, 0, 390164786, 0, 0, 
        0, 780329572, 0, 0, 0, 1560659145, 0, 0, 0, 3121318290, 0, 0, 0, 1947669285, 0, 0, 
        0, 3895338570, 0, 0, 0, 3495709844, 0, 0, 0, 2696452393, 0, 0, 0, 1097937490, 0, 0, 
        0, 2195874980, 0, 0, 0, 96782664, 0, 0, 0, 2832696784, 0, 0, 0, 1370426272, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2424557694, 0, 0, 0, 554148093, 0, 0, 0, 1108296186, 0, 0, 0, 2216592373, 0, 
        0, 0, 138217450, 0, 0, 0, 276434901, 0, 0, 0, 552869802, 0, 0, 0, 1105739604, 0, 
        0, 0, 2211479208, 0, 0, 0, 127991121, 0, 0, 0, 255982243, 0, 0, 0, 511964486, 0, 
        0, 0, 1023928972, 0, 0, 0, 2047857944, 0, 0, 0, 4095715888, 0, 0, 0, 2025620510, 0, 
        0, 0, 4051241021, 0, 0, 0, 3807514746, 0, 0, 0, 3320062196, 0, 0, 0, 2345157096, 0, 
        0, 0, 395346896, 0, 0, 0, 790693792, 0, 0, 0, 1581387585, 0, 0, 0, 3162775171, 0, 
        0, 0, 2030583047, 0, 0, 0, 4061166095, 0, 0, 0, 3827364895, 0, 0, 0, 3359762495, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8390658, 
        0, 0, 0, 16781316, 0, 0, 0, 33562633, 0, 0, 0, 67125266, 0, 0, 0, 134250532, 
        0, 0, 0, 268501064, 0, 0, 0, 537002128, 0, 0, 0, 1074004256, 0, 0, 0, 2148008512, 
        0, 0, 0, 1049728, 0, 0, 0, 2099456, 0, 0, 0, 4198913, 0, 0, 0, 8397826, 
        0, 0, 0, 16795652, 0, 0, 0, 33591305, 0, 0, 0, 67182610, 0, 0, 0, 134365220, 
        0, 0, 0, 268730440, 0, 0, 0, 537460880, 0, 0, 0, 1074921760, 0, 0, 0, 2149843520, 
        0, 0, 0, 4719745, 0, 0, 0, 1048832, 0, 0, 0, 2097664, 0, 0, 0, 4195329, 
    },
    {
        0, 0, 0, 0, 1739616249, 0, 0, 0, 3479232498, 0, 0, 0, 2663497700, 0, 0, 0, 
        1032028104, 0, 0, 0, 2064056209, 0, 0, 0, 4128112418, 0, 0, 0, 3961257541, 0, 0, 0, 
        3627547787, 0, 0, 0, 2960128279, 0, 0, 0, 1625289262, 0, 0, 0, 3250578525, 0, 0, 0, 
        2206189754, 0, 0, 0, 117412213, 0, 0, 0, 234824426, 0, 0, 0, 469648853, 0, 0, 0, 
        939297707, 0, 0, 0, 1878595415, 0, 0, 0, 3757190830, 0, 0, 0, 3219414364, 0, 0, 0, 
        2143861433, 0, 0, 0, 4287722866, 0, 0, 0, 4280478436, 0, 0, 0, 4265989576, 0, 0, 0, 
        4237011857, 0, 0, 0, 4179056419, 0, 0, 0, 2510209471, 0, 0, 0, 725451647, 0, 0, 0, 
        1450903295, 0, 0, 0, 2901806591, 0, 0, 0, 1508645886, 0, 0, 0, 3017291772, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3220345106, 0, 0, 
        0, 2145722916, 0, 0, 0, 4291445832, 0, 0, 0, 4287924368, 0, 0, 0, 4280881440, 0, 0, 
        0, 4266795584, 0, 0, 0, 4238623872, 0, 0, 0, 4182280448, 0, 0, 0, 4069593601, 0, 0, 
        0, 3844219907, 0, 0, 0, 3393472519, 0, 0, 0, 2491977742, 0, 0, 0, 688988188, 0, 0, 
        0, 1377976376, 0, 0, 0, 2755952753, 0, 0, 0, 1216938211, 0, 0, 0, 2433876422, 0, 0, 
        0, 572785549, 0, 0, 0, 1145571098, 0, 0, 0, 2291142197, 0, 0, 0, 287317098, 0, 0, 
        0, 574634197, 0, 0, 0, 1149268394, 0, 0, 0, 2298536789, 0, 0, 0, 302106282, 0, 0, 
        0, 604212565, 0, 0, 0, 1208425131, 0, 0, 0, 805086276, 0, 0, 0, 1610172553, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 70539992, 0, 0, 0, 141079985, 0, 0, 0, 282159971, 0, 0, 0, 564319943, 0, 
        0, 0, 1128639887, 0, 0, 0, 2257279774, 0, 0, 0, 219592253, 0, 0, 0, 439184507, 0, 
        0, 0, 878369014, 0, 0, 0, 1756738029, 0, 0, 0, 3513476059, 0, 0, 0, 2731984823, 0, 
        0, 0, 1169002351, 0, 0, 0, 2338004702, 0, 0, 0, 381042109, 0, 0, 0, 693641634, 0, 
        0, 0, 1387283269, 0, 0, 0, 2774566539, 0, 0, 0, 1254165782, 0, 0, 0, 2508331565, 0, 
        0, 0, 721695834, 0, 0, 0, 1443391669, 0, 0, 0, 2886783339, 0, 0, 0, 1478599382, 0, 
        0, 0, 2957198765, 0, 0, 0, 1619430235, 0, 0, 0, 3238860470, 0, 0, 0, 2182753644, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144703526, 
        0, 0, 0, 289407053, 0, 0, 0, 578814107, 0, 0, 0, 1157628214, 0, 0, 0, 2315256429, 
        0, 0, 0, 335545562, 0, 0, 0, 671091124, 0, 0, 0, 1342182248, 0, 0, 0, 2684364496, 
        0, 0, 0, 1073761696, 0, 0, 0, 2147523392, 0, 0, 0, 79488, 0, 0, 0, 158976, 
        0, 0, 0, 317952, 0, 0, 0, 635904, 0, 0, 0, 1271808, 0, 0, 0, 2543616, 
        0, 0, 0, 5087233, 0, 0, 0, 10174466, 0, 0, 0, 20348932, 0, 0, 0, 40697864, 
        0, 0, 0, 81395729, 0, 0, 0, 18087940, 0, 0, 0, 36175881, 0, 0, 0, 72351763, 
    },
    {
        0, 0, 0, 0, 1915396941, 0, 0, 0, 3830793883, 0, 0, 0, 3366620471, 0, 0, 0, 
        2438273647, 0, 0, 0, 581579999, 0, 0, 0, 1163159998, 0, 0, 0, 2326319996, 0, 0, 0, 
        357672696, 0, 0, 0, 715345393, 0, 0, 0, 1430690786, 0, 0, 0, 2861381572, 0, 0, 0, 
        1427795848, 0, 0, 0, 2855591696, 0, 0, 0, 1416216096, 0, 0, 0, 2832432193, 0, 0, 0, 
        1369897090, 0, 0, 0, 2739794180, 0, 0, 0, 1184621065, 0, 0, 0, 2369242131, 0, 0, 0, 
        443516967, 0, 0, 0, 887033934, 0, 0, 0, 1774067868, 0, 0, 0, 3548135736, 0, 0, 0, 
        2801304176, 0, 0, 0, 1307641056, 0, 0, 0, 3922242189, 0, 0, 0, 3549517082, 0, 0, 0, 
        2804066868, 0, 0, 0, 1313166441, 0, 0, 0, 2626332883, 0, 0, 0, 957698470, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 348140706, 0, 0, 
        0, 696281412, 0, 0, 0, 1392562824, 0, 0, 0, 2785125649, 0, 0, 0, 1275284003, 0, 0, 
        0, 2550568007, 0, 0, 0, 806168719, 0, 0, 0, 1612337439, 0, 0, 0, 3224674878, 0, 0, 
        0, 2154382460, 0, 0, 0, 13797624, 0, 0, 0, 27595248, 0, 0, 0, 55190496, 0, 0, 
        0, 110380992, 0, 0, 0, 220761985, 0, 0, 0, 441523971, 0, 0, 0, 883047943, 0, 0, 
        0, 1766095886, 0, 0, 0, 3532191772, 0, 0, 0, 2769416249, 0, 0, 0, 1243865203, 0, 0, 
        0, 2487730406, 0, 0, 0, 680493516, 0, 0, 0, 1360987032, 0, 0, 0, 2721974065, 0, 0, 
        0, 1148980834, 0, 0, 0, 2297961669, 0, 0, 0, 87035176, 0, 0, 0, 174070353, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1770227281, 0, 0, 0, 3540454563, 0, 0, 0, 2785941830, 0, 0, 0, 1276916364, 0, 
        0, 0, 2553832729, 0, 0, 0, 812698162, 0, 0, 0, 1625396325, 0, 0, 0, 3250792650, 0, 
        0, 0, 2206618004, 0, 0, 0, 118268713, 0, 0, 0, 236537426, 0, 0, 0, 473074852, 0, 
        0, 0, 946149705, 0, 0, 0, 1892299411, 0, 0, 0, 3784598822, 0, 0, 0, 2863352860, 0, 
        0, 0, 1431738424, 0, 0, 0, 2863476848, 0, 0, 0, 1431986401, 0, 0, 0, 2863972803, 0, 
        0, 0, 1432978310, 0, 0, 0, 2865956620, 0, 0, 0, 1436945945, 0, 0, 0, 2873891890, 0, 
        0, 0, 1452816485, 0, 0, 0, 2905632970, 0, 0, 0, 1516298644, 0, 0, 0, 3032597288, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135049252, 
        0, 0, 0, 270098504, 0, 0, 0, 540197008, 0, 0, 0, 1080394017, 0, 0, 0, 2160788035, 
        0, 0, 0, 26608774, 0, 0, 0, 53217549, 0, 0, 0, 106435098, 0, 0, 0, 212870196, 
        0, 0, 0, 425740393, 0, 0, 0, 851480786, 0, 0, 0, 1702961572, 0, 0, 0, 3405923145, 
        0, 0, 0, 2516878995, 0, 0, 0, 738790694, 0, 0, 0, 1477581388, 0, 0, 0, 2955162776, 
        0, 0, 0, 1615358257, 0, 0, 0, 3230716514, 0, 0, 0, 2166465732, 0, 0, 0, 37964168, 
        0, 0, 0, 75928336, 0, 0, 0, 16881156, 0, 0, 0, 33762313, 0, 0, 0, 67524626, 
    },
    {
        0, 0, 0, 0, 4038889453, 0, 0, 0, 3782811611, 0, 0, 0, 3270655926, 0, 0, 0, 
        2246344557, 0, 0, 0, 197721819, 0, 0, 0, 395443639, 0, 0, 0, 790887279, 0, 0, 0, 
        1581774559, 0, 0, 0, 3163549119, 0, 0, 0, 2032130942, 0, 0, 0, 4064261884, 0, 0, 0, 
        3833556473, 0, 0, 0, 3372145651, 0, 0, 0, 2449324007, 0, 0, 0, 603680719, 0, 0, 0, 
        1207361439, 0, 0, 0, 2414722878, 0, 0, 0, 534478461, 0, 0, 0, 1068956923, 0, 0, 0, 
        2137913847, 0, 0, 0, 4275827694, 0, 0, 0, 4256688093, 0, 0, 0, 4218408890, 0, 0, 0, 
        4141850484, 0, 0, 0, 3988733673, 0, 0, 0, 734196287, 0, 0, 0, 1468392575, 0, 0, 0, 
        2936785150, 0, 0, 0, 1578603005, 0, 0, 0, 3157206011, 0, 0, 0, 2019444726, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2692483345, 0, 0, 
        0, 1089999394, 0, 0, 0, 2179998788, 0, 0, 0, 65030280, 0, 0, 0, 130060560, 0, 0, 
        0, 260121121, 0, 0, 0, 520242243, 0, 0, 0, 1040484486, 0, 0, 0, 2080968972, 0, 0, 
        0, 4161937944, 0, 0, 0, 4028908593, 0, 0, 0, 3762849891, 0, 0, 0, 3230732486, 0, 0, 
        0, 2166497676, 0, 0, 0, 38028056, 0, 0, 0, 76056112, 0, 0, 0, 152112225, 0, 0, 
        0, 304224450, 0, 0, 0, 608448901, 0, 0, 0, 1216897803, 0, 0, 0, 2433795606, 0, 0, 
        0, 572623917, 0, 0, 0, 1145247834, 0, 0, 0, 2290495669, 0, 0, 0, 286024042, 0, 0, 
        0, 572048085, 0, 0, 0, 1144096170, 0, 0, 0, 673120836, 0, 0, 0, 1346241672, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 302254233, 0, 0, 0, 604508466, 0, 0, 0, 1209016932, 0, 0, 0, 2418033865, 0, 
        0, 0, 541100435, 0, 0, 0, 1082200870, 0, 0, 0, 2164401740, 0, 0, 0, 33836184, 0, 
        0, 0, 67672369, 0, 0, 0, 135344738, 0, 0, 0, 270689477, 0, 0, 0, 541378955, 0, 
        0, 0, 1082757911, 0, 0, 0, 2165515822, 0, 0, 0, 36064348, 0, 0, 0, 373854240, 0, 
        0, 0, 747708480, 0, 0, 0, 1495416961, 0, 0, 0, 2990833922, 0, 0, 0, 1686700548, 0, 
        0, 0, 3373401096, 0, 0, 0, 2451834897, 0, 0, 0, 608702498, 0, 0, 0, 1217404996, 0, 
        0, 0, 2434809993, 0, 0, 0, 574652691, 0, 0, 0, 1149305382, 0, 0, 0, 2298610764, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3961969350, 
        0, 0, 0, 3628971405, 0, 0, 0, 2962975514, 0, 0, 0, 1630983732, 0, 0, 0, 3261967464, 
        0, 0, 0, 2228967633, 0, 0, 0, 162967970, 0, 0, 0, 325935940, 0, 0, 0, 651871880, 
        0, 0, 0, 1303743760, 0, 0, 0, 2607487520, 0, 0, 0, 920007744, 0, 0, 0, 1840015488, 
        0, 0, 0, 3680030976, 0, 0, 0, 3065094657, 0, 0, 0, 1835222019, 0, 0, 0, 3670444038, 
        0, 0, 0, 3045920780, 0, 0, 0, 1796874265, 0, 0, 0, 3593748531, 0, 0, 0, 2892529767, 
        0, 0, 0, 1490092239, 0, 0, 0, 1568987992, 0, 0, 0, 3137975985, 0, 0, 0, 1980984675, 
    },
    {
        0, 0, 0, 0, 3824344628, 0, 0, 0, 3353721960, 0, 0, 0, 2412476624, 0, 0, 0, 
        529985953, 0, 0, 0, 1059971907, 0, 0, 0, 2119943815, 0, 0, 0, 4239887631, 0, 0, 0, 
        4184807967, 0, 0, 0, 4074648638, 0, 0, 0, 3854329981, 0, 0, 0, 3413692666, 0, 0, 0, 
        2532418036, 0, 0, 0, 769868776, 0, 0, 0, 1539737553, 0, 0, 0, 3079475106, 0, 0, 0, 
        1863982917, 0, 0, 0, 3727965834, 0, 0, 0, 3160964373, 0, 0, 0, 2026961450, 0, 0, 0, 
        4053922901, 0, 0, 0, 3812878506, 0, 0, 0, 3330789716, 0, 0, 0, 2366612137, 0, 0, 0, 
        438256979, 0, 0, 0, 876513958, 0, 0, 0, 2341456760, 0, 0, 0, 387946225, 0, 0, 0, 
        775892451, 0, 0, 0, 1551784902, 0, 0, 0, 3103569805, 0, 0, 0, 1912172314, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1473249760, 0, 0, 
        0, 2946499520, 0, 0, 0, 1598031745, 0, 0, 0, 3196063490, 0, 0, 0, 2097159684, 0, 0, 
        0, 4194319368, 0, 0, 0, 4093671441, 0, 0, 0, 3892375586, 0, 0, 0, 3489783876, 0, 0, 
        0, 2684600457, 0, 0, 0, 1074233618, 0, 0, 0, 2148467236, 0, 0, 0, 1967176, 0, 0, 
        0, 3934352, 0, 0, 0, 7868704, 0, 0, 0, 15737408, 0, 0, 0, 31474816, 0, 0, 
        0, 62949632, 0, 0, 0, 125899264, 0, 0, 0, 251798529, 0, 0, 0, 503597059, 0, 0, 
        0, 1007194118, 0, 0, 0, 2014388236, 0, 0, 0, 4028776473, 0, 0, 0, 3762585651, 0, 0, 
        0, 3230204006, 0, 0, 0, 2165440716, 0, 0, 0, 1442054264, 0, 0, 0, 2884108528, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 536903683, 0, 0, 0, 1073807366, 0, 0, 0, 2147614732, 0, 0, 0, 262168, 0, 
        0, 0, 524336, 0, 0, 0, 1048672, 0, 0, 0, 2097344, 0, 0, 0, 4194688, 0, 
        0, 0, 8389376, 0, 0, 0, 16778752, 0, 0, 0, 33557504, 0, 0, 0, 67115008, 0, 
        0, 0, 134230016, 0, 0, 0, 268460033, 0, 0, 0, 536920067, 0, 0, 0, 1610678276, 0, 
        0, 0, 3221356552, 0, 0, 0, 2147745808, 0, 0, 0, 524320, 0, 0, 0, 1048640, 0, 
        0, 0, 2097280, 0, 0, 0, 4194560, 0, 0, 0, 8389120, 0, 0, 0, 16778240, 0, 
        0, 0, 33556480, 0, 0, 0, 67112960, 0, 0, 0, 134225920, 0, 0, 0, 268451841, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3548126500, 
        0, 0, 0, 2801285704, 0, 0, 0, 1307604113, 0, 0, 0, 2615208226, 0, 0, 0, 935449156, 
        0, 0, 0, 1870898313, 0, 0, 0, 3741796627, 0, 0, 0, 3188625959, 0, 0, 0, 2082284622, 
        0, 0, 0, 4164569244, 0, 0, 0, 4034171193, 0, 0, 0, 3773375091, 0, 0, 0, 3251782887, 
        0, 0, 0, 2208598479, 0, 0, 0, 122229662, 0, 0, 0, 244459325, 0, 0, 0, 488918650, 
        0, 0, 0, 977837300, 0, 0, 0, 1955674600, 0, 0, 0, 3911349200, 0, 0, 0, 3527731104, 
        0, 0, 0, 2760494912, 0, 0, 0, 2590999460, 0, 0, 0, 887031625, 0, 0, 0, 1774063250, 
    },
    {
        0, 0, 0, 0, 1099834596, 0, 0, 0, 2199669192, 0, 0, 0, 104371089, 0, 0, 0, 
        208742178, 0, 0, 0, 417484356, 0, 0, 0, 834968712, 0, 0, 0, 1669937425, 0, 0, 0, 
        3339874850, 0, 0, 0, 2384782404, 0, 0, 0, 474597512, 0, 0, 0, 949195024, 0, 0, 0, 
        1898390048, 0, 0, 0, 3796780096, 0, 0, 0, 3298592897, 0, 0, 0, 2302218499, 0, 0, 0, 
        309469703, 0, 0, 0, 618939406, 0, 0, 0, 1237878812, 0, 0, 0, 2475757624, 0, 0, 0, 
        656547953, 0, 0, 0, 1313095907, 0, 0, 0, 2626191815, 0, 0, 0, 957416334, 0, 0, 0, 
        1914832669, 0, 0, 0, 3829665339, 0, 0, 0, 2298886291, 0, 0, 0, 302805287, 0, 0, 0, 
        605610574, 0, 0, 0, 1211221148, 0, 0, 0, 2422442297, 0, 0, 0, 549917298, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1442838528, 0, 0, 
        0, 2885677056, 0, 0, 0, 1476386816, 0, 0, 0, 2952773632, 0, 0, 0, 1610579969, 0, 0, 
        0, 3221159938, 0, 0, 0, 2147352580, 0, 0, 0, 4294705160, 0, 0, 0, 4294443024, 0, 0, 
        0, 4293918752, 0, 0, 0, 4292870208, 0, 0, 0, 4290773120, 0, 0, 0, 4286578944, 0, 0, 
        0, 4278190592, 0, 0, 0, 4261413888, 0, 0, 0, 4227860480, 0, 0, 0, 4160753664, 0, 0, 
        0, 4026540033, 0, 0, 0, 3758112771, 0, 0, 0, 3221258246, 0, 0, 0, 2147549196, 0, 0, 
        0, 131096, 0, 0, 0, 262192, 0, 0, 0, 524384, 0, 0, 0, 1048768, 0, 0, 
        0, 2097536, 0, 0, 0, 4195072, 0, 0, 0, 1434451456, 0, 0, 0, 2868902912, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 262152, 0, 0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 
        0, 0, 4194432, 0, 0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 
        0, 0, 67110912, 0, 0, 0, 134221824, 0, 0, 0, 268443649, 0, 0, 0, 536887298, 0, 
        0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 0, 0, 131092, 0, 0, 0, 32, 0, 
        0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 
        0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 
        0, 0, 16384, 0, 0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 357270623, 
        0, 0, 0, 714541247, 0, 0, 0, 1429082494, 0, 0, 0, 2858164988, 0, 0, 0, 1421362680, 
        0, 0, 0, 2842725361, 0, 0, 0, 1390483426, 0, 0, 0, 2780966853, 0, 0, 0, 1266966411, 
        0, 0, 0, 2533932823, 0, 0, 0, 772898351, 0, 0, 0, 1545796702, 0, 0, 0, 3091593405, 
        0, 0, 0, 1888219514, 0, 0, 0, 3776439028, 0, 0, 0, 3257910761, 0, 0, 0, 2220854227, 
        0, 0, 0, 146741158, 0, 0, 0, 293482317, 0, 0, 0, 586964634, 0, 0, 0, 1173929269, 
        0, 0, 0, 2347858538, 0, 0, 0, 44658827, 0, 0, 0, 89317655, 0, 0, 0, 178635311, 
    },
    {
        0, 0, 0, 0, 3400190380, 0, 0, 0, 2505413465, 0, 0, 0, 715859635, 0, 0, 0, 
        1431719270, 0, 0, 0, 2863438540, 0, 0, 0, 1431909784, 0, 0, 0, 2863819568, 0, 0, 0, 
        1432671840, 0, 0, 0, 2865343680, 0, 0, 0, 1435720064, 0, 0, 0, 2871440128, 0, 0, 0, 
        1447912961, 0, 0, 0, 2895825923, 0, 0, 0, 1496684550, 0, 0, 0, 2993369100, 0, 0, 0, 
        1691770904, 0, 0, 0, 3383541809, 0, 0, 0, 2472116322, 0, 0, 0, 649265349, 0, 0, 0, 
        1298530698, 0, 0, 0, 2597061396, 0, 0, 0, 899155496, 0, 0, 0, 1798310993, 0, 0, 0, 
        3596621986, 0, 0, 0, 2898276677, 0, 0, 0, 2469047078, 0, 0, 0, 643126861, 0, 0, 0, 
        1286253722, 0, 0, 0, 2572507445, 0, 0, 0, 850047595, 0, 0, 0, 1700095190, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 
        0, 32, 0, 0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 
        0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 
        0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 
        0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 
        0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 
        0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 
        0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483652, 0, 0, 0, 8, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1073774613, 0, 0, 0, 2147549226, 0, 0, 0, 131156, 0, 0, 0, 262312, 0, 
        0, 0, 524624, 0, 0, 0, 1049248, 0, 0, 0, 2098496, 0, 0, 0, 4196992, 0, 
        0, 0, 8393984, 0, 0, 0, 16787968, 0, 0, 0, 33575936, 0, 0, 0, 67151873, 0, 
        0, 0, 134303746, 0, 0, 0, 268607492, 0, 0, 0, 537214984, 0, 0, 0, 655364, 0, 
        0, 0, 1310728, 0, 0, 0, 2621456, 0, 0, 0, 5242912, 0, 0, 0, 10485824, 0, 
        0, 0, 20971648, 0, 0, 0, 41943296, 0, 0, 0, 83886592, 0, 0, 0, 167773184, 0, 
        0, 0, 335546369, 0, 0, 0, 671092738, 0, 0, 0, 1342185477, 0, 0, 0, 2684370954, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3265725291, 
        0, 0, 0, 2236483287, 0, 0, 0, 177999279, 0, 0, 0, 355998558, 0, 0, 0, 711997116, 
        0, 0, 0, 1423994233, 0, 0, 0, 2847988467, 0, 0, 0, 1401009639, 0, 0, 0, 2802019279, 
        0, 0, 0, 1309071263, 0, 0, 0, 2618142526, 0, 0, 0, 941317756, 0, 0, 0, 1882635512, 
        0, 0, 0, 3765271025, 0, 0, 0, 3235574755, 0, 0, 0, 2176182214, 0, 0, 0, 57397132, 
        0, 0, 0, 114794264, 0, 0, 0, 229588528, 0, 0, 0, 459177056, 0, 0, 0, 918354113, 
        0, 0, 0, 1836708227, 0, 0, 0, 408215661, 0, 0, 0, 816431322, 0, 0, 0, 1632862645, 
    },
    {
        0, 0, 0, 0, 2928597988, 0, 0, 0, 1562228680, 0, 0, 0, 3124457360, 0, 0, 0, 
        1953947424, 0, 0, 0, 3907894849, 0, 0, 0, 3520822403, 0, 0, 0, 2746677510, 0, 0, 0, 
        1198387725, 0, 0, 0, 2396775450, 0, 0, 0, 498583604, 0, 0, 0, 997167209, 0, 0, 0, 
        1994334419, 0, 0, 0, 3988668839, 0, 0, 0, 3682370382, 0, 0, 0, 3069773468, 0, 0, 0, 
        1844579640, 0, 0, 0, 3689159280, 0, 0, 0, 3083351264, 0, 0, 0, 1871735233, 0, 0, 0, 
        3743470466, 0, 0, 0, 3191973636, 0, 0, 0, 2088979976, 0, 0, 0, 4177959953, 0, 0, 0, 
        4060952610, 0, 0, 0, 3826937925, 0, 0, 0, 1723480943, 0, 0, 0, 3446961887, 0, 0, 0, 
        2598956478, 0, 0, 0, 902945660, 0, 0, 0, 1805891321, 0, 0, 0, 3611782642, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 
        0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 32, 0, 0, 0, 64, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 18087960, 0, 0, 0, 36175920, 0, 0, 0, 72351840, 0, 0, 0, 144703680, 0, 
        0, 0, 289407361, 0, 0, 0, 578814722, 0, 0, 0, 1157629444, 0, 0, 0, 2315258888, 0, 
        0, 0, 335550481, 0, 0, 0, 671100962, 0, 0, 0, 1342201925, 0, 0, 0, 2684403851, 0, 
        0, 0, 1073840407, 0, 0, 0, 2147680814, 0, 0, 0, 394332, 0, 0, 0, 18352288, 0, 
        0, 0, 36704576, 0, 0, 0, 73409152, 0, 0, 0, 146818304, 0, 0, 0, 293636608, 0, 
        0, 0, 587273216, 0, 0, 0, 1174546432, 0, 0, 0, 2349092864, 0, 0, 0, 403218432, 0, 
        0, 0, 806436865, 0, 0, 0, 1612873731, 0, 0, 0, 3225747462, 0, 0, 0, 2156527628, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3612118070, 
        0, 0, 0, 2929268845, 0, 0, 0, 1563570394, 0, 0, 0, 3127140788, 0, 0, 0, 1959314281, 
        0, 0, 0, 3918628562, 0, 0, 0, 3542289829, 0, 0, 0, 2789612362, 0, 0, 0, 1284257428, 
        0, 0, 0, 2568514856, 0, 0, 0, 842062417, 0, 0, 0, 1684124835, 0, 0, 0, 3368249671, 
        0, 0, 0, 2441532046, 0, 0, 0, 588096797, 0, 0, 0, 1176193595, 0, 0, 0, 2352387190, 
        0, 0, 0, 409807085, 0, 0, 0, 819614171, 0, 0, 0, 1639228342, 0, 0, 0, 3278456684, 
        0, 0, 0, 2261946072, 0, 0, 0, 3672740230, 0, 0, 0, 3050513165, 0, 0, 0, 1806059035, 
    },
};

// clang-format on
// clang-format off
static const unsigned int h_lfsr113_sequence_jump_matrices[LFSR113_JUMP_MATRICES][LFSR113_SIZE] = {
    {
        0, 0, 0, 0, 2928597988, 0, 0, 0, 1562228680, 0, 0, 0, 3124457360, 0, 0, 0, 
        1953947424, 0, 0, 0, 3907894849, 0, 0, 0, 3520822403, 0, 0, 0, 2746677510, 0, 0, 0, 
        1198387725, 0, 0, 0, 2396775450, 0, 0, 0, 498583604, 0, 0, 0, 997167209, 0, 0, 0, 
        1994334419, 0, 0, 0, 3988668839, 0, 0, 0, 3682370382, 0, 0, 0, 3069773468, 0, 0, 0, 
        1844579640, 0, 0, 0, 3689159280, 0, 0, 0, 3083351264, 0, 0, 0, 1871735233, 0, 0, 0, 
        3743470466, 0, 0, 0, 3191973636, 0, 0, 0, 2088979976, 0, 0, 0, 4177959953, 0, 0, 0, 
        4060952610, 0, 0, 0, 3826937925, 0, 0, 0, 1723480943, 0, 0, 0, 3446961887, 0, 0, 0, 
        2598956478, 0, 0, 0, 902945660, 0, 0, 0, 1805891321, 0, 0, 0, 3611782642, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1442838528, 0, 0, 
        0, 2885677056, 0, 0, 0, 1476386816, 0, 0, 0, 2952773632, 0, 0, 0, 1610579969, 0, 0, 
        0, 3221159938, 0, 0, 0, 2147352580, 0, 0, 0, 4294705160, 0, 0, 0, 4294443024, 0, 0, 
        0, 4293918752, 0, 0, 0, 4292870208, 0, 0, 0, 4290773120, 0, 0, 0, 4286578944, 0, 0, 
        0, 4278190592, 0, 0, 0, 4261413888, 0, 0, 0, 4227860480, 0, 0, 0, 4160753664, 0, 0, 
        0, 4026540033, 0, 0, 0, 3758112771, 0, 0, 0, 3221258246, 0, 0, 0, 2147549196, 0, 0, 
        0, 131096, 0, 0, 0, 262192, 0, 0, 0, 524384, 0, 0, 0, 1048768, 0, 0, 
        0, 2097536, 0, 0, 0, 4195072, 0, 0, 0, 1434451456, 0, 0, 0, 2868902912, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 536903683, 0, 0, 0, 1073807366, 0, 0, 0, 2147614732, 0, 0, 0, 262168, 0, 
        0, 0, 524336, 0, 0, 0, 1048672, 0, 0, 0, 2097344, 0, 0, 0, 4194688, 0, 
        0, 0, 8389376, 0, 0, 0, 16778752, 0, 0, 0, 33557504, 0, 0, 0, 67115008, 0, 
        0, 0, 134230016, 0, 0, 0, 268460033, 0, 0, 0, 536920067, 0, 0, 0, 1610678276, 0, 
        0, 0, 3221356552, 0, 0, 0, 2147745808, 0, 0, 0, 524320, 0, 0, 0, 1048640, 0, 
        0, 0, 2097280, 0, 0, 0, 4194560, 0, 0, 0, 8389120, 0, 0, 0, 16778240, 0, 
        0, 0, 33556480, 0, 0, 0, 67112960, 0, 0, 0, 134225920, 0, 0, 0, 268451841, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144703526, 
        0, 0, 0, 289407053, 0, 0, 0, 578814107, 0, 0, 0, 1157628214, 0, 0, 0, 2315256429, 
        0, 0, 0, 335545562, 0, 0, 0, 671091124, 0, 0, 0, 1342182248, 0, 0, 0, 2684364496, 
        0, 0, 0, 1073761696, 0, 0, 0, 2147523392, 0, 0, 0, 79488, 0, 0, 0, 158976, 
        0, 0, 0, 317952, 0, 0, 0, 635904, 0, 0, 0, 1271808, 0, 0, 0, 2543616, 
        0, 0, 0, 5087233, 0, 0, 0, 10174466, 0, 0, 0, 20348932, 0, 0, 0, 40697864, 
        0, 0, 0, 81395729, 0, 0, 0, 18087940, 0, 0, 0, 36175881, 0, 0, 0, 72351763, 
    },
    {
        0, 0, 0, 0, 1874778401, 0, 0, 0, 3749556802, 0, 0, 0, 3204146308, 0, 0, 0, 
        2113325320, 0, 0, 0, 4226650640, 0, 0, 0, 4158333984, 0, 0, 0, 4021700672, 0, 0, 0, 
        3748434048, 0, 0, 0, 3201900800, 0, 0, 0, 2108834304, 0, 0, 0, 4217668608, 0, 0, 0, 
        4140369920, 0, 0, 0, 3985772545, 0, 0, 0, 3676577794, 0, 0, 0, 3058188292, 0, 0, 0, 
        1821409288, 0, 0, 0, 3642818577, 0, 0, 0, 2990669858, 0, 0, 0, 1686372420, 0, 0, 0, 
        3372744841, 0, 0, 0, 2450522386, 0, 0, 0, 606077476, 0, 0, 0, 1212154952, 0, 0, 0, 
        2424309905, 0, 0, 0, 553652514, 0, 0, 0, 767490916, 0, 0, 0, 1534981833, 0, 0, 0, 
        3069963666, 0, 0, 0, 1844960036, 0, 0, 0, 3689920072, 0, 0, 0, 3084872848, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 
        0, 32, 0, 0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 
        0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 
        0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 
        0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 
        0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 
        0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 
        0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483652, 0, 0, 0, 8, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 262152, 0, 0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 
        0, 0, 4194432, 0, 0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 
        0, 0, 67110912, 0, 0, 0, 134221824, 0, 0, 0, 268443649, 0, 0, 0, 536887298, 0, 
        0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 0, 0, 131092, 0, 0, 0, 32, 0, 
        0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 
        0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 
        0, 0, 16384, 0, 0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135049252, 
        0, 0, 0, 270098504, 0, 0, 0, 540197008, 0, 0, 0, 1080394017, 0, 0, 0, 2160788035, 
        0, 0, 0, 26608774, 0, 0, 0, 53217549, 0, 0, 0, 106435098, 0, 0, 0, 212870196, 
        0, 0, 0, 425740393, 0, 0, 0, 851480786, 0, 0, 0, 1702961572, 0, 0, 0, 3405923145, 
        0, 0, 0, 2516878995, 0, 0, 0, 738790694, 0, 0, 0, 1477581388, 0, 0, 0, 2955162776, 
        0, 0, 0, 1615358257, 0, 0, 0, 3230716514, 0, 0, 0, 2166465732, 0, 0, 0, 37964168, 
        0, 0, 0, 75928336, 0, 0, 0, 16881156, 0, 0, 0, 33762313, 0, 0, 0, 67524626, 
    },
    {
        0, 0, 0, 0, 882001920, 0, 0, 0, 1764003840, 0, 0, 0, 3528007680, 0, 0, 0, 
        2761048065, 0, 0, 0, 1227128834, 0, 0, 0, 2454257668, 0, 0, 0, 613548040, 0, 0, 0, 
        1227096080, 0, 0, 0, 2454192160, 0, 0, 0, 613417024, 0, 0, 0, 1226834048, 0, 0, 0, 
        2453668096, 0, 0, 0, 612368896, 0, 0, 0, 1224737792, 0, 0, 0, 2449475584, 0, 0, 0, 
        603983872, 0, 0, 0, 1207967744, 0, 0, 0, 2415935489, 0, 0, 0, 536903682, 0, 0, 0, 
        1073807364, 0, 0, 0, 2147614729, 0, 0, 0, 262162, 0, 0, 0, 524324, 0, 0, 0, 
        1048648, 0, 0, 0, 2097296, 0, 0, 0, 886196512, 0, 0, 0, 1772393024, 0, 0, 0, 
        3544786048, 0, 0, 0, 2794604800, 0, 0, 0, 1294242304, 0, 0, 0, 2588484608, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 
        0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 32, 0, 0, 0, 64, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1073774613, 0, 0, 0, 2147549226, 0, 0, 0, 131156, 0, 0, 0, 262312, 0, 
        0, 0, 524624, 0, 0, 0, 1049248, 0, 0, 0, 2098496, 0, 0, 0, 4196992, 0, 
        0, 0, 8393984, 0, 0, 0, 16787968, 0, 0, 0, 33575936, 0, 0, 0, 67151873, 0, 
        0, 0, 134303746, 0, 0, 0, 268607492, 0, 0, 0, 537214984, 0, 0, 0, 655364, 0, 
        0, 0, 1310728, 0, 0, 0, 2621456, 0, 0, 0, 5242912, 0, 0, 0, 10485824, 0, 
        0, 0, 20971648, 0, 0, 0, 41943296, 0, 0, 0, 83886592, 0, 0, 0, 167773184, 0, 
        0, 0, 335546369, 0, 0, 0, 671092738, 0, 0, 0, 1342185477, 0, 0, 0, 2684370954, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3961969350, 
        0, 0, 0, 3628971405, 0, 0, 0, 2962975514, 0, 0, 0, 1630983732, 0, 0, 0, 3261967464, 
        0, 0, 0, 2228967633, 0, 0, 0, 162967970, 0, 0, 0, 325935940, 0, 0, 0, 651871880, 
        0, 0, 0, 1303743760, 0, 0, 0, 2607487520, 0, 0, 0, 920007744, 0, 0, 0, 1840015488, 
        0, 0, 0, 3680030976, 0, 0, 0, 3065094657, 0, 0, 0, 1835222019, 0, 0, 0, 3670444038, 
        0, 0, 0, 3045920780, 0, 0, 0, 1796874265, 0, 0, 0, 3593748531, 0, 0, 0, 2892529767, 
        0, 0, 0, 1490092239, 0, 0, 0, 1568987992, 0, 0, 0, 3137975985, 0, 0, 0, 1980984675, 
    },
    {
        0, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 
        8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 0, 
        131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 
        2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 
        33554433, 0, 0, 0, 67108866, 0, 0, 0, 134217732, 0, 0, 0, 268435464, 0, 0, 0, 
        536870928, 0, 0, 0, 1073741856, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 
        260, 0, 0, 0, 520, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 
        64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 2560, 0, 0, 0, 5120, 0, 0, 
        0, 10240, 0, 0, 0, 20480, 0, 0, 0, 40960, 0, 0, 0, 81920, 0, 0, 
        0, 163840, 0, 0, 0, 327680, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 18087960, 0, 0, 0, 36175920, 0, 0, 0, 72351840, 0, 0, 0, 144703680, 0, 
        0, 0, 289407361, 0, 0, 0, 578814722, 0, 0, 0, 1157629444, 0, 0, 0, 2315258888, 0, 
        0, 0, 335550481, 0, 0, 0, 671100962, 0, 0, 0, 1342201925, 0, 0, 0, 2684403851, 0, 
        0, 0, 1073840407, 0, 0, 0, 2147680814, 0, 0, 0, 394332, 0, 0, 0, 18352288, 0, 
        0, 0, 36704576, 0, 0, 0, 73409152, 0, 0, 0, 146818304, 0, 0, 0, 293636608, 0, 
        0, 0, 587273216, 0, 0, 0, 1174546432, 0, 0, 0, 2349092864, 0, 0, 0, 403218432, 0, 
        0, 0, 806436865, 0, 0, 0, 1612873731, 0, 0, 0, 3225747462, 0, 0, 0, 2156527628, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3548126500, 
        0, 0, 0, 2801285704, 0, 0, 0, 1307604113, 0, 0, 0, 2615208226, 0, 0, 0, 935449156, 
        0, 0, 0, 1870898313, 0, 0, 0, 3741796627, 0, 0, 0, 3188625959, 0, 0, 0, 2082284622, 
        0, 0, 0, 4164569244, 0, 0, 0, 4034171193, 0, 0, 0, 3773375091, 0, 0, 0, 3251782887, 
        0, 0, 0, 2208598479, 0, 0, 0, 122229662, 0, 0, 0, 244459325, 0, 0, 0, 488918650, 
        0, 0, 0, 977837300, 0, 0, 0, 1955674600, 0, 0, 0, 3911349200, 0, 0, 0, 3527731104, 
        0, 0, 0, 2760494912, 0, 0, 0, 2590999460, 0, 0, 0, 887031625, 0, 0, 0, 1774063250, 
    },
    {
        0, 0, 0, 0, 4160, 0, 0, 0, 8320, 0, 0, 0, 16640, 0, 0, 0, 
        33280, 0, 0, 0, 66560, 0, 0, 0, 133120, 0, 0, 0, 266240, 0, 0, 0, 
        532480, 0, 0, 0, 1064960, 0, 0, 0, 2129920, 0, 0, 0, 4259840, 0, 0, 0, 
        8519680, 0, 0, 0, 17039360, 0, 0, 0, 34078721, 0, 0, 0, 68157442, 0, 0, 0, 
        136314884, 0, 0, 0, 272629768, 0, 0, 0, 545259536, 0, 0, 0, 1090519072, 0, 0, 0, 
        2181038144, 0, 0, 0, 67108992, 0, 0, 0, 134217984, 0, 0, 0, 268435968, 0, 0, 0, 
        536871936, 0, 0, 0, 1073743872, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 
        260, 0, 0, 0, 520, 0, 0, 0, 1040, 0, 0, 0, 2080, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8704, 0, 0, 
        0, 17408, 0, 0, 0, 34816, 0, 0, 0, 69632, 0, 0, 0, 139264, 0, 0, 
        0, 278528, 0, 0, 0, 557056, 0, 0, 0, 1114112, 0, 0, 0, 2228224, 0, 0, 
        0, 4456448, 0, 0, 0, 8912896, 0, 0, 0, 17825792, 0, 0, 0, 35651584, 0, 0, 
        0, 71303168, 0, 0, 0, 142606337, 0, 0, 0, 285212674, 0, 0, 0, 570425349, 0, 0, 
        0, 1140850698, 0, 0, 0, 2281701397, 0, 0, 0, 268435498, 0, 0, 0, 536870997, 0, 0, 
        0, 1073741994, 0, 0, 0, 2147483988, 0, 0, 0, 680, 0, 0, 0, 1360, 0, 0, 
        0, 2720, 0, 0, 0, 5440, 0, 0, 0, 2176, 0, 0, 0, 4352, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1417720836, 0, 0, 0, 2835441672, 0, 0, 0, 1375916048, 0, 0, 0, 2751832097, 0, 
        0, 0, 1208696898, 0, 0, 0, 2417393796, 0, 0, 0, 539820296, 0, 0, 0, 1079640592, 0, 
        0, 0, 2159281184, 0, 0, 0, 23595072, 0, 0, 0, 47190144, 0, 0, 0, 94380288, 0, 
        0, 0, 188760576, 0, 0, 0, 377521152, 0, 0, 0, 755042304, 0, 0, 0, 243442693, 0, 
        0, 0, 486885387, 0, 0, 0, 973770774, 0, 0, 0, 1947541549, 0, 0, 0, 3895083098, 0, 
        0, 0, 3495198900, 0, 0, 0, 2695430504, 0, 0, 0, 1095893712, 0, 0, 0, 2191787424, 0, 
        0, 0, 88607552, 0, 0, 0, 177215104, 0, 0, 0, 354430209, 0, 0, 0, 708860418, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 357270623, 
        0, 0, 0, 714541247, 0, 0, 0, 1429082494, 0, 0, 0, 2858164988, 0, 0, 0, 1421362680, 
        0, 0, 0, 2842725361, 0, 0, 0, 1390483426, 0, 0, 0, 2780966853, 0, 0, 0, 1266966411, 
        0, 0, 0, 2533932823, 0, 0, 0, 772898351, 0, 0, 0, 1545796702, 0, 0, 0, 3091593405, 
        0, 0, 0, 1888219514, 0, 0, 0, 3776439028, 0, 0, 0, 3257910761, 0, 0, 0, 2220854227, 
        0, 0, 0, 146741158, 0, 0, 0, 293482317, 0, 0, 0, 586964634, 0, 0, 0, 1173929269, 
        0, 0, 0, 2347858538, 0, 0, 0, 44658827, 0, 0, 0, 89317655, 0, 0, 0, 178635311, 
    },
    {
        0, 0, 0, 0, 3162112, 0, 0, 0, 6324224, 0, 0, 0, 12648448, 0, 0, 0, 
        25296896, 0, 0, 0, 50593793, 0, 0, 0, 101187587, 0, 0, 0, 202375174, 0, 0, 0, 
        404750348, 0, 0, 0, 809500696, 0, 0, 0, 1619001392, 0, 0, 0, 3238002785, 0, 0, 0, 
        2181038274, 0, 0, 0, 67109252, 0, 0, 0, 134218504, 0, 0, 0, 268437008, 0, 0, 0, 
        536874016, 0, 0, 0, 1073748032, 0, 0, 0, 2147496065, 0, 0, 0, 24834, 0, 0, 0, 
        49668, 0, 0, 0, 99336, 0, 0, 0, 198672, 0, 0, 0, 397344, 0, 0, 0, 
        794688, 0, 0, 0, 1589376, 0, 0, 0, 49408, 0, 0, 0, 98816, 0, 0, 0, 
        197632, 0, 0, 0, 395264, 0, 0, 0, 790528, 0, 0, 0, 1581056, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134299649, 0, 0, 
        0, 268599298, 0, 0, 0, 537198597, 0, 0, 0, 1074397194, 0, 0, 0, 2148794388, 0, 0, 
        0, 2621480, 0, 0, 0, 5242960, 0, 0, 0, 10485920, 0, 0, 0, 20971840, 0, 0, 
        0, 41943680, 0, 0, 0, 83887360, 0, 0, 0, 167774721, 0, 0, 0, 335549442, 0, 0, 
        0, 671098884, 0, 0, 0, 1342197768, 0, 0, 0, 2684395537, 0, 0, 0, 1073823778, 0, 0, 
        0, 2147647556, 0, 0, 0, 327816, 0, 0, 0, 655632, 0, 0, 0, 1311264, 0, 0, 
        0, 2622528, 0, 0, 0, 5245056, 0, 0, 0, 10490112, 0, 0, 0, 20980224, 0, 0, 
        0, 41960448, 0, 0, 0, 83920896, 0, 0, 0, 33574912, 0, 0, 0, 67149824, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 844445257, 0, 0, 0, 1688890514, 0, 0, 0, 3377781029, 0, 0, 0, 2460594762, 0, 
        0, 0, 626222228, 0, 0, 0, 1252444457, 0, 0, 0, 2504888914, 0, 0, 0, 714810532, 0, 
        0, 0, 1429621065, 0, 0, 0, 2859242131, 0, 0, 0, 1423516967, 0, 0, 0, 2847033934, 0, 
        0, 0, 1399100572, 0, 0, 0, 2798201144, 0, 0, 0, 1301434992, 0, 0, 0, 2842792617, 0, 
        0, 0, 1390617939, 0, 0, 0, 2781235878, 0, 0, 0, 1267504461, 0, 0, 0, 2535008923, 0, 
        0, 0, 775050550, 0, 0, 0, 1550101100, 0, 0, 0, 3100202201, 0, 0, 0, 1905437106, 0, 
        0, 0, 3810874212, 0, 0, 0, 3326781129, 0, 0, 0, 2358594962, 0, 0, 0, 422222628, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3265725291, 
        0, 0, 0, 2236483287, 0, 0, 0, 177999279, 0, 0, 0, 355998558, 0, 0, 0, 711997116, 
        0, 0, 0, 1423994233, 0, 0, 0, 2847988467, 0, 0, 0, 1401009639, 0, 0, 0, 2802019279, 
        0, 0, 0, 1309071263, 0, 0, 0, 2618142526, 0, 0, 0, 941317756, 0, 0, 0, 1882635512, 
        0, 0, 0, 3765271025, 0, 0, 0, 3235574755, 0, 0, 0, 2176182214, 0, 0, 0, 57397132, 
        0, 0, 0, 114794264, 0, 0, 0, 229588528, 0, 0, 0, 459177056, 0, 0, 0, 918354113, 
        0, 0, 0, 1836708227, 0, 0, 0, 408215661, 0, 0, 0, 816431322, 0, 0, 0, 1632862645, 
    },
    {
        0, 0, 0, 0, 2554888269, 0, 0, 0, 814809242, 0, 0, 0, 1629618484, 0, 0, 0, 
        3259236968, 0, 0, 0, 2223506641, 0, 0, 0, 152045986, 0, 0, 0, 304091973, 0, 0, 0, 
        608183946, 0, 0, 0, 1216367892, 0, 0, 0, 2432735785, 0, 0, 0, 570504275, 0, 0, 0, 
        1141008550, 0, 0, 0, 2282017101, 0, 0, 0, 269066906, 0, 0, 0, 538133812, 0, 0, 0, 
        1076267624, 0, 0, 0, 2152535249, 0, 0, 0, 10103202, 0, 0, 0, 20206404, 0, 0, 0, 
        40412809, 0, 0, 0, 80825618, 0, 0, 0, 161651236, 0, 0, 0, 323302473, 0, 0, 0, 
        646604947, 0, 0, 0, 1293209894, 0, 0, 0, 39920129, 0, 0, 0, 79840258, 0, 0, 0, 
        159680516, 0, 0, 0, 319361033, 0, 0, 0, 638722067, 0, 0, 0, 1277444134, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 336678914, 0, 0, 
        0, 673357828, 0, 0, 0, 1346715656, 0, 0, 0, 2693431313, 0, 0, 0, 1091895330, 0, 0, 
        0, 2183790660, 0, 0, 0, 72614024, 0, 0, 0, 145228049, 0, 0, 0, 290456098, 0, 0, 
        0, 580912197, 0, 0, 0, 1161824394, 0, 0, 0, 2323648789, 0, 0, 0, 352330282, 0, 0, 
        0, 704660564, 0, 0, 0, 1409321128, 0, 0, 0, 2818642256, 0, 0, 0, 1342317216, 0, 0, 
        0, 2684634433, 0, 0, 0, 1074301570, 0, 0, 0, 2148603140, 0, 0, 0, 2238984, 0, 0, 
        0, 4477968, 0, 0, 0, 8955936, 0, 0, 0, 17911872, 0, 0, 0, 35823744, 0, 0, 
        0, 71647488, 0, 0, 0, 143294977, 0, 0, 0, 84169728, 0, 0, 0, 168339457, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 3001529316, 0, 0, 0, 1708091336, 0, 0, 0, 3416182673, 0, 0, 0, 2537398050, 0, 
        0, 0, 779828804, 0, 0, 0, 1559657609, 0, 0, 0, 3119315218, 0, 0, 0, 1943663140, 0, 
        0, 0, 3887326281, 0, 0, 0, 3479685267, 0, 0, 0, 2664403238, 0, 0, 0, 1033839181, 0, 
        0, 0, 2067678363, 0, 0, 0, 4135356726, 0, 0, 0, 3975746156, 0, 0, 0, 1796577085, 0, 
        0, 0, 3593154171, 0, 0, 0, 2891341046, 0, 0, 0, 1487714796, 0, 0, 0, 2975429593, 0, 
        0, 0, 1655891891, 0, 0, 0, 3311783783, 0, 0, 0, 2328600271, 0, 0, 0, 362233247, 0, 
        0, 0, 724466494, 0, 0, 0, 1448932988, 0, 0, 0, 2897865977, 0, 0, 0, 1500764658, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3612118070, 
        0, 0, 0, 2929268845, 0, 0, 0, 1563570394, 0, 0, 0, 3127140788, 0, 0, 0, 1959314281, 
        0, 0, 0, 3918628562, 0, 0, 0, 3542289829, 0, 0, 0, 2789612362, 0, 0, 0, 1284257428, 
        0, 0, 0, 2568514856, 0, 0, 0, 842062417, 0, 0, 0, 1684124835, 0, 0, 0, 3368249671, 
        0, 0, 0, 2441532046, 0, 0, 0, 588096797, 0, 0, 0, 1176193595, 0, 0, 0, 2352387190, 
        0, 0, 0, 409807085, 0, 0, 0, 819614171, 0, 0, 0, 1639228342, 0, 0, 0, 3278456684, 
        0, 0, 0, 2261946072, 0, 0, 0, 3672740230, 0, 0, 0, 3050513165, 0, 0, 0, 1806059035, 
    },
    {
        0, 0, 0, 0, 1164254896, 0, 0, 0, 2328509792, 0, 0, 0, 362052288, 0, 0, 0, 
        724104577, 0, 0, 0, 1448209155, 0, 0, 0, 2896418311, 0, 0, 0, 1497869326, 0, 0, 0, 
        2995738652, 0, 0, 0, 1696510008, 0, 0, 0, 3393020016, 0, 0, 0, 2491072737, 0, 0, 0, 
        687178178, 0, 0, 0, 1374356356, 0, 0, 0, 2748712712, 0, 0, 0, 1202458129, 0, 0, 0, 
        2404916258, 0, 0, 0, 514865221, 0, 0, 0, 1029730442, 0, 0, 0, 2059460885, 0, 0, 0, 
        4118921771, 0, 0, 0, 3942876246, 0, 0, 0, 3590785196, 0, 0, 0, 2886603097, 0, 0, 0, 
        1478238898, 0, 0, 0, 2956477797, 0, 0, 0, 622171258, 0, 0, 0, 1244342517, 0, 0, 0, 
        2488685035, 0, 0, 0, 682402774, 0, 0, 0, 1364805548, 0, 0, 0, 2729611096, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 339960066, 0, 0, 
        0, 679920132, 0, 0, 0, 1359840264, 0, 0, 0, 2719680529, 0, 0, 0, 1144393762, 0, 0, 
        0, 2288787525, 0, 0, 0, 282607754, 0, 0, 0, 565215509, 0, 0, 0, 1130431018, 0, 0, 
        0, 2260862036, 0, 0, 0, 226756777, 0, 0, 0, 453513555, 0, 0, 0, 907027111, 0, 0, 
        0, 1814054222, 0, 0, 0, 3628108445, 0, 0, 0, 2961249595, 0, 0, 0, 1627531895, 0, 0, 
        0, 3255063790, 0, 0, 0, 2215160284, 0, 0, 0, 135353273, 0, 0, 0, 270706546, 0, 0, 
        0, 541413093, 0, 0, 0, 1082826186, 0, 0, 0, 2165652372, 0, 0, 0, 36337448, 0, 0, 
        0, 72674896, 0, 0, 0, 145349793, 0, 0, 0, 84990016, 0, 0, 0, 169980033, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2938358989, 0, 0, 0, 1581750682, 0, 0, 0, 3163501365, 0, 0, 0, 2032035435, 0, 
        0, 0, 4064070870, 0, 0, 0, 3833174445, 0, 0, 0, 3371381594, 0, 0, 0, 2447795893, 0, 
        0, 0, 600624491, 0, 0, 0, 1201248983, 0, 0, 0, 2402497966, 0, 0, 0, 510028637, 0, 
        0, 0, 1020057274, 0, 0, 0, 2040114548, 0, 0, 0, 4080229097, 0, 0, 0, 1229289758, 0, 
        0, 0, 2458579516, 0, 0, 0, 622191737, 0, 0, 0, 1244383475, 0, 0, 0, 2488766950, 0, 
        0, 0, 682566604, 0, 0, 0, 1365133209, 0, 0, 0, 2730266419, 0, 0, 0, 1165565542, 0, 
        0, 0, 2331131084, 0, 0, 0, 367294873, 0, 0, 0, 734589747, 0, 0, 0, 1469179494, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 490940283, 
        0, 0, 0, 981880567, 0, 0, 0, 1963761134, 0, 0, 0, 3927522269, 0, 0, 0, 3560077242, 
        0, 0, 0, 2825187189, 0, 0, 0, 1355407083, 0, 0, 0, 2710814166, 0, 0, 0, 1126661037, 
        0, 0, 0, 2253322074, 0, 0, 0, 211676852, 0, 0, 0, 423353704, 0, 0, 0, 846707408, 
        0, 0, 0, 1693414817, 0, 0, 0, 3386829635, 0, 0, 0, 2478691975, 0, 0, 0, 662416654, 
        0, 0, 0, 1324833308, 0, 0, 0, 2649666617, 0, 0, 0, 1004365938, 0, 0, 0, 2008731877, 
        0, 0, 0, 4017463754, 0, 0, 0, 3282593007, 0, 0, 0, 2270218718, 0, 0, 0, 245470141, 
    },
    {
        0, 0, 0, 0, 126298325, 0, 0, 0, 252596651, 0, 0, 0, 505193303, 0, 0, 0, 
        1010386606, 0, 0, 0, 2020773212, 0, 0, 0, 4041546425, 0, 0, 0, 3788125555, 0, 0, 0, 
        3281283814, 0, 0, 0, 2267600332, 0, 0, 0, 240233369, 0, 0, 0, 480466738, 0, 0, 0, 
        960933476, 0, 0, 0, 1921866953, 0, 0, 0, 3843733907, 0, 0, 0, 3392500518, 0, 0, 0, 
        2490033741, 0, 0, 0, 685100186, 0, 0, 0, 1370200372, 0, 0, 0, 2740400744, 0, 0, 0, 
        1185834193, 0, 0, 0, 2371668387, 0, 0, 0, 448369479, 0, 0, 0, 896738958, 0, 0, 0, 
        1793477917, 0, 0, 0, 3586955835, 0, 0, 0, 2887654563, 0, 0, 0, 1480341830, 0, 0, 0, 
        2960683661, 0, 0, 0, 1626400026, 0, 0, 0, 3252800053, 0, 0, 0, 2210632810, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1457526048, 0, 0, 
        0, 2915052096, 0, 0, 0, 1535136897, 0, 0, 0, 3070273795, 0, 0, 0, 1845580294, 0, 0, 
        0, 3691160589, 0, 0, 0, 3087353882, 0, 0, 0, 1879740469, 0, 0, 0, 3759480939, 0, 0, 
        0, 3223994582, 0, 0, 0, 2153021868, 0, 0, 0, 11076440, 0, 0, 0, 22152880, 0, 0, 
        0, 44305760, 0, 0, 0, 88611520, 0, 0, 0, 177223041, 0, 0, 0, 354446082, 0, 0, 
        0, 708892164, 0, 0, 0, 1417784328, 0, 0, 0, 2835568656, 0, 0, 0, 1376170016, 0, 0, 
        0, 2752340033, 0, 0, 0, 1209712771, 0, 0, 0, 2419425542, 0, 0, 0, 543883789, 0, 0, 
        0, 1087767578, 0, 0, 0, 2175535156, 0, 0, 0, 1438123336, 0, 0, 0, 2876246672, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1801783692, 0, 0, 0, 3603567385, 0, 0, 0, 2912167474, 0, 0, 0, 1529367653, 0, 
        0, 0, 3058735306, 0, 0, 0, 1822503316, 0, 0, 0, 3645006633, 0, 0, 0, 2995045970, 0, 
        0, 0, 1695124645, 0, 0, 0, 3390249290, 0, 0, 0, 2485531285, 0, 0, 0, 676095274, 0, 
        0, 0, 1352190548, 0, 0, 0, 2704381097, 0, 0, 0, 1113794898, 0, 0, 0, 4020460328, 0, 
        0, 0, 3745953360, 0, 0, 0, 3196939425, 0, 0, 0, 2098911554, 0, 0, 0, 4197823108, 0, 
        0, 0, 4100678921, 0, 0, 0, 3906390547, 0, 0, 0, 3517813798, 0, 0, 0, 2740660300, 0, 
        0, 0, 1186353304, 0, 0, 0, 2372706609, 0, 0, 0, 450445923, 0, 0, 0, 900891846, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42029323, 
        0, 0, 0, 84058646, 0, 0, 0, 168117293, 0, 0, 0, 336234586, 0, 0, 0, 672469172, 
        0, 0, 0, 1344938344, 0, 0, 0, 2689876689, 0, 0, 0, 1084786082, 0, 0, 0, 2169572165, 
        0, 0, 0, 44177035, 0, 0, 0, 88354071, 0, 0, 0, 176708143, 0, 0, 0, 353416286, 
        0, 0, 0, 706832573, 0, 0, 0, 1413665147, 0, 0, 0, 2827330294, 0, 0, 0, 1359693292, 
        0, 0, 0, 2719386585, 0, 0, 0, 1143805874, 0, 0, 0, 2287611749, 0, 0, 0, 280256202, 
        0, 0, 0, 560512405, 0, 0, 0, 1078995489, 0, 0, 0, 2157990978, 0, 0, 0, 21014661, 
    },
    {
        0, 0, 0, 0, 3480795388, 0, 0, 0, 2666623480, 0, 0, 0, 1038279664, 0, 0, 0, 
        2076559329, 0, 0, 0, 4153118658, 0, 0, 0, 4011270020, 0, 0, 0, 3727572744, 0, 0, 0, 
        3160178193, 0, 0, 0, 2025389090, 0, 0, 0, 4050778181, 0, 0, 0, 3806589066, 0, 0, 0, 
        3318210837, 0, 0, 0, 2341454378, 0, 0, 0, 387941461, 0, 0, 0, 775882923, 0, 0, 0, 
        1551765846, 0, 0, 0, 3103531693, 0, 0, 0, 1912096090, 0, 0, 0, 3824192180, 0, 0, 0, 
        3353417064, 0, 0, 0, 2411866832, 0, 0, 0, 528766369, 0, 0, 0, 1057532739, 0, 0, 0, 
        2115065479, 0, 0, 0, 4230130959, 0, 0, 0, 926802659, 0, 0, 0, 1853605319, 0, 0, 0, 
        3707210639, 0, 0, 0, 3119453983, 0, 0, 0, 1943940671, 0, 0, 0, 3887881342, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4124527681, 0, 0, 
        0, 3954088066, 0, 0, 0, 3613208836, 0, 0, 0, 2931450376, 0, 0, 0, 1567933457, 0, 0, 
        0, 3135866914, 0, 0, 0, 1976766533, 0, 0, 0, 3953533066, 0, 0, 0, 3612098836, 0, 0, 
        0, 2929230376, 0, 0, 0, 1563493457, 0, 0, 0, 3126986914, 0, 0, 0, 1959006533, 0, 0, 
        0, 3918013066, 0, 0, 0, 3541058836, 0, 0, 0, 2787150377, 0, 0, 0, 1279333459, 0, 0, 
        0, 2558666919, 0, 0, 0, 822366543, 0, 0, 0, 1644733087, 0, 0, 0, 3289466174, 0, 0, 
        0, 2283965053, 0, 0, 0, 272962810, 0, 0, 0, 545925621, 0, 0, 0, 1091851242, 0, 0, 
        0, 2183702484, 0, 0, 0, 72437672, 0, 0, 0, 4252357392, 0, 0, 0, 4209747488, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2656366736, 0, 0, 0, 1017766176, 0, 0, 0, 2035532352, 0, 0, 0, 4071064704, 0, 
        0, 0, 3847162112, 0, 0, 0, 3399356928, 0, 0, 0, 2503746561, 0, 0, 0, 712525826, 0, 
        0, 0, 1425051652, 0, 0, 0, 2850103304, 0, 0, 0, 1405239313, 0, 0, 0, 2810478627, 0, 
        0, 0, 1325989958, 0, 0, 0, 2651979917, 0, 0, 0, 1008992539, 0, 0, 0, 3860656807, 0, 
        0, 0, 3426346319, 0, 0, 0, 2557725342, 0, 0, 0, 820483388, 0, 0, 0, 1640966776, 0, 
        0, 0, 3281933552, 0, 0, 0, 2268899809, 0, 0, 0, 242832322, 0, 0, 0, 485664644, 0, 
        0, 0, 971329289, 0, 0, 0, 1942658578, 0, 0, 0, 3885317156, 0, 0, 0, 3475667016, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 537135248, 
        0, 0, 0, 1074270496, 0, 0, 0, 2148540992, 0, 0, 0, 2114688, 0, 0, 0, 4229377, 
        0, 0, 0, 8458754, 0, 0, 0, 16917508, 0, 0, 0, 33835017, 0, 0, 0, 67670034, 
        0, 0, 0, 135340068, 0, 0, 0, 270680136, 0, 0, 0, 541360273, 0, 0, 0, 1082720546, 
        0, 0, 0, 2165441092, 0, 0, 0, 35914889, 0, 0, 0, 71829779, 0, 0, 0, 143659558, 
        0, 0, 0, 287319116, 0, 0, 0, 574638232, 0, 0, 0, 1149276464, 0, 0, 0, 2298552928, 
        0, 0, 0, 302138561, 0, 0, 0, 67141906, 0, 0, 0, 134283812, 0, 0, 0, 268567624, 
    },
    {
        0, 0, 0, 0, 460238757, 0, 0, 0, 920477515, 0, 0, 0, 1840955030, 0, 0, 0, 
        3681910060, 0, 0, 0, 3068852824, 0, 0, 0, 1842738352, 0, 0, 0, 3685476704, 0, 0, 0, 
        3075986112, 0, 0, 0, 1857004929, 0, 0, 0, 3714009859, 0, 0, 0, 3133052422, 0, 0, 0, 
        1971137548, 0, 0, 0, 3942275096, 0, 0, 0, 3589582897, 0, 0, 0, 2884198498, 0, 0, 0, 
        1473429701, 0, 0, 0, 2946859402, 0, 0, 0, 1598751509, 0, 0, 0, 3197503018, 0, 0, 0, 
        2100038740, 0, 0, 0, 4200077480, 0, 0, 0, 4105187665, 0, 0, 0, 3915408035, 0, 0, 0, 
        3535848774, 0, 0, 0, 2776730253, 0, 0, 0, 1349368510, 0, 0, 0, 2698737021, 0, 0, 0, 
        1102506746, 0, 0, 0, 2205013492, 0, 0, 0, 115059689, 0, 0, 0, 230119378, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3560175108, 0, 0, 
        0, 2825382920, 0, 0, 0, 1355798544, 0, 0, 0, 2711597089, 0, 0, 0, 1128226882, 0, 0, 
        0, 2256453764, 0, 0, 0, 217940233, 0, 0, 0, 435880467, 0, 0, 0, 871760935, 0, 0, 
        0, 1743521871, 0, 0, 0, 3487043743, 0, 0, 0, 2679120191, 0, 0, 0, 1063273086, 0, 0, 
        0, 2126546172, 0, 0, 0, 4253092344, 0, 0, 0, 4211217392, 0, 0, 0, 4127467489, 0, 0, 
        0, 3959967682, 0, 0, 0, 3624968069, 0, 0, 0, 2954968843, 0, 0, 0, 1614970391, 0, 0, 
        0, 3229940782, 0, 0, 0, 2164914268, 0, 0, 0, 34861240, 0, 0, 0, 69722480, 0, 0, 
        0, 139444961, 0, 0, 0, 278889922, 0, 0, 0, 4111269249, 0, 0, 0, 3927571202, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2424557694, 0, 0, 0, 554148093, 0, 0, 0, 1108296186, 0, 0, 0, 2216592373, 0, 
        0, 0, 138217450, 0, 0, 0, 276434901, 0, 0, 0, 552869802, 0, 0, 0, 1105739604, 0, 
        0, 0, 2211479208, 0, 0, 0, 127991121, 0, 0, 0, 255982243, 0, 0, 0, 511964486, 0, 
        0, 0, 1023928972, 0, 0, 0, 2047857944, 0, 0, 0, 4095715888, 0, 0, 0, 2025620510, 0, 
        0, 0, 4051241021, 0, 0, 0, 3807514746, 0, 0, 0, 3320062196, 0, 0, 0, 2345157096, 0, 
        0, 0, 395346896, 0, 0, 0, 790693792, 0, 0, 0, 1581387585, 0, 0, 0, 3162775171, 0, 
        0, 0, 2030583047, 0, 0, 0, 4061166095, 0, 0, 0, 3827364895, 0, 0, 0, 3359762495, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1048576, 
        0, 0, 0, 2097152, 0, 0, 0, 4194305, 0, 0, 0, 8388610, 0, 0, 0, 16777220, 
        0, 0, 0, 33554441, 0, 0, 0, 67108882, 0, 0, 0, 134217764, 0, 0, 0, 268435528, 
        0, 0, 0, 536871056, 0, 0, 0, 1073742112, 0, 0, 0, 2147484224, 0, 0, 0, 1152, 
        0, 0, 0, 2304, 0, 0, 0, 4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 
        0, 0, 0, 36864, 0, 0, 0, 73728, 0, 0, 0, 147456, 0, 0, 0, 294912, 
        0, 0, 0, 589824, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 
    },
    {
        0, 0, 0, 0, 1980210557, 0, 0, 0, 3960421115, 0, 0, 0, 3625874935, 0, 0, 0, 
        2956782575, 0, 0, 0, 1618597854, 0, 0, 0, 3237195709, 0, 0, 0, 2179424123, 0, 0, 0, 
        63880951, 0, 0, 0, 127761903, 0, 0, 0, 255523807, 0, 0, 0, 511047615, 0, 0, 0, 
        1022095230, 0, 0, 0, 2044190460, 0, 0, 0, 4088380920, 0, 0, 0, 3881794544, 0, 0, 0, 
        3468621792, 0, 0, 0, 2642276289, 0, 0, 0, 989585283, 0, 0, 0, 1979170566, 0, 0, 0, 
        3958341132, 0, 0, 0, 3621714968, 0, 0, 0, 2948462640, 0, 0, 0, 1601957985, 0, 0, 0, 
        3203915970, 0, 0, 0, 2112864644, 0, 0, 0, 2379751029, 0, 0, 0, 464534763, 0, 0, 0, 
        929069527, 0, 0, 0, 1858139055, 0, 0, 0, 3716278111, 0, 0, 0, 3137588926, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3625984309, 0, 0, 
        0, 2957001323, 0, 0, 0, 1619035351, 0, 0, 0, 3238070702, 0, 0, 0, 2181174108, 0, 0, 
        0, 67380920, 0, 0, 0, 134761841, 0, 0, 0, 269523682, 0, 0, 0, 539047365, 0, 0, 
        0, 1078094730, 0, 0, 0, 2156189460, 0, 0, 0, 17411624, 0, 0, 0, 34823248, 0, 0, 
        0, 69646496, 0, 0, 0, 139292993, 0, 0, 0, 278585986, 0, 0, 0, 557171973, 0, 0, 
        0, 1114343946, 0, 0, 0, 2228687892, 0, 0, 0, 162408489, 0, 0, 0, 324816978, 0, 0, 
        0, 649633957, 0, 0, 0, 1299267915, 0, 0, 0, 2598535831, 0, 0, 0, 902104367, 0, 0, 
        0, 1804208734, 0, 0, 0, 3608417468, 0, 0, 0, 1980237901, 0, 0, 0, 3960475802, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 70539992, 0, 0, 0, 141079985, 0, 0, 0, 282159971, 0, 0, 0, 564319943, 0, 
        0, 0, 1128639887, 0, 0, 0, 2257279774, 0, 0, 0, 219592253, 0, 0, 0, 439184507, 0, 
        0, 0, 878369014, 0, 0, 0, 1756738029, 0, 0, 0, 3513476059, 0, 0, 0, 2731984823, 0, 
        0, 0, 1169002351, 0, 0, 0, 2338004702, 0, 0, 0, 381042109, 0, 0, 0, 693641634, 0, 
        0, 0, 1387283269, 0, 0, 0, 2774566539, 0, 0, 0, 1254165782, 0, 0, 0, 2508331565, 0, 
        0, 0, 721695834, 0, 0, 0, 1443391669, 0, 0, 0, 2886783339, 0, 0, 0, 1478599382, 0, 
        0, 0, 2957198765, 0, 0, 0, 1619430235, 0, 0, 0, 3238860470, 0, 0, 0, 2182753644, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33280, 
        0, 0, 0, 66560, 0, 0, 0, 133120, 0, 0, 0, 266240, 0, 0, 0, 532480, 
        0, 0, 0, 1064960, 0, 0, 0, 2129920, 0, 0, 0, 4259841, 0, 0, 0, 8519682, 
        0, 0, 0, 17039364, 0, 0, 0, 34078729, 0, 0, 0, 68157458, 0, 0, 0, 136314916, 
        0, 0, 0, 272629833, 0, 0, 0, 545259666, 0, 0, 0, 1090519332, 0, 0, 0, 2181038665, 
        0, 0, 0, 67110034, 0, 0, 0, 134220068, 0, 0, 0, 268440136, 0, 0, 0, 536880272, 
        0, 0, 0, 1073760544, 0, 0, 0, 2147487808, 0, 0, 0, 8320, 0, 0, 0, 16640, 
    },
    {
        0, 0, 0, 0, 893107048, 0, 0, 0, 1786214097, 0, 0, 0, 3572428195, 0, 0, 0, 
        2849889095, 0, 0, 0, 1404810895, 0, 0, 0, 2809621790, 0, 0, 0, 1324276285, 0, 0, 0, 
        2648552571, 0, 0, 0, 1002137847, 0, 0, 0, 2004275695, 0, 0, 0, 4008551390, 0, 0, 0, 
        3722135485, 0, 0, 0, 3149303674, 0, 0, 0, 2003640053, 0, 0, 0, 4007280106, 0, 0, 0, 
        3719592917, 0, 0, 0, 3144218538, 0, 0, 0, 1993469781, 0, 0, 0, 3986939563, 0, 0, 0, 
        3678911830, 0, 0, 0, 3062856364, 0, 0, 0, 1830745432, 0, 0, 0, 3661490864, 0, 0, 0, 
        3028014433, 0, 0, 0, 1761061570, 0, 0, 0, 3839160045, 0, 0, 0, 3383352795, 0, 0, 0, 
        2471738294, 0, 0, 0, 648509293, 0, 0, 0, 1297018586, 0, 0, 0, 2594037172, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99817600, 0, 0, 
        0, 199635201, 0, 0, 0, 399270402, 0, 0, 0, 798540804, 0, 0, 0, 1597081609, 0, 0, 
        0, 3194163218, 0, 0, 0, 2093359140, 0, 0, 0, 4186718280, 0, 0, 0, 4078469265, 0, 0, 
        0, 3861971235, 0, 0, 0, 3428975175, 0, 0, 0, 2562983055, 0, 0, 0, 830998815, 0, 0, 
        0, 1661997631, 0, 0, 0, 3323995262, 0, 0, 0, 2353023229, 0, 0, 0, 411079163, 0, 0, 
        0, 822158327, 0, 0, 0, 1644316655, 0, 0, 0, 3288633310, 0, 0, 0, 2282299325, 0, 0, 
        0, 269631354, 0, 0, 0, 539262709, 0, 0, 0, 1078525418, 0, 0, 0, 2157050836, 0, 0, 
        0, 19134376, 0, 0, 0, 38268752, 0, 0, 0, 24954400, 0, 0, 0, 49908800, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1770227281, 0, 0, 0, 3540454563, 0, 0, 0, 2785941830, 0, 0, 0, 1276916364, 0, 
        0, 0, 2553832729, 0, 0, 0, 812698162, 0, 0, 0, 1625396325, 0, 0, 0, 3250792650, 0, 
        0, 0, 2206618004, 0, 0, 0, 118268713, 0, 0, 0, 236537426, 0, 0, 0, 473074852, 0, 
        0, 0, 946149705, 0, 0, 0, 1892299411, 0, 0, 0, 3784598822, 0, 0, 0, 2863352860, 0, 
        0, 0, 1431738424, 0, 0, 0, 2863476848, 0, 0, 0, 1431986401, 0, 0, 0, 2863972803, 0, 
        0, 0, 1432978310, 0, 0, 0, 2865956620, 0, 0, 0, 1436945945, 0, 0, 0, 2873891890, 0, 
        0, 0, 1452816485, 0, 0, 0, 2905632970, 0, 0, 0, 1516298644, 0, 0, 0, 3032597288, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180224, 
        0, 0, 0, 360448, 0, 0, 0, 720896, 0, 0, 0, 1441792, 0, 0, 0, 2883584, 
        0, 0, 0, 5767169, 0, 0, 0, 11534338, 0, 0, 0, 23068677, 0, 0, 0, 46137354, 
        0, 0, 0, 92274708, 0, 0, 0, 184549417, 0, 0, 0, 369098835, 0, 0, 0, 738197670, 
        0, 0, 0, 1476395340, 0, 0, 0, 2952790680, 0, 0, 0, 1610614064, 0, 0, 0, 3221228128, 
        0, 0, 0, 2147488960, 0, 0, 0, 10624, 0, 0, 0, 21248, 0, 0, 0, 42496, 
        0, 0, 0, 84992, 0, 0, 0, 22528, 0, 0, 0, 45056, 0, 0, 0, 90112, 
    },
    {
        0, 0, 0, 0, 2113541784, 0, 0, 0, 4227083568, 0, 0, 0, 4159199840, 0, 0, 0, 
        4023432384, 0, 0, 0, 3751897472, 0, 0, 0, 3208827648, 0, 0, 0, 2122688001, 0, 0, 0, 
        4245376003, 0, 0, 0, 4195784710, 0, 0, 0, 4096602125, 0, 0, 0, 3898236955, 0, 0, 0, 
        3501506615, 0, 0, 0, 2708045935, 0, 0, 0, 1121124575, 0, 0, 0, 2242249151, 0, 0, 0, 
        189531007, 0, 0, 0, 379062015, 0, 0, 0, 758124030, 0, 0, 0, 1516248061, 0, 0, 0, 
        3032496123, 0, 0, 0, 1770024950, 0, 0, 0, 3540049900, 0, 0, 0, 2785132504, 0, 0, 0, 
        1275297712, 0, 0, 0, 2550595425, 0, 0, 0, 1308092506, 0, 0, 0, 2616185012, 0, 0, 0, 
        937402729, 0, 0, 0, 1874805459, 0, 0, 0, 3749610918, 0, 0, 0, 3204254540, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1409835056, 0, 0, 
        0, 2819670112, 0, 0, 0, 1344372928, 0, 0, 0, 2688745857, 0, 0, 0, 1082524418, 0, 0, 
        0, 2165048836, 0, 0, 0, 35130376, 0, 0, 0, 70260752, 0, 0, 0, 140521505, 0, 0, 
        0, 281043010, 0, 0, 0, 562086021, 0, 0, 0, 1124172042, 0, 0, 0, 2248344084, 0, 0, 
        0, 201720873, 0, 0, 0, 403441747, 0, 0, 0, 806883495, 0, 0, 0, 1613766991, 0, 0, 
        0, 3227533982, 0, 0, 0, 2160100668, 0, 0, 0, 25234040, 0, 0, 0, 50468080, 0, 0, 
        0, 100936160, 0, 0, 0, 201872321, 0, 0, 0, 403744643, 0, 0, 0, 807489287, 0, 0, 
        0, 1614978575, 0, 0, 0, 3229957150, 0, 0, 0, 3573684236, 0, 0, 0, 2852401176, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 302254233, 0, 0, 0, 604508466, 0, 0, 0, 1209016932, 0, 0, 0, 2418033865, 0, 
        0, 0, 541100435, 0, 0, 0, 1082200870, 0, 0, 0, 2164401740, 0, 0, 0, 33836184, 0, 
        0, 0, 67672369, 0, 0, 0, 135344738, 0, 0, 0, 270689477, 0, 0, 0, 541378955, 0, 
        0, 0, 1082757911, 0, 0, 0, 2165515822, 0, 0, 0, 36064348, 0, 0, 0, 373854240, 0, 
        0, 0, 747708480, 0, 0, 0, 1495416961, 0, 0, 0, 2990833922, 0, 0, 0, 1686700548, 0, 
        0, 0, 3373401096, 0, 0, 0, 2451834897, 0, 0, 0, 608702498, 0, 0, 0, 1217404996, 0, 
        0, 0, 2434809993, 0, 0, 0, 574652691, 0, 0, 0, 1149305382, 0, 0, 0, 2298610764, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37905416, 
        0, 0, 0, 75810832, 0, 0, 0, 151621664, 0, 0, 0, 303243329, 0, 0, 0, 606486658, 
        0, 0, 0, 1212973317, 0, 0, 0, 2425946634, 0, 0, 0, 556925972, 0, 0, 0, 1113851944, 
        0, 0, 0, 2227703889, 0, 0, 0, 160440482, 0, 0, 0, 320880965, 0, 0, 0, 641761930, 
        0, 0, 0, 1283523860, 0, 0, 0, 2567047720, 0, 0, 0, 839128145, 0, 0, 0, 1678256290, 
        0, 0, 0, 3356512580, 0, 0, 0, 2418057864, 0, 0, 0, 541148433, 0, 0, 0, 1082296866, 
        0, 0, 0, 2164593732, 0, 0, 0, 4738177, 0, 0, 0, 9476354, 0, 0, 0, 18952708, 
    },
    {
        0, 0, 0, 0, 307855197, 0, 0, 0, 615710394, 0, 0, 0, 1231420788, 0, 0, 0, 
        2462841576, 0, 0, 0, 630715856, 0, 0, 0, 1261431713, 0, 0, 0, 2522863426, 0, 0, 0, 
        750759556, 0, 0, 0, 1501519112, 0, 0, 0, 3003038224, 0, 0, 0, 1711109152, 0, 0, 0, 
        3422218304, 0, 0, 0, 2549469312, 0, 0, 0, 803971329, 0, 0, 0, 1607942659, 0, 0, 0, 
        3215885318, 0, 0, 0, 2136803341, 0, 0, 0, 4273606682, 0, 0, 0, 4252246069, 0, 0, 0, 
        4209524842, 0, 0, 0, 4124082389, 0, 0, 0, 3953197482, 0, 0, 0, 3611427668, 0, 0, 0, 
        2927888040, 0, 0, 0, 1560808784, 0, 0, 0, 2823382525, 0, 0, 0, 1351797754, 0, 0, 0, 
        2703595509, 0, 0, 0, 1112223723, 0, 0, 0, 2224447447, 0, 0, 0, 153927598, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1430273920, 0, 0, 
        0, 2860547840, 0, 0, 0, 1426128384, 0, 0, 0, 2852256768, 0, 0, 0, 1409546240, 0, 0, 
        0, 2819092480, 0, 0, 0, 1343217664, 0, 0, 0, 2686435329, 0, 0, 0, 1077903362, 0, 0, 
        0, 2155806724, 0, 0, 0, 16646152, 0, 0, 0, 33292304, 0, 0, 0, 66584608, 0, 0, 
        0, 133169216, 0, 0, 0, 266338433, 0, 0, 0, 532676867, 0, 0, 0, 1065353734, 0, 0, 
        0, 2130707468, 0, 0, 0, 4261414936, 0, 0, 0, 4227862576, 0, 0, 0, 4160757856, 0, 0, 
        0, 4026548417, 0, 0, 0, 3758129539, 0, 0, 0, 3221291782, 0, 0, 0, 2147616268, 0, 0, 
        0, 265240, 0, 0, 0, 530480, 0, 0, 0, 1431310304, 0, 0, 0, 2862620608, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 536903683, 0, 0, 0, 1073807366, 0, 0, 0, 2147614732, 0, 0, 0, 262168, 0, 
        0, 0, 524336, 0, 0, 0, 1048672, 0, 0, 0, 2097344, 0, 0, 0, 4194688, 0, 
        0, 0, 8389376, 0, 0, 0, 16778752, 0, 0, 0, 33557504, 0, 0, 0, 67115008, 0, 
        0, 0, 134230016, 0, 0, 0, 268460033, 0, 0, 0, 536920067, 0, 0, 0, 1610678276, 0, 
        0, 0, 3221356552, 0, 0, 0, 2147745808, 0, 0, 0, 524320, 0, 0, 0, 1048640, 0, 
        0, 0, 2097280, 0, 0, 0, 4194560, 0, 0, 0, 8389120, 0, 0, 0, 16778240, 0, 
        0, 0, 33556480, 0, 0, 0, 67112960, 0, 0, 0, 134225920, 0, 0, 0, 268451841, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2731147994, 
        0, 0, 0, 1167328692, 0, 0, 0, 2334657385, 0, 0, 0, 374347474, 0, 0, 0, 748694948, 
        0, 0, 0, 1497389897, 0, 0, 0, 2994779795, 0, 0, 0, 1694592294, 0, 0, 0, 3389184589, 
        0, 0, 0, 2483401882, 0, 0, 0, 671836468, 0, 0, 0, 1343672936, 0, 0, 0, 2687345872, 
        0, 0, 0, 1079724449, 0, 0, 0, 2159448898, 0, 0, 0, 23930501, 0, 0, 0, 47861002, 
        0, 0, 0, 95722004, 0, 0, 0, 191444008, 0, 0, 0, 382888016, 0, 0, 0, 765776032, 
        0, 0, 0, 1531552064, 0, 0, 0, 341393499, 0, 0, 0, 682786998, 0, 0, 0, 1365573997, 
    },
    {
        0, 0, 0, 0, 1769338744, 0, 0, 0, 3538677488, 0, 0, 0, 2782387681, 0, 0, 0, 
        1269808067, 0, 0, 0, 2539616134, 0, 0, 0, 784264973, 0, 0, 0, 1568529946, 0, 0, 0, 
        3137059892, 0, 0, 0, 1979152488, 0, 0, 0, 3958304976, 0, 0, 0, 3621642656, 0, 0, 0, 
        2948318016, 0, 0, 0, 1601668737, 0, 0, 0, 3203337474, 0, 0, 0, 2111707652, 0, 0, 0, 
        4223415304, 0, 0, 0, 4151863312, 0, 0, 0, 4008759328, 0, 0, 0, 3722551361, 0, 0, 0, 
        3150135426, 0, 0, 0, 2005303557, 0, 0, 0, 4010607114, 0, 0, 0, 3726246932, 0, 0, 0, 
        3157526569, 0, 0, 0, 2020085842, 0, 0, 0, 2577782749, 0, 0, 0, 860598203, 0, 0, 0, 
        1721196407, 0, 0, 0, 3442392815, 0, 0, 0, 2589818334, 0, 0, 0, 884669372, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4294705152, 0, 0, 
        0, 4294443008, 0, 0, 0, 4293918720, 0, 0, 0, 4292870144, 0, 0, 0, 4290772992, 0, 0, 
        0, 4286578688, 0, 0, 0, 4278190080, 0, 0, 0, 4261412864, 0, 0, 0, 4227858432, 0, 0, 
        0, 4160749568, 0, 0, 0, 4026531841, 0, 0, 0, 3758096387, 0, 0, 0, 3221225478, 0, 0, 
        0, 2147483660, 0, 0, 0, 24, 0, 0, 0, 48, 0, 0, 0, 96, 0, 0, 
        0, 192, 0, 0, 0, 384, 0, 0, 0, 768, 0, 0, 0, 1536, 0, 0, 
        0, 3072, 0, 0, 0, 6144, 0, 0, 0, 12288, 0, 0, 0, 24576, 0, 0, 
        0, 49152, 0, 0, 0, 98304, 0, 0, 0, 4294901760, 0, 0, 0, 4294836224, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 262152, 0, 0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 
        0, 0, 4194432, 0, 0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 
        0, 0, 67110912, 0, 0, 0, 134221824, 0, 0, 0, 268443649, 0, 0, 0, 536887298, 0, 
        0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 0, 0, 131092, 0, 0, 0, 32, 0, 
        0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 
        0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 
        0, 0, 16384, 0, 0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3732057110, 
        0, 0, 0, 3169146925, 0, 0, 0, 2043326555, 0, 0, 0, 4086653111, 0, 0, 0, 3878338927, 
        0, 0, 0, 3461710558, 0, 0, 0, 2628453820, 0, 0, 0, 961940345, 0, 0, 0, 1923880691, 
        0, 0, 0, 3847761383, 0, 0, 0, 3400555471, 0, 0, 0, 2506143647, 0, 0, 0, 717319998, 
        0, 0, 0, 1434639996, 0, 0, 0, 2869279993, 0, 0, 0, 1443592691, 0, 0, 0, 2887185382, 
        0, 0, 0, 1479403468, 0, 0, 0, 2958806937, 0, 0, 0, 1622646578, 0, 0, 0, 3245293157, 
        0, 0, 0, 2195619018, 0, 0, 0, 3687732610, 0, 0, 0, 3080497925, 0, 0, 0, 1866028555, 
    },
    {
        0, 0, 0, 0, 2045181768, 0, 0, 0, 4090363536, 0, 0, 0, 3885759776, 0, 0, 0, 
        3476552256, 0, 0, 0, 2658137216, 0, 0, 0, 1021307136, 0, 0, 0, 2042614272, 0, 0, 0, 
        4085228544, 0, 0, 0, 3875489792, 0, 0, 0, 3456012289, 0, 0, 0, 2617057282, 0, 0, 0, 
        939147269, 0, 0, 0, 1878294539, 0, 0, 0, 3756589078, 0, 0, 0, 3218210860, 0, 0, 0, 
        2141454425, 0, 0, 0, 4282908850, 0, 0, 0, 4270850404, 0, 0, 0, 4246733513, 0, 0, 0, 
        4198499730, 0, 0, 0, 4102032165, 0, 0, 0, 3909097035, 0, 0, 0, 3523226774, 0, 0, 0, 
        2751486253, 0, 0, 0, 1208005210, 0, 0, 0, 3924270077, 0, 0, 0, 3553572858, 0, 0, 0, 
        2812178420, 0, 0, 0, 1329389545, 0, 0, 0, 2658779090, 0, 0, 0, 1022590884, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 
        0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 0, 
        0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 0, 
        0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 
        0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 
        0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554432, 0, 0, 
        0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 0, 536870917, 0, 0, 
        0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 0, 8, 0, 0, 0, 16, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1073774613, 0, 0, 0, 2147549226, 0, 0, 0, 131156, 0, 0, 0, 262312, 0, 
        0, 0, 524624, 0, 0, 0, 1049248, 0, 0, 0, 2098496, 0, 0, 0, 4196992, 0, 
        0, 0, 8393984, 0, 0, 0, 16787968, 0, 0, 0, 33575936, 0, 0, 0, 67151873, 0, 
        0, 0, 134303746, 0, 0, 0, 268607492, 0, 0, 0, 537214984, 0, 0, 0, 655364, 0, 
        0, 0, 1310728, 0, 0, 0, 2621456, 0, 0, 0, 5242912, 0, 0, 0, 10485824, 0, 
        0, 0, 20971648, 0, 0, 0, 41943296, 0, 0, 0, 83886592, 0, 0, 0, 167773184, 0, 
        0, 0, 335546369, 0, 0, 0, 671092738, 0, 0, 0, 1342185477, 0, 0, 0, 2684370954, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2033130968, 
        0, 0, 0, 4066261936, 0, 0, 0, 3837556576, 0, 0, 0, 3380145857, 0, 0, 0, 2465324418, 
        0, 0, 0, 635681541, 0, 0, 0, 1271363082, 0, 0, 0, 2542726165, 0, 0, 0, 790485035, 
        0, 0, 0, 1580970071, 0, 0, 0, 3161940143, 0, 0, 0, 2028912991, 0, 0, 0, 4057825983, 
        0, 0, 0, 3820684671, 0, 0, 0, 3346402046, 0, 0, 0, 2397836796, 0, 0, 0, 500706297, 
        0, 0, 0, 1001412595, 0, 0, 0, 2002825190, 0, 0, 0, 4005650380, 0, 0, 0, 3716333464, 
        0, 0, 0, 3137699633, 0, 0, 0, 254141371, 0, 0, 0, 508282742, 0, 0, 0, 1016565484, 
    },
    {
        0, 0, 0, 0, 698651200, 0, 0, 0, 1397302401, 0, 0, 0, 2794604802, 0, 0, 0, 
        1294242308, 0, 0, 0, 2588484616, 0, 0, 0, 882001936, 0, 0, 0, 1764003872, 0, 0, 0, 
        3528007744, 0, 0, 0, 2761048193, 0, 0, 0, 1227129090, 0, 0, 0, 2454258180, 0, 0, 0, 
        613549064, 0, 0, 0, 1227098128, 0, 0, 0, 2454196256, 0, 0, 0, 613425216, 0, 0, 0, 
        1226850432, 0, 0, 0, 2453700864, 0, 0, 0, 612434432, 0, 0, 0, 1224868864, 0, 0, 0, 
        2449737728, 0, 0, 0, 604508160, 0, 0, 0, 1209016320, 0, 0, 0, 2418032641, 0, 0, 0, 
        541097986, 0, 0, 0, 1082195972, 0, 0, 0, 2829488713, 0, 0, 0, 1364010130, 0, 0, 0, 
        2728020260, 0, 0, 0, 1161073224, 0, 0, 0, 2322146448, 0, 0, 0, 349325600, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 18087960, 0, 0, 0, 36175920, 0, 0, 0, 72351840, 0, 0, 0, 144703680, 0, 
        0, 0, 289407361, 0, 0, 0, 578814722, 0, 0, 0, 1157629444, 0, 0, 0, 2315258888, 0, 
        0, 0, 335550481, 0, 0, 0, 671100962, 0, 0, 0, 1342201925, 0, 0, 0, 2684403851, 0, 
        0, 0, 1073840407, 0, 0, 0, 2147680814, 0, 0, 0, 394332, 0, 0, 0, 18352288, 0, 
        0, 0, 36704576, 0, 0, 0, 73409152, 0, 0, 0, 146818304, 0, 0, 0, 293636608, 0, 
        0, 0, 587273216, 0, 0, 0, 1174546432, 0, 0, 0, 2349092864, 0, 0, 0, 403218432, 0, 
        0, 0, 806436865, 0, 0, 0, 1612873731, 0, 0, 0, 3225747462, 0, 0, 0, 2156527628, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2199499341, 
        0, 0, 0, 104031387, 0, 0, 0, 208062775, 0, 0, 0, 416125551, 0, 0, 0, 832251102, 
        0, 0, 0, 1664502205, 0, 0, 0, 3329004410, 0, 0, 0, 2363041525, 0, 0, 0, 431115754, 
        0, 0, 0, 862231508, 0, 0, 0, 1724463016, 0, 0, 0, 3448926032, 0, 0, 0, 2602884769, 
        0, 0, 0, 910802242, 0, 0, 0, 1821604484, 0, 0, 0, 3643208968, 0, 0, 0, 2991450640, 
        0, 0, 0, 1687933984, 0, 0, 0, 3375867968, 0, 0, 0, 2456768640, 0, 0, 0, 618569985, 
        0, 0, 0, 1237139970, 0, 0, 0, 274937417, 0, 0, 0, 549874835, 0, 0, 0, 1099749670, 
    },
    {
        0, 0, 0, 0, 1226833920, 0, 0, 0, 2453667840, 0, 0, 0, 612368384, 0, 0, 0, 
        1224736768, 0, 0, 0, 2449473536, 0, 0, 0, 603979776, 0, 0, 0, 1207959552, 0, 0, 0, 
        2415919105, 0, 0, 0, 536870914, 0, 0, 0, 1073741828, 0, 0, 0, 2147483657, 0, 0, 0, 
        18, 0, 0, 0, 36, 0, 0, 0, 72, 0, 0, 0, 144, 0, 0, 0, 
        288, 0, 0, 0, 576, 0, 0, 0, 1152, 0, 0, 0, 2304, 0, 0, 0, 
        4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 0, 0, 0, 36864, 0, 0, 0, 
        73728, 0, 0, 0, 147456, 0, 0, 0, 1227128832, 0, 0, 0, 2454257664, 0, 0, 0, 
        613548032, 0, 0, 0, 1227096064, 0, 0, 0, 2454192128, 0, 0, 0, 613416960, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 320, 0, 0, 
        0, 640, 0, 0, 0, 1280, 0, 0, 0, 2560, 0, 0, 0, 5120, 0, 0, 
        0, 10240, 0, 0, 0, 20480, 0, 0, 0, 40960, 0, 0, 0, 81920, 0, 0, 
        0, 163840, 0, 0, 0, 327680, 0, 0, 0, 655360, 0, 0, 0, 1310720, 0, 0, 
        0, 2621440, 0, 0, 0, 5242880, 0, 0, 0, 10485760, 0, 0, 0, 20971520, 0, 0, 
        0, 41943040, 0, 0, 0, 83886080, 0, 0, 0, 167772161, 0, 0, 0, 335544322, 0, 0, 
        0, 671088644, 0, 0, 0, 1342177288, 0, 0, 0, 2684354577, 0, 0, 0, 1073741858, 0, 0, 
        0, 2147483716, 0, 0, 0, 136, 0, 0, 0, 80, 0, 0, 0, 160, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1417720836, 0, 0, 0, 2835441672, 0, 0, 0, 1375916048, 0, 0, 0, 2751832097, 0, 
        0, 0, 1208696898, 0, 0, 0, 2417393796, 0, 0, 0, 539820296, 0, 0, 0, 1079640592, 0, 
        0, 0, 2159281184, 0, 0, 0, 23595072, 0, 0, 0, 47190144, 0, 0, 0, 94380288, 0, 
        0, 0, 188760576, 0, 0, 0, 377521152, 0, 0, 0, 755042304, 0, 0, 0, 243442693, 0, 
        0, 0, 486885387, 0, 0, 0, 973770774, 0, 0, 0, 1947541549, 0, 0, 0, 3895083098, 0, 
        0, 0, 3495198900, 0, 0, 0, 2695430504, 0, 0, 0, 1095893712, 0, 0, 0, 2191787424, 0, 
        0, 0, 88607552, 0, 0, 0, 177215104, 0, 0, 0, 354430209, 0, 0, 0, 708860418, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4196822677, 
        0, 0, 0, 4098678059, 0, 0, 0, 3902388822, 0, 0, 0, 3509810348, 0, 0, 0, 2724653400, 
        0, 0, 0, 1154339505, 0, 0, 0, 2308679010, 0, 0, 0, 322390725, 0, 0, 0, 644781450, 
        0, 0, 0, 1289562901, 0, 0, 0, 2579125802, 0, 0, 0, 863284308, 0, 0, 0, 1726568616, 
        0, 0, 0, 3453137233, 0, 0, 0, 2611307171, 0, 0, 0, 927647046, 0, 0, 0, 1855294093, 
        0, 0, 0, 3710588186, 0, 0, 0, 3126209076, 0, 0, 0, 1957450856, 0, 0, 0, 3914901713, 
        0, 0, 0, 3534836131, 0, 0, 0, 1598344658, 0, 0, 0, 3196689317, 0, 0, 0, 2098411338, 
    },
    {
        0, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 
        4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 0, 33554433, 0, 0, 0, 
        67108866, 0, 0, 0, 134217732, 0, 0, 0, 268435464, 0, 0, 0, 536870928, 0, 0, 0, 
        1073741856, 0, 0, 0, 2147483713, 0, 0, 0, 130, 0, 0, 0, 260, 0, 0, 0, 
        520, 0, 0, 0, 1040, 0, 0, 0, 2080, 0, 0, 0, 4160, 0, 0, 0, 
        8320, 0, 0, 0, 16640, 0, 0, 0, 33280, 0, 0, 0, 66560, 0, 0, 0, 
        133120, 0, 0, 0, 266240, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 
        32768, 0, 0, 0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8421376, 0, 0, 
        0, 16842752, 0, 0, 0, 33685504, 0, 0, 0, 67371008, 0, 0, 0, 134742017, 0, 0, 
        0, 269484034, 0, 0, 0, 538968069, 0, 0, 0, 1077936138, 0, 0, 0, 2155872276, 0, 0, 
        0, 16777256, 0, 0, 0, 33554512, 0, 0, 0, 67109024, 0, 0, 0, 134218049, 0, 0, 
        0, 268436098, 0, 0, 0, 536872197, 0, 0, 0, 1073744394, 0, 0, 0, 2147488788, 0, 0, 
        0, 10280, 0, 0, 0, 20560, 0, 0, 0, 41120, 0, 0, 0, 82240, 0, 0, 
        0, 164480, 0, 0, 0, 328960, 0, 0, 0, 657920, 0, 0, 0, 1315840, 0, 0, 
        0, 2631680, 0, 0, 0, 5263360, 0, 0, 0, 2105344, 0, 0, 0, 4210688, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 844445257, 0, 0, 0, 1688890514, 0, 0, 0, 3377781029, 0, 0, 0, 2460594762, 0, 
        0, 0, 626222228, 0, 0, 0, 1252444457, 0, 0, 0, 2504888914, 0, 0, 0, 714810532, 0, 
        0, 0, 1429621065, 0, 0, 0, 2859242131, 0, 0, 0, 1423516967, 0, 0, 0, 2847033934, 0, 
        0, 0, 1399100572, 0, 0, 0, 2798201144, 0, 0, 0, 1301434992, 0, 0, 0, 2842792617, 0, 
        0, 0, 1390617939, 0, 0, 0, 2781235878, 0, 0, 0, 1267504461, 0, 0, 0, 2535008923, 0, 
        0, 0, 775050550, 0, 0, 0, 1550101100, 0, 0, 0, 3100202201, 0, 0, 0, 1905437106, 0, 
        0, 0, 3810874212, 0, 0, 0, 3326781129, 0, 0, 0, 2358594962, 0, 0, 0, 422222628, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2034053848, 
        0, 0, 0, 4068107696, 0, 0, 0, 3841248097, 0, 0, 0, 3387528899, 0, 0, 0, 2480090502, 
        0, 0, 0, 665213709, 0, 0, 0, 1330427418, 0, 0, 0, 2660854837, 0, 0, 0, 1026742378, 
        0, 0, 0, 2053484756, 0, 0, 0, 4106969513, 0, 0, 0, 3918971730, 0, 0, 0, 3542976165, 
        0, 0, 0, 2790985034, 0, 0, 0, 1287002772, 0, 0, 0, 2574005545, 0, 0, 0, 853043794, 
        0, 0, 0, 1706087588, 0, 0, 0, 3412175176, 0, 0, 0, 2529383056, 0, 0, 0, 763798816, 
        0, 0, 0, 1527597633, 0, 0, 0, 3475482203, 0, 0, 0, 2655997110, 0, 0, 0, 1017026924, 
    },
    {
        0, 0, 0, 0, 8390656, 0, 0, 0, 16781312, 0, 0, 0, 33562625, 0, 0, 0, 
        67125250, 0, 0, 0, 134250500, 0, 0, 0, 268501000, 0, 0, 0, 537002000, 0, 0, 0, 
        1074004000, 0, 0, 0, 2148008001, 0, 0, 0, 1048706, 0, 0, 0, 2097412, 0, 0, 0, 
        4194824, 0, 0, 0, 8389648, 0, 0, 0, 16779296, 0, 0, 0, 33558593, 0, 0, 0, 
        67117186, 0, 0, 0, 134234372, 0, 0, 0, 268468744, 0, 0, 0, 536937488, 0, 0, 0, 
        1073874976, 0, 0, 0, 2147749953, 0, 0, 0, 532610, 0, 0, 0, 1065220, 0, 0, 0, 
        2130440, 0, 0, 0, 4260880, 0, 0, 0, 131104, 0, 0, 0, 262208, 0, 0, 0, 
        524416, 0, 0, 0, 1048832, 0, 0, 0, 2097664, 0, 0, 0, 4195328, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 591396869, 0, 0, 
        0, 1182793738, 0, 0, 0, 2365587477, 0, 0, 0, 436207659, 0, 0, 0, 872415319, 0, 0, 
        0, 1744830638, 0, 0, 0, 3489661276, 0, 0, 0, 2684355257, 0, 0, 0, 1073743218, 0, 0, 
        0, 2147486436, 0, 0, 0, 5576, 0, 0, 0, 11152, 0, 0, 0, 22304, 0, 0, 
        0, 44608, 0, 0, 0, 89216, 0, 0, 0, 178432, 0, 0, 0, 356864, 0, 0, 
        0, 713728, 0, 0, 0, 1427456, 0, 0, 0, 2854912, 0, 0, 0, 5709824, 0, 0, 
        0, 11419648, 0, 0, 0, 22839296, 0, 0, 0, 45678592, 0, 0, 0, 91357184, 0, 0, 
        0, 182714369, 0, 0, 0, 365428738, 0, 0, 0, 147849217, 0, 0, 0, 295698434, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 3001529316, 0, 0, 0, 1708091336, 0, 0, 0, 3416182673, 0, 0, 0, 2537398050, 0, 
        0, 0, 779828804, 0, 0, 0, 1559657609, 0, 0, 0, 3119315218, 0, 0, 0, 1943663140, 0, 
        0, 0, 3887326281, 0, 0, 0, 3479685267, 0, 0, 0, 2664403238, 0, 0, 0, 1033839181, 0, 
        0, 0, 2067678363, 0, 0, 0, 4135356726, 0, 0, 0, 3975746156, 0, 0, 0, 1796577085, 0, 
        0, 0, 3593154171, 0, 0, 0, 2891341046, 0, 0, 0, 1487714796, 0, 0, 0, 2975429593, 0, 
        0, 0, 1655891891, 0, 0, 0, 3311783783, 0, 0, 0, 2328600271, 0, 0, 0, 362233247, 0, 
        0, 0, 724466494, 0, 0, 0, 1448932988, 0, 0, 0, 2897865977, 0, 0, 0, 1500764658, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30521863, 
        0, 0, 0, 61043727, 0, 0, 0, 122087454, 0, 0, 0, 244174909, 0, 0, 0, 488349818, 
        0, 0, 0, 976699637, 0, 0, 0, 1953399275, 0, 0, 0, 3906798551, 0, 0, 0, 3518629806, 
        0, 0, 0, 2742292316, 0, 0, 0, 1189617336, 0, 0, 0, 2379234673, 0, 0, 0, 463502051, 
        0, 0, 0, 927004102, 0, 0, 0, 1854008205, 0, 0, 0, 3708016410, 0, 0, 0, 3121065525, 
        0, 0, 0, 1947163754, 0, 0, 0, 3894327508, 0, 0, 0, 3493687720, 0, 0, 0, 2692408145, 
        0, 0, 0, 1089848995, 0, 0, 0, 2151298880, 0, 0, 0, 7630465, 0, 0, 0, 15260931, 
    },
    {
        0, 0, 0, 0, 134300932, 0, 0, 0, 268601864, 0, 0, 0, 537203728, 0, 0, 0, 
        1074407456, 0, 0, 0, 2148814913, 0, 0, 0, 2662530, 0, 0, 0, 5325060, 0, 0, 0, 
        10650120, 0, 0, 0, 21300240, 0, 0, 0, 42600481, 0, 0, 0, 85200962, 0, 0, 0, 
        170401925, 0, 0, 0, 340803850, 0, 0, 0, 681607700, 0, 0, 0, 1363215400, 0, 0, 0, 
        2726430800, 0, 0, 0, 1157894304, 0, 0, 0, 2315788608, 0, 0, 0, 336609920, 0, 0, 0, 
        673219840, 0, 0, 0, 1346439680, 0, 0, 0, 2692879361, 0, 0, 0, 1090791426, 0, 0, 0, 
        2181582852, 0, 0, 0, 68198408, 0, 0, 0, 2098452, 0, 0, 0, 4196904, 0, 0, 0, 
        8393808, 0, 0, 0, 16787616, 0, 0, 0, 33575233, 0, 0, 0, 67150466, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 661652741, 0, 0, 
        0, 1323305483, 0, 0, 0, 2646610967, 0, 0, 0, 998254638, 0, 0, 0, 1996509277, 0, 0, 
        0, 3993018554, 0, 0, 0, 3691069813, 0, 0, 0, 3087172330, 0, 0, 0, 1879377365, 0, 0, 
        0, 3758754731, 0, 0, 0, 3222542166, 0, 0, 0, 2150117036, 0, 0, 0, 5266776, 0, 0, 
        0, 10533552, 0, 0, 0, 21067104, 0, 0, 0, 42134208, 0, 0, 0, 84268416, 0, 0, 
        0, 168536833, 0, 0, 0, 337073666, 0, 0, 0, 674147332, 0, 0, 0, 1348294664, 0, 0, 
        0, 2696589329, 0, 0, 0, 1098211362, 0, 0, 0, 2196422724, 0, 0, 0, 97878152, 0, 0, 
        0, 195756305, 0, 0, 0, 391512610, 0, 0, 0, 165413185, 0, 0, 0, 330826370, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2938358989, 0, 0, 0, 1581750682, 0, 0, 0, 3163501365, 0, 0, 0, 2032035435, 0, 
        0, 0, 4064070870, 0, 0, 0, 3833174445, 0, 0, 0, 3371381594, 0, 0, 0, 2447795893, 0, 
        0, 0, 600624491, 0, 0, 0, 1201248983, 0, 0, 0, 2402497966, 0, 0, 0, 510028637, 0, 
        0, 0, 1020057274, 0, 0, 0, 2040114548, 0, 0, 0, 4080229097, 0, 0, 0, 1229289758, 0, 
        0, 0, 2458579516, 0, 0, 0, 622191737, 0, 0, 0, 1244383475, 0, 0, 0, 2488766950, 0, 
        0, 0, 682566604, 0, 0, 0, 1365133209, 0, 0, 0, 2730266419, 0, 0, 0, 1165565542, 0, 
        0, 0, 2331131084, 0, 0, 0, 367294873, 0, 0, 0, 734589747, 0, 0, 0, 1469179494, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33833481, 
        0, 0, 0, 67666962, 0, 0, 0, 135333924, 0, 0, 0, 270667848, 0, 0, 0, 541335697, 
        0, 0, 0, 1082671394, 0, 0, 0, 2165342788, 0, 0, 0, 35718281, 0, 0, 0, 71436563, 
        0, 0, 0, 142873126, 0, 0, 0, 285746252, 0, 0, 0, 571492505, 0, 0, 0, 1142985010, 
        0, 0, 0, 2285970021, 0, 0, 0, 276972746, 0, 0, 0, 553945492, 0, 0, 0, 1107890985, 
        0, 0, 0, 2215781970, 0, 0, 0, 136596644, 0, 0, 0, 273193289, 0, 0, 0, 546386578, 
        0, 0, 0, 1092773156, 0, 0, 0, 2151712833, 0, 0, 0, 8458370, 0, 0, 0, 16916740, 
    },
    {
        0, 0, 0, 0, 826542200, 0, 0, 0, 1653084401, 0, 0, 0, 3306168803, 0, 0, 0, 
        2317370310, 0, 0, 0, 339773324, 0, 0, 0, 679546648, 0, 0, 0, 1359093296, 0, 0, 0, 
        2718186592, 0, 0, 0, 1141405888, 0, 0, 0, 2282811777, 0, 0, 0, 270656258, 0, 0, 0, 
        541312516, 0, 0, 0, 1082625032, 0, 0, 0, 2165250065, 0, 0, 0, 35532835, 0, 0, 0, 
        71065670, 0, 0, 0, 142131340, 0, 0, 0, 284262680, 0, 0, 0, 568525360, 0, 0, 0, 
        1137050721, 0, 0, 0, 2274101442, 0, 0, 0, 253235589, 0, 0, 0, 506471179, 0, 0, 0, 
        1012942358, 0, 0, 0, 2025884716, 0, 0, 0, 3234140193, 0, 0, 0, 2173313091, 0, 0, 0, 
        51658887, 0, 0, 0, 103317775, 0, 0, 0, 206635550, 0, 0, 0, 413271100, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2815455249, 0, 0, 
        0, 1335943203, 0, 0, 0, 2671886407, 0, 0, 0, 1048805518, 0, 0, 0, 2097611036, 0, 0, 
        0, 4195222072, 0, 0, 0, 4095476849, 0, 0, 0, 3895986402, 0, 0, 0, 3497005508, 0, 0, 
        0, 2699043721, 0, 0, 0, 1103120146, 0, 0, 0, 2206240292, 0, 0, 0, 117513288, 0, 0, 
        0, 235026577, 0, 0, 0, 470053155, 0, 0, 0, 940106310, 0, 0, 0, 1880212621, 0, 0, 
        0, 3760425243, 0, 0, 0, 3225883190, 0, 0, 0, 2156799084, 0, 0, 0, 18630872, 0, 0, 
        0, 37261744, 0, 0, 0, 74523488, 0, 0, 0, 149046977, 0, 0, 0, 298093954, 0, 0, 
        0, 596187909, 0, 0, 0, 1192375818, 0, 0, 0, 703863812, 0, 0, 0, 1407727624, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1801783692, 0, 0, 0, 3603567385, 0, 0, 0, 2912167474, 0, 0, 0, 1529367653, 0, 
        0, 0, 3058735306, 0, 0, 0, 1822503316, 0, 0, 0, 3645006633, 0, 0, 0, 2995045970, 0, 
        0, 0, 1695124645, 0, 0, 0, 3390249290, 0, 0, 0, 2485531285, 0, 0, 0, 676095274, 0, 
        0, 0, 1352190548, 0, 0, 0, 2704381097, 0, 0, 0, 1113794898, 0, 0, 0, 4020460328, 0, 
        0, 0, 3745953360, 0, 0, 0, 3196939425, 0, 0, 0, 2098911554, 0, 0, 0, 4197823108, 0, 
        0, 0, 4100678921, 0, 0, 0, 3906390547, 0, 0, 0, 3517813798, 0, 0, 0, 2740660300, 0, 
        0, 0, 1186353304, 0, 0, 0, 2372706609, 0, 0, 0, 450445923, 0, 0, 0, 900891846, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67141650, 
        0, 0, 0, 134283300, 0, 0, 0, 268566600, 0, 0, 0, 537133200, 0, 0, 0, 1074266400, 
        0, 0, 0, 2148532800, 0, 0, 0, 2098304, 0, 0, 0, 4196609, 0, 0, 0, 8393218, 
        0, 0, 0, 16786436, 0, 0, 0, 33572873, 0, 0, 0, 67145746, 0, 0, 0, 134291492, 
        0, 0, 0, 268582984, 0, 0, 0, 537165968, 0, 0, 0, 1074331936, 0, 0, 0, 2148663872, 
        0, 0, 0, 2360448, 0, 0, 0, 4720897, 0, 0, 0, 9441794, 0, 0, 0, 18883588, 
        0, 0, 0, 37767176, 0, 0, 0, 8392706, 0, 0, 0, 16785412, 0, 0, 0, 33570825, 
    },
    {
        0, 0, 0, 0, 2499687121, 0, 0, 0, 704406946, 0, 0, 0, 1408813893, 0, 0, 0, 
        2817627786, 0, 0, 0, 1340288277, 0, 0, 0, 2680576554, 0, 0, 0, 1066185813, 0, 0, 0, 
        2132371627, 0, 0, 0, 4264743254, 0, 0, 0, 4234519213, 0, 0, 0, 4174071131, 0, 0, 0, 
        4053174967, 0, 0, 0, 3811382638, 0, 0, 0, 3327797980, 0, 0, 0, 2360628665, 0, 0, 0, 
        426290034, 0, 0, 0, 852580069, 0, 0, 0, 1705160138, 0, 0, 0, 3410320276, 0, 0, 0, 
        2525673256, 0, 0, 0, 756379216, 0, 0, 0, 1512758433, 0, 0, 0, 3025516867, 0, 0, 0, 
        1756066438, 0, 0, 0, 3512132877, 0, 0, 0, 911472843, 0, 0, 0, 1822945686, 0, 0, 0, 
        3645891373, 0, 0, 0, 2996815450, 0, 0, 0, 1698663604, 0, 0, 0, 3397327208, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1432822912, 0, 0, 
        0, 2865645824, 0, 0, 0, 1436324352, 0, 0, 0, 2872648704, 0, 0, 0, 1450330112, 0, 0, 
        0, 2900660224, 0, 0, 0, 1506353153, 0, 0, 0, 3012706307, 0, 0, 0, 1730445319, 0, 0, 
        0, 3460890639, 0, 0, 0, 2626813983, 0, 0, 0, 958660670, 0, 0, 0, 1917321341, 0, 0, 
        0, 3834642683, 0, 0, 0, 3374318071, 0, 0, 0, 2453668846, 0, 0, 0, 612370397, 0, 0, 
        0, 1224740795, 0, 0, 0, 2449481590, 0, 0, 0, 603995885, 0, 0, 0, 1207991771, 0, 0, 
        0, 2415983542, 0, 0, 0, 536999789, 0, 0, 0, 1073999578, 0, 0, 0, 2147999156, 0, 0, 
        0, 1031016, 0, 0, 0, 2062032, 0, 0, 0, 1431947552, 0, 0, 0, 2863895104, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2656366736, 0, 0, 0, 1017766176, 0, 0, 0, 2035532352, 0, 0, 0, 4071064704, 0, 
        0, 0, 3847162112, 0, 0, 0, 3399356928, 0, 0, 0, 2503746561, 0, 0, 0, 712525826, 0, 
        0, 0, 1425051652, 0, 0, 0, 2850103304, 0, 0, 0, 1405239313, 0, 0, 0, 2810478627, 0, 
        0, 0, 1325989958, 0, 0, 0, 2651979917, 0, 0, 0, 1008992539, 0, 0, 0, 3860656807, 0, 
        0, 0, 3426346319, 0, 0, 0, 2557725342, 0, 0, 0, 820483388, 0, 0, 0, 1640966776, 0, 
        0, 0, 3281933552, 0, 0, 0, 2268899809, 0, 0, 0, 242832322, 0, 0, 0, 485664644, 0, 
        0, 0, 971329289, 0, 0, 0, 1942658578, 0, 0, 0, 3885317156, 0, 0, 0, 3475667016, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2304, 
        0, 0, 0, 4608, 0, 0, 0, 9216, 0, 0, 0, 18432, 0, 0, 0, 36864, 
        0, 0, 0, 73728, 0, 0, 0, 147456, 0, 0, 0, 294912, 0, 0, 0, 589824, 
        0, 0, 0, 1179648, 0, 0, 0, 2359296, 0, 0, 0, 4718593, 0, 0, 0, 9437186, 
        0, 0, 0, 18874372, 0, 0, 0, 37748744, 0, 0, 0, 75497488, 0, 0, 0, 150994976, 
        0, 0, 0, 301989953, 0, 0, 0, 603979906, 0, 0, 0, 1207959812, 0, 0, 0, 2415919624, 
        0, 0, 0, 536871952, 0, 0, 0, 1073742112, 0, 0, 0, 2147484224, 0, 0, 0, 1152, 
    },
    {
        0, 0, 0, 0, 2271571420, 0, 0, 0, 248175545, 0, 0, 0, 496351090, 0, 0, 0, 
        992702181, 0, 0, 0, 1985404363, 0, 0, 0, 3970808727, 0, 0, 0, 3646650159, 0, 0, 0, 
        2998333022, 0, 0, 0, 1701698748, 0, 0, 0, 3403397496, 0, 0, 0, 2511827697, 0, 0, 0, 
        728688099, 0, 0, 0, 1457376199, 0, 0, 0, 2914752399, 0, 0, 0, 1534537503, 0, 0, 0, 
        3069075006, 0, 0, 0, 1843182716, 0, 0, 0, 3686365432, 0, 0, 0, 3077763568, 0, 0, 0, 
        1860559841, 0, 0, 0, 3721119683, 0, 0, 0, 3147272070, 0, 0, 0, 1999576845, 0, 0, 0, 
        3999153690, 0, 0, 0, 3703340085, 0, 0, 0, 1042126263, 0, 0, 0, 2084252526, 0, 0, 0, 
        4168505053, 0, 0, 0, 4042042811, 0, 0, 0, 3789118327, 0, 0, 0, 3283269358, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2740852545, 0, 0, 
        0, 1186737794, 0, 0, 0, 2373475589, 0, 0, 0, 451983883, 0, 0, 0, 903967767, 0, 0, 
        0, 1807935534, 0, 0, 0, 3615871068, 0, 0, 0, 2936774840, 0, 0, 0, 1578582385, 0, 0, 
        0, 3157164770, 0, 0, 0, 2019362244, 0, 0, 0, 4038724489, 0, 0, 0, 3782481683, 0, 0, 
        0, 3269996070, 0, 0, 0, 2245024844, 0, 0, 0, 195082393, 0, 0, 0, 390164786, 0, 0, 
        0, 780329572, 0, 0, 0, 1560659145, 0, 0, 0, 3121318290, 0, 0, 0, 1947669285, 0, 0, 
        0, 3895338570, 0, 0, 0, 3495709844, 0, 0, 0, 2696452393, 0, 0, 0, 1097937490, 0, 0, 
        0, 2195874980, 0, 0, 0, 96782664, 0, 0, 0, 2832696784, 0, 0, 0, 1370426272, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 2424557694, 0, 0, 0, 554148093, 0, 0, 0, 1108296186, 0, 0, 0, 2216592373, 0, 
        0, 0, 138217450, 0, 0, 0, 276434901, 0, 0, 0, 552869802, 0, 0, 0, 1105739604, 0, 
        0, 0, 2211479208, 0, 0, 0, 127991121, 0, 0, 0, 255982243, 0, 0, 0, 511964486, 0, 
        0, 0, 1023928972, 0, 0, 0, 2047857944, 0, 0, 0, 4095715888, 0, 0, 0, 2025620510, 0, 
        0, 0, 4051241021, 0, 0, 0, 3807514746, 0, 0, 0, 3320062196, 0, 0, 0, 2345157096, 0, 
        0, 0, 395346896, 0, 0, 0, 790693792, 0, 0, 0, 1581387585, 0, 0, 0, 3162775171, 0, 
        0, 0, 2030583047, 0, 0, 0, 4061166095, 0, 0, 0, 3827364895, 0, 0, 0, 3359762495, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8390658, 
        0, 0, 0, 16781316, 0, 0, 0, 33562633, 0, 0, 0, 67125266, 0, 0, 0, 134250532, 
        0, 0, 0, 268501064, 0, 0, 0, 537002128, 0, 0, 0, 1074004256, 0, 0, 0, 2148008512, 
        0, 0, 0, 1049728, 0, 0, 0, 2099456, 0, 0, 0, 4198913, 0, 0, 0, 8397826, 
        0, 0, 0, 16795652, 0, 0, 0, 33591305, 0, 0, 0, 67182610, 0, 0, 0, 134365220, 
        0, 0, 0, 268730440, 0, 0, 0, 537460880, 0, 0, 0, 1074921760, 0, 0, 0, 2149843520, 
        0, 0, 0, 4719745, 0, 0, 0, 1048832, 0, 0, 0, 2097664, 0, 0, 0, 4195329, 
    },
    {
        0, 0, 0, 0, 1739616249, 0, 0, 0, 3479232498, 0, 0, 0, 2663497700, 0, 0, 0, 
        1032028104, 0, 0, 0, 2064056209, 0, 0, 0, 4128112418, 0, 0, 0, 3961257541, 0, 0, 0, 
        3627547787, 0, 0, 0, 2960128279, 0, 0, 0, 1625289262, 0, 0, 0, 3250578525, 0, 0, 0, 
        2206189754, 0, 0, 0, 117412213, 0, 0, 0, 234824426, 0, 0, 0, 469648853, 0, 0, 0, 
        939297707, 0, 0, 0, 1878595415, 0, 0, 0, 3757190830, 0, 0, 0, 3219414364, 0, 0, 0, 
        2143861433, 0, 0, 0, 4287722866, 0, 0, 0, 4280478436, 0, 0, 0, 4265989576, 0, 0, 0, 
        4237011857, 0, 0, 0, 4179056419, 0, 0, 0, 2510209471, 0, 0, 0, 725451647, 0, 0, 0, 
        1450903295, 0, 0, 0, 2901806591, 0, 0, 0, 1508645886, 0, 0, 0, 3017291772, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3220345106, 0, 0, 
        0, 2145722916, 0, 0, 0, 4291445832, 0, 0, 0, 4287924368, 0, 0, 0, 4280881440, 0, 0, 
        0, 4266795584, 0, 0, 0, 4238623872, 0, 0, 0, 4182280448, 0, 0, 0, 4069593601, 0, 0, 
        0, 3844219907, 0, 0, 0, 3393472519, 0, 0, 0, 2491977742, 0, 0, 0, 688988188, 0, 0, 
        0, 1377976376, 0, 0, 0, 2755952753, 0, 0, 0, 1216938211, 0, 0, 0, 2433876422, 0, 0, 
        0, 572785549, 0, 0, 0, 1145571098, 0, 0, 0, 2291142197, 0, 0, 0, 287317098, 0, 0, 
        0, 574634197, 0, 0, 0, 1149268394, 0, 0, 0, 2298536789, 0, 0, 0, 302106282, 0, 0, 
        0, 604212565, 0, 0, 0, 1208425131, 0, 0, 0, 805086276, 0, 0, 0, 1610172553, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 70539992, 0, 0, 0, 141079985, 0, 0, 0, 282159971, 0, 0, 0, 564319943, 0, 
        0, 0, 1128639887, 0, 0, 0, 2257279774, 0, 0, 0, 219592253, 0, 0, 0, 439184507, 0, 
        0, 0, 878369014, 0, 0, 0, 1756738029, 0, 0, 0, 3513476059, 0, 0, 0, 2731984823, 0, 
        0, 0, 1169002351, 0, 0, 0, 2338004702, 0, 0, 0, 381042109, 0, 0, 0, 693641634, 0, 
        0, 0, 1387283269, 0, 0, 0, 2774566539, 0, 0, 0, 1254165782, 0, 0, 0, 2508331565, 0, 
        0, 0, 721695834, 0, 0, 0, 1443391669, 0, 0, 0, 2886783339, 0, 0, 0, 1478599382, 0, 
        0, 0, 2957198765, 0, 0, 0, 1619430235, 0, 0, 0, 3238860470, 0, 0, 0, 2182753644, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144703526, 
        0, 0, 0, 289407053, 0, 0, 0, 578814107, 0, 0, 0, 1157628214, 0, 0, 0, 2315256429, 
        0, 0, 0, 335545562, 0, 0, 0, 671091124, 0, 0, 0, 1342182248, 0, 0, 0, 2684364496, 
        0, 0, 0, 1073761696, 0, 0, 0, 2147523392, 0, 0, 0, 79488, 0, 0, 0, 158976, 
        0, 0, 0, 317952, 0, 0, 0, 635904, 0, 0, 0, 1271808, 0, 0, 0, 2543616, 
        0, 0, 0, 5087233, 0, 0, 0, 10174466, 0, 0, 0, 20348932, 0, 0, 0, 40697864, 
        0, 0, 0, 81395729, 0, 0, 0, 18087940, 0, 0, 0, 36175881, 0, 0, 0, 72351763, 
    },
    {
        0, 0, 0, 0, 1915396941, 0, 0, 0, 3830793883, 0, 0, 0, 3366620471, 0, 0, 0, 
        2438273647, 0, 0, 0, 581579999, 0, 0, 0, 1163159998, 0, 0, 0, 2326319996, 0, 0, 0, 
        357672696, 0, 0, 0, 715345393, 0, 0, 0, 1430690786, 0, 0, 0, 2861381572, 0, 0, 0, 
        1427795848, 0, 0, 0, 2855591696, 0, 0, 0, 1416216096, 0, 0, 0, 2832432193, 0, 0, 0, 
        1369897090, 0, 0, 0, 2739794180, 0, 0, 0, 1184621065, 0, 0, 0, 2369242131, 0, 0, 0, 
        443516967, 0, 0, 0, 887033934, 0, 0, 0, 1774067868, 0, 0, 0, 3548135736, 0, 0, 0, 
        2801304176, 0, 0, 0, 1307641056, 0, 0, 0, 3922242189, 0, 0, 0, 3549517082, 0, 0, 0, 
        2804066868, 0, 0, 0, 1313166441, 0, 0, 0, 2626332883, 0, 0, 0, 957698470, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 348140706, 0, 0, 
        0, 696281412, 0, 0, 0, 1392562824, 0, 0, 0, 2785125649, 0, 0, 0, 1275284003, 0, 0, 
        0, 2550568007, 0, 0, 0, 806168719, 0, 0, 0, 1612337439, 0, 0, 0, 3224674878, 0, 0, 
        0, 2154382460, 0, 0, 0, 13797624, 0, 0, 0, 27595248, 0, 0, 0, 55190496, 0, 0, 
        0, 110380992, 0, 0, 0, 220761985, 0, 0, 0, 441523971, 0, 0, 0, 883047943, 0, 0, 
        0, 1766095886, 0, 0, 0, 3532191772, 0, 0, 0, 2769416249, 0, 0, 0, 1243865203, 0, 0, 
        0, 2487730406, 0, 0, 0, 680493516, 0, 0, 0, 1360987032, 0, 0, 0, 2721974065, 0, 0, 
        0, 1148980834, 0, 0, 0, 2297961669, 0, 0, 0, 87035176, 0, 0, 0, 174070353, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1770227281, 0, 0, 0, 3540454563, 0, 0, 0, 2785941830, 0, 0, 0, 1276916364, 0, 
        0, 0, 2553832729, 0, 0, 0, 812698162, 0, 0, 0, 1625396325, 0, 0, 0, 3250792650, 0, 
        0, 0, 2206618004, 0, 0, 0, 118268713, 0, 0, 0, 236537426, 0, 0, 0, 473074852, 0, 
        0, 0, 946149705, 0, 0, 0, 1892299411, 0, 0, 0, 3784598822, 0, 0, 0, 2863352860, 0, 
        0, 0, 1431738424, 0, 0, 0, 2863476848, 0, 0, 0, 1431986401, 0, 0, 0, 2863972803, 0, 
        0, 0, 1432978310, 0, 0, 0, 2865956620, 0, 0, 0, 1436945945, 0, 0, 0, 2873891890, 0, 
        0, 0, 1452816485, 0, 0, 0, 2905632970, 0, 0, 0, 1516298644, 0, 0, 0, 3032597288, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135049252, 
        0, 0, 0, 270098504, 0, 0, 0, 540197008, 0, 0, 0, 1080394017, 0, 0, 0, 2160788035, 
        0, 0, 0, 26608774, 0, 0, 0, 53217549, 0, 0, 0, 106435098, 0, 0, 0, 212870196, 
        0, 0, 0, 425740393, 0, 0, 0, 851480786, 0, 0, 0, 1702961572, 0, 0, 0, 3405923145, 
        0, 0, 0, 2516878995, 0, 0, 0, 738790694, 0, 0, 0, 1477581388, 0, 0, 0, 2955162776, 
        0, 0, 0, 1615358257, 0, 0, 0, 3230716514, 0, 0, 0, 2166465732, 0, 0, 0, 37964168, 
        0, 0, 0, 75928336, 0, 0, 0, 16881156, 0, 0, 0, 33762313, 0, 0, 0, 67524626, 
    },
    {
        0, 0, 0, 0, 4038889453, 0, 0, 0, 3782811611, 0, 0, 0, 3270655926, 0, 0, 0, 
        2246344557, 0, 0, 0, 197721819, 0, 0, 0, 395443639, 0, 0, 0, 790887279, 0, 0, 0, 
        1581774559, 0, 0, 0, 3163549119, 0, 0, 0, 2032130942, 0, 0, 0, 4064261884, 0, 0, 0, 
        3833556473, 0, 0, 0, 3372145651, 0, 0, 0, 2449324007, 0, 0, 0, 603680719, 0, 0, 0, 
        1207361439, 0, 0, 0, 2414722878, 0, 0, 0, 534478461, 0, 0, 0, 1068956923, 0, 0, 0, 
        2137913847, 0, 0, 0, 4275827694, 0, 0, 0, 4256688093, 0, 0, 0, 4218408890, 0, 0, 0, 
        4141850484, 0, 0, 0, 3988733673, 0, 0, 0, 734196287, 0, 0, 0, 1468392575, 0, 0, 0, 
        2936785150, 0, 0, 0, 1578603005, 0, 0, 0, 3157206011, 0, 0, 0, 2019444726, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2692483345, 0, 0, 
        0, 1089999394, 0, 0, 0, 2179998788, 0, 0, 0, 65030280, 0, 0, 0, 130060560, 0, 0, 
        0, 260121121, 0, 0, 0, 520242243, 0, 0, 0, 1040484486, 0, 0, 0, 2080968972, 0, 0, 
        0, 4161937944, 0, 0, 0, 4028908593, 0, 0, 0, 3762849891, 0, 0, 0, 3230732486, 0, 0, 
        0, 2166497676, 0, 0, 0, 38028056, 0, 0, 0, 76056112, 0, 0, 0, 152112225, 0, 0, 
        0, 304224450, 0, 0, 0, 608448901, 0, 0, 0, 1216897803, 0, 0, 0, 2433795606, 0, 0, 
        0, 572623917, 0, 0, 0, 1145247834, 0, 0, 0, 2290495669, 0, 0, 0, 286024042, 0, 0, 
        0, 572048085, 0, 0, 0, 1144096170, 0, 0, 0, 673120836, 0, 0, 0, 1346241672, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 302254233, 0, 0, 0, 604508466, 0, 0, 0, 1209016932, 0, 0, 0, 2418033865, 0, 
        0, 0, 541100435, 0, 0, 0, 1082200870, 0, 0, 0, 2164401740, 0, 0, 0, 33836184, 0, 
        0, 0, 67672369, 0, 0, 0, 135344738, 0, 0, 0, 270689477, 0, 0, 0, 541378955, 0, 
        0, 0, 1082757911, 0, 0, 0, 2165515822, 0, 0, 0, 36064348, 0, 0, 0, 373854240, 0, 
        0, 0, 747708480, 0, 0, 0, 1495416961, 0, 0, 0, 2990833922, 0, 0, 0, 1686700548, 0, 
        0, 0, 3373401096, 0, 0, 0, 2451834897, 0, 0, 0, 608702498, 0, 0, 0, 1217404996, 0, 
        0, 0, 2434809993, 0, 0, 0, 574652691, 0, 0, 0, 1149305382, 0, 0, 0, 2298610764, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3961969350, 
        0, 0, 0, 3628971405, 0, 0, 0, 2962975514, 0, 0, 0, 1630983732, 0, 0, 0, 3261967464, 
        0, 0, 0, 2228967633, 0, 0, 0, 162967970, 0, 0, 0, 325935940, 0, 0, 0, 651871880, 
        0, 0, 0, 1303743760, 0, 0, 0, 2607487520, 0, 0, 0, 920007744, 0, 0, 0, 1840015488, 
        0, 0, 0, 3680030976, 0, 0, 0, 3065094657, 0, 0, 0, 1835222019, 0, 0, 0, 3670444038, 
        0, 0, 0, 3045920780, 0, 0, 0, 1796874265, 0, 0, 0, 3593748531, 0, 0, 0, 2892529767, 
        0, 0, 0, 1490092239, 0, 0, 0, 1568987992, 0, 0, 0, 3137975985, 0, 0, 0, 1980984675, 
    },
    {
        0, 0, 0, 0, 3824344628, 0, 0, 0, 3353721960, 0, 0, 0, 2412476624, 0, 0, 0, 
        529985953, 0, 0, 0, 1059971907, 0, 0, 0, 2119943815, 0, 0, 0, 4239887631, 0, 0, 0, 
        4184807967, 0, 0, 0, 4074648638, 0, 0, 0, 3854329981, 0, 0, 0, 3413692666, 0, 0, 0, 
        2532418036, 0, 0, 0, 769868776, 0, 0, 0, 1539737553, 0, 0, 0, 3079475106, 0, 0, 0, 
        1863982917, 0, 0, 0, 3727965834, 0, 0, 0, 3160964373, 0, 0, 0, 2026961450, 0, 0, 0, 
        4053922901, 0, 0, 0, 3812878506, 0, 0, 0, 3330789716, 0, 0, 0, 2366612137, 0, 0, 0, 
        438256979, 0, 0, 0, 876513958, 0, 0, 0, 2341456760, 0, 0, 0, 387946225, 0, 0, 0, 
        775892451, 0, 0, 0, 1551784902, 0, 0, 0, 3103569805, 0, 0, 0, 1912172314, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1473249760, 0, 0, 
        0, 2946499520, 0, 0, 0, 1598031745, 0, 0, 0, 3196063490, 0, 0, 0, 2097159684, 0, 0, 
        0, 4194319368, 0, 0, 0, 4093671441, 0, 0, 0, 3892375586, 0, 0, 0, 3489783876, 0, 0, 
        0, 2684600457, 0, 0, 0, 1074233618, 0, 0, 0, 2148467236, 0, 0, 0, 1967176, 0, 0, 
        0, 3934352, 0, 0, 0, 7868704, 0, 0, 0, 15737408, 0, 0, 0, 31474816, 0, 0, 
        0, 62949632, 0, 0, 0, 125899264, 0, 0, 0, 251798529, 0, 0, 0, 503597059, 0, 0, 
        0, 1007194118, 0, 0, 0, 2014388236, 0, 0, 0, 4028776473, 0, 0, 0, 3762585651, 0, 0, 
        0, 3230204006, 0, 0, 0, 2165440716, 0, 0, 0, 1442054264, 0, 0, 0, 2884108528, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 536903683, 0, 0, 0, 1073807366, 0, 0, 0, 2147614732, 0, 0, 0, 262168, 0, 
        0, 0, 524336, 0, 0, 0, 1048672, 0, 0, 0, 2097344, 0, 0, 0, 4194688, 0, 
        0, 0, 8389376, 0, 0, 0, 16778752, 0, 0, 0, 33557504, 0, 0, 0, 67115008, 0, 
        0, 0, 134230016, 0, 0, 0, 268460033, 0, 0, 0, 536920067, 0, 0, 0, 1610678276, 0, 
        0, 0, 3221356552, 0, 0, 0, 2147745808, 0, 0, 0, 524320, 0, 0, 0, 1048640, 0, 
        0, 0, 2097280, 0, 0, 0, 4194560, 0, 0, 0, 8389120, 0, 0, 0, 16778240, 0, 
        0, 0, 33556480, 0, 0, 0, 67112960, 0, 0, 0, 134225920, 0, 0, 0, 268451841, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3548126500, 
        0, 0, 0, 2801285704, 0, 0, 0, 1307604113, 0, 0, 0, 2615208226, 0, 0, 0, 935449156, 
        0, 0, 0, 1870898313, 0, 0, 0, 3741796627, 0, 0, 0, 3188625959, 0, 0, 0, 2082284622, 
        0, 0, 0, 4164569244, 0, 0, 0, 4034171193, 0, 0, 0, 3773375091, 0, 0, 0, 3251782887, 
        0, 0, 0, 2208598479, 0, 0, 0, 122229662, 0, 0, 0, 244459325, 0, 0, 0, 488918650, 
        0, 0, 0, 977837300, 0, 0, 0, 1955674600, 0, 0, 0, 3911349200, 0, 0, 0, 3527731104, 
        0, 0, 0, 2760494912, 0, 0, 0, 2590999460, 0, 0, 0, 887031625, 0, 0, 0, 1774063250, 
    },
    {
        0, 0, 0, 0, 1099834596, 0, 0, 0, 2199669192, 0, 0, 0, 104371089, 0, 0, 0, 
        208742178, 0, 0, 0, 417484356, 0, 0, 0, 834968712, 0, 0, 0, 1669937425, 0, 0, 0, 
        3339874850, 0, 0, 0, 2384782404, 0, 0, 0, 474597512, 0, 0, 0, 949195024, 0, 0, 0, 
        1898390048, 0, 0, 0, 3796780096, 0, 0, 0, 3298592897, 0, 0, 0, 2302218499, 0, 0, 0, 
        309469703, 0, 0, 0, 618939406, 0, 0, 0, 1237878812, 0, 0, 0, 2475757624, 0, 0, 0, 
        656547953, 0, 0, 0, 1313095907, 0, 0, 0, 2626191815, 0, 0, 0, 957416334, 0, 0, 0, 
        1914832669, 0, 0, 0, 3829665339, 0, 0, 0, 2298886291, 0, 0, 0, 302805287, 0, 0, 0, 
        605610574, 0, 0, 0, 1211221148, 0, 0, 0, 2422442297, 0, 0, 0, 549917298, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1442838528, 0, 0, 
        0, 2885677056, 0, 0, 0, 1476386816, 0, 0, 0, 2952773632, 0, 0, 0, 1610579969, 0, 0, 
        0, 3221159938, 0, 0, 0, 2147352580, 0, 0, 0, 4294705160, 0, 0, 0, 4294443024, 0, 0, 
        0, 4293918752, 0, 0, 0, 4292870208, 0, 0, 0, 4290773120, 0, 0, 0, 4286578944, 0, 0, 
        0, 4278190592, 0, 0, 0, 4261413888, 0, 0, 0, 4227860480, 0, 0, 0, 4160753664, 0, 0, 
        0, 4026540033, 0, 0, 0, 3758112771, 0, 0, 0, 3221258246, 0, 0, 0, 2147549196, 0, 0, 
        0, 131096, 0, 0, 0, 262192, 0, 0, 0, 524384, 0, 0, 0, 1048768, 0, 0, 
        0, 2097536, 0, 0, 0, 4195072, 0, 0, 0, 1434451456, 0, 0, 0, 2868902912, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 262152, 0, 0, 0, 524304, 0, 0, 0, 1048608, 0, 0, 0, 2097216, 0, 
        0, 0, 4194432, 0, 0, 0, 8388864, 0, 0, 0, 16777728, 0, 0, 0, 33555456, 0, 
        0, 0, 67110912, 0, 0, 0, 134221824, 0, 0, 0, 268443649, 0, 0, 0, 536887298, 0, 
        0, 0, 1073774597, 0, 0, 0, 2147549194, 0, 0, 0, 131092, 0, 0, 0, 32, 0, 
        0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 0, 512, 0, 
        0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 0, 8192, 0, 
        0, 0, 16384, 0, 0, 0, 32769, 0, 0, 0, 65538, 0, 0, 0, 131076, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 357270623, 
        0, 0, 0, 714541247, 0, 0, 0, 1429082494, 0, 0, 0, 2858164988, 0, 0, 0, 1421362680, 
        0, 0, 0, 2842725361, 0, 0, 0, 1390483426, 0, 0, 0, 2780966853, 0, 0, 0, 1266966411, 
        0, 0, 0, 2533932823, 0, 0, 0, 772898351, 0, 0, 0, 1545796702, 0, 0, 0, 3091593405, 
        0, 0, 0, 1888219514, 0, 0, 0, 3776439028, 0, 0, 0, 3257910761, 0, 0, 0, 2220854227, 
        0, 0, 0, 146741158, 0, 0, 0, 293482317, 0, 0, 0, 586964634, 0, 0, 0, 1173929269, 
        0, 0, 0, 2347858538, 0, 0, 0, 44658827, 0, 0, 0, 89317655, 0, 0, 0, 178635311, 
    },
    {
        0, 0, 0, 0, 3400190380, 0, 0, 0, 2505413465, 0, 0, 0, 715859635, 0, 0, 0, 
        1431719270, 0, 0, 0, 2863438540, 0, 0, 0, 1431909784, 0, 0, 0, 2863819568, 0, 0, 0, 
        1432671840, 0, 0, 0, 2865343680, 0, 0, 0, 1435720064, 0, 0, 0, 2871440128, 0, 0, 0, 
        1447912961, 0, 0, 0, 2895825923, 0, 0, 0, 1496684550, 0, 0, 0, 2993369100, 0, 0, 0, 
        1691770904, 0, 0, 0, 3383541809, 0, 0, 0, 2472116322, 0, 0, 0, 649265349, 0, 0, 0, 
        1298530698, 0, 0, 0, 2597061396, 0, 0, 0, 899155496, 0, 0, 0, 1798310993, 0, 0, 0, 
        3596621986, 0, 0, 0, 2898276677, 0, 0, 0, 2469047078, 0, 0, 0, 643126861, 0, 0, 0, 
        1286253722, 0, 0, 0, 2572507445, 0, 0, 0, 850047595, 0, 0, 0, 1700095190, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 
        0, 32, 0, 0, 0, 64, 0, 0, 0, 128, 0, 0, 0, 256, 0, 0, 
        0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 0, 4096, 0, 0, 
        0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 0, 65536, 0, 0, 
        0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 0, 1048576, 0, 0, 
        0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 0, 16777216, 0, 0, 
        0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 0, 268435458, 0, 0, 
        0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483652, 0, 0, 0, 8, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 1073774613, 0, 0, 0, 2147549226, 0, 0, 0, 131156, 0, 0, 0, 262312, 0, 
        0, 0, 524624, 0, 0, 0, 1049248, 0, 0, 0, 2098496, 0, 0, 0, 4196992, 0, 
        0, 0, 8393984, 0, 0, 0, 16787968, 0, 0, 0, 33575936, 0, 0, 0, 67151873, 0, 
        0, 0, 134303746, 0, 0, 0, 268607492, 0, 0, 0, 537214984, 0, 0, 0, 655364, 0, 
        0, 0, 1310728, 0, 0, 0, 2621456, 0, 0, 0, 5242912, 0, 0, 0, 10485824, 0, 
        0, 0, 20971648, 0, 0, 0, 41943296, 0, 0, 0, 83886592, 0, 0, 0, 167773184, 0, 
        0, 0, 335546369, 0, 0, 0, 671092738, 0, 0, 0, 1342185477, 0, 0, 0, 2684370954, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3265725291, 
        0, 0, 0, 2236483287, 0, 0, 0, 177999279, 0, 0, 0, 355998558, 0, 0, 0, 711997116, 
        0, 0, 0, 1423994233, 0, 0, 0, 2847988467, 0, 0, 0, 1401009639, 0, 0, 0, 2802019279, 
        0, 0, 0, 1309071263, 0, 0, 0, 2618142526, 0, 0, 0, 941317756, 0, 0, 0, 1882635512, 
        0, 0, 0, 3765271025, 0, 0, 0, 3235574755, 0, 0, 0, 2176182214, 0, 0, 0, 57397132, 
        0, 0, 0, 114794264, 0, 0, 0, 229588528, 0, 0, 0, 459177056, 0, 0, 0, 918354113, 
        0, 0, 0, 1836708227, 0, 0, 0, 408215661, 0, 0, 0, 816431322, 0, 0, 0, 1632862645, 
    },
    {
        0, 0, 0, 0, 2928597988, 0, 0, 0, 1562228680, 0, 0, 0, 3124457360, 0, 0, 0, 
        1953947424, 0, 0, 0, 3907894849, 0, 0, 0, 3520822403, 0, 0, 0, 2746677510, 0, 0, 0, 
        1198387725, 0, 0, 0, 2396775450, 0, 0, 0, 498583604, 0, 0, 0, 997167209, 0, 0, 0, 
        1994334419, 0, 0, 0, 3988668839, 0, 0, 0, 3682370382, 0, 0, 0, 3069773468, 0, 0, 0, 
        1844579640, 0, 0, 0, 3689159280, 0, 0, 0, 3083351264, 0, 0, 0, 1871735233, 0, 0, 0, 
        3743470466, 0, 0, 0, 3191973636, 0, 0, 0, 2088979976, 0, 0, 0, 4177959953, 0, 0, 0, 
        4060952610, 0, 0, 0, 3826937925, 0, 0, 0, 1723480943, 0, 0, 0, 3446961887, 0, 0, 0, 
        2598956478, 0, 0, 0, 902945660, 0, 0, 0, 1805891321, 0, 0, 0, 3611782642, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 
        0, 256, 0, 0, 0, 512, 0, 0, 0, 1024, 0, 0, 0, 2048, 0, 0, 
        0, 4096, 0, 0, 0, 8192, 0, 0, 0, 16384, 0, 0, 0, 32768, 0, 0, 
        0, 65536, 0, 0, 0, 131072, 0, 0, 0, 262144, 0, 0, 0, 524288, 0, 0, 
        0, 1048576, 0, 0, 0, 2097152, 0, 0, 0, 4194304, 0, 0, 0, 8388608, 0, 0, 
        0, 16777216, 0, 0, 0, 33554432, 0, 0, 0, 67108864, 0, 0, 0, 134217729, 0, 0, 
        0, 268435458, 0, 0, 0, 536870917, 0, 0, 0, 1073741834, 0, 0, 0, 2147483668, 0, 0, 
        0, 40, 0, 0, 0, 80, 0, 0, 0, 32, 0, 0, 0, 64, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 18087960, 0, 0, 0, 36175920, 0, 0, 0, 72351840, 0, 0, 0, 144703680, 0, 
        0, 0, 289407361, 0, 0, 0, 578814722, 0, 0, 0, 1157629444, 0, 0, 0, 2315258888, 0, 
        0, 0, 335550481, 0, 0, 0, 671100962, 0, 0, 0, 1342201925, 0, 0, 0, 2684403851, 0, 
        0, 0, 1073840407, 0, 0, 0, 2147680814, 0, 0, 0, 394332, 0, 0, 0, 18352288, 0, 
        0, 0, 36704576, 0, 0, 0, 73409152, 0, 0, 0, 146818304, 0, 0, 0, 293636608, 0, 
        0, 0, 587273216, 0, 0, 0, 1174546432, 0, 0, 0, 2349092864, 0, 0, 0, 403218432, 0, 
        0, 0, 806436865, 0, 0, 0, 1612873731, 0, 0, 0, 3225747462, 0, 0, 0, 2156527628, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3612118070, 
        0, 0, 0, 2929268845, 0, 0, 0, 1563570394, 0, 0, 0, 3127140788, 0, 0, 0, 1959314281, 
        0, 0, 0, 3918628562, 0, 0, 0, 3542289829, 0, 0, 0, 2789612362, 0, 0, 0, 1284257428, 
        0, 0, 0, 2568514856, 0, 0, 0, 842062417, 0, 0, 0, 1684124835, 0, 0, 0, 3368249671, 
        0, 0, 0, 2441532046, 0, 0, 0, 588096797, 0, 0, 0, 1176193595, 0, 0, 0, 2352387190, 
        0, 0, 0, 409807085, 0, 0, 0, 819614171, 0, 0, 0, 1639228342, 0, 0, 0, 3278456684, 
        0, 0, 0, 2261946072, 0, 0, 0, 3672740230, 0, 0, 0, 3050513165, 0, 0, 0, 1806059035, 
    },
};

// clang-format on

#endif // ROCRAND_LFSR113_PRECOMPUTED_H_
