\name{ObjectnessMeasureImageFilter}
\alias{ObjectnessMeasureImageFilter}
\title{ObjectnessMeasureImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Enhance M-dimensional objects in N-dimensional images.
ObjectnessMeasureImageFilter}
\details{
This filter is a generalization of Frangi's vesselness measurement for
detecting M-dimensional object in N-dimensional space. For example a
vessel is a 1-D object in 3-D space. The filter can enhance blob-like
structures (M=0), vessel-like structures (M=1), 2D plate-like
structures (M=2), hyper-plate-like structures (M=3) in N-dimensional
images, with M<N.
This filter takes a scalar image as input and produces a real valued
image as output which contains the objectness measure at each pixel.
Internally, it computes a Hessian via discrete central differences.
Before applying this filter it is expected that a Gaussian smoothing
filter at an appropriate scale (sigma) was applied to the input image.
The enhancement is based on the eigenvalues of the Hessian matrix. For
the Frangi's vesselness case were M=1 and N=3 we have the 3
eigenvalues such that \eqn{ | \lambda_1 | < | \lambda_2 | < |\lambda_3 | } . The formula follows:
 \deqn{ R_A = \frac{|\lambda_2|}{|\lambda_3|}, \; R_B = \frac{|\lambda_2|}{|\lambda_2\lambda_3|}, \; S = \sqrt{\lambda_1^2+\lambda_2^2+\lambda_3^2} } \deqn{ V_{\sigma}= \begin{cases} (1-e^{-\frac{R_A^2}{2\alpha^2}}) \cdot e^{\frac{R_B^2}{2\beta^2}} \cdot (1-e^{-\frac{S^2}{2\gamma^2}}) if  \lambda_2<0  and  \lambda_3<0 ,\\ 0 otherwise \end{cases} }
References
Antiga, L. Generalizing vesselness with respect to dimensionality and
shape. https://hdl.handle.net/1926/576
Frangi, AF, Niessen, WJ, Vincken, KL, & Viergever, MA (1998).
Multiscale Vessel Enhancement Filtering. In Wells, WM, Colchester, A,
& Delp, S, Editors, MICCAI '98 Medical Image Computing and Computer-Assisted Intervention, Lecture Notes in
Computer Science, pages 130-137, Springer Verlag, 1998.
See:
itk::HessianToObjectnessMeasureImageFilter
ObjectnessMeasure for the procedural interface
itk::ObjectnessMeasureImageFilter for the Doxygen on the original ITK
class.
ObjectnessMeasureImageFilter}
%C++ includes: sitkObjectnessMeasureImageFilter.h
\section{Methods}{
\describe{
\item{Self BrightObjectOff():}{}
\item{Self BrightObjectOn():}{
Set the value of BrightObject to true or false respectfully.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetAlpha() const:}{
Set/Get Alpha, the weight corresponding to R_A (the ratio of the
smallest eigenvalue that has to be large to the larger ones). Smaller
values lead to increased sensitivity to the object dimensionality.
}
\item{double GetBeta() const:}{
Set/Get Beta, the weight corresponding to R_B (the ratio of the
largest eigenvalue that has to be small to the larger ones). Smaller
values lead to increased sensitivity to the object dimensionality.
}
\item{bool GetBrightObject() const:}{
Enhance bright structures on a dark background if true, the opposite
if false.
}
\item{double GetGamma() const:}{
Set/Get Gamma, the weight corresponding to S (the Frobenius norm of
the Hessian matrix, or second-order structureness)
}
\item{std::string GetName() const:}{
Name of this class
}
\item{unsigned int GetObjectDimension() const:}{
Set/Get the dimensionality of the object (0: points (blobs), 1: lines
(vessels), 2: planes (plate-like structures), 3: hyper-planes.
ObjectDimension must be smaller than ImageDimension.
}
\item{bool GetScaleObjectnessMeasure() const:}{
Toggle scaling the objectness measure with the magnitude of the
largest absolute eigenvalue
}
\item{ ObjectnessMeasureImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self ScaleObjectnessMeasureOff():}{}
\item{Self ScaleObjectnessMeasureOn():}{
Set the value of ScaleObjectnessMeasure to true or false respectfully.
}
\item{Self SetAlpha(double Alpha):}{
Set/Get Alpha, the weight corresponding to R_A (the ratio of the
smallest eigenvalue that has to be large to the larger ones). Smaller
values lead to increased sensitivity to the object dimensionality.
}
\item{Self SetBeta(double Beta):}{
Set/Get Beta, the weight corresponding to R_B (the ratio of the
largest eigenvalue that has to be small to the larger ones). Smaller
values lead to increased sensitivity to the object dimensionality.
}
\item{Self SetBrightObject(bool BrightObject):}{
Enhance bright structures on a dark background if true, the opposite
if false.
}
\item{Self SetGamma(double Gamma):}{
Set/Get Gamma, the weight corresponding to S (the Frobenius norm of
the Hessian matrix, or second-order structureness)
}
\item{Self SetObjectDimension(unsigned int ObjectDimension):}{
Set/Get the dimensionality of the object (0: points (blobs), 1: lines
(vessels), 2: planes (plate-like structures), 3: hyper-planes.
ObjectDimension must be smaller than ImageDimension.
}
\item{Self SetScaleObjectnessMeasure(bool ScaleObjectnessMeasure):}{
Toggle scaling the objectness measure with the magnitude of the
largest absolute eigenvalue
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ObjectnessMeasureImageFilter():}{
Destructor
}
}
}
