\name{CollidingFrontsImageFilter}
\alias{CollidingFrontsImageFilter}
\title{CollidingFrontsImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Selects a region of space where two independent fronts run towards
each other.
CollidingFrontsImageFilter}
\details{
The filter can be used to quickly segment anatomical structures (e.g.
for level set initialization).
The filter uses two instances of FastMarchingUpwindGradientImageFilter to compute the gradients of arrival times of two wavefronts
propagating from two sets of seeds. The input of the filter is used as
the speed of the two wavefronts. The output is the dot product between
the two gradient vector fields.
The filter works on the following basic idea. In the regions where the
dot product between the two gradient fields is negative, the two
fronts propagate in opposite directions. In the regions where the dot
product is positive, the two fronts propagate in the same direction.
This can be used to extract the region of space between two sets of
points.
If StopOnTargets is On, then each front will stop as soon as all seeds
of the other front have been reached. This can markedly speed up the
execution of the filter, since wave propagation does not take place on
the complete image.
Optionally, a connectivity criterion can be applied to the resulting
dot product image. In this case, the only negative region in the
output image is the one connected to the seeds.
Luca Antiga Ph.D. Biomedical Technologies Laboratory, Bioengineering
Department, Mario Negri Institute, Italy.
See:
CollidingFronts for the procedural interface
itk::CollidingFrontsImageFilter for the Doxygen on the original ITK class.
CollidingFrontsImageFilter}
%C++ includes: sitkCollidingFrontsImageFilter.h
\section{Methods}{
\describe{
\item{Self AddSeedPoint1(std::vector< unsigned int > point):}{
Add SeedPoints1 point.
}
\item{Self AddSeedPoint2(std::vector< unsigned int > point):}{
Add SeedPoints2 point.
}
\item{Self ApplyConnectivityOff():}{}
\item{Self ApplyConnectivityOn():}{
Set the value of ApplyConnectivity to true or false respectfully.
}
\item{Self ClearSeedPoints1():}{
Remove all SeedPoints1 points.
}
\item{Self ClearSeedPoints2():}{
Remove all SeedPoints2 points.
}
\item{ CollidingFrontsImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{bool GetApplyConnectivity() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetNegativeEpsilon() const:}{}
\item{std::vector< std::vector< unsigned int > > GetSeedPoints1() const:}{
Get the container of Seed Points representing the first initial front.
}
\item{std::vector< std::vector< unsigned int > > GetSeedPoints2() const:}{
Get the container of Seed Points representing the second initial
front.
}
\item{bool GetStopOnTargets() const:}{}
\item{Self SetApplyConnectivity(bool ApplyConnectivity):}{}
\item{Self SetNegativeEpsilon(double NegativeEpsilon):}{}
\item{Self SetSeedPoints1(std::vector< std::vector< unsigned int > > SeedPoints1):}{
Set the container of Seed Points representing the first initial front.
Seed points are represented as a VectorContainer of LevelSetNodes.
}
\item{Self SetSeedPoints2(std::vector< std::vector< unsigned int > > SeedPoints2):}{
Set the container of Seed Points representing the second initial
front. Seed points are represented as a VectorContainer of LevelSetNodes.
}
\item{Self SetStopOnTargets(bool StopOnTargets):}{}
\item{Self StopOnTargetsOff():}{}
\item{Self StopOnTargetsOn():}{
Set the value of StopOnTargets to true or false respectfully.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~CollidingFrontsImageFilter():}{
Destructor
}
}
}
