"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTooltipInfoSelector = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var goal_spec_1 = require("./goal_spec");
var picked_shapes_1 = require("./picked_shapes");
var EMPTY_TOOLTIP = Object.freeze({
    header: null,
    values: [],
});
exports.getTooltipInfoSelector = create_selector_1.createCustomCachedSelector([goal_spec_1.getSpecOrNull, picked_shapes_1.getPickedShapes], function (spec, pickedShapes) {
    if (!spec) {
        return EMPTY_TOOLTIP;
    }
    var tooltipInfo = {
        header: null,
        values: [],
    };
    pickedShapes.forEach(function (shape) {
        tooltipInfo.values.push({
            label: 'Actual',
            color: 'white',
            isHighlighted: false,
            isVisible: true,
            seriesIdentifier: {
                specId: spec.id,
                key: spec.id,
            },
            value: shape.actual,
            formattedValue: "" + shape.actual,
            datum: shape.actual,
        });
    });
    return tooltipInfo;
});
//# sourceMappingURL=tooltip.js.map