/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.sql.TIMESTAMPTZ;

public final class OsonPrimitiveConversions {
    private static final int HUNDIGMAX = 66;
    private static final int BIGINTARRAYMAX = 54;
    private static final int BIGLENMAX = 22;
    private static final byte DIGEND = 21;
    private static final int LNXSGNBT = 128;
    private static final byte LNXDIGS = 20;
    private static final int LNXBASE = 100;
    private static final int LNXEXPMX = 127;
    private static final byte LNXEXPBS = 64;
    private static final int LNXEXPMN = 0;
    private static final byte ODIGEND = 9;
    private static final byte MAX_LONG_BASE100_DIGITS = 9;
    public static int SIZE_TIMESTAMP = 11;
    public static int SIZE_TIMESTAMP_NOFRAC = 7;
    public static int SIZE_DATE = 7;
    public static int SIZE_TIMESTAMPTZ = 13;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;
    private static final int MAXYEAR = 9999;
    static final int INTERVAL_BYTE_OFFSET = 60;
    static final int INTERVAL_INT_OFFSET = Integer.MIN_VALUE;
    static final int SECONDS_PER_DAY = 86400;
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int SECONDS_PER_MINUTE = 60;

    private static int nanos(byte[] bytes) {
        int nanos = bytes.length == SIZE_TIMESTAMP_NOFRAC ? 0 : OsonPrimitiveConversions.getNanos(bytes, 7);
        return nanos;
    }

    private static void yearError(OracleJsonExceptions.ExceptionFactory f, int year) {
        if (year < 1 || year > 9999) {
            throw OracleJsonExceptions.BAD_YEAR.create(f, year);
        }
    }

    public static boolean isPosInf(byte[] b) {
        return OsonPrimitiveConversions._isInf(b);
    }

    public static boolean isNegInf(byte[] b, int len, int offset) {
        if (len != 1) {
            return false;
        }
        return b[offset] == 0;
    }

    private static void appendInt(StringBuilder result, int n, int i) {
        if (n < 0) {
            result.append("-");
            n = -n;
        }
        int tmp = n;
        while (tmp > 0) {
            tmp /= 10;
            --i;
        }
        while (i > 0) {
            result.append('0');
            --i;
        }
        if (n != 0) {
            result.append(n);
        }
    }

    public static String timestampToString(OracleJsonExceptions.ExceptionFactory f, byte[] bytes) {
        StringBuilder result = new StringBuilder(27);
        int year = OsonPrimitiveConversions.getJavaYear(bytes[0] & 0xFF, bytes[1] & 0xFF);
        OsonPrimitiveConversions.yearError(f, year);
        int month = bytes[2] & 0xFF;
        int day = bytes[3] & 0xFF;
        int hours = (bytes[4] & 0xFF) - 1;
        int minutes = (bytes[5] & 0xFF) - 1;
        int seconds = (bytes[6] & 0xFF) - 1;
        int nanos = OsonPrimitiveConversions.nanos(bytes);
        OsonPrimitiveConversions.isoTimestamp(result, false, year, month, day, hours, minutes, seconds, nanos);
        return result.toString();
    }

    private static void isoTimestamp(StringBuilder result, boolean alwaysNanos, int year, int month, int day, int hours, int minutes, int seconds, int nanos) {
        OsonPrimitiveConversions.appendInt(result, year, 4);
        result.append("-");
        OsonPrimitiveConversions.appendInt(result, month, 2);
        result.append("-");
        OsonPrimitiveConversions.appendInt(result, day, 2);
        result.append("T");
        OsonPrimitiveConversions.appendInt(result, hours, 2);
        result.append(":");
        OsonPrimitiveConversions.appendInt(result, minutes, 2);
        result.append(":");
        OsonPrimitiveConversions.appendInt(result, seconds, 2);
        if (nanos > 0 || alwaysNanos) {
            result.append(".");
            if (nanos % 1000 > 0) {
                OsonPrimitiveConversions.appendInt(result, nanos, 9);
            } else {
                OsonPrimitiveConversions.appendInt(result, (int)TimeUnit.NANOSECONDS.toMicros(nanos), 6);
            }
        }
    }

    public static String timestampTZToString(OracleJsonExceptions.ExceptionFactory f, byte[] bytes) {
        StringBuilder result = new StringBuilder();
        OffsetDateTime odt = OsonPrimitiveConversions.timestamptzToOffsetDateTime(f, bytes);
        int year = odt.getYear();
        int month = odt.getMonthValue();
        int day = odt.getDayOfMonth();
        int hours = odt.getHour();
        int minutes = odt.getMinute();
        int seconds = odt.getSecond();
        int nanos = odt.getNano();
        OsonPrimitiveConversions.isoTimestamp(result, true, year, month, day, hours, minutes, seconds, nanos);
        ZoneOffset off = odt.getOffset();
        int offSeconds = Math.abs(off.getTotalSeconds());
        int offHours = offSeconds / 3600;
        int offMinutes = offSeconds % 3600 / 60;
        if (offHours == 0 && offMinutes == 0) {
            result.append("Z");
            return result.toString();
        }
        if (off.getTotalSeconds() < 0) {
            result.append("-");
        } else {
            result.append("+");
        }
        OsonPrimitiveConversions.appendInt(result, offHours, 2);
        result.append(":");
        OsonPrimitiveConversions.appendInt(result, offMinutes, 2);
        return result.toString();
    }

    public static void assertNoRegionTimestampTZ(OracleJsonExceptions.ExceptionFactory f, byte[] bytes) {
        if ((bytes[11] & REGIONIDBIT) != 0) {
            throw OracleJsonExceptions.BAD_TIMESTAMP_TZ.create(f, new Object[0]);
        }
    }

    public static OffsetDateTime timestamptzToOffsetDateTime(OracleJsonExceptions.ExceptionFactory f, byte[] bytes) {
        OsonPrimitiveConversions.assertNoRegionTimestampTZ(f, bytes);
        LocalDateTime ldt = OsonPrimitiveConversions.timestampToLocalDateTime(f, bytes);
        OffsetDateTime utc = OffsetDateTime.of(ldt, ZoneOffset.UTC);
        int offHour = bytes[11] - OFFSET_HOUR;
        int offMinute = Math.abs(bytes[12] - OFFSET_MINUTE);
        ZoneOffset zoneOffset = ZoneOffset.ofHoursMinutes(offHour, (int)Math.signum(offHour) * offMinute);
        return utc.withOffsetSameInstant(zoneOffset);
    }

    public static byte[] toOracleTimestampTZ(OracleJsonExceptions.ExceptionFactory f, OffsetDateTime i) {
        try {
            Timestamp ts = Timestamp.from(i.toInstant());
            return TIMESTAMPTZ.toBytes(null, ts, (ZoneId)i.getOffset());
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static LocalDateTime dateToLocalDateTime(OracleJsonExceptions.ExceptionFactory f, byte[] bytes) {
        int year = OsonPrimitiveConversions.getJavaYear(bytes[0] & 0xFF, bytes[1] & 0xFF);
        OsonPrimitiveConversions.yearError(f, year);
        int month = bytes[2] & 0xFF;
        int day = bytes[3] & 0xFF;
        int hours = (bytes[4] & 0xFF) - 1;
        int minutes = (bytes[5] & 0xFF) - 1;
        int seconds = (bytes[6] & 0xFF) - 1;
        return LocalDateTime.of(year, month, day, hours, minutes, seconds);
    }

    public static LocalDateTime timestampToLocalDateTime(OracleJsonExceptions.ExceptionFactory f, byte[] bytes) {
        int year = OsonPrimitiveConversions.getJavaYear(bytes[0] & 0xFF, bytes[1] & 0xFF);
        OsonPrimitiveConversions.yearError(f, year);
        int month = bytes[2] & 0xFF;
        int day = bytes[3] & 0xFF;
        int hours = (bytes[4] & 0xFF) - 1;
        int minutes = (bytes[5] & 0xFF) - 1;
        int seconds = (bytes[6] & 0xFF) - 1;
        int nanos = OsonPrimitiveConversions.nanos(bytes);
        return LocalDateTime.of(year, month, day, hours, minutes, seconds, nanos);
    }

    public static byte[] toOracleDate(OracleJsonExceptions.ExceptionFactory f, LocalDateTime local) {
        int year = local.getYear();
        OsonPrimitiveConversions.yearError(f, year);
        byte[] result = new byte[SIZE_DATE];
        result[0] = (byte)(year / 100 + 100);
        result[1] = (byte)(year % 100 + 100);
        result[2] = (byte)local.getMonthValue();
        result[3] = (byte)local.getDayOfMonth();
        result[4] = (byte)(local.getHour() + 1);
        result[5] = (byte)(local.getMinute() + 1);
        result[6] = (byte)(local.getSecond() + 1);
        return result;
    }

    public static byte[] toOracleTimestamp(OracleJsonExceptions.ExceptionFactory f, LocalDateTime local) {
        int year = local.getYear();
        OsonPrimitiveConversions.yearError(f, year);
        int nanos = local.getNano();
        byte[] result = new byte[nanos == 0 ? SIZE_TIMESTAMP_NOFRAC : SIZE_TIMESTAMP];
        result[0] = (byte)(year / 100 + 100);
        result[1] = (byte)(year % 100 + 100);
        result[2] = (byte)local.getMonthValue();
        result[3] = (byte)local.getDayOfMonth();
        result[4] = (byte)(local.getHour() + 1);
        result[5] = (byte)(local.getMinute() + 1);
        result[6] = (byte)(local.getSecond() + 1);
        if (nanos > 0) {
            result[7] = (byte)(nanos >> 24);
            result[8] = (byte)(nanos >> 16 & 0xFF);
            result[9] = (byte)(nanos >> 8 & 0xFF);
            result[10] = (byte)(nanos & 0xFF);
        }
        return result;
    }

    public static String dateToString(OracleJsonExceptions.ExceptionFactory f, byte[] bytes) {
        int year = OsonPrimitiveConversions.getJavaYear(bytes[0] & 0xFF, bytes[1] & 0xFF);
        OsonPrimitiveConversions.yearError(f, year);
        int month = bytes[2] & 0xFF;
        int day = bytes[3] & 0xFF;
        int hours = (bytes[4] & 0xFF) - 1;
        int minutes = (bytes[5] & 0xFF) - 1;
        int seconds = (bytes[6] & 0xFF) - 1;
        StringBuilder result = new StringBuilder(27);
        OsonPrimitiveConversions.appendInt(result, year, 4);
        result.append("-");
        OsonPrimitiveConversions.appendInt(result, month, 2);
        result.append("-");
        OsonPrimitiveConversions.appendInt(result, day, 2);
        result.append("T");
        OsonPrimitiveConversions.appendInt(result, hours, 2);
        result.append(":");
        OsonPrimitiveConversions.appendInt(result, minutes, 2);
        result.append(":");
        OsonPrimitiveConversions.appendInt(result, seconds, 2);
        return result.toString();
    }

    public static Duration intervalDSToDuration(byte[] raw) {
        int d = OsonPrimitiveConversions.getDaysFromIntervalDS(raw);
        int h = OsonPrimitiveConversions.getHoursFromIntervalDS(raw);
        int m = OsonPrimitiveConversions.getMinutesFromIntervalDS(raw);
        int s = OsonPrimitiveConversions.getSecondsFromIntervalDS(raw);
        int n = OsonPrimitiveConversions.getNanosFromIntervalDS(raw);
        long secs = (long)d * 86400L + (long)h * 3600L + (long)m * 60L + (long)s;
        return Duration.ofSeconds(secs, n);
    }

    public static String serializeIntervalDS(OracleJsonExceptions.ExceptionFactory f, byte[] raw) {
        long days = OsonPrimitiveConversions.getDaysFromIntervalDS(raw);
        long hrs = OsonPrimitiveConversions.getHoursFromIntervalDS(raw);
        long mins = OsonPrimitiveConversions.getMinutesFromIntervalDS(raw);
        long secs = OsonPrimitiveConversions.getSecondsFromIntervalDS(raw);
        long nanos = OsonPrimitiveConversions.getNanosFromIntervalDS(raw);
        int micros = (int)(nanos / 1000L);
        if (days < 0L || hrs < 0L || mins < 0L || secs < 0L || micros < 0 || (nanos %= 1000L) < 0L) {
            throw OracleJsonExceptions.NOT_IMPLEMENTED.create(f, new Object[0]);
        }
        boolean tim = hrs > 0L || mins > 0L || secs > 0L || micros > 0 || nanos > 0L;
        StringBuilder result = new StringBuilder();
        result.append("P");
        if (days > 0L || !tim) {
            result.append(days);
            result.append("D");
        }
        if (tim) {
            result.append("T");
            if (hrs > 0L) {
                result.append(hrs).append("H");
            }
            if (mins > 0L) {
                result.append(mins).append("M");
            }
            if (secs > 0L || micros > 0 || nanos > 0L) {
                result.append(secs);
                if (micros > 0 || nanos > 0L) {
                    String microsStr = String.valueOf(micros);
                    result.append(".");
                    for (int i = 0; i < 6 - microsStr.length(); ++i) {
                        result.append("0");
                    }
                    result.append(micros);
                    if (nanos > 0L) {
                        String nanosStr = String.valueOf(nanos);
                        for (int i = 0; i < 3 - nanosStr.length(); ++i) {
                            result.append("0");
                        }
                        result.append(nanos);
                    }
                }
                result.append("S");
            }
        }
        return result.toString();
    }

    public static byte[] durationToIntervalDS(Duration duration) {
        long seconds = duration.getSeconds();
        long days = seconds / 86400L;
        long hours = duration.toHours() % 24L;
        long min = duration.toMinutes() % 60L;
        long sec = seconds % 60L;
        int frac = duration.getNano();
        int idays = (int)days;
        if ((long)idays != days) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = new byte[11];
        OsonPrimitiveConversions.writeIntervalInt(idays, 0, bytes);
        bytes[4] = (byte)(hours + 60L);
        bytes[5] = (byte)(min + 60L);
        bytes[6] = (byte)(sec + 60L);
        OsonPrimitiveConversions.writeIntervalInt(frac, 7, bytes);
        return bytes;
    }

    private static void writeIntervalInt(int value, int offset, byte[] bytes) {
        bytes[offset++] = (byte)((0xFF000000 & (value -= Integer.MIN_VALUE)) >> 24);
        bytes[offset++] = (byte)((0xFF0000 & value) >> 16);
        bytes[offset++] = (byte)((0xFF00 & value) >> 8);
        bytes[offset++] = (byte)(0xFF & value);
    }

    static int getDaysFromIntervalDS(byte[] bytes) {
        return ((bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF) - Integer.MIN_VALUE;
    }

    static int getHoursFromIntervalDS(byte[] bytes) {
        return bytes[4] - 60;
    }

    static int getMinutesFromIntervalDS(byte[] bytes) {
        return bytes[5] - 60;
    }

    static int getSecondsFromIntervalDS(byte[] bytes) {
        return bytes[6] - 60;
    }

    static int getNanosFromIntervalDS(byte[] bytes) {
        return ((bytes[7] & 0xFF) << 24 | (bytes[8] & 0xFF) << 16 | (bytes[9] & 0xFF) << 8 | bytes[10] & 0xFF) - Integer.MIN_VALUE;
    }

    public static Period intervalYMToPeriod(byte[] raw) {
        int years = OsonPrimitiveConversions.getYearFromIntervalYM(raw);
        int months = OsonPrimitiveConversions.getMonthFromIntervalYM(raw);
        return Period.of(years, months, 0);
    }

    public static byte[] periodToIntervalYM(OracleJsonExceptions.ExceptionFactory f, Period p) {
        int years = p.getYears();
        int months = p.getMonths();
        if (months > 11) {
            throw OracleJsonExceptions.NOT_IMPLEMENTED.create(f, new Object[0]);
        }
        if (years < 0 || months < 0) {
            throw OracleJsonExceptions.NOT_IMPLEMENTED.create(f, new Object[0]);
        }
        if (p.getDays() != 0) {
            throw OracleJsonExceptions.NO_DAYS_ALLOWED.create(f, new Object[0]);
        }
        byte[] result = new byte[5];
        OsonPrimitiveConversions.writeIntervalInt(p.getYears(), 0, result);
        result[4] = (byte)(p.getMonths() + 60);
        return result;
    }

    private static int getMonthFromIntervalYM(byte[] raw) {
        return raw[4] - 60;
    }

    private static int getYearFromIntervalYM(byte[] raw) {
        return ((raw[0] & 0xFF) << 24 | (raw[1] & 0xFF) << 16 | (raw[2] & 0xFF) << 8 | raw[3] & 0xFF) - Integer.MIN_VALUE;
    }

    public static String serializeIntervalYM(OracleJsonExceptions.ExceptionFactory f, byte[] raw) {
        int years = OsonPrimitiveConversions.getYearFromIntervalYM(raw);
        int months = OsonPrimitiveConversions.getMonthFromIntervalYM(raw);
        if (years < 0 || months < 0) {
            throw OracleJsonExceptions.NOT_IMPLEMENTED.create(f, new Object[0]);
        }
        StringBuilder result = new StringBuilder();
        result.append('P');
        if (years > 0 || months == 0) {
            result.append(years).append('Y');
        }
        if (months > 0) {
            result.append(months).append('M');
        }
        return result.toString();
    }

    private static final int getNanos(byte[] buffer, int off) {
        int nanos = (buffer[off] & 0xFF) << 24;
        nanos |= (buffer[off + 1] & 0xFF) << 16;
        nanos |= (buffer[off + 2] & 0xFF) << 8;
        return nanos |= buffer[off + 3] & 0xFF & 0xFF;
    }

    private static int getJavaYear(int cent, int decade) {
        int year = (cent - 100) * 100 + (decade - 100);
        if (year < 0) {
            ++year;
        }
        return year;
    }

    static byte[] doubleToCanonicalFormatBytes(double _d) {
        double d = _d;
        if (d == 0.0) {
            d = 0.0;
        } else if (d != d) {
            d = Double.NaN;
        }
        long longBits = Double.doubleToLongBits(d);
        byte[] b = new byte[8];
        int lowInt = (int)longBits;
        int highInt = (int)(longBits >> 32);
        int b7 = lowInt;
        int b6 = lowInt >>= 8;
        int b5 = lowInt >>= 8;
        int b4 = lowInt >>= 8;
        int b3 = highInt;
        int b2 = highInt >>= 8;
        int b1 = highInt >>= 8;
        int b0 = highInt >>= 8;
        if ((b0 & 0x80) == 0) {
            b0 |= 0x80;
        } else {
            b0 ^= 0xFFFFFFFF;
            b1 ^= 0xFFFFFFFF;
            b2 ^= 0xFFFFFFFF;
            b3 ^= 0xFFFFFFFF;
            b4 ^= 0xFFFFFFFF;
            b5 ^= 0xFFFFFFFF;
            b6 ^= 0xFFFFFFFF;
            b7 ^= 0xFFFFFFFF;
        }
        b[7] = (byte)b7;
        b[6] = (byte)b6;
        b[5] = (byte)b5;
        b[4] = (byte)b4;
        b[3] = (byte)b3;
        b[2] = (byte)b2;
        b[1] = (byte)b1;
        b[0] = (byte)b0;
        return b;
    }

    static double canonicalFormatBytesToDouble(byte[] b) {
        int b0 = b[0];
        int b1 = b[1];
        int b2 = b[2];
        int b3 = b[3];
        int b4 = b[4];
        int b5 = b[5];
        int b6 = b[6];
        int b7 = b[7];
        if ((b0 & 0x80) != 0) {
            b0 &= 0x7F;
            b1 &= 0xFF;
            b2 &= 0xFF;
            b3 &= 0xFF;
            b4 &= 0xFF;
            b5 &= 0xFF;
            b6 &= 0xFF;
            b7 &= 0xFF;
        } else {
            b0 = ~b0 & 0xFF;
            b1 = ~b1 & 0xFF;
            b2 = ~b2 & 0xFF;
            b3 = ~b3 & 0xFF;
            b4 = ~b4 & 0xFF;
            b5 = ~b5 & 0xFF;
            b6 = ~b6 & 0xFF;
            b7 = ~b7 & 0xFF;
        }
        int hiBits = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        int loBits = b4 << 24 | b5 << 16 | b6 << 8 | b7;
        long longBits = (long)hiBits << 32 | (long)loBits & 0xFFFFFFFFL;
        return Double.longBitsToDouble(longBits);
    }

    static byte[] floatToCanonicalFormatBytes(float _f) {
        float f = _f;
        if (f == 0.0f) {
            f = 0.0f;
        } else if (f != f) {
            f = Float.NaN;
        }
        int intBits = Float.floatToIntBits(f);
        byte[] b = new byte[4];
        int b3 = intBits;
        int b2 = intBits >>= 8;
        int b1 = intBits >>= 8;
        int b0 = intBits >>= 8;
        if ((b0 & 0x80) == 0) {
            b0 |= 0x80;
        } else {
            b0 ^= 0xFFFFFFFF;
            b1 ^= 0xFFFFFFFF;
            b2 ^= 0xFFFFFFFF;
            b3 ^= 0xFFFFFFFF;
        }
        b[3] = (byte)b3;
        b[2] = (byte)b2;
        b[1] = (byte)b1;
        b[0] = (byte)b0;
        return b;
    }

    static float canonicalFormatBytesToFloat(byte[] b) {
        int b0 = b[0];
        int b1 = b[1];
        int b2 = b[2];
        int b3 = b[3];
        if ((b0 & 0x80) != 0) {
            b0 &= 0x7F;
            b1 &= 0xFF;
            b2 &= 0xFF;
            b3 &= 0xFF;
        } else {
            b0 = ~b0 & 0xFF;
            b1 = ~b1 & 0xFF;
            b2 = ~b2 & 0xFF;
            b3 = ~b3 & 0xFF;
        }
        int intBits = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        return Float.intBitsToFloat(intBits);
    }

    public static byte[] toNumber(BigDecimal BigDecNum) {
        int mantlen;
        long value;
        int i;
        BigDecimal DBTMP;
        if (BigDecNum == null) {
            throw new IllegalArgumentException();
        }
        byte[] mantissa = new byte[66];
        long[] bnum = new long[54];
        long[] digit = new long[22];
        int digidx = 21;
        int bidx = 0;
        int dstart = 21;
        int oidx = 0;
        int exponent = 0;
        BigDecimal BDABS = BigDecNum.abs();
        int leftdigs = 0;
        if (BigDecNum.signum() == 0) {
            return OsonPrimitiveConversions._makeZero();
        }
        boolean positive = BigDecNum.signum() != -1;
        int scale = BigDecNum.scale();
        if (scale < 0) {
            BigDecNum = BigDecNum.setScale(0);
            scale = 0;
        }
        int rad = BDABS.compareTo(BigDecimal.valueOf(1L));
        int moves = 0;
        if (rad == -1) {
            while ((DBTMP = BDABS.movePointRight(++moves)).compareTo(BigDecimal.valueOf(1L)) < 0) {
            }
            leftdigs = -moves;
        } else {
            while ((DBTMP = BDABS.movePointLeft(++moves)).compareTo(BigDecimal.valueOf(1L)) >= 0) {
            }
            leftdigs = moves;
        }
        byte[] temp = BDABS.movePointRight(scale).toBigInteger().toByteArray();
        if (temp.length > 54) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < temp.length; ++i) {
            bnum[i] = temp[i] < 0 ? (long)(temp[i] + 256) : (long)temp[i];
        }
        int blen = temp.length;
        switch (blen % 3) {
            case 2: {
                digit[digidx] = (bnum[bidx] << 8) + bnum[bidx + 1];
                bidx = (byte)(bidx + 2);
                blen -= 2;
                break;
            }
            case 1: {
                digit[digidx] = bnum[bidx];
                bidx = (byte)(bidx + 1);
                --blen;
                break;
            }
            default: {
                value = (bnum[bidx] << 16) + (bnum[bidx + 1] << 8) + bnum[bidx + 2];
                digit[digidx] = value % 1000000L;
                digit[digidx - 1] = value / 1000000L;
                dstart = (byte)(dstart - (digit[digidx - 1] != 0L ? 1 : 0));
                bidx = (byte)(bidx + 3);
                blen -= 3;
            }
        }
        while (blen != 0) {
            value = (bnum[bidx] << 4) + (bnum[bidx + 1] >> 4);
            for (digidx = 21; digidx >= dstart; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] << 12) % 1000000L;
                value /= 1000000L;
            }
            if (value != 0L) {
                dstart = (byte)(dstart - 1);
                digit[dstart] = value;
            }
            value = ((bnum[bidx + 1] & 0xFL) << 8) + bnum[bidx + 2];
            for (digidx = 21; digidx >= dstart; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] << 12) % 1000000L;
                value /= 1000000L;
            }
            if (value != 0L) {
                dstart = (byte)(dstart - 1);
                digit[dstart] = value;
            }
            bidx = (byte)(bidx + 3);
            blen -= 3;
        }
        mantissa[oidx] = (byte)(digit[dstart] / 10000L);
        if (mantissa[oidx] != 0) {
            mantlen = 3 * (21 - dstart) + 3;
            mantissa[oidx + 1] = (byte)(digit[dstart] % 10000L / 100L);
            mantissa[oidx + 2] = (byte)(digit[dstart] % 100L);
            oidx += 3;
        } else {
            mantissa[oidx] = (byte)(digit[dstart] % 10000L / 100L);
            if (mantissa[oidx] != 0) {
                mantlen = 3 * (21 - dstart) + 2;
                mantissa[oidx + 1] = (byte)(digit[dstart] % 100L);
                oidx += 2;
            } else {
                mantissa[oidx] = (byte)digit[dstart];
                mantlen = 3 * (21 - dstart) + 1;
                ++oidx;
            }
        }
        for (digidx = (int)((byte)(dstart + 1)); digidx <= 21; digidx = (int)((byte)(digidx + 1))) {
            mantissa[oidx] = (byte)(digit[digidx] / 10000L);
            mantissa[oidx + 1] = (byte)(digit[digidx] % 10000L / 100L);
            mantissa[oidx + 2] = (byte)(digit[digidx] % 100L);
            oidx += 3;
        }
        for (i = oidx - 1; i >= 0 && mantissa[i] == 0; --i) {
            --mantlen;
        }
        if (scale > 0 && (scale & 1) != 0) {
            int len = mantlen;
            byte[] buf = new byte[len + 1];
            if (mantissa[0] <= 9) {
                for (i = 0; i < len - 1; ++i) {
                    buf[i] = (byte)(mantissa[i] % 10 * 10 + mantissa[i + 1] / 10);
                }
                buf[i] = (byte)(mantissa[i] % 10 * 10);
                if (buf[len - 1] == 0) {
                    --mantlen;
                }
            } else {
                buf[len] = (byte)(mantissa[len - 1] % 10 * 10);
                for (i = len - 1; i > 0; --i) {
                    buf[i] = (byte)(mantissa[i] / 10 + mantissa[i - 1] % 10 * 10);
                }
                buf[i] = (byte)(mantissa[i] / 10);
                if (buf[len] > 0) {
                    ++mantlen;
                }
            }
            System.arraycopy(buf, 0, mantissa, 0, mantlen);
        }
        if (mantlen > 20) {
            i = 20;
            mantlen = 20;
            if (mantissa[i] >= 50) {
                int n = --i;
                mantissa[n] = (byte)(mantissa[n] + 1);
                while (mantissa[i] == 100) {
                    if (i == 0) {
                        ++leftdigs;
                        mantissa[i] = 1;
                        break;
                    }
                    mantissa[i] = 0;
                    int n2 = --i;
                    mantissa[n2] = (byte)(mantissa[n2] + 1);
                }
            }
            for (i = mantlen - 1; i >= 0 && mantissa[i] == 0; --i) {
                --mantlen;
            }
        }
        exponent = leftdigs <= 0 ? (mantissa[0] < 10 ? -(2 - leftdigs) / 2 + 1 : -(2 - leftdigs) / 2) : (leftdigs - 1) / 2;
        if (exponent > 62) {
            throw new IllegalArgumentException();
        }
        if (exponent < -65) {
            throw new IllegalArgumentException();
        }
        byte[] oranum = new byte[mantlen + 1];
        oranum[0] = (byte)exponent;
        System.arraycopy(mantissa, 0, oranum, 1, mantlen);
        return OsonPrimitiveConversions._toLnxFmt(oranum, positive);
    }

    public static byte[] toNumber(BigInteger BigIntNum) {
        int mantlen;
        long value;
        int i;
        int exponent;
        byte[] temp;
        if (BigIntNum == null) {
            throw new IllegalArgumentException();
        }
        byte[] mantissa = new byte[66];
        long[] bnum = new long[54];
        long[] digit = new long[22];
        int digidx = 21;
        int bidx = 0;
        int dstart = 21;
        int oidx = 0;
        boolean positive = true;
        if (BigIntNum.signum() == 0) {
            return OsonPrimitiveConversions._makeZero();
        }
        if (BigIntNum.signum() == -1) {
            BigInteger Num = BigIntNum.abs();
            positive = false;
            temp = Num.toByteArray();
            exponent = (int)Math.floor((double)Num.bitLength() * 0.1505149978319906);
        } else {
            temp = BigIntNum.toByteArray();
            exponent = (int)Math.floor((double)BigIntNum.bitLength() * 0.1505149978319906);
        }
        if (BigIntNum.abs().compareTo(BigInteger.valueOf(100L).pow(exponent)) < 0) {
            --exponent;
        }
        if (temp.length > 54) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < temp.length; ++i) {
            bnum[i] = temp[i] < 0 ? (long)(temp[i] + 256) : (long)temp[i];
        }
        int blen = temp.length;
        switch (blen % 3) {
            case 2: {
                digit[digidx] = (bnum[bidx] << 8) + bnum[bidx + 1];
                bidx = (byte)(bidx + 2);
                blen -= 2;
                break;
            }
            case 1: {
                digit[digidx] = bnum[bidx];
                bidx = (byte)(bidx + 1);
                --blen;
                break;
            }
            default: {
                value = (bnum[bidx] << 16) + (bnum[bidx + 1] << 8) + bnum[bidx + 2];
                digit[digidx] = value % 1000000L;
                digit[digidx - 1] = value / 1000000L;
                dstart = (byte)(dstart - (digit[digidx - 1] != 0L ? 1 : 0));
                bidx = (byte)(bidx + 3);
                blen -= 3;
            }
        }
        while (blen != 0) {
            value = (bnum[bidx] << 4) + (bnum[bidx + 1] >> 4);
            for (digidx = 21; digidx >= dstart; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] << 12) % 1000000L;
                value /= 1000000L;
            }
            if (value != 0L) {
                dstart = (byte)(dstart - 1);
                digit[dstart] = value;
            }
            value = ((bnum[bidx + 1] & 0xFL) << 8) + bnum[bidx + 2];
            for (digidx = 21; digidx >= dstart; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] << 12) % 1000000L;
                value /= 1000000L;
            }
            if (value != 0L) {
                dstart = (byte)(dstart - 1);
                digit[dstart] = value;
            }
            bidx = (byte)(bidx + 3);
            blen -= 3;
        }
        mantissa[oidx] = (byte)(digit[dstart] / 10000L);
        if (mantissa[oidx] != 0) {
            mantlen = 3 * (21 - dstart) + 3;
            mantissa[oidx + 1] = (byte)(digit[dstart] % 10000L / 100L);
            mantissa[oidx + 2] = (byte)(digit[dstart] % 100L);
            oidx += 3;
        } else {
            mantissa[oidx] = (byte)(digit[dstart] % 10000L / 100L);
            if (mantissa[oidx] != 0) {
                mantlen = 3 * (21 - dstart) + 2;
                mantissa[oidx + 1] = (byte)(digit[dstart] % 100L);
                oidx += 2;
            } else {
                mantissa[oidx] = (byte)digit[dstart];
                mantlen = 3 * (21 - dstart) + 1;
                ++oidx;
            }
        }
        for (digidx = (int)((byte)(dstart + 1)); digidx <= 21; digidx = (int)((byte)(digidx + 1))) {
            mantissa[oidx] = (byte)(digit[digidx] / 10000L);
            mantissa[oidx + 1] = (byte)(digit[digidx] % 10000L / 100L);
            mantissa[oidx + 2] = (byte)(digit[digidx] % 100L);
            oidx += 3;
        }
        for (i = oidx - 1; i >= 0 && mantissa[i] == 0; --i) {
            --mantlen;
        }
        if (mantlen > 19) {
            i = 20;
            mantlen = 19;
            if (mantissa[i] >= 50) {
                int n = --i;
                mantissa[n] = (byte)(mantissa[n] + 1);
                while (mantissa[i] == 100) {
                    if (i == 0) {
                        ++exponent;
                        mantissa[i] = 1;
                        break;
                    }
                    mantissa[i] = 0;
                    int n2 = --i;
                    mantissa[n2] = (byte)(mantissa[n2] + 1);
                }
                for (i = mantlen - 1; i >= 0 && mantissa[i] == 0; --i) {
                    --mantlen;
                }
            }
        }
        if (exponent > 62) {
            throw new IllegalArgumentException();
        }
        byte[] oranum = new byte[mantlen + 1];
        oranum[0] = (byte)exponent;
        System.arraycopy(mantissa, 0, oranum, 1, mantlen);
        return OsonPrimitiveConversions._toLnxFmt(oranum, positive);
    }

    static byte[] _makeZero() {
        byte[] num = new byte[]{-128};
        return num;
    }

    static byte[] _toLnxFmt(byte[] num, boolean pos) {
        byte[] tmp;
        int numl = num.length;
        if (pos) {
            tmp = new byte[numl];
            tmp[0] = (byte)(num[0] + 128 + 64 + 1);
            for (int i = 1; i < numl; ++i) {
                tmp[i] = (byte)(num[i] + 1);
            }
        } else {
            int i;
            tmp = numl - 1 < 20 ? new byte[numl + 1] : new byte[numl];
            tmp[0] = (byte)(~(num[0] + 128 + 64 + 1));
            for (i = 1; i < numl; ++i) {
                tmp[i] = (byte)(101 - num[i]);
            }
            if (i <= 20) {
                tmp[i] = 102;
            }
        }
        return tmp;
    }

    static byte[] toNumber(int value) {
        return OsonPrimitiveConversions.lnxmin(value);
    }

    public static byte[] toNumber(long value) {
        return OsonPrimitiveConversions.lnxmin(value);
    }

    public static byte[] lnxmin(long longNum) {
        if (longNum <= Integer.MAX_VALUE && longNum >= Integer.MIN_VALUE) {
            return OsonPrimitiveConversions.lnxmin32((int)longNum);
        }
        return OsonPrimitiveConversions.lnxmin64(longNum);
    }

    private static byte[] lnxmin32(int val) {
        byte[] b;
        if (val == 0) {
            b = new byte[]{-128};
        } else if (val < 0) {
            if (val == Integer.MIN_VALUE) {
                b = new byte[7];
                OsonPrimitiveConversions.encodeIntMinValue(b, 0);
            } else if (-val < 100) {
                b = new byte[]{62, (byte)(101 + val), 102};
            } else if (-val < 10000) {
                int x = -val % 100;
                if (x != 0) {
                    b = new byte[4];
                    b[2] = (byte)(101 - x);
                    b[3] = 102;
                } else {
                    b = new byte[3];
                    b[2] = 102;
                }
                b[0] = 61;
                b[1] = (byte)(101 - -val / 100);
            } else if (-val < 1000000) {
                int x = -val % 100;
                if (x != 0) {
                    b = new byte[5];
                    b[2] = (byte)(101 - -val % 10000 / 100);
                    b[3] = (byte)(101 - x);
                    b[4] = 102;
                } else {
                    x = -val % 10000 / 100;
                    if (x != 0) {
                        b = new byte[4];
                        b[2] = (byte)(101 - x);
                        b[3] = 102;
                    } else {
                        b = new byte[3];
                        b[2] = 102;
                    }
                }
                b[0] = 60;
                b[1] = (byte)(101 - -val / 10000);
            } else if (-val < 100000000) {
                int x = -val % 100;
                if (x != 0) {
                    b = new byte[6];
                    b[2] = (byte)(101 - -val % 1000000 / 10000);
                    b[3] = (byte)(101 - -val % 10000 / 100);
                    b[4] = (byte)(101 - x);
                    b[5] = 102;
                } else {
                    x = -val % 10000 / 100;
                    if (x != 0) {
                        b = new byte[5];
                        b[2] = (byte)(101 - -val % 1000000 / 10000);
                        b[3] = (byte)(101 - x);
                        b[4] = 102;
                    } else {
                        x = -val % 1000000 / 10000;
                        if (x != 0) {
                            b = new byte[4];
                            b[2] = (byte)(101 - x);
                            b[3] = 102;
                        } else {
                            b = new byte[3];
                            b[2] = 102;
                        }
                    }
                }
                b[0] = 59;
                b[1] = (byte)(101 - -val / 1000000);
            } else {
                int x = -val % 100;
                if (x != 0) {
                    b = new byte[7];
                    b[2] = (byte)(101 - -val % 100000000 / 1000000);
                    b[3] = (byte)(101 - -val % 1000000 / 10000);
                    b[4] = (byte)(101 - -val % 10000 / 100);
                    b[5] = (byte)(101 - x);
                    b[6] = 102;
                } else {
                    x = -val % 10000 / 100;
                    if (x != 0) {
                        b = new byte[6];
                        b[2] = (byte)(101 - -val % 100000000 / 1000000);
                        b[3] = (byte)(101 - -val % 1000000 / 10000);
                        b[4] = (byte)(101 - x);
                        b[5] = 102;
                    } else {
                        x = -val % 1000000 / 10000;
                        if (x != 0) {
                            b = new byte[5];
                            b[2] = (byte)(101 - -val % 100000000 / 1000000);
                            b[3] = (byte)(101 - x);
                            b[4] = 102;
                        } else {
                            x = -val % 100000000 / 1000000;
                            if (x != 0) {
                                b = new byte[4];
                                b[2] = (byte)(101 - x);
                                b[3] = 102;
                            } else {
                                b = new byte[3];
                                b[2] = 102;
                            }
                        }
                    }
                }
                b[0] = 58;
                b[1] = (byte)(101 - -val / 100000000);
            }
        } else if (val < 100) {
            b = new byte[]{-63, (byte)(val + 1)};
        } else if (val < 10000) {
            int x = val % 100;
            if (x != 0) {
                b = new byte[3];
                b[2] = (byte)(x + 1);
            } else {
                b = new byte[]{-62, (byte)(val / 100 + 1)};
            }
        } else if (val < 1000000) {
            int x = val % 100;
            if (x != 0) {
                b = new byte[4];
                b[2] = (byte)(val % 10000 / 100 + 1);
                b[3] = (byte)(x + 1);
            } else {
                x = val % 10000 / 100;
                if (x != 0) {
                    b = new byte[3];
                    b[2] = (byte)(x + 1);
                } else {
                    b = new byte[]{-61, (byte)(val / 10000 + 1)};
                }
            }
        } else if (val < 100000000) {
            int x = val % 100;
            if (x != 0) {
                b = new byte[5];
                b[2] = (byte)(val % 1000000 / 10000 + 1);
                b[3] = (byte)(val % 10000 / 100 + 1);
                b[4] = (byte)(x + 1);
            } else {
                x = val % 10000 / 100;
                if (x != 0) {
                    b = new byte[4];
                    b[2] = (byte)(val % 1000000 / 10000 + 1);
                    b[3] = (byte)(x + 1);
                } else {
                    x = val % 1000000 / 10000;
                    if (x != 0) {
                        b = new byte[3];
                        b[2] = (byte)(x + 1);
                    } else {
                        b = new byte[]{-60, (byte)(val / 1000000 + 1)};
                    }
                }
            }
        } else {
            int x = val % 100;
            if (x != 0) {
                b = new byte[6];
                b[2] = (byte)(val % 100000000 / 1000000 + 1);
                b[3] = (byte)(val % 1000000 / 10000 + 1);
                b[4] = (byte)(val % 10000 / 100 + 1);
                b[5] = (byte)(x + 1);
            } else {
                x = val % 10000 / 100;
                if (x != 0) {
                    b = new byte[5];
                    b[2] = (byte)(val % 100000000 / 1000000 + 1);
                    b[3] = (byte)(val % 1000000 / 10000 + 1);
                    b[4] = (byte)(x + 1);
                } else {
                    x = val % 1000000 / 10000;
                    if (x != 0) {
                        b = new byte[4];
                        b[2] = (byte)(val % 100000000 / 1000000 + 1);
                        b[3] = (byte)(x + 1);
                    } else {
                        x = val % 100000000 / 1000000;
                        if (x != 0) {
                            b = new byte[3];
                            b[2] = (byte)(x + 1);
                        } else {
                            b = new byte[]{-59, (byte)(val / 100000000 + 1)};
                        }
                    }
                }
            }
        }
        return b;
    }

    private static void encodeIntMinValue(byte[] b, int offset) {
        b[offset] = 58;
        b[offset + 1] = 80;
        b[offset + 2] = 54;
        b[offset + 3] = 53;
        b[offset + 4] = 65;
        b[offset + 5] = 53;
        b[offset + 6] = 102;
    }

    private static byte[] lnxmin64(long val) {
        int exponent;
        boolean sign = val >= 0L;
        if (sign) {
            val = -val;
        }
        int digits = exponent = OsonPrimitiveConversions.log100(val);
        long qL = val / 100L;
        long leastDigit = qL * 100L - val;
        if (0L == leastDigit) {
            do {
                --digits;
            } while (0L == (leastDigit = (qL = (val = qL) / 100L) * 100L - val));
            if (digits == 0) {
                if (sign) {
                    byte[] dst = new byte[2];
                    OsonPrimitiveConversions.lnxminEncodeP1((int)leastDigit, exponent, dst, 0);
                    return dst;
                }
                byte[] dst = new byte[3];
                OsonPrimitiveConversions.lnxminEncodeN1((int)leastDigit, exponent, dst, 0);
                return dst;
            }
        }
        if (sign) {
            byte[] dst = new byte[digits + 2];
            OsonPrimitiveConversions.lnxminEncodeP(qL, exponent, digits, (int)leastDigit, dst, 0);
            return dst;
        }
        byte[] dst = new byte[digits + 3];
        OsonPrimitiveConversions.lnxminEncodeN(qL, exponent, digits, (int)leastDigit, dst, 0);
        return dst;
    }

    private static int log100(long longNum) {
        return longNum > -10000000000L ? 4 : (longNum > -1000000000000L ? 5 : (longNum > -100000000000000L ? 6 : (longNum > -10000000000000000L ? 7 : (longNum > -1000000000000000000L ? 8 : 9))));
    }

    private static void lnxminEncodeP1(int digit, int exponent, byte[] dst, int offset) {
        dst[offset] = (byte)(193 + exponent);
        dst[offset + 1] = (byte)(1 + digit);
    }

    private static void lnxminEncodeN1(int digit, int exponent, byte[] dst, int offset) {
        dst[offset] = (byte)(62 - exponent);
        dst[offset + 1] = (byte)(101 - digit);
        dst[offset + 2] = 102;
    }

    private static void lnxminEncodeP(long val, int exponent, int digits, int leastDigit, byte[] dst, int offset) {
        dst[offset] = (byte)(193 + exponent);
        int pos = offset + digits + 1;
        dst[pos--] = (byte)(1 + leastDigit);
        while (digits-- > 4) {
            long qL = val / 100L;
            dst[pos--] = (byte)(1L + qL * 100L - val);
            val = qL;
        }
        int val32 = (int)val;
        while (val32 <= -100) {
            int qI = val32 / 100;
            dst[pos--] = (byte)(1 + qI * 100 - val32);
            val32 = qI;
        }
        dst[pos] = (byte)(1 - val32);
    }

    private static void lnxminEncodeN(long val, int exponent, int digits, int leastDigit, byte[] dst, int offset) {
        dst[offset] = (byte)(64 - (2 + exponent));
        int pos = offset + digits + 2;
        dst[pos--] = 102;
        dst[pos--] = (byte)(101 - leastDigit);
        while (digits-- > 4) {
            long qL = val / 100L;
            dst[pos--] = (byte)(101L - (qL * 100L - val));
            val = qL;
        }
        int val32 = (int)val;
        while (val32 <= -100) {
            int qI = val32 / 100;
            dst[pos--] = (byte)(101 - (qI * 100 - val32));
            val32 = qI;
        }
        dst[pos] = (byte)(101 + val32);
    }

    public static BigDecimal toBigDecimalLong(byte[] num) {
        int baseTenScale;
        int mantlen = OsonPrimitiveConversions.getOraNumLength(num) - 1;
        if (mantlen > 9) {
            return null;
        }
        int scale = OsonPrimitiveConversions.getScale(num) - mantlen + 1;
        if (mantlen + scale > 9) {
            return null;
        }
        long mantissa = 0L;
        try {
            long n = 1L;
            for (int i = mantlen; i > 0; --i) {
                mantissa += Math.multiplyExact(OsonPrimitiveConversions.unpackBase100(num, i), n);
                n *= 100L;
            }
        }
        catch (ArithmeticException e) {
            return null;
        }
        for (baseTenScale = scale * 2; baseTenScale > 0; --baseTenScale) {
            try {
                mantissa = Math.multiplyExact(mantissa, 10);
                continue;
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        while (baseTenScale < 0 && mantissa % 10L == 0L) {
            mantissa /= 10L;
            ++baseTenScale;
        }
        if (!OsonPrimitiveConversions._isPositive(num)) {
            mantissa = -mantissa;
        }
        return BigDecimal.valueOf(mantissa, -baseTenScale);
    }

    public static BigDecimal toBigDecimal(byte[] num) {
        if (OsonPrimitiveConversions._isZero(num)) {
            return BigDecimal.valueOf(0L);
        }
        if (OsonPrimitiveConversions._isInf(num)) {
            throw new IllegalArgumentException();
        }
        BigDecimal result = OsonPrimitiveConversions.toBigDecimalLong(num);
        return result == null ? OsonPrimitiveConversions.toBigDecimalFull(num) : result;
    }

    public static BigDecimal toBigDecimalFull(byte[] num) {
        int mantlen;
        long[] digit = new long[10];
        int digidx = 9;
        int oidx = 1;
        int arycnt = 0;
        boolean positive = OsonPrimitiveConversions._isPositive(num);
        byte[] temp = OsonPrimitiveConversions._fromLnxFmt(num);
        int clen = mantlen = temp.length - 1;
        if ((mantlen & 1) == 1) {
            digit[digidx] = temp[oidx];
            oidx = (byte)(oidx + 1);
            --clen;
        } else {
            digit[digidx] = temp[oidx] * 100 + temp[oidx + 1];
            oidx = (byte)(oidx + 2);
            clen -= 2;
        }
        int cnt = digidx;
        while (clen != 0) {
            long value = temp[oidx] * 100 + temp[oidx + 1];
            for (digidx = 9; digidx >= cnt; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] * 10000L) & 0xFFFFL;
                value >>= 16;
            }
            if (value != 0L) {
                // empty if block
            }
            cnt = (byte)(cnt - 1);
            digit[cnt] = value;
            oidx = (byte)(oidx + 2);
            clen -= 2;
        }
        int numbytes = digit[cnt] >> 8 != 0L ? 2 * (9 - cnt) + 2 : 2 * (9 - cnt) + 1;
        byte[] barray = new byte[numbytes];
        if ((numbytes & 1) == 1) {
            barray[arycnt] = (byte)digit[cnt];
            ++arycnt;
        } else {
            barray[arycnt] = (byte)(digit[cnt] >> 8);
            barray[++arycnt] = (byte)(digit[cnt] & 0xFFL);
            ++arycnt;
        }
        for (cnt = (int)((byte)(cnt + 1)); cnt <= 9; cnt = (int)((byte)(cnt + 1))) {
            barray[arycnt] = (byte)(digit[cnt] >> 8);
            barray[arycnt + 1] = (byte)(digit[cnt] & 0xFFL);
            arycnt += 2;
        }
        BigInteger bigtemp = new BigInteger(positive ? 1 : -1, barray);
        BigDecimal result = new BigDecimal(bigtemp);
        int scale = temp[0] - mantlen + 1;
        result = result.movePointRight(scale * 2);
        if (scale < 0 && temp[mantlen] % 10 == 0) {
            result = result.setScale(-(scale * 2 + 1));
        }
        return result;
    }

    private static boolean _isZero(byte[] num) {
        return num[0] == -128 && num.length == 1;
    }

    private static boolean _isInf(byte[] num) {
        return num.length == 2 && num[0] == -1 && num[1] == 101 || num[0] == 0 && num.length == 1;
    }

    private static boolean _isPositive(byte[] num) {
        return (num[0] & 0xFFFFFF80) != 0;
    }

    private static int getOraNumLength(byte[] num) {
        int n = num.length - 1;
        return OsonPrimitiveConversions._isPositive(num) || n == 20 && num[n] != 102 ? num.length : num.length - 1;
    }

    private static int getScale(byte[] num) {
        if (OsonPrimitiveConversions._isPositive(num)) {
            return (byte)((num[0] & 0xFFFFFF7F) - 65);
        }
        return (byte)((~num[0] & 0xFFFFFF7F) - 65);
    }

    private static long unpackBase100(byte[] num, int i) {
        return OsonPrimitiveConversions._isPositive(num) ? (long)(num[i] - 1) : (long)((byte)(101 - num[i]));
    }

    private static byte[] _fromLnxFmt(byte[] num) {
        byte[] tmp;
        int numl = num.length;
        if (OsonPrimitiveConversions._isPositive(num)) {
            tmp = new byte[numl];
            tmp[0] = (byte)((num[0] & 0xFFFFFF7F) - 65);
            for (int i = 1; i < numl; ++i) {
                tmp[i] = (byte)(num[i] - 1);
            }
        } else {
            tmp = numl - 1 == 20 && num[numl - 1] != 102 ? new byte[numl] : new byte[numl - 1];
            tmp[0] = (byte)((~num[0] & 0xFFFFFF7F) - 65);
            for (int i = 1; i < tmp.length; ++i) {
                tmp[i] = (byte)(101 - num[i]);
            }
        }
        return tmp;
    }
}

