/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.diagnostics;

import java.security.AccessController;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.logging.Level;
import oracle.rsi.diagnostics.Diagnosable;
import oracle.rsi.diagnostics.Diagnostic;

public class RSIDiagnosable
implements Diagnosable {
    public static final Predicate<String> IS_VALID_BUFFER_SIZE = string -> {
        Integer n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n > 0 && n <= Integer.MAX_VALUE;
    };
    private static final Predicate<String> IS_VALID_BOOLEAN_STRING = string -> "true".equalsIgnoreCase((String)string) || "false".equalsIgnoreCase((String)string);
    private static final Predicate<String> IS_VALID_LOGGER_NAME = string -> string != null && !string.isEmpty();
    private Diagnostic diagnostic;
    private static final RSIDiagnosable RSI_DIAGNOSABLE_INSTANCE = new RSIDiagnosable();
    private final String diagnosticLoggerName = RSIDiagnosable.getSystemProperty("oracle.rsi.diagnostic.loggerName", "oracle.rsi", IS_VALID_LOGGER_NAME);
    private final int diagnosticBufferSize = Integer.parseInt(RSIDiagnosable.getSystemProperty("oracle.rsi.diagnostic.bufferSize", "4000", IS_VALID_BUFFER_SIZE));
    private final AtomicBoolean isTraceEnabled = new AtomicBoolean(Boolean.parseBoolean(RSIDiagnosable.getSystemProperty("oracle.rsi.diagnostic.enableTrace", "true", IS_VALID_BOOLEAN_STRING)));
    private final AtomicBoolean isDebugEnabled = new AtomicBoolean(Boolean.parseBoolean(RSIDiagnosable.getSystemProperty("oracle.rsi.diagnostic.enableLogging", "false", IS_VALID_BOOLEAN_STRING)));

    private RSIDiagnosable() {
        this.init();
    }

    private void init() {
        this.diagnostic = Diagnostic.get(this.diagnosticLoggerName, this.diagnosticBufferSize);
    }

    public static Diagnosable getInstance() {
        return RSI_DIAGNOSABLE_INSTANCE;
    }

    private static String getSystemProperty(String string, String string2, Predicate predicate) {
        if (string == null) {
            return string2;
        }
        String string3 = AccessController.doPrivileged(() -> System.getProperty(string, string2));
        return predicate.test(string3) ? string3 : string2;
    }

    @Override
    public <T extends Throwable> T debug(Level level, String string, String string2, String string3, T t, Object ... objectArray) {
        if (this.isDebugEnabled.get()) {
            return this.diagnostic.debug(level, string, string2, string3, t, objectArray);
        }
        return t;
    }

    @Override
    public <T extends Throwable> T trace(Level level, String string, String string2, String string3, T t, Object ... objectArray) {
        if (this.isDebugEnabled.get()) {
            return this.diagnostic.debug(level, string, string2, string3, t, objectArray);
        }
        if (this.isTraceEnabled.get()) {
            return this.diagnostic.trace(level, string, string2, string3, t, objectArray);
        }
        return t;
    }
}

