import java.util.Date;

public class Request {
	
	private String host;
	private int    port;
	private boolean ssl;
	private String method;
	private String path;
	private String header;
	private String query;
	private String body;
	private String responsecode;
	private String responseheader;
	private String responsebody;
	private Date timestamp;
	

	private String getHeaders(byte[] message) {
		String   tmpString = new String(message);
		String[] headerArray = tmpString.split("\n");
		StringBuilder headers = new StringBuilder();
		for (int i=1; i< headerArray.length; i++) {
			if (headerArray[i].length() == 1) break;
			headers.append(headerArray[i]);
			headers.append("\n");
		}
		
		return headers.toString();
	}
	
	private String getBodyContent(byte[] message) {
		String   tmpString = new String(message);
		String[] bodyArray = tmpString.split("\n");
		StringBuilder body = new StringBuilder();
		int responsestart = 0;
		
		for (int i=1; i< bodyArray.length; i++) {
			responsestart = i;
			if (bodyArray[i].length() == 1) break;
			
		}
		
		for (int i=responsestart+1; i < bodyArray.length; i++) {
			body.append(bodyArray[i]);
			body.append("\n");
		}
		
		return body.toString();
	}
	
	public Request() {
		host = "";
		port = 80;
		ssl = false;
		method = "";
		path = "";
		header = "";
		query = "";
		body = "";
		responsecode = "";
		responseheader = "";
		responsebody = "";
	}
	
	public String getHost() { return host;}
	public void setHost(String param) { host = param;}
	
	public int getPort() { return port; }
	public void setPort(int param) { port = param; }
	
	public boolean getSSL() { return ssl;}
	public void setSSL(boolean param) {ssl = param; }
	
	public String getMethod() { return method;}
	public void setMethod(String param) { method = param;}
	
	public String getPath() { return path;}
	public void setPath(String param) { path = param;}
	
	public String getQuery() { return query;}
	public void setQuery(String param) { query = param;}
	
	public String getBody() { return body;}
	public void setBody(byte[] param) { body = this.getBodyContent(param);}
	
	public String getHeader() { return header;}
	public void setHeader(byte[] param) { header = this.getHeaders(param);}
	
	public String getResponseCode() { return responsecode;}
	public void setResponseCode(String param) { responsecode = param;}
	
	public String getResponseHeader() { return responseheader;}
	public void setResponseHeader(byte[] param) { responseheader = this.getHeaders(param);}
	
	public String getResponseBody() { return responsebody;}
	public void setResponseBody(byte[] param) { responsebody = this.getBodyContent(param);}
	
	public Date getTimestamp() { return timestamp;}
	public void setTimestamp(Date param) { timestamp = param;}
}
