/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.bandwidth;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import mediathek.gui.actions.ShowBandwidthUsageAction;
import mediathek.gui.bandwidth.WriteConfigComponentListener;
import mediathek.gui.messages.DarkModeChangeEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import mediathek.tool.http.ByteCounter;
import mediathek.tool.http.MVHttpClient;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class BandwidthDialog
extends JDialog {
    protected static final String CONFIG_X = "bandwidth_monitor.x";
    protected static final String CONFIG_Y = "bandwidth_monitor.y";
    protected static final String CONFIG_HEIGHT = "bandwidth_monitor.height";
    protected static final String CONFIG_WIDTH = "bandwidth_monitor.width";
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 150;
    private final TimeSeries total = new TimeSeries((Comparable)((Object)"Bandwidth"));
    private final DateAxis dateAxis = new DateAxis();
    private final NumberAxis bandwidthAxis = new NumberAxis();
    private final BandwidthUsageDataGenerator dataGenerator = new BandwidthUsageDataGenerator(1, TimeUnit.SECONDS);
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private JLabel lblBandwidth;
    private ChartPanel chartPanel1;

    public BandwidthDialog(@NotNull Window owner, final @NotNull ShowBandwidthUsageAction menuAction) {
        super(owner);
        this.initComponents();
        this.setupChart();
        this.restoreSizeFromConfig();
        this.addComponentListener(new WriteConfigComponentListener(this.config, this));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ BandwidthDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowOpened(WindowEvent e) {
                this.this$0.storeVisibilityState(true);
                menuAction.setDialogOptional(Optional.of(this.this$0));
                menuAction.setEnabled(false);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.this$0.storeVisibilityState(false);
                menuAction.setDialogOptional(Optional.empty());
                menuAction.setEnabled(true);
            }
        });
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    @Handler
    private void handleDarkModeChange(DarkModeChangeEvent e) {
        SwingUtilities.invokeLater(this::setLabelColors);
    }

    private void calculateHudPosition() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode dm = gd.getDisplayMode();
        this.setLocation(dm.getWidth() - 300, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSizeFromConfig() {
        try {
            this.config.lock(LockMode.READ);
            int x = this.config.getInt(CONFIG_X);
            int y = this.config.getInt(CONFIG_Y);
            int width = this.config.getInt(CONFIG_WIDTH);
            int height = this.config.getInt(CONFIG_HEIGHT);
            this.setSize(width, height);
            this.setLocation(x, y);
        }
        catch (Exception ex) {
            this.setSize(300, 150);
            this.calculateHudPosition();
        }
        finally {
            this.config.unlock(LockMode.READ);
        }
    }

    private void setLabelColors() {
        Color color = UIManager.getColor("Label.foreground");
        this.dateAxis.setLabelPaint((Paint)color);
        this.dateAxis.setTickLabelPaint((Paint)color);
        this.dateAxis.setTickMarkPaint((Paint)color);
        this.dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(""));
        this.bandwidthAxis.setLabelPaint((Paint)color);
        this.bandwidthAxis.setTickLabelPaint((Paint)color);
        this.bandwidthAxis.setTickMarkPaint((Paint)color);
    }

    private void setupChart() {
        this.total.setMaximumItemAge(TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS));
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(this.total);
        this.bandwidthAxis.setAutoRange(true);
        this.setLabelColors();
        XYSplineRenderer renderer = new XYSplineRenderer();
        renderer.setDefaultShapesVisible(false);
        renderer.setSeriesPaint(0, (Paint)Color.red);
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)this.dateAxis, (ValueAxis)this.bandwidthAxis, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.BLACK);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinesVisible(false);
        this.dateAxis.setAutoRange(true);
        this.dateAxis.setLowerMargin(0.0);
        this.dateAxis.setUpperMargin(0.0);
        this.dateAxis.setTickLabelsVisible(false);
        this.dateAxis.setTickMarksVisible(false);
        this.dateAxis.setAxisLineVisible(false);
        this.bandwidthAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.bandwidthAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat("#######.##"));
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.removeLegend();
        this.chartPanel1.setPopupMenu(null);
        this.chartPanel1.setChart(chart);
        MVHttpClient.getInstance().getByteCounter().resetCounters();
        this.dataGenerator.start();
    }

    @Override
    public void dispose() {
        this.dataGenerator.stop();
        super.dispose();
    }

    public void storeVisibilityState(boolean newVar) {
        this.config.setProperty("application.ui.bandwidth_monitor.visible", (Object)newVar);
    }

    private void initComponents() {
        this.lblBandwidth = new JLabel();
        JLabel label1 = new JLabel();
        JPanel chartContainer = new JPanel();
        this.chartPanel1 = new ChartPanel(null);
        this.setTitle("Bandbreite");
        this.setDefaultCloseOperation(2);
        this.setType(Window.Type.UTILITY);
        this.setPreferredSize(new Dimension(400, 200));
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout(new LC().fill().insets("5").hideMode(3), new AC().grow().fill().gap().align("right"), new AC().align("center").gap().grow().fill()));
        this.lblBandwidth.setText("0");
        this.lblBandwidth.setHorizontalAlignment(11);
        this.lblBandwidth.setVerticalAlignment(3);
        this.lblBandwidth.setFont(this.lblBandwidth.getFont().deriveFont(this.lblBandwidth.getFont().getStyle() | 1, (float)this.lblBandwidth.getFont().getSize() + 19.0f));
        contentPane.add((Component)this.lblBandwidth, new CC().cell(new int[]{0, 0}).alignY("bottom").growY(0.0f));
        label1.setText("MBit/s");
        label1.setFont(label1.getFont().deriveFont((float)label1.getFont().getSize() + 2.0f));
        contentPane.add((Component)label1, new CC().cell(new int[]{1, 0}).alignY("bottom").growY(0.0f));
        chartContainer.setMinimumSize(new Dimension(240, 120));
        chartContainer.setLayout(new BorderLayout());
        chartContainer.add((Component)this.chartPanel1, "Center");
        contentPane.add((Component)chartContainer, new CC().cell(new int[]{0, 1, 2, 1}));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public class BandwidthUsageDataGenerator
    extends Timer
    implements ActionListener {
        public BandwidthUsageDataGenerator(@NotNull int interval, TimeUnit timeUnit) {
            super((int)TimeUnit.MILLISECONDS.convert(interval, timeUnit), null);
            BandwidthDialog.this.setName("BandwidthUsageGenerator");
            this.addActionListener(this);
        }

        private double calculateBandwidthUsage() {
            ByteCounter byteCounter = MVHttpClient.getInstance().getByteCounter();
            double bandwidth = byteCounter.bytesRead();
            byteCounter.resetCounters();
            bandwidth = bandwidth * 8.0 / 1048576.0;
            if (bandwidth < 0.0) {
                bandwidth = 0.0;
            }
            return bandwidth;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            double usage = this.calculateBandwidthUsage();
            BandwidthDialog.this.total.add((RegularTimePeriod)new Millisecond(), usage);
            BandwidthDialog.this.lblBandwidth.setText(Long.toString(Math.round(usage)));
        }
    }
}

