/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.SignatureBuilder;
import io.quarkus.gizmo.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class MethodSignatureBuilderImpl
implements SignatureBuilder.MethodSignatureBuilder {
    private List<Type.TypeVariable> typeParameters = new ArrayList<Type.TypeVariable>();
    private Type returnType = Type.VoidType.INSTANCE;
    private List<Type> parameterTypes = new ArrayList<Type>();
    private List<Type> exceptions = new ArrayList<Type>();

    MethodSignatureBuilderImpl() {
    }

    @Override
    public String build() {
        StringBuilder signature = new StringBuilder();
        if (!this.typeParameters.isEmpty()) {
            signature.append('<');
            for (Type.TypeVariable typeParameter : this.typeParameters) {
                typeParameter.appendTypeParameterToSignature(signature);
            }
            signature.append('>');
        }
        signature.append('(');
        for (Type parameterType : this.parameterTypes) {
            parameterType.appendToSignature(signature);
        }
        signature.append(')');
        this.returnType.appendToSignature(signature);
        if (!this.exceptions.isEmpty()) {
            for (Type exceptionType : this.exceptions) {
                signature.append('^');
                exceptionType.appendToSignature(signature);
            }
        }
        return signature.toString();
    }

    @Override
    public SignatureBuilder.MethodSignatureBuilder addTypeParameter(Type.TypeVariable typeParameter) {
        this.typeParameters.add(Objects.requireNonNull(typeParameter));
        return this;
    }

    @Override
    public SignatureBuilder.MethodSignatureBuilder setReturnType(Type returnType) {
        this.returnType = Objects.requireNonNull(returnType);
        return this;
    }

    @Override
    public SignatureBuilder.MethodSignatureBuilder addParameterType(Type parameterType) {
        this.parameterTypes.add(Objects.requireNonNull(parameterType));
        return this;
    }

    @Override
    public SignatureBuilder.MethodSignatureBuilder addException(Type.ClassType exceptionType) {
        this.exceptions.add(Objects.requireNonNull(exceptionType));
        return this;
    }

    @Override
    public SignatureBuilder.MethodSignatureBuilder addException(Type.TypeVariable exceptionType) {
        this.exceptions.add(Objects.requireNonNull(exceptionType));
        return this;
    }
}

