/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.util.ClassPathUtils;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappings;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class ConfigDescriptionBuildStep {
    @BuildStep
    List<ConfigDescriptionBuildItem> createConfigDescriptions(ConfigurationBuildItem config) throws Exception {
        Properties javadoc = new Properties();
        ClassPathUtils.consumeAsStreams((String)"META-INF/quarkus-javadoc.properties", in -> {
            try {
                javadoc.load((InputStream)in);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        ArrayList<ConfigDescriptionBuildItem> ret = new ArrayList<ConfigDescriptionBuildItem>();
        this.processMappings(config.getReadResult().getBuildTimeMappings(), ret, javadoc, ConfigPhase.BUILD_TIME);
        this.processMappings(config.getReadResult().getBuildTimeRunTimeMappings(), ret, javadoc, ConfigPhase.BUILD_AND_RUN_TIME_FIXED);
        this.processMappings(config.getReadResult().getRunTimeMappings(), ret, javadoc, ConfigPhase.RUN_TIME);
        return ret;
    }

    private void processMappings(List<ConfigMappings.ConfigClass> mappings, List<ConfigDescriptionBuildItem> descriptionBuildItems, Properties javaDocProperties, ConfigPhase configPhase) {
        for (ConfigMappings.ConfigClass mapping : mappings) {
            Map properties = ConfigMappings.getProperties((ConfigMappings.ConfigClass)mapping);
            for (Map.Entry entry : properties.entrySet()) {
                ConfigMappingInterface.LeafProperty leafProperty;
                String propertyName = (String)entry.getKey();
                ConfigMappingInterface.Property property = (ConfigMappingInterface.Property)entry.getValue();
                Method method = property.getMethod();
                String defaultValue = null;
                if (property instanceof ConfigMappingInterface.PrimitiveProperty) {
                    ConfigMappingInterface.PrimitiveProperty primitiveProperty = (ConfigMappingInterface.PrimitiveProperty)property;
                    if (primitiveProperty.hasDefaultValue()) {
                        defaultValue = primitiveProperty.getDefaultValue();
                    } else if (primitiveProperty.getPrimitiveType() == Boolean.TYPE) {
                        defaultValue = "false";
                    } else if (primitiveProperty.getPrimitiveType() != Character.TYPE) {
                        defaultValue = "0";
                    }
                } else if (property instanceof ConfigMappingInterface.LeafProperty && (leafProperty = (ConfigMappingInterface.LeafProperty)property).hasDefaultValue()) {
                    defaultValue = leafProperty.getDefaultValue();
                }
                String javadocKey = method.getDeclaringClass().getName().replace('$', '.') + "." + method.getName();
                EffectiveConfigTypeAndValues typeName = this.getTypeName(method.getReturnType(), method.getGenericReturnType());
                descriptionBuildItems.add(new ConfigDescriptionBuildItem(propertyName, defaultValue, javaDocProperties.getProperty(javadocKey), typeName.typeName(), typeName.allowedValues(), configPhase));
            }
        }
    }

    private EffectiveConfigTypeAndValues getTypeName(Class<?> valueClass, Type genericType) {
        String name;
        ArrayList<String> allowedValues = new ArrayList<String>();
        if (valueClass.equals(Optional.class) || valueClass.equals(List.class) || valueClass.equals(Set.class)) {
            String thisName = valueClass.getName();
            if (genericType != null) {
                thisName = genericType.getTypeName();
            }
            if (thisName.contains("<") && thisName.contains(">")) {
                thisName = thisName.substring(thisName.lastIndexOf("<") + 1, thisName.indexOf(">"));
            }
            try {
                Class<?> c = Class.forName(thisName);
                return this.getTypeName(c, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                name = thisName;
            }
        } else if (Enum.class.isAssignableFrom(valueClass)) {
            ?[] values;
            name = Enum.class.getName();
            for (Object v : values = valueClass.getEnumConstants()) {
                Enum casted = (Enum)valueClass.cast(v);
                allowedValues.add(casted.name());
            }
        } else {
            switch (valueClass.getName()) {
                case "java.util.OptionalInt": 
                case "int": {
                    String string = Integer.class.getName();
                    break;
                }
                case "boolean": {
                    String string = Boolean.class.getName();
                    break;
                }
                case "float": {
                    String string = Float.class.getName();
                    break;
                }
                case "java.util.OptionalDouble": 
                case "double": {
                    String string = Double.class.getName();
                    break;
                }
                case "java.util.OptionalLong": 
                case "long": {
                    String string = Long.class.getName();
                    break;
                }
                case "byte": {
                    String string = Byte.class.getName();
                    break;
                }
                case "short": {
                    String string = Short.class.getName();
                    break;
                }
                case "char": {
                    String string = Character.class.getName();
                    break;
                }
                default: {
                    String string = name = valueClass.getName();
                }
            }
        }
        if (valueClass.isAssignableFrom(Level.class)) {
            allowedValues.add(Level.ALL.getName());
            allowedValues.add(Level.CONFIG.getName());
            allowedValues.add(Level.FINE.getName());
            allowedValues.add(Level.FINER.getName());
            allowedValues.add(Level.FINEST.getName());
            allowedValues.add(Level.INFO.getName());
            allowedValues.add(Level.OFF.getName());
            allowedValues.add(Level.SEVERE.getName());
            allowedValues.add(Level.WARNING.getName());
        }
        return new EffectiveConfigTypeAndValues(name, allowedValues);
    }

    private record EffectiveConfigTypeAndValues(String typeName, List<String> allowedValues) {
    }
}

