/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mutiny;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.infinispan.api.Experimental;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.events.cache.CacheEntryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;
import org.infinispan.api.common.process.CacheEntryProcessorResult;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.mutiny.MutinyCacheEntryProcessor;
import org.infinispan.api.mutiny.MutinyContainer;
import org.infinispan.api.mutiny.MutinyQuery;
import org.infinispan.api.mutiny.MutinyStreamingCache;

@Experimental
public interface MutinyCache<K, V> {
    public String name();

    public Uni<CacheConfiguration> configuration();

    public MutinyContainer container();

    default public Uni<V> get(K key) {
        return this.get(key, CacheOptions.DEFAULT);
    }

    default public Uni<V> get(K key, CacheOptions options) {
        return this.getEntry(key, options).map(CacheEntry::value);
    }

    default public Uni<CacheEntry<K, V>> getEntry(K key) {
        return this.getEntry(key, CacheOptions.DEFAULT);
    }

    public Uni<CacheEntry<K, V>> getEntry(K var1, CacheOptions var2);

    default public Uni<CacheEntry<K, V>> putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, CacheWriteOptions.DEFAULT);
    }

    public Uni<CacheEntry<K, V>> putIfAbsent(K var1, V var2, CacheWriteOptions var3);

    default public Uni<Boolean> setIfAbsent(K key, V value) {
        return this.setIfAbsent(key, value, CacheWriteOptions.DEFAULT);
    }

    default public Uni<Boolean> setIfAbsent(K key, V value, CacheWriteOptions options) {
        return this.putIfAbsent(key, value, options).map(Objects::isNull);
    }

    default public Uni<CacheEntry<K, V>> put(K key, V value) {
        return this.put(key, value, CacheWriteOptions.DEFAULT);
    }

    public Uni<CacheEntry<K, V>> put(K var1, V var2, CacheWriteOptions var3);

    default public Uni<Void> set(K key, V value) {
        return this.set(key, value, CacheWriteOptions.DEFAULT);
    }

    default public Uni<Void> set(K key, V value, CacheWriteOptions options) {
        return this.put(key, value, options).map(__ -> null);
    }

    default public Uni<Boolean> remove(K key) {
        return this.remove(key, CacheOptions.DEFAULT);
    }

    default public Uni<Boolean> remove(K key, CacheOptions options) {
        return this.getAndRemove(key, options).map(Objects::nonNull);
    }

    default public Uni<CacheEntry<K, V>> getAndRemove(K key) {
        return this.getAndRemove(key, CacheOptions.DEFAULT);
    }

    public Uni<CacheEntry<K, V>> getAndRemove(K var1, CacheOptions var2);

    default public Multi<K> keys() {
        return this.keys(CacheOptions.DEFAULT);
    }

    default public Multi<K> keys(CacheOptions options) {
        return this.entries(options).map(CacheEntry::key);
    }

    default public Multi<CacheEntry<K, V>> entries() {
        return this.entries(CacheOptions.DEFAULT);
    }

    public Multi<CacheEntry<K, V>> entries(CacheOptions var1);

    default public Multi<CacheEntry<K, V>> getAll(Set<K> keys) {
        return this.getAll(keys, CacheOptions.DEFAULT);
    }

    public Multi<CacheEntry<K, V>> getAll(Set<K> var1, CacheOptions var2);

    default public Multi<CacheEntry<K, V>> getAll(K ... keys) {
        return this.getAll(CacheOptions.DEFAULT, keys);
    }

    public Multi<CacheEntry<K, V>> getAll(CacheOptions var1, K ... var2);

    default public Uni<Void> putAll(Multi<CacheEntry<K, V>> pairs) {
        return this.putAll(pairs, CacheWriteOptions.DEFAULT);
    }

    public Uni<Void> putAll(Multi<CacheEntry<K, V>> var1, CacheWriteOptions var2);

    public Uni<Void> putAll(Map<K, V> var1, CacheWriteOptions var2);

    default public Uni<Void> putAll(Map<K, V> map) {
        return this.putAll(map, CacheWriteOptions.DEFAULT);
    }

    default public Uni<Boolean> replace(K key, V value, CacheEntryVersion version) {
        return this.replace(key, value, version, CacheWriteOptions.DEFAULT);
    }

    default public Uni<Boolean> replace(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return this.getOrReplaceEntry(key, value, version, options).map(ce -> ce != null && version.equals(ce.metadata().version()));
    }

    default public Uni<CacheEntry<K, V>> getOrReplaceEntry(K key, V value, CacheEntryVersion version) {
        return this.getOrReplaceEntry(key, value, version, CacheWriteOptions.DEFAULT);
    }

    public Uni<CacheEntry<K, V>> getOrReplaceEntry(K var1, V var2, CacheEntryVersion var3, CacheWriteOptions var4);

    default public Multi<K> removeAll(Set<K> keys) {
        return this.removeAll(keys, CacheWriteOptions.DEFAULT);
    }

    public Multi<K> removeAll(Set<K> var1, CacheWriteOptions var2);

    default public Multi<K> removeAll(Multi<K> keys) {
        return this.removeAll(keys, CacheWriteOptions.DEFAULT);
    }

    public Multi<K> removeAll(Multi<K> var1, CacheWriteOptions var2);

    default public Multi<CacheEntry<K, V>> getAndRemoveAll(Multi<K> keys) {
        return this.getAndRemoveAll(keys, CacheWriteOptions.DEFAULT);
    }

    default public Multi<CacheEntry<K, V>> getAndRemoveAll(Multi<K> keys, CacheWriteOptions options) {
        return keys.onItem().transformToUni(this::getAndRemove).concatenate();
    }

    default public Uni<Long> estimateSize() {
        return this.estimateSize(CacheOptions.DEFAULT);
    }

    public Uni<Long> estimateSize(CacheOptions var1);

    default public Uni<Void> clear() {
        return this.clear(CacheOptions.DEFAULT);
    }

    public Uni<Void> clear(CacheOptions var1);

    default public <R> MutinyQuery<K, V, R> query(String query) {
        return this.query(query, CacheOptions.DEFAULT);
    }

    public <R> MutinyQuery<K, V, R> query(String var1, CacheOptions var2);

    default public Multi<CacheEntryEvent<K, V>> listen(CacheEntryEventType ... types) {
        return this.listen(new CacheListenerOptions(), types);
    }

    public Multi<CacheEntryEvent<K, V>> listen(CacheListenerOptions var1, CacheEntryEventType ... var2);

    default public <T> Multi<CacheEntryProcessorResult<K, T>> process(Set<K> keys, MutinyCacheEntryProcessor<K, V, T> processor) {
        return this.process(keys, processor, CacheOptions.DEFAULT);
    }

    public <T> Multi<CacheEntryProcessorResult<K, T>> process(Set<K> var1, MutinyCacheEntryProcessor<K, V, T> var2, CacheOptions var3);

    public MutinyStreamingCache<K> streaming();
}

