/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.WorkflowStepProvider;

public class NotifyUserStepProvider
implements WorkflowStepProvider {
    private static final String ACCOUNT_DISABLE_NOTIFICATION_SUBJECT = "accountDisableNotificationSubject";
    private static final String ACCOUNT_DELETE_NOTIFICATION_SUBJECT = "accountDeleteNotificationSubject";
    private static final String ACCOUNT_DISABLE_NOTIFICATION_BODY = "accountDisableNotificationBody";
    private static final String ACCOUNT_DELETE_NOTIFICATION_BODY = "accountDeleteNotificationBody";
    private final KeycloakSession session;
    private final ComponentModel stepModel;
    private final Logger log = Logger.getLogger(NotifyUserStepProvider.class);

    public NotifyUserStepProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.stepModel = model;
    }

    public void close() {
    }

    public void run(List<String> userIds) {
        RealmModel realm = this.session.getContext().getRealm();
        EmailTemplateProvider emailProvider = ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).setRealm(realm);
        String subjectKey = this.getSubjectKey();
        String bodyTemplate = this.getBodyTemplate();
        Map<String, Object> bodyAttributes = this.getBodyAttributes();
        for (String id : userIds) {
            UserModel user = this.session.users().getUserById(realm, id);
            if (user != null && user.getEmail() != null) {
                try {
                    emailProvider.setUser(user).send(subjectKey, bodyTemplate, bodyAttributes);
                    this.log.debugv("Notification email sent to user {0} ({1})", (Object)user.getUsername(), (Object)user.getEmail());
                }
                catch (EmailException e) {
                    this.log.errorv((Throwable)e, "Failed to send notification email to user {0} ({1})", (Object)user.getUsername(), (Object)user.getEmail());
                }
                continue;
            }
            if (user == null || user.getEmail() != null) continue;
            this.log.warnv("User {0} has no email address, skipping notification", (Object)user.getUsername());
        }
    }

    private String getSubjectKey() {
        String nextStepType = this.getNextStepType();
        String customSubjectKey = (String)this.stepModel.getConfig().getFirst((Object)"custom_subject_key");
        if (customSubjectKey != null && !customSubjectKey.trim().isEmpty()) {
            return customSubjectKey;
        }
        return this.getDefaultSubjectKey(nextStepType);
    }

    private String getBodyTemplate() {
        return "workflow-notification.ftl";
    }

    private Map<String, Object> getBodyAttributes() {
        RealmModel realm = this.session.getContext().getRealm();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        String nextStepType = this.getNextStepType();
        String customMessage = (String)this.stepModel.getConfig().getFirst((Object)"custom_message");
        if (customMessage != null && !customMessage.trim().isEmpty()) {
            attributes.put("messageKey", "customMessage");
            attributes.put("customMessage", customMessage);
        } else {
            attributes.put("messageKey", this.getDefaultMessageKey(nextStepType));
        }
        int daysRemaining = this.calculateDaysUntilNextStep();
        attributes.put("daysRemaining", daysRemaining);
        attributes.put("reason", this.stepModel.getConfig().getFirstOrDefault((Object)"reason", (Object)"inactivity"));
        attributes.put("realmName", realm.getDisplayName() != null ? realm.getDisplayName() : realm.getName());
        attributes.put("nextStepType", nextStepType);
        attributes.put("subjectKey", this.getSubjectKey());
        return attributes;
    }

    private String getNextStepType() {
        Map<ComponentModel, Long> nextStepMap = this.getNextNonNotificationStep();
        return nextStepMap.isEmpty() ? "unknown-step" : nextStepMap.keySet().iterator().next().getProviderId();
    }

    private int calculateDaysUntilNextStep() {
        Map<ComponentModel, Long> nextStepMap = this.getNextNonNotificationStep();
        if (nextStepMap.isEmpty()) {
            return 0;
        }
        Long timeToNextStep = nextStepMap.values().iterator().next();
        return Math.toIntExact(Duration.ofMillis(timeToNextStep).toDays());
    }

    private Map<ComponentModel, Long> getNextNonNotificationStep() {
        long timeToNextNonNotificationStep = 0L;
        RealmModel realm = this.session.getContext().getRealm();
        ComponentModel workflowModel = realm.getComponent(this.stepModel.getParentId());
        List steps = realm.getComponentsStream(workflowModel.getId(), WorkflowStepProvider.class.getName()).sorted((a, b) -> {
            int priorityA = Integer.parseInt(a.get("priority", "0"));
            int priorityB = Integer.parseInt(b.get("priority", "0"));
            return Integer.compare(priorityA, priorityB);
        }).toList();
        boolean foundCurrent = false;
        for (ComponentModel step : steps) {
            if (foundCurrent) {
                timeToNextNonNotificationStep += step.get("after", 0L);
                if (!step.getProviderId().equals("notify-user")) {
                    return Map.of(step, timeToNextNonNotificationStep);
                }
            }
            if (!step.getId().equals(this.stepModel.getId())) continue;
            foundCurrent = true;
        }
        return Map.of();
    }

    private String getDefaultSubjectKey(String stepType) {
        return switch (stepType) {
            case "disable-user" -> ACCOUNT_DISABLE_NOTIFICATION_SUBJECT;
            case "delete-user" -> ACCOUNT_DELETE_NOTIFICATION_SUBJECT;
            default -> "accountNotificationSubject";
        };
    }

    private String getDefaultMessageKey(String stepType) {
        return switch (stepType) {
            case "disable-user" -> ACCOUNT_DISABLE_NOTIFICATION_BODY;
            case "delete-user" -> ACCOUNT_DELETE_NOTIFICATION_BODY;
            default -> "accountNotificationBody";
        };
    }
}

