/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.authentication.authenticators.client.AbstractClientAuthenticator;
import org.keycloak.authentication.authenticators.client.ClientAssertionState;
import org.keycloak.broker.provider.ClientAssertionIdentityProvider;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.cache.AlternativeLookupProvider;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.resources.IdentityBrokerService;

public class FederatedJWTClientAuthenticator
extends AbstractClientAuthenticator
implements EnvironmentDependentProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(FederatedJWTClientAuthenticator.class);
    public static final String PROVIDER_ID = "federated-jwt";
    public static final String JWT_CREDENTIAL_ISSUER_KEY = "jwt.credential.issuer";
    public static final String JWT_CREDENTIAL_SUBJECT_KEY = "jwt.credential.sub";
    private static final List<ProviderConfigProperty> CLIENT_CONFIG = List.of(new ProviderConfigProperty("jwt.credential.issuer", "Identity provider", "Issuer of the client assertion", "String", null), new ProviderConfigProperty("jwt.credential.sub", "Federated subject", "External clientId (subject)", "String", null));
    private static final Set<String> SUPPORTED_ASSERTION_TYPES = Set.of("urn:ietf:params:oauth:client-assertion-type:jwt-bearer", "urn:ietf:params:oauth:client-assertion-type:jwt-spiffe");

    public String getId() {
        return PROVIDER_ID;
    }

    public void authenticateClient(ClientAuthenticationFlowContext context) {
        try {
            ClientAssertionState clientAssertionState = (ClientAssertionState)context.getState(ClientAssertionState.class, ClientAssertionState.supplier());
            if (clientAssertionState == null || clientAssertionState.getClientAssertionType() == null) {
                return;
            }
            if (!SUPPORTED_ASSERTION_TYPES.contains(clientAssertionState.getClientAssertionType())) {
                return;
            }
            AlternativeLookupProvider lookupProvider = (AlternativeLookupProvider)context.getSession().getProvider(AlternativeLookupProvider.class);
            String federatedClientId = clientAssertionState.getToken().getSubject();
            ClientModel client = lookupProvider.lookupClientFromClientAttributes(context.getSession(), Map.of(JWT_CREDENTIAL_SUBJECT_KEY, federatedClientId));
            if (client == null) {
                return;
            }
            String idpAlias = client.getAttribute(JWT_CREDENTIAL_ISSUER_KEY);
            IdentityProviderModel identityProviderModel = context.getSession().identityProviders().getByAlias(idpAlias);
            ClientAssertionIdentityProvider identityProvider = this.getClientAssertionIdentityProvider(context.getSession(), identityProviderModel);
            if (identityProvider == null) {
                return;
            }
            clientAssertionState.setClient(client);
            if (!PROVIDER_ID.equals(client.getClientAuthenticatorType())) {
                return;
            }
            if (identityProvider.verifyClientAssertion(context)) {
                context.success();
            } else {
                context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Authentication failed", (Throwable)e);
            context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS);
        }
    }

    private ClientAssertionIdentityProvider getClientAssertionIdentityProvider(KeycloakSession session, IdentityProviderModel identityProviderModel) {
        if (identityProviderModel == null) {
            return null;
        }
        IdentityProvider<?> identityProvider = IdentityBrokerService.getIdentityProvider(session, identityProviderModel);
        if (identityProvider instanceof ClientAssertionIdentityProvider) {
            ClientAssertionIdentityProvider clientAssertionProvider = (ClientAssertionIdentityProvider)identityProvider;
            return clientAssertionProvider;
        }
        throw new RuntimeException("Provider does not support client assertions");
    }

    public String getDisplayType() {
        return "Signed JWT - Federated";
    }

    public String getHelpText() {
        return "Validates client based on signed JWT issued and signed by an external identity provider";
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return ConfigurableAuthenticatorFactory.REQUIREMENT_CHOICES;
    }

    public boolean isConfigurable() {
        return false;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    public List<ProviderConfigProperty> getConfigPropertiesPerClient() {
        return CLIENT_CONFIG;
    }

    public Map<String, Object> getAdapterConfiguration(ClientModel client) {
        return Collections.emptyMap();
    }

    public Set<String> getProtocolAuthenticatorMethods(String loginProtocol) {
        return Collections.emptySet();
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_AUTH_FEDERATED);
    }
}

