/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.AccessFlags;
import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.Attributes;
import io.github.dmlloyd.classfile.ClassElement;
import io.github.dmlloyd.classfile.ClassFileVersion;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.CustomAttribute;
import io.github.dmlloyd.classfile.FieldModel;
import io.github.dmlloyd.classfile.Interfaces;
import io.github.dmlloyd.classfile.MethodModel;
import io.github.dmlloyd.classfile.Superclass;
import io.github.dmlloyd.classfile.attribute.InnerClassesAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleHashesAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleMainClassAttribute;
import io.github.dmlloyd.classfile.attribute.ModulePackagesAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleResolutionAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleTargetAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.SourceDebugExtensionAttribute;
import io.github.dmlloyd.classfile.attribute.SourceFileAttribute;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantPool;
import io.github.dmlloyd.classfile.extras.reflect.AccessFlag;
import io.github.dmlloyd.classfile.impl.AbstractElement;
import io.github.dmlloyd.classfile.impl.AccessFlagsImpl;
import io.github.dmlloyd.classfile.impl.BoundAttribute;
import io.github.dmlloyd.classfile.impl.ClassFileImpl;
import io.github.dmlloyd.classfile.impl.ClassReaderImpl;
import io.github.dmlloyd.classfile.impl.FieldImpl;
import io.github.dmlloyd.classfile.impl.MethodImpl;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public final class ClassImpl
extends AbstractElement
implements ClassModel {
    final ClassReaderImpl reader;
    private final int attributesPos;
    private final List<MethodModel> methods;
    private final List<FieldModel> fields;
    private List<Attribute<?>> attributes;
    private List<ClassEntry> interfaces;

    public ClassImpl(byte[] cfbytes, ClassFileImpl context) {
        this.reader = new ClassReaderImpl(cfbytes, context);
        int p = this.reader.interfacesPos;
        int icnt = this.reader.readU2(p);
        int fcnt = this.reader.readU2(p += 2 + icnt * 2);
        FieldImpl[] fields = new FieldImpl[fcnt];
        p += 2;
        for (int i = 0; i < fcnt; ++i) {
            int startPos = p;
            int attrStart = p + 6;
            p = this.reader.skipAttributeHolder(attrStart);
            fields[i] = new FieldImpl(this.reader, startPos, p, attrStart);
        }
        this.fields = List.of(fields);
        int mcnt = this.reader.readU2(p);
        MethodImpl[] methods = new MethodImpl[mcnt];
        p += 2;
        for (int i = 0; i < mcnt; ++i) {
            int startPos = p;
            int attrStart = p + 6;
            p = this.reader.skipAttributeHolder(attrStart);
            methods[i] = new MethodImpl(this.reader, startPos, p, attrStart);
        }
        this.methods = List.of(methods);
        this.attributesPos = p;
        this.reader.setContainedClass(this);
    }

    public int classfileLength() {
        return this.reader.classfileLength();
    }

    @Override
    public AccessFlags flags() {
        return new AccessFlagsImpl(AccessFlag.Location.CLASS, this.reader.flags());
    }

    @Override
    public int majorVersion() {
        return this.reader.readU2(6);
    }

    @Override
    public int minorVersion() {
        return this.reader.readU2(4);
    }

    @Override
    public ConstantPool constantPool() {
        return this.reader;
    }

    @Override
    public ClassEntry thisClass() {
        return this.reader.thisClassEntry();
    }

    @Override
    public Optional<ClassEntry> superclass() {
        return this.reader.superclassEntry();
    }

    @Override
    public List<ClassEntry> interfaces() {
        if (this.interfaces == null) {
            int pos = this.reader.thisClassPos() + 4;
            int cnt = this.reader.readU2(pos);
            pos += 2;
            ClassEntry[] arr = new ClassEntry[cnt];
            for (int i = 0; i < cnt; ++i) {
                arr[i] = this.reader.readEntry(pos, ClassEntry.class);
                pos += 2;
            }
            this.interfaces = List.of(arr);
        }
        return this.interfaces;
    }

    @Override
    public List<Attribute<?>> attributes() {
        if (this.attributes == null) {
            this.attributes = BoundAttribute.readAttributes(this, this.reader, this.attributesPos, this.reader.customAttributes());
        }
        return this.attributes;
    }

    @Override
    public void forEach(final Consumer<? super ClassElement> consumer) {
        consumer.accept(this.flags());
        consumer.accept(ClassFileVersion.of(this.majorVersion(), this.minorVersion()));
        this.superclass().ifPresent(new Consumer<ClassEntry>(){

            @Override
            public void accept(ClassEntry entry) {
                consumer.accept(Superclass.of(entry));
            }
        });
        consumer.accept(Interfaces.of(this.interfaces()));
        this.fields().forEach(consumer);
        this.methods().forEach(consumer);
        for (Attribute<?> attr : this.attributes()) {
            if (!(attr instanceof ClassElement)) continue;
            ClassElement e = (ClassElement)((Object)attr);
            consumer.accept(e);
        }
    }

    @Override
    public List<FieldModel> fields() {
        return this.fields;
    }

    @Override
    public List<MethodModel> methods() {
        return this.methods;
    }

    @Override
    public boolean isModuleInfo() {
        AccessFlags flags = this.flags();
        return flags.has(AccessFlag.MODULE) && this.majorVersion() >= 53 && this.thisClass().asInternalName().equals("module-info") && this.superclass().isEmpty() && this.interfaces().isEmpty() && this.fields().isEmpty() && this.methods().isEmpty() && this.verifyModuleAttributes();
    }

    public String toString() {
        return String.format("ClassModel[thisClass=%s, flags=%d]", this.thisClass().name().stringValue(), this.flags().flagsMask());
    }

    private boolean verifyModuleAttributes() {
        if (this.findAttribute(Attributes.module()).isEmpty()) {
            return false;
        }
        return this.attributes().stream().allMatch(a -> a instanceof ModuleAttribute || a instanceof ModulePackagesAttribute || a instanceof ModuleHashesAttribute || a instanceof ModuleMainClassAttribute || a instanceof ModuleResolutionAttribute || a instanceof ModuleTargetAttribute || a instanceof InnerClassesAttribute || a instanceof SourceFileAttribute || a instanceof SourceDebugExtensionAttribute || a instanceof RuntimeVisibleAnnotationsAttribute || a instanceof RuntimeInvisibleAnnotationsAttribute || a instanceof CustomAttribute);
    }
}

