/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.nio.ByteBuffer;

public class EntryHeader {
    private static final byte MAGIC = 1;
    static final int HEADER_SIZE_10_1 = 24;
    static final int HEADER_SIZE_11_0 = 27;
    private final int keyLength;
    private final int valueLength;
    private final int metadataLength;
    private final long seqId;
    private final long expiration;
    private final int internalMetadataLength;
    private final int headerLength;

    public EntryHeader(ByteBuffer buffer) {
        this(buffer, false);
    }

    public EntryHeader(ByteBuffer buffer, boolean oldFormat) {
        byte magicByte;
        if (!oldFormat && (magicByte = buffer.get()) != 1) {
            throw new IllegalStateException("Magic byte was: " + magicByte);
        }
        this.keyLength = buffer.getShort();
        this.metadataLength = buffer.getShort();
        this.valueLength = buffer.getInt();
        this.internalMetadataLength = oldFormat ? (short)0 : buffer.getShort();
        this.seqId = buffer.getLong();
        this.expiration = buffer.getLong();
        this.headerLength = oldFormat ? 24 : 27;
    }

    public int keyLength() {
        return this.keyLength;
    }

    public int metadataLength() {
        return this.metadataLength;
    }

    public int internalMetadataLength() {
        return this.internalMetadataLength;
    }

    public int valueLength() {
        return this.valueLength;
    }

    public long seqId() {
        return this.seqId;
    }

    public long expiryTime() {
        return this.expiration;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public String toString() {
        return String.format("[keyLength=%d, valueLength=%d, metadataLength=%d, internalMetadataLength=%d,seqId=%d, expiration=%d]", this.keyLength, this.valueLength, this.metadataLength, this.internalMetadataLength, this.seqId, this.expiration);
    }

    public int totalLength() {
        return this.keyLength + this.metadataLength + this.internalMetadataLength + this.valueLength + this.headerLength;
    }

    public static void writeHeader(ByteBuffer buf, short keyLength, short metadataLength, int valueLength, short internalMetadataLength, long seqId, long expiration) {
        buf.put((byte)1);
        buf.putShort(keyLength);
        buf.putShort(metadataLength);
        buf.putInt(valueLength);
        buf.putShort(internalMetadataLength);
        buf.putLong(seqId);
        buf.putLong(expiration);
    }
}

