/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jta.internal;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import org.hibernate.TransactionException;
import org.hibernate.resource.transaction.backend.jta.internal.JtaLogging;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionAdapter;
import org.hibernate.resource.transaction.backend.jta.internal.StatusTranslator;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class JtaTransactionAdapterTransactionManagerImpl
implements JtaTransactionAdapter {
    private final TransactionManager transactionManager;
    private boolean initiator;

    public JtaTransactionAdapterTransactionManagerImpl(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void begin() {
        try {
            if (this.getStatus() == TransactionStatus.NOT_ACTIVE) {
                JtaLogging.JTA_LOGGER.callingTransactionManagerBegin();
                this.transactionManager.begin();
                this.initiator = true;
                JtaLogging.JTA_LOGGER.calledTransactionManagerBegin();
            } else {
                JtaLogging.JTA_LOGGER.skippingTransactionManagerBegin();
            }
        }
        catch (Exception e) {
            throw new TransactionException("JTA TransactionManager.begin() failed", e);
        }
    }

    @Override
    public void commit() {
        try {
            if (this.initiator) {
                this.initiator = false;
                JtaLogging.JTA_LOGGER.callingTransactionManagerCommit();
                this.transactionManager.commit();
                JtaLogging.JTA_LOGGER.calledTransactionManagerCommit();
            } else {
                JtaLogging.JTA_LOGGER.skippingTransactionManagerCommit();
            }
        }
        catch (Exception e) {
            throw new TransactionException("JTA TransactionManager.commit() failed", e);
        }
    }

    @Override
    public void rollback() {
        try {
            if (this.initiator) {
                this.initiator = false;
                JtaLogging.JTA_LOGGER.callingTransactionManagerRollback();
                this.transactionManager.rollback();
                JtaLogging.JTA_LOGGER.calledTransactionManagerRollback();
            } else {
                this.markRollbackOnly();
            }
        }
        catch (Exception e) {
            throw new TransactionException("JTA TransactionManager.rollback() failed", e);
        }
    }

    @Override
    public TransactionStatus getStatus() {
        try {
            TransactionStatus status = StatusTranslator.translate(this.transactionManager.getStatus());
            if (status == null) {
                throw new TransactionException("TransactionManager reported transaction status as unknown");
            }
            return status;
        }
        catch (SystemException e) {
            throw new TransactionException("JTA TransactionManager#getStatus failed", e);
        }
    }

    @Override
    public void markRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new TransactionException("Could not set transaction to rollback only", e);
        }
    }

    @Override
    public void setTimeOut(int seconds) {
        if (seconds > 0) {
            try {
                this.transactionManager.setTransactionTimeout(seconds);
            }
            catch (SystemException e) {
                throw new TransactionException("Unable to apply requested transaction timeout", e);
            }
        }
    }
}

