/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class LinkedIdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private Node<K, V>[] table;
    private int size;
    private Node<K, V> head;
    private Node<K, V> tail;
    private transient Set<Map.Entry<K, V>> entrySet;

    public LinkedIdentityHashMap() {
        this(16);
    }

    public LinkedIdentityHashMap(int initialCapacity) {
        int cap;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        for (cap = 1; cap < initialCapacity; cap <<= 1) {
        }
        this.table = new Node[cap];
    }

    private static int indexFor(int hash, int length) {
        return hash & length - 1;
    }

    @Override
    public V get(Object key) {
        Node<K, V> e = this.getNode(key);
        return e != null ? (V)e.value : null;
    }

    private Node<K, V> getNode(Object key) {
        int hash = System.identityHashCode(key);
        int idx = LinkedIdentityHashMap.indexFor(hash, this.table.length);
        Node<K, V> e = this.table[idx];
        while (e != null) {
            if (e.key == key) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getNode(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Node<K, V> e = this.head;
        while (e != null) {
            if (Objects.equals(e.value, value)) {
                return true;
            }
            e = e.after;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        int hash = System.identityHashCode(key);
        int idx = LinkedIdentityHashMap.indexFor(hash, this.table.length);
        Node<K, V> e = this.table[idx];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        Node<K, V> newNode = new Node<K, V>(key, value, this.table[idx]);
        this.table[idx] = newNode;
        this.linkLast(newNode);
        ++this.size;
        if (this.size == this.table.length) {
            this.resize();
        }
        return null;
    }

    private void linkLast(Node<K, V> node) {
        if (this.tail == null) {
            this.tail = node;
            this.head = this.tail;
        } else {
            this.tail.after = node;
            node.before = this.tail;
            this.tail = node;
        }
    }

    @Override
    public V remove(Object key) {
        int hash = System.identityHashCode(key);
        int idx = LinkedIdentityHashMap.indexFor(hash, this.table.length);
        Node<K, V> prev = null;
        Node<K, V> e = this.table[idx];
        while (e != null) {
            if (e.key == key) {
                if (prev == null) {
                    this.table[idx] = e.next;
                } else {
                    prev.next = e.next;
                }
                Node b = e.before;
                Node a = e.after;
                if (b == null) {
                    this.head = a;
                } else {
                    b.after = a;
                }
                if (a == null) {
                    this.tail = b;
                } else {
                    a.before = b;
                }
                --this.size;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, null);
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void resize() {
        int oldCap = this.table.length;
        int newCap = oldCap << 1;
        Node[] newTable = new Node[newCap];
        for (int i = 0; i < oldCap; ++i) {
            Node<K, V> e = this.table[i];
            while (e != null) {
                Node next = e.next;
                int idx = LinkedIdentityHashMap.indexFor(System.identityHashCode(e.key), newCap);
                e.next = newTable[idx];
                newTable[idx] = e;
                e = next;
            }
        }
        this.table = newTable;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    static final class Node<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        Node<K, V> next;
        Node<K, V> before;
        Node<K, V> after;

        Node(K key, V value, Node<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V old = this.value;
            this.value = newValue;
            return old;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Node)) return false;
            Node node = (Node)o;
            if (this.key != node.key) return false;
            if (!Objects.equals(this.value, node.value)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = System.identityHashCode(this.key);
            result = 31 * result + Objects.hashCode(this.value);
            return result;
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + String.valueOf(this.value);
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return LinkedIdentityHashMap.this.size;
        }

        @Override
        public void clear() {
            LinkedIdentityHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Node n = LinkedIdentityHashMap.this.getNode(e.getKey());
                return n != null && Objects.equals(n.value, e.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry e;
            return o instanceof Map.Entry && LinkedIdentityHashMap.this.remove((e = (Map.Entry)o).getKey()) != null;
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private Node<K, V> next;
        private Node<K, V> current;

        EntryIterator() {
            this.next = LinkedIdentityHashMap.this.head;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Node<K, V> next() {
            Node e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = e.after;
            return e;
        }

        @Override
        public void remove() {
            Node e = this.current;
            if (e == null) {
                throw new IllegalStateException();
            }
            LinkedIdentityHashMap.this.remove(e.key);
            this.current = null;
        }
    }
}

