/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.UnknownProfileException;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.persister.entity.EntityPersister;

class MultiIdentifierLoadAccessImpl<T>
implements MultiIdentifierLoadAccess<T>,
MultiIdLoadOptions {
    private final SharedSessionContractImplementor session;
    private final EntityPersister entityPersister;
    private LockOptions lockOptions;
    private CacheMode cacheMode;
    private Boolean readOnly;
    private RootGraphImplementor<T> rootGraph;
    private GraphSemantic graphSemantic;
    private Integer batchSize;
    private boolean sessionCheckingEnabled;
    private boolean returnOfDeletedEntitiesEnabled;
    private boolean orderedReturnEnabled = true;
    private Set<String> enabledFetchProfiles;
    private Set<String> disabledFetchProfiles;

    public MultiIdentifierLoadAccessImpl(SharedSessionContractImplementor session, EntityPersister entityPersister) {
        this.session = session;
        this.entityPersister = entityPersister;
    }

    @Override
    public MultiIdentifierLoadAccess<T> with(LockMode lockMode, PessimisticLockScope lockScope) {
        if (this.lockOptions == null) {
            this.lockOptions = new LockOptions();
        }
        this.lockOptions.setLockMode(lockMode);
        this.lockOptions.setLockScope(lockScope);
        return this;
    }

    @Override
    public MultiIdentifierLoadAccess<T> with(Timeout timeout) {
        if (this.lockOptions == null) {
            this.lockOptions = new LockOptions();
        }
        this.lockOptions.setTimeOut(timeout.milliseconds());
        return this;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public final MultiIdentifierLoadAccess<T> with(LockOptions lockOptions) {
        this.lockOptions = lockOptions;
        return this;
    }

    @Override
    public MultiIdentifierLoadAccess<T> with(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public MultiIdentifierLoadAccess<T> withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public MultiIdentifierLoadAccess<T> with(EntityGraph<T> graph, GraphSemantic semantic) {
        this.rootGraph = (RootGraphImplementor)graph;
        this.graphSemantic = semantic;
        return this;
    }

    @Override
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public MultiIdentifierLoadAccess<T> withBatchSize(int batchSize) {
        this.batchSize = batchSize < 1 ? null : Integer.valueOf(batchSize);
        return this;
    }

    @Override
    public boolean isSessionCheckingEnabled() {
        return this.sessionCheckingEnabled;
    }

    @Override
    public boolean isSecondLevelCacheCheckingEnabled() {
        return this.cacheMode == CacheMode.NORMAL || this.cacheMode == CacheMode.GET;
    }

    @Override
    public MultiIdentifierLoadAccess<T> enableSessionCheck(boolean enabled) {
        this.sessionCheckingEnabled = enabled;
        return this;
    }

    @Override
    public boolean isReturnOfDeletedEntitiesEnabled() {
        return this.returnOfDeletedEntitiesEnabled;
    }

    @Override
    public MultiIdentifierLoadAccess<T> enableReturnOfDeletedEntities(boolean enabled) {
        this.returnOfDeletedEntitiesEnabled = enabled;
        return this;
    }

    @Override
    public boolean isOrderReturnEnabled() {
        return this.orderedReturnEnabled;
    }

    @Override
    public MultiIdentifierLoadAccess<T> enableOrderedReturn(boolean enabled) {
        this.orderedReturnEnabled = enabled;
        return this;
    }

    @Override
    public Boolean getReadOnly(SessionImplementor session) {
        return this.readOnly != null ? this.readOnly : session.getLoadQueryInfluencers().getReadOnly();
    }

    @Override
    public <K> List<T> multiLoad(K ... ids) {
        return this.perform(() -> this.entityPersister.multiLoad(ids, this.session, (MultiIdLoadOptions)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> perform(Supplier<List<T>> executor) {
        CacheMode sessionCacheMode = this.session.getCacheMode();
        boolean cacheModeChanged = false;
        if (this.cacheMode != null && this.cacheMode != sessionCacheMode) {
            this.session.setCacheMode(this.cacheMode);
            cacheModeChanged = true;
        }
        try {
            LoadQueryInfluencers influencers = this.session.getLoadQueryInfluencers();
            HashSet<String> fetchProfiles = influencers.adjustFetchProfiles(this.disabledFetchProfiles, this.enabledFetchProfiles);
            EffectiveEntityGraph effectiveEntityGraph = influencers.applyEntityGraph(this.rootGraph, this.graphSemantic);
            try {
                List<T> list = executor.get();
                effectiveEntityGraph.clear();
                influencers.setEnabledFetchProfileNames(fetchProfiles);
                return list;
            }
            catch (Throwable throwable) {
                effectiveEntityGraph.clear();
                influencers.setEnabledFetchProfileNames(fetchProfiles);
                throw throwable;
            }
        }
        finally {
            if (cacheModeChanged) {
                this.session.setCacheMode(sessionCacheMode);
            }
        }
    }

    @Override
    public <K> List<T> multiLoad(List<K> ids) {
        return ids.isEmpty() ? Collections.emptyList() : this.perform(() -> this.entityPersister.multiLoad(ids.toArray(), this.session, (MultiIdLoadOptions)this));
    }

    @Override
    public MultiIdentifierLoadAccess<T> enableFetchProfile(String profileName) {
        if (!this.session.getFactory().containsFetchProfileDefinition(profileName)) {
            throw new UnknownProfileException(profileName);
        }
        if (this.enabledFetchProfiles == null) {
            this.enabledFetchProfiles = new HashSet<String>();
        }
        this.enabledFetchProfiles.add(profileName);
        if (this.disabledFetchProfiles != null) {
            this.disabledFetchProfiles.remove(profileName);
        }
        return this;
    }

    @Override
    public MultiIdentifierLoadAccess<T> disableFetchProfile(String profileName) {
        if (this.disabledFetchProfiles == null) {
            this.disabledFetchProfiles = new HashSet<String>();
        }
        this.disabledFetchProfiles.add(profileName);
        if (this.enabledFetchProfiles != null) {
            this.enabledFetchProfiles.remove(profileName);
        }
        return this;
    }
}

