/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.FetchProfileOverride;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.mapping.PersistentClass;

public class FetchSecondPass
implements SecondPass {
    private final FetchProfileOverride fetch;
    private final PropertyHolder propertyHolder;
    private final String propertyName;
    private final MetadataBuildingContext buildingContext;

    public FetchSecondPass(FetchProfileOverride fetch, PropertyHolder propertyHolder, String propertyName, MetadataBuildingContext buildingContext) {
        this.fetch = fetch;
        this.propertyHolder = propertyHolder;
        this.propertyName = propertyName;
        this.buildingContext = buildingContext;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        String profileName = this.fetch.profile();
        FetchProfile profile = this.buildingContext.getMetadataCollector().getFetchProfile(profileName);
        if (profile == null) {
            throw new AnnotationException("Property '" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName) + "' refers to an unknown fetch profile named '" + profileName + "'");
        }
        if (profile.getSource() == MetadataSource.ANNOTATIONS) {
            profile.addFetch(new FetchProfile.Fetch(this.propertyHolder.getEntityName(), this.propertyName, this.fetch.mode(), this.fetch.fetch()));
        }
    }
}

