/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\r%e\u0001\u0002\u00192\u0001aB\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t3\u0002\u0011\t\u0011)A\u0005'\"A!\f\u0001BC\u0002\u0013\u00051\f\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003]\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001d\u0011\b\u00011A\u0005\nMDqA\u001f\u0001A\u0002\u0013%1\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0015\u0002;\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003g\u0003A\u0011BA[\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!!=\u0001\t\u0013\t\u0019\u0010C\u0004\u0003\u0004\u0001!IA!\u0002\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!\u0011\u0005\u0001\u0005B\t\r\u0002\"\u0003B\u001f\u0001E\u0005I\u0011\u0001B \u0011%\u0011)\u0006AI\u0001\n\u0003\u0011y\u0004C\u0004\u0003X\u0001!\tE!\u0017\t\u000f\tu\u0004\u0001\"\u0011\u0003\u0000!9!\u0011\u0011\u0001\u0005B\t\r\u0005b\u0002BG\u0001\u0011\u0005#q\u0012\u0005\b\u00057\u0003A\u0011\tBO\u0011\u001d\u0011\t\u000b\u0001C!\u0005GCqAa*\u0001\t\u0003\u0012I\u000bC\u0004\u0003.\u0002!\tEa,\t\u000f\t]\u0006\u0001\"\u0011\u0003:\"9!q\u0018\u0001\u0005B\t\u0005\u0007b\u0002Bc\u0001\u0011\u0005#q\u0019\u0005\b\u0005/\u0004A\u0011\tBm\u0011\u001d\u0011y\u000e\u0001C!\u0005CDqA!;\u0001\t\u0003\u0012Y\u000fC\u0004\u0003p\u0002!\tE!=\t\u000f\te\b\u0001\"\u0011\u0003|\"911\u0002\u0001\u0005B\r5\u0001bBB\b\u0001\u0011%1\u0011\u0003\u0005\b\u0007+\u0001A\u0011IB\f\u0011\u001d\u0019\u0019\u0003\u0001C!\u0007KAqaa\t\u0001\t\u0003\u001aI\u0003C\u0004\u0004.\u0001!\taa\f\t\u000f\rU\u0002\u0001\"\u0001\u0002J!91q\u0007\u0001\u0005B\re\u0002bBB(\u0001\u0011\u00053\u0011\u000b\u0005\b\u0007G\u0002A\u0011IB3\u0011\u001d\u0019)\b\u0001C!\u0007oBqaa \u0001\t\u0003\u001a\tI\u0001\nL%\u00064G/T3uC\u0012\fG/Y\"bG\",'B\u0001\u001a4\u0003!iW\r^1eCR\f'B\u0001\u001b6\u0003\u0019\u0019XM\u001d<fe*\ta'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001I\u0014i\u0013\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nA\u0001\\1oO*\ta(\u0001\u0003kCZ\f\u0017B\u0001!<\u0005\u0019y%M[3diB\u0011!)S\u0007\u0002\u0007*\u0011!\u0007\u0012\u0006\u0003m\u0015S!AR$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0015aA8sO&\u0011!j\u0011\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u00051{U\"A'\u000b\u00059+\u0014!B;uS2\u001c\u0018B\u0001)N\u0005\u001daunZ4j]\u001e\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002'B\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013\u0001F6sC\u001a$h+\u001a:tS>t7+\u001e9qY&,'/F\u0001]!\ri&\rZ\u0007\u0002=*\u0011q\fY\u0001\tMVt7\r^5p]*\u0011\u0011-P\u0001\u0005kRLG.\u0003\u0002d=\nA1+\u001e9qY&,'\u000f\u0005\u0002fS6\taM\u0003\u0002hQ\u000611m\\7n_:T!\u0001\u000e#\n\u0005)4'\u0001D&SC\u001a$h+\u001a:tS>t\u0017!F6sC\u001a$h+\u001a:tS>t7+\u001e9qY&,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079\u0004\u0018\u000f\u0005\u0002p\u00015\t\u0011\u0007C\u0003R\u000b\u0001\u00071\u000bC\u0003[\u000b\u0001\u0007A,A\u0007`GV\u0014(/\u001a8u\u00136\fw-Z\u000b\u0002iB\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fR\u0001\u0006S6\fw-Z\u0005\u0003sZ\u0014Q\"T3uC\u0012\fG/Y%nC\u001e,\u0017!E0dkJ\u0014XM\u001c;J[\u0006<Wm\u0018\u0013fcR\u0011Ap \t\u0003)vL!A`+\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u00039\u0011\u0011!a\u0001i\u0006\u0019\u0001\u0010J\u0019\u0002\u001d}\u001bWO\u001d:f]RLU.Y4fA!\u001a\u0001\"a\u0002\u0011\u0007Q\u000bI!C\u0002\u0002\fU\u0013\u0001B^8mCRLG.Z\u0001\u0019[\u0006L(-\u001a$jYR,'/\u00117jm\u0016\u0014V\r\u001d7jG\u0006\u001cHCCA\t\u0003?\t\t#a\u000b\u0002>A1\u00111CA\u000b\u00033i\u0011\u0001Y\u0005\u0004\u0003/\u0001'\u0001\u0002'jgR\u00042AOA\u000e\u0013\r\tib\u000f\u0002\b\u0013:$XmZ3s\u0011\u00159\u0018\u00021\u0001u\u0011\u001d\t\u0019#\u0003a\u0001\u0003K\tqA\u0019:pW\u0016\u00148\u000f\u0005\u0003U\u0003O\u0019\u0016bAA\u0015+\n)\u0011I\u001d:bs\"9\u0011QF\u0005A\u0002\u0005=\u0012\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BA\u0019\u0003si!!a\r\u000b\t\u0005U\u0012qG\u0001\b]\u0016$xo\u001c:l\u0015\t9G)\u0003\u0003\u0002<\u0005M\"\u0001\u0004'jgR,g.\u001a:OC6,\u0007bBA \u0013\u0001\u0007\u0011\u0011I\u0001\u001bM&dG/\u001a:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo\u001d\t\u0004)\u0006\r\u0013bAA#+\n9!i\\8mK\u0006t\u0017\u0001D2veJ,g\u000e^%nC\u001e,G#\u0001;\u0002)\u001d,G\u000fU1si&$\u0018n\u001c8NKR\fG-\u0019;b)1\ty%a%\u0002\u0016\u0006%\u00161VAX!\u0015!\u0016\u0011KA+\u0013\r\t\u0019&\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0005]\u0013qMA7\u001d\u0011\tI&a\u0019\u000f\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u00188\u0003\u0019a$o\\8u}%\ta+C\u0002\u0002fU\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002j\u0005-$\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005\u0015T\u000b\u0005\u0003\u0002p\u00055e\u0002BA9\u0003\u000fsA!a\u001d\u0002\u0004:!\u0011QOAA\u001d\u0011\t9(a \u000f\t\u0005e\u0014Q\u0010\b\u0005\u00037\nY(C\u0001I\u0013\t1u)\u0003\u00027\u000b&\u0011q\rR\u0005\u0005\u0003\u000b\u000b9$A\u0004nKN\u001c\u0018mZ3\n\t\u0005%\u00151R\u0001\u0015\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$\u0015\r^1\u000b\t\u0005\u0015\u0015qG\u0005\u0005\u0003\u001f\u000b\tJA\rNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKB\u000b'\u000f^5uS>t'\u0002BAE\u0003\u0017CQa^\u0006A\u0002QDq!a&\f\u0001\u0004\tI*A\u0005u_BL7MT1nKB!\u00111TAR\u001d\u0011\ti*a(\u0011\u0007\u0005mS+C\u0002\u0002\"V\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAS\u0003O\u0013aa\u0015;sS:<'bAAQ+\"9\u0011QF\u0006A\u0002\u0005=\u0002bBAW\u0017\u0001\u0007\u0011\u0011I\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016,e\u000e\u001a9pS:$8\u000fC\u0004\u00022.\u0001\r!!\u0011\u00023\u0015\u0014(o\u001c:V]\u00064\u0018-\u001b7bE2,G*[:uK:,'o]\u0001-O\u0016$\b+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1G_J$Um]2sS\n,Gk\u001c9jGJ+7\u000f]8og\u0016$B\"a.\u0002R\u0006M\u0017Q[Al\u00037\u0004b\u0001VA]\u0003{\u001b\u0016bAA^+\n1A+\u001e9mKJ\u0002R\u0001VA)\u0003\u007f\u0003b!a\u0016\u0002B\u0006\r\u0017\u0002BA\f\u0003W\u0002B!!2\u0002L:!\u0011\u0011OAd\u0013\u0011\tI-a#\u0002G\u0011+7o\u0019:jE\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c(+Z:q_:\u001cX\rR1uC&!\u0011QZAh\u0005!\"Um]2sS\n,Gk\u001c9jGB\u000b'\u000f^5uS>t7OU3ta>t7/\u001a)beRLG/[8o\u0015\u0011\tI-a#\t\u000b]d\u0001\u0019\u0001;\t\u000f\u0005]E\u00021\u0001\u0002\u001a\"9\u0011Q\u0006\u0007A\u0002\u0005=\u0002BBAm\u0019\u0001\u00071+\u0001\u0006ti\u0006\u0014H/\u00138eKbDa!!8\r\u0001\u0004\u0019\u0016\u0001C7bq\u000e{WO\u001c;\u0002%\u001d,Go\u00144gY&tWMU3qY&\u001c\u0017m\u001d\u000b\t\u0003#\t\u0019/!:\u0002p\")q/\u0004a\u0001i\"9\u0011q]\u0007A\u0002\u0005%\u0018!\u00039beRLG/[8o!\r\u0011\u00151^\u0005\u0004\u0003[\u001c%!\u0006)beRLG/[8o%\u0016<\u0017n\u001d;sCRLwN\u001c\u0005\b\u0003[i\u0001\u0019AA\u0018\u0003AI7OU3qY&\u001c\u0017m\u00144gY&tW\r\u0006\u0005\u0002B\u0005U\u0018q_A}\u0011\u001d\t9O\u0004a\u0001\u0003SDq!!\f\u000f\u0001\u0004\ty\u0003C\u0004\u0002|:\u0001\r!!@\u0002\r\t\u0014xn[3s!\r\u0011\u0015q`\u0005\u0004\u0005\u0003\u0019%A\u0005\"s_.,'OU3hSN$(/\u0019;j_:\fQ#[:SKBd\u0017nY1J]>3g\r\\5oK\u0012K'\u000f\u0006\u0004\u0002B\t\u001d!\u0011\u0002\u0005\b\u0003w|\u0001\u0019AA\u007f\u0011\u001d\t9o\u0004a\u0001\u0003S\f\u0001cZ3u\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\u0011\t=!\u0011\u0004B\u000e\u0005?\u0001R\u0001VA)\u0005#\u0001BAa\u0005\u0003\u00165\u0011\u0011qG\u0005\u0005\u0005/\t9D\u0001\u0003O_\u0012,\u0007\"B<\u0011\u0001\u0004!\bB\u0002B\u000f!\u0001\u00071+\u0001\u0002jI\"9\u0011Q\u0006\tA\u0002\u0005=\u0012\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b))\u0011)C!\f\u00038\te\"1\b\t\u0007\u0003'\t)Ba\n\u0011\t\u0005=$\u0011F\u0005\u0005\u0005W\t\tJA\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKR{\u0007/[2\t\u000f\t=\u0012\u00031\u0001\u00032\u00051Ao\u001c9jGN\u0004b!a\u0005\u00034\u0005e\u0015b\u0001B\u001bA\n\u00191+\u001a;\t\u000f\u00055\u0012\u00031\u0001\u00020!I\u0011QV\t\u0011\u0002\u0003\u0007\u0011\u0011\t\u0005\n\u0003c\u000b\u0002\u0013!a\u0001\u0003\u0003\n!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM*\"A!\u0011+\t\u0005\u0005#1I\u0016\u0003\u0005\u000b\u0002BAa\u0012\u0003R5\u0011!\u0011\n\u0006\u0005\u0005\u0017\u0012i%A\u0005v]\u000eDWmY6fI*\u0019!qJ+\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003T\t%#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%i\u0005)B-Z:de&\u0014W\rV8qS\u000e\u0014Vm\u001d9p]N,G\u0003\u0004B.\u0005G\u0012IGa\u001b\u0003v\te\u0004\u0003\u0002B/\u0005?j!!a#\n\t\t\u0005\u00141\u0012\u0002$\t\u0016\u001c8M]5cKR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\u0011y\u0003\u0006a\u0001\u0005K\u0002b!a\u0005\u0003h\u0005e\u0015bAA5A\"9\u0011Q\u0006\u000bA\u0002\u0005=\u0002b\u0002B7)\u0001\u0007!qN\u0001\u0019i>\u0004\u0018n\u0019)beRLG/[8o'R\f'\u000f^%oI\u0016D\bcB/\u0003r\u0005e\u0015\u0011D\u0005\u0004\u0005gr&\u0001\u0003$v]\u000e$\u0018n\u001c8\t\r\t]D\u00031\u0001T\u0003ei\u0017\r_5nk6tU/\u001c2fe>3\u0007+\u0019:uSRLwN\\:\t\u000f\tmD\u00031\u0001\u0002B\u0005Q\u0012n\u001a8pe\u0016$v\u000e]5dg^KG\u000f[#yG\u0016\u0004H/[8og\u0006aq-\u001a;BY2$v\u000e]5dgR\u0011!\u0011G\u0001\u000bO\u0016$Hk\u001c9jG&#G\u0003\u0002BC\u0005\u0017\u0003BAa\u0005\u0003\b&!!\u0011RA\u001c\u0005\u0011)V/\u001b3\t\u000f\u0005]e\u00031\u0001\u0002\u001a\u0006aq-\u001a;U_BL7MT1nKR!!\u0011\u0013BL!\u0019\t\u0019Ba%\u0002\u001a&\u0019!Q\u00131\u0003\u0011=\u0003H/[8oC2DqA!'\u0018\u0001\u0004\u0011))A\u0004u_BL7-\u00133\u0002\u001d!\f7/\u00117jm\u0016\u0014%o\\6feR!\u0011\u0011\tBP\u0011\u0015\t\u0006\u00041\u0001T\u00039I7O\u0011:pW\u0016\u0014h)\u001a8dK\u0012$B!!\u0011\u0003&\")\u0011+\u0007a\u0001'\u0006!\u0012n\u001d\"s_.,'o\u00155viRLgn\u001a#po:$B!!\u0011\u0003,\")\u0011K\u0007a\u0001'\u0006\u0011r-\u001a;BY&4XM\u0011:pW\u0016\u0014hj\u001c3f)\u0019\u0011\tLa-\u00036B1\u00111\u0003BJ\u0005#AQ!U\u000eA\u0002MCq!!\f\u001c\u0001\u0004\ty#A\nhKR\fE.\u001b<f\u0005J|7.\u001a:O_\u0012,7\u000f\u0006\u0003\u0003<\nu\u0006CBA\n\u0003+\u0011\t\u0002C\u0004\u0002.q\u0001\r!a\f\u0002\u001d\u001d,GO\u0011:pW\u0016\u0014hj\u001c3fgR!!1\u0018Bb\u0011\u001d\ti#\ba\u0001\u0003_\tqbZ3u\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\u000b\u0007\u0005\u0013\u0014\tNa5\u0011\r\u0005M!1\u0013Bf!\r\u0011%QZ\u0005\u0004\u0005\u001f\u001c%\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\bbBAL=\u0001\u0007\u0011\u0011\u0014\u0005\u0007\u0005+t\u0002\u0019A*\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0015\t\tm'Q\u001c\t\u0007\u0003'\u0011\u0019*!\u0007\t\u000f\u0005]u\u00041\u0001\u0002\u001a\u0006yAo\u001c9jG&#7\u000fV8OC6,7\u000f\u0006\u0002\u0003dBA\u00111\u0003Bs\u0005\u000b\u000bI*C\u0002\u0003h\u0002\u00141!T1q\u0003=!x\u000e]5d\u001d\u0006lWm\u001d+p\u0013\u0012\u001cHC\u0001Bw!!\t\u0019B!:\u0002\u001a\n\u0015\u0015AG4fiB\u000b'\u000f^5uS>tG*Z1eKJ,e\u000e\u001a9pS:$H\u0003\u0003BY\u0005g\u0014)Pa>\t\u000f\u0005]%\u00051\u0001\u0002\u001a\"1!Q\u001b\u0012A\u0002MCq!!\f#\u0001\u0004\ty#\u0001\u000fhKR\u0004\u0016M\u001d;ji&|gNU3qY&\u001c\u0017-\u00128ea>Lg\u000e^:\u0015\r\tu(q`B\u0005!!\t\u0019B!:\u0002\u001a\tE\u0001bBB\u0001G\u0001\u000711A\u0001\u0003iB\u0004BAa\u0005\u0004\u0006%!1qAA\u001c\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!\f$\u0001\u0004\ty#\u0001\fhKR\u0014\u0016M\u001c3p[\u0006c\u0017N^3Ce>\\WM]%e)\t\u0011Y.\u0001\u000bhKR\u0014\u0016M\u001c3p[\u0006c\u0017N^3Ce>\\WM\u001d\u000b\u0005\u00057\u001c\u0019\u0002C\u0003xK\u0001\u0007A/A\nhKR\fE.\u001b<f\u0005J|7.\u001a:Fa>\u001c\u0007\u000e\u0006\u0003\u0004\u001a\r\u0005\u0002CBA\n\u0005'\u001bY\u0002E\u0002;\u0007;I1aa\b<\u0005\u0011auN\\4\t\u000bE3\u0003\u0019A*\u0002\u0011\r|g\u000e^1j]N$B!!\u0011\u0004(!9\u0011qS\u0014A\u0002\u0005eE\u0003BA!\u0007WAqa!\u0001)\u0001\u0004\u0019\u0019!\u0001\u0005tKRLU.Y4f)\ra8\u0011\u0007\u0005\u0007\u0007gI\u0003\u0019\u0001;\u0002\u00119,w/S7bO\u0016\f\u0001bZ3u\u00136\fw-Z\u0001\u0007G>tg-[4\u0015\t\rm2\u0011\t\t\u0005\u0003'\u0019i$C\u0002\u0004@\u0001\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0019\u0019e\u000ba\u0001\u0007\u000b\nabY8oM&<'+Z:pkJ\u001cW\r\u0005\u0003\u0004H\r-SBAB%\u0015\u0011\u00199$a\u000e\n\t\r53\u0011\n\u0002\u000f\u0007>tg-[4SKN|WO]2f\u0003Q!Wm]2sS\n,7\t\\5f]R\fVo\u001c;bgR!11KB-!\u0011\u0011if!\u0016\n\t\r]\u00131\u0012\u0002!\t\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0004\u0004\\1\u0002\ra!\u0018\u0002\u000fI,\u0017/^3tiB!!QLB0\u0013\u0011\u0019\t'a#\u0003?\u0011+7o\u0019:jE\u0016\u001cE.[3oiF+x\u000e^1t%\u0016\fX/Z:u\t\u0006$\u0018-\u0001\reKN\u001c'/\u001b2f'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN$Baa\u001a\u0004nA!!QLB5\u0013\u0011\u0019Y'a#\u0003Q\u0011+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+7\u000f]8og\u0016$\u0015\r^1\t\u000f\rmS\u00061\u0001\u0004pA!!QLB9\u0013\u0011\u0019\u0019(a#\u0003O\u0011+7o\u0019:jE\u0016,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgJ+\u0017/^3ti\u0012\u000bG/Y\u0001\u0010[\u0016$\u0018\rZ1uCZ+'o]5p]R\u00111\u0011\u0010\t\u0004K\u000em\u0014bAB?M\nyQ*\u001a;bI\u0006$\u0018MV3sg&|g.\u0001\u0005gK\u0006$XO]3t)\t\u0019\u0019\tE\u0002f\u0007\u000bK1aa\"g\u0005E1\u0015N\\1mSj,GMR3biV\u0014Xm\u001d")
public class KRaftMetadataCache
implements MetadataCache,
Logging {
    private final int brokerId;
    private final Supplier<KRaftVersion> kraftVersionSupplier;
    private volatile MetadataImage _currentImage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Supplier<KRaftVersion> kraftVersionSupplier() {
        return this.kraftVersionSupplier;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), (Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return new Some((Object)((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1 & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": leader not available");
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": listener " + listenerName + " not found on leader " + partition$1.leader);
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": replica information not available for following brokers " + Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(","));
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": in sync replica information not available for following brokers " + Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(","));
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            })).iterator());
        }
        throw new MatchError((Object)option);
    }

    private Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> getPartitionMetadataForDescribeTopicResponse(MetadataImage image, String topicName, ListenerName listenerName, int startIndex, int maxCount) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            ListBuffer result = new ListBuffer();
            Set partitions = topic.partitions().keySet();
            int upperIndex = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(topic.partitions().size()), startIndex + maxCount);
            int nextIndex = upperIndex < partitions.size() ? upperIndex : -1;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startIndex), upperIndex).foreach((Function1 & Serializable)partitionId -> KRaftMetadataCache.$anonfun$getPartitionMetadataForDescribeTopicResponse$1(this, topic, image, listenerName, result, topicName, BoxesRunTime.unboxToInt((Object)partitionId)));
            return new Tuple2((Object)new Some((Object)result.toList()), (Object)BoxesRunTime.boxToInteger((int)nextIndex));
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(this, image, offlineReplicas, partition, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$1.node(listenerName.value()))));
    }

    public java.util.List<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return topics.stream().flatMap(topic -> {
            Option<Iterator<MetadataResponseData.MetadataResponsePartition>> option = this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners);
            if (option instanceof Some) {
                Iterator partitionMetadata = (Iterator)((Some)option).value();
                return Stream.of(new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava()));
            }
            if (None$.MODULE$.equals(option)) {
                return Stream.empty();
            }
            throw new MatchError(option);
        }).collect(Collectors.toList());
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public boolean getTopicMetadata$default$4() {
        return false;
    }

    public DescribeTopicPartitionsResponseData describeTopicResponse(java.util.Iterator<String> topics, ListenerName listenerName, Function<String, Integer> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        MetadataImage image = this._currentImage();
        IntRef remaining = IntRef.create((int)maximumNumberOfPartitions);
        DescribeTopicPartitionsResponseData result = new DescribeTopicPartitionsResponseData();
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> topics.forEachRemaining(topicName -> {
            if (remaining$1.elem > 0) {
                void var9_9;
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> tuple2 = this.getPartitionMetadataForDescribeTopicResponse(image, (String)topicName, listenerName, Predef$.MODULE$.Integer2int((Integer)topicPartitionStartIndex.apply((String)topicName)), remaining$1.elem);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Option partitionResponse = (Option)tuple2._1();
                int n = tuple2._2$mcI$sp();
                var9_9.map((Function1 & Serializable)partitions -> {
                    KRaftMetadataCache.$anonfun$describeTopicResponse$3(topicName, image, result, n, remaining, partitions);
                    return BoxedUnit.UNIT;
                });
                if (!ignoreTopicsWithExceptions && var9_9.isEmpty()) {
                    Errors errors;
                    try {
                        Topic.validate((String)topicName);
                        errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        errors = Errors.INVALID_TOPIC_EXCEPTION;
                    }
                    Errors error = errors;
                    result.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(error.code()).setName(topicName).setTopicId(this.getTopicId((String)topicName)).setIsInternal(Topic.isInternal((String)topicName)));
                    return;
                }
                return;
            }
            if (remaining$1.elem == 0) {
                result.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName).setPartitionIndex(0));
                throw Breaks$.MODULE$.break();
            }
        }));
        return result;
    }

    public Set<String> getAllTopics() {
        return this._currentImage().topics().topicsByName().keySet();
    }

    public Uuid getTopicId(String topicName) {
        return Optional.ofNullable(this._currentImage().topics().topicsByName().get((Object)topicName)).map(x$3 -> x$3.id()).orElse(Uuid.ZERO_UUID);
    }

    public Optional<String> getTopicName(Uuid topicId) {
        return Optional.ofNullable(this._currentImage().topics().topicsById().get((Object)topicId)).map(t -> t.name());
    }

    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$4))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.inControlledShutdown())) == 1;
    }

    public Optional<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Optional.ofNullable(this._currentImage().cluster().broker(brokerId)).filter(Predicate.not(x$7 -> x$7.fenced())).flatMap(broker -> broker.node(listenerName.value()));
    }

    public java.util.List<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return this._currentImage().cluster().brokers().values().stream().filter(Predicate.not(x$8 -> x$8.fenced())).flatMap(broker -> broker.node(listenerName.value()).stream()).collect(Collectors.toList());
    }

    public java.util.List<Node> getBrokerNodes(ListenerName listenerName) {
        return this._currentImage().cluster().brokers().values().stream().flatMap(broker -> broker.node(listenerName.value()).stream()).collect(Collectors.toList());
    }

    public Optional<LeaderAndIsr> getLeaderAndIsr(String topicName, int partitionId) {
        return Optional.ofNullable(this._currentImage().topics().getTopic(topicName)).flatMap(topic -> Optional.ofNullable(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap(partition -> Optional.ofNullable(new LeaderAndIsr(partition.leader, partition.leaderEpoch, Arrays.asList((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1 & Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Integer.class))), partition.leaderRecoveryState, partition.partitionEpoch)));
    }

    public Optional<Integer> numPartitions(String topicName) {
        return Optional.ofNullable(this._currentImage().topics().getTopic(topicName)).map(topic -> Predef$.MODULE$.int2Integer(topic.partitions().size()));
    }

    public Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    public Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    public Optional<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return Optional.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return Optional.empty();
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return Optional.of(Node.noNode());
                }
                if (option3 instanceof Some) {
                    return Optional.of(((BrokerRegistration)((Some)option3).value()).node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public Map<Integer, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap<Integer, Node> result = new HashMap<Integer, Node>();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(tp, image, listenerName, result, topic);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    public Optional<Integer> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Optional<Integer> getRandomAliveBroker(MetadataImage image) {
        java.util.List<Object> aliveBrokers = image.cluster().brokers().values().stream().filter(Predicate.not(x$9 -> x$9.fenced())).map(x$10 -> BoxesRunTime.boxToInteger((int)x$10.id())).toList();
        if (aliveBrokers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)aliveBrokers.get(ThreadLocalRandom.current().nextInt(aliveBrokers.size())))));
    }

    public Optional<Long> getAliveBrokerEpoch(int brokerId) {
        return Optional.ofNullable(this._currentImage().cluster().broker(brokerId)).filter(Predicate.not(x$11 -> x$11.fenced())).map(brokerRegistration -> Predef$.MODULE$.long2Long(brokerRegistration.epoch()));
    }

    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey((Object)topicName);
    }

    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    public MetadataImage getImage() {
        return this._currentImage();
    }

    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersionOrThrow();
    }

    public FinalizedFeatures features() {
        MetadataImage image = this._currentImage();
        HashMap<String, Short> finalizedFeatures = new HashMap<String, Short>(image.features().finalizedVersions());
        short kraftVersionLevel = this.kraftVersionSupplier().get().featureLevel();
        if (kraftVersionLevel > 0) {
            finalizedFeatures.put("kraft.version", Predef$.MODULE$.short2Short(kraftVersionLevel));
        }
        return new FinalizedFeatures(image.features().metadataVersionOrThrow(), finalizedFeatures, image.highestOffsetAndEpoch().offset());
    }

    public static final /* synthetic */ Object $anonfun$getPartitionMetadataForDescribeTopicResponse$1(KRaftMetadataCache $this, TopicImage topic$1, MetadataImage image$3, ListenerName listenerName$3, ListBuffer result$1, String topicName$2, int partitionId) {
        PartitionRegistration partitionRegistration = (PartitionRegistration)topic$1.partitions().get(BoxesRunTime.boxToInteger((int)partitionId));
        if (partitionRegistration != null) {
            java.util.List<Integer> filteredReplicas = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.replicas, listenerName$3, false);
            java.util.List<Integer> filteredIsr = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.isr, listenerName$3, false);
            java.util.List<Integer> offlineReplicas = $this.getOfflineReplicas(image$3, partitionRegistration, listenerName$3);
            Option<Node> maybeLeader = $this.getAliveEndpoint(image$3, partitionRegistration.leader, listenerName$3);
            if (None$.MODULE$.equals(maybeLeader)) {
                return (ListBuffer)result$1.append((Object)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(-1).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr)));
            }
            if (maybeLeader instanceof Some) {
                Node leader = (Node)((Some)maybeLeader).value();
                return (ListBuffer)result$1.append((Object)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(leader.id()).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr)));
            }
            throw new MatchError(maybeLeader);
        }
        $this.warn((Function0<String>)(Function0 & Serializable)() -> "The partition " + partitionId + " does not exist for " + topicName$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(KRaftMetadataCache $this, MetadataImage image$4, ArrayList offlineReplicas$1, PartitionRegistration partition$2, ListenerName listenerName$4, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$4.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if ($this.isReplicaOffline(partition$2, listenerName$4, broker)) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$describeTopicResponse$3(String topicName$3, MetadataImage image$6, DescribeTopicPartitionsResponseData result$2, int nextPartition$1, IntRef remaining$1, List partitions) {
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic response = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName$3).setTopicId((Uuid)Option$.MODULE$.apply((Object)image$6.topics().getTopic(topicName$3).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topicName$3)).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions).asJava());
        result$2.topics().add((ImplicitLinkedHashCollection.Element)response);
        if (nextPartition$1 != -1) {
            result$2.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName$3).setPartitionIndex(nextPartition$1));
            throw Breaks$.MODULE$.break();
        }
        remaining$1.elem -= partitions.size();
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$4) {
        return !x$4.fenced();
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(TopicPartition tp$1, MetadataImage image$7, ListenerName listenerName$11, HashMap result$3, TopicImage topic) {
        Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)tp$1.partition()))).foreach((Function1 & Serializable)partition -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1)(JFunction1.mcVI.sp & Serializable)replicaId -> {
                BrokerRegistration broker = image$7.cluster().broker(replicaId);
                if (broker != null && !broker.fenced()) {
                    broker.node(listenerName$11.value()).ifPresent(node -> {
                        if (!node.isEmpty()) {
                            result$3.put(Predef$.MODULE$.int2Integer(replicaId), node);
                            return;
                        }
                    });
                    return;
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    public KRaftMetadataCache(int brokerId, Supplier<KRaftVersion> kraftVersionSupplier) {
        this.brokerId = brokerId;
        this.kraftVersionSupplier = kraftVersionSupplier;
        this.logIdent_$eq("[MetadataCache brokerId=" + brokerId + "] ");
        this._currentImage = MetadataImage.EMPTY;
    }
}

