/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.builders;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.LogManager;
import kafka.server.AlterPartitionManager;
import kafka.server.DelayedFetch;
import kafka.server.DelayedProduce;
import kafka.server.DelayedRemoteFetch;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.share.DelayedShareFetch;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.ActionQueue;
import org.apache.kafka.server.DelayedActionQueue;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.log.remote.storage.RemoteLogManager;
import org.apache.kafka.server.purgatory.DelayedDeleteRecords;
import org.apache.kafka.server.purgatory.DelayedOperationPurgatory;
import org.apache.kafka.server.purgatory.DelayedRemoteListOffsets;
import org.apache.kafka.server.transaction.AddPartitionsToTxnManager;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function0;
import scala.Option;

public class ReplicaManagerBuilder {
    private KafkaConfig config = null;
    private Metrics metrics = null;
    private Time time = Time.SYSTEM;
    private Scheduler scheduler = null;
    private LogManager logManager = null;
    private QuotaFactory.QuotaManagers quotaManagers = null;
    private MetadataCache metadataCache = null;
    private LogDirFailureChannel logDirFailureChannel = null;
    private AlterPartitionManager alterPartitionManager = null;
    private BrokerTopicStats brokerTopicStats = null;

    public ReplicaManagerBuilder setConfig(KafkaConfig config) {
        this.config = config;
        return this;
    }

    public ReplicaManagerBuilder setMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public ReplicaManagerBuilder setTime(Time time) {
        this.time = time;
        return this;
    }

    public ReplicaManagerBuilder setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ReplicaManagerBuilder setLogManager(LogManager logManager) {
        this.logManager = logManager;
        return this;
    }

    public ReplicaManagerBuilder setQuotaManagers(QuotaFactory.QuotaManagers quotaManagers) {
        this.quotaManagers = quotaManagers;
        return this;
    }

    public ReplicaManagerBuilder setMetadataCache(MetadataCache metadataCache) {
        this.metadataCache = metadataCache;
        return this;
    }

    public ReplicaManagerBuilder setLogDirFailureChannel(LogDirFailureChannel logDirFailureChannel) {
        this.logDirFailureChannel = logDirFailureChannel;
        return this;
    }

    public ReplicaManagerBuilder setAlterPartitionManager(AlterPartitionManager alterPartitionManager) {
        this.alterPartitionManager = alterPartitionManager;
        return this;
    }

    public ReplicaManagerBuilder setBrokerTopicStats(BrokerTopicStats brokerTopicStats) {
        this.brokerTopicStats = brokerTopicStats;
        return this;
    }

    public ReplicaManager build() {
        if (this.config == null) {
            this.config = new KafkaConfig(Map.of());
        }
        if (this.logManager == null) {
            throw new RuntimeException("You must set logManager");
        }
        if (this.metadataCache == null) {
            throw new RuntimeException("You must set metadataCache");
        }
        if (this.logDirFailureChannel == null) {
            throw new RuntimeException("You must set logDirFailureChannel");
        }
        if (this.alterPartitionManager == null) {
            throw new RuntimeException("You must set alterIsrManager");
        }
        if (this.brokerTopicStats == null) {
            this.brokerTopicStats = new BrokerTopicStats(this.config.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
        }
        if (this.metrics == null) {
            this.metrics = new Metrics();
        }
        return new ReplicaManager(this.config, this.metrics, this.time, this.scheduler, this.logManager, (Option<RemoteLogManager>)Option.empty(), this.quotaManagers, this.metadataCache, this.logDirFailureChannel, this.alterPartitionManager, this.brokerTopicStats, new AtomicBoolean(false), (Option<DelayedOperationPurgatory<DelayedProduce>>)Option.empty(), (Option<DelayedOperationPurgatory<DelayedFetch>>)Option.empty(), (Option<DelayedOperationPurgatory<DelayedDeleteRecords>>)Option.empty(), (Option<DelayedOperationPurgatory<DelayedRemoteFetch>>)Option.empty(), (Option<DelayedOperationPurgatory<DelayedRemoteListOffsets>>)Option.empty(), (Option<DelayedOperationPurgatory<DelayedShareFetch>>)Option.empty(), (Option<String>)Option.empty(), (Function0<Object>)((Function0)() -> -1L), (Option<AddPartitionsToTxnManager>)Option.empty(), DirectoryEventHandler.NOOP, (ActionQueue)new DelayedActionQueue());
    }
}

