/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.ListConfigResourcesResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class ListConfigResourcesResponse
extends AbstractResponse {
    private final ListConfigResourcesResponseData data;

    public ListConfigResourcesResponse(ListConfigResourcesResponseData data) {
        super(ApiKeys.LIST_CONFIG_RESOURCES);
        this.data = data;
    }

    @Override
    public ListConfigResourcesResponseData data() {
        return this.data;
    }

    public ApiError error() {
        return new ApiError(Errors.forCode(this.data.errorCode()));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return ListConfigResourcesResponse.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    public static ListConfigResourcesResponse parse(Readable readable, short version) {
        return new ListConfigResourcesResponse(new ListConfigResourcesResponseData(readable, version));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public Collection<ConfigResource> configResources() {
        return this.data.configResources().stream().map(entry -> new ConfigResource(ConfigResource.Type.forId(entry.resourceType()), entry.resourceName())).collect(Collectors.toList());
    }
}

