/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.commons.Method;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.SettingControl;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.ASMToolkit;
import jdk.jfr.internal.EventControl;
import jdk.jfr.internal.EventHandlerProxyCreator;
import jdk.jfr.internal.EventInstrumentation;
import jdk.jfr.internal.EventWriter;
import jdk.jfr.internal.EventWriterMethod;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.StringPool;
import jdk.jfr.internal.TypeLibrary;
import jdk.jfr.internal.handlers.EventHandler;

final class EventHandlerCreator {
    private static final int CLASS_VERSION = 52;
    private static final String SUFFIX = "_" + System.currentTimeMillis() + "-" + JVM.getJVM().getPid();
    private static final String FIELD_EVENT_TYPE = "platformEventType";
    private static final String FIELD_PREFIX_STRING_POOL = "stringPool";
    private static final Class<? extends EventHandler> eventHandlerProxy = EventHandlerProxyCreator.proxyClass;
    private static final Type TYPE_STRING_POOL = Type.getType(StringPool.class);
    private static final Type TYPE_EVENT_WRITER = Type.getType(EventWriter.class);
    private static final Type TYPE_PLATFORM_EVENT_TYPE = Type.getType(PlatformEventType.class);
    private static final Type TYPE_EVENT_HANDLER = Type.getType(eventHandlerProxy);
    private static final Type TYPE_SETTING_CONTROL = Type.getType(SettingControl.class);
    private static final Type TYPE_EVENT_TYPE = Type.getType(EventType.class);
    private static final Type TYPE_EVENT_CONTROL = Type.getType(EventControl.class);
    private static final String DESCRIPTOR_EVENT_HANDLER = "(" + Type.BOOLEAN_TYPE.getDescriptor() + TYPE_EVENT_TYPE.getDescriptor() + TYPE_EVENT_CONTROL.getDescriptor() + ")V";
    private static final Method METHOD_GET_EVENT_WRITER = new Method("getEventWriter", "()" + TYPE_EVENT_WRITER.getDescriptor());
    private static final Method METHOD_EVENT_HANDLER_CONSTRUCTOR = new Method("<init>", DESCRIPTOR_EVENT_HANDLER);
    private static final Method METHOD_RESET = new Method("reset", "()V");
    private final ClassWriter classWriter = new ClassWriter(3);
    private final String className;
    private final String internalClassName;
    private final List<EventInstrumentation.SettingInfo> settingInfos;
    private final List<EventInstrumentation.FieldInfo> fields;

    public EventHandlerCreator(long l, List<EventInstrumentation.SettingInfo> list, List<EventInstrumentation.FieldInfo> list2) {
        this.className = EventHandlerCreator.makeEventHandlerName(l);
        this.internalClassName = ASMToolkit.getInternalName(this.className);
        this.settingInfos = list;
        this.fields = list2;
    }

    public static String makeEventHandlerName(long l) {
        return eventHandlerProxy.getName() + l + SUFFIX;
    }

    public EventHandlerCreator(long l, List<EventInstrumentation.SettingInfo> list, EventType eventType, Class<? extends Event> clazz) {
        this(l, list, EventHandlerCreator.createFieldInfos(clazz, eventType));
    }

    private static List<EventInstrumentation.FieldInfo> createFieldInfos(Class<? extends Event> clazz, EventType eventType) throws Error {
        ArrayList<EventInstrumentation.FieldInfo> arrayList = new ArrayList<EventInstrumentation.FieldInfo>();
        for (ValueDescriptor valueDescriptor : eventType.getFields()) {
            if (valueDescriptor == TypeLibrary.STACK_TRACE_FIELD || valueDescriptor == TypeLibrary.THREAD_FIELD) continue;
            String string = PrivateAccess.getInstance().getFieldName(valueDescriptor);
            String string2 = ASMToolkit.getDescriptor(valueDescriptor.getTypeName());
            String string3 = null;
            for (Class<? extends Event> clazz2 = clazz; clazz2 != Event.class; clazz2 = clazz2.getSuperclass()) {
                try {
                    Field field = clazz2.getDeclaredField(string);
                    if (clazz2 != clazz && Modifier.isPrivate(field.getModifiers())) continue;
                    string3 = ASMToolkit.getInternalName(clazz2.getName());
                    break;
                }
                catch (NoSuchFieldException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (string3 != null) {
                arrayList.add(new EventInstrumentation.FieldInfo(string, string2, string3));
                continue;
            }
            throw new InternalError("Could not locate field " + string + " for event type" + eventType.getName());
        }
        return arrayList;
    }

    public Class<? extends EventHandler> makeEventHandlerClass() {
        this.buildClassInfo();
        this.buildConstructor();
        this.buildWriteMethod();
        byte[] byArray = this.classWriter.toByteArray();
        ASMToolkit.logASM(this.className, byArray);
        return SecuritySupport.defineClass(this.className, byArray, Event.class.getClassLoader()).asSubclass(EventHandler.class);
    }

    public static EventHandler instantiateEventHandler(Class<? extends EventHandler> clazz, boolean bl, EventType eventType, EventControl eventControl) throws Error {
        Constructor<?> constructor;
        try {
            constructor = clazz.getDeclaredConstructors()[0];
        }
        catch (Exception exception) {
            throw (Error)new InternalError("Could not get handler constructor for " + eventType.getName()).initCause(exception);
        }
        SecuritySupport.setAccessible(constructor);
        try {
            List<EventInstrumentation.SettingInfo> list = eventControl.getSettingInfos();
            Object[] objectArray = new Object[3 + list.size()];
            objectArray[0] = bl;
            objectArray[1] = eventType;
            objectArray[2] = eventControl;
            for (EventInstrumentation.SettingInfo settingInfo : list) {
                objectArray[settingInfo.index + 3] = settingInfo.settingControl;
            }
            return (EventHandler)constructor.newInstance(objectArray);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            throw (Error)new InternalError("Could not instantiate event handler for " + eventType.getName() + ". " + exception.getMessage()).initCause(exception);
        }
    }

    private void buildConstructor() {
        MethodVisitor methodVisitor = this.classWriter.visitMethod(2, METHOD_EVENT_HANDLER_CONSTRUCTOR.getName(), EventHandlerCreator.makeConstructorDescriptor(this.settingInfos), null, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(eventHandlerProxy), METHOD_EVENT_HANDLER_CONSTRUCTOR.getName(), METHOD_EVENT_HANDLER_CONSTRUCTOR.getDescriptor(), false);
        for (EventInstrumentation.SettingInfo object : this.settingInfos) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, object.index + 4);
            methodVisitor.visitFieldInsn(181, this.internalClassName, object.fieldName, TYPE_SETTING_CONTROL.getDescriptor());
        }
        int n = 0;
        for (EventInstrumentation.FieldInfo fieldInfo : this.fields) {
            if (fieldInfo.isString()) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, Type.getInternalName(eventHandlerProxy), "createStringFieldWriter", "()" + TYPE_STRING_POOL.getDescriptor(), false);
                methodVisitor.visitFieldInsn(181, this.internalClassName, FIELD_PREFIX_STRING_POOL + n, TYPE_STRING_POOL.getDescriptor());
            }
            ++n;
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void buildClassInfo() {
        String string = ASMToolkit.getInternalName(eventHandlerProxy.getName());
        this.classWriter.visit(52, 49, this.internalClassName, null, string, null);
        for (EventInstrumentation.SettingInfo object : this.settingInfos) {
            this.classWriter.visitField(17, object.fieldName, TYPE_SETTING_CONTROL.getDescriptor(), null, null);
        }
        int n = 0;
        for (EventInstrumentation.FieldInfo fieldInfo : this.fields) {
            if (fieldInfo.isString()) {
                this.classWriter.visitField(18, FIELD_PREFIX_STRING_POOL + n, TYPE_STRING_POOL.getDescriptor(), null, null);
            }
            ++n;
        }
    }

    private void visitMethod(MethodVisitor methodVisitor, int n, Type type, Method method) {
        methodVisitor.visitMethodInsn(n, type.getInternalName(), method.getName(), method.getDescriptor(), false);
    }

    private void buildWriteMethod() {
        Object object;
        Object object2;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        Method method = ASMToolkit.makeWriteMethod(this.fields);
        Type[] typeArray = Type.getArgumentTypes(method.getDescriptor());
        MethodVisitor methodVisitor = this.classWriter.visitMethod(1, method.getName(), method.getDescriptor(), null, null);
        methodVisitor.visitCode();
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        methodVisitor.visitTryCatchBlock(label, label2, label3, "java/lang/Throwable");
        methodVisitor.visitLabel(label);
        this.visitMethod(methodVisitor, 184, TYPE_EVENT_WRITER, METHOD_GET_EVENT_WRITER);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, TYPE_EVENT_HANDLER.getInternalName(), FIELD_EVENT_TYPE, TYPE_PLATFORM_EVENT_TYPE.getDescriptor());
        this.visitMethod(methodVisitor, 182, TYPE_EVENT_WRITER, EventWriterMethod.BEGIN_EVENT.asASM());
        Label label4 = new Label();
        methodVisitor.visitJumpInsn(153, label4);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(typeArray[n].getOpcode(21), n2);
        int n4 = n++;
        this.visitMethod(methodVisitor, 182, TYPE_EVENT_WRITER, EventWriterMethod.PUT_LONG.asASM());
        ++n3;
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(typeArray[n].getOpcode(21), n2 += typeArray[n4].getSize());
        n2 += typeArray[n++].getSize();
        this.visitMethod(methodVisitor, 182, TYPE_EVENT_WRITER, EventWriterMethod.PUT_LONG.asASM());
        ++n3;
        methodVisitor.visitInsn(89);
        this.visitMethod(methodVisitor, 182, TYPE_EVENT_WRITER, EventWriterMethod.PUT_EVENT_THREAD.asASM());
        methodVisitor.visitInsn(89);
        this.visitMethod(methodVisitor, 182, TYPE_EVENT_WRITER, EventWriterMethod.PUT_STACK_TRACE.asASM());
        while (n3 < this.fields.size()) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(typeArray[n].getOpcode(21), n2);
            n2 += typeArray[n++].getSize();
            object2 = this.fields.get(n3);
            if (((EventInstrumentation.FieldInfo)object2).isString()) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.internalClassName, FIELD_PREFIX_STRING_POOL + n3, TYPE_STRING_POOL.getDescriptor());
            }
            object = EventWriterMethod.lookupMethod((EventInstrumentation.FieldInfo)object2);
            this.visitMethod(methodVisitor, 182, TYPE_EVENT_WRITER, object.asASM());
            ++n3;
        }
        this.visitMethod(methodVisitor, 182, TYPE_EVENT_WRITER, EventWriterMethod.END_EVENT.asASM());
        methodVisitor.visitJumpInsn(153, label);
        methodVisitor.visitLabel(label2);
        object2 = new Label();
        methodVisitor.visitJumpInsn(167, (Label)object2);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
        this.visitMethod(methodVisitor, 184, TYPE_EVENT_WRITER, METHOD_GET_EVENT_WRITER);
        methodVisitor.visitInsn(89);
        object = new Label();
        methodVisitor.visitJumpInsn(198, (Label)object);
        methodVisitor.visitInsn(89);
        this.visitMethod(methodVisitor, 182, TYPE_EVENT_WRITER, METHOD_RESET);
        methodVisitor.visitLabel((Label)object);
        methodVisitor.visitFrame(3, 0, null, 2, new Object[]{"java/lang/Throwable", TYPE_EVENT_WRITER.getInternalName()});
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(191);
        methodVisitor.visitLabel(label4);
        methodVisitor.visitFrame(3, 0, null, 1, new Object[]{TYPE_EVENT_WRITER.getInternalName()});
        methodVisitor.visitInsn(87);
        methodVisitor.visitLabel((Label)object2);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static String makeConstructorDescriptor(List<EventInstrumentation.SettingInfo> list) {
        StringJoiner stringJoiner = new StringJoiner("", "(", ")V");
        stringJoiner.add(Type.BOOLEAN_TYPE.getDescriptor());
        stringJoiner.add(Type.getType(EventType.class).getDescriptor());
        stringJoiner.add(Type.getType(EventControl.class).getDescriptor());
        for (int i = 0; i < list.size(); ++i) {
            stringJoiner.add(TYPE_SETTING_CONTROL.getDescriptor());
        }
        return stringJoiner.toString();
    }
}

