/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.BS;
import javajs.util.Measure;
import javajs.util.P3;
import org.jmol.render.FontLineShapeRenderer;
import org.jmol.shape.Bbcage;
import org.jmol.shape.FontLineShape;
import org.jmol.util.BoxInfo;

abstract class CageRenderer
extends FontLineShapeRenderer {
    protected final P3[] p3Screens = new P3[8];
    protected char[] tickEdges;
    protected boolean isSlab;
    protected boolean isPolymer;
    protected int periodicity;
    protected int nDims;
    protected BS bsPeriod;
    protected P3 pt;
    protected P3[] vvert;
    protected boolean shiftA;
    protected boolean shiftB;
    protected boolean shiftC;
    protected boolean shifting;

    CageRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.p3Screens[i] = new P3();
        }
        this.periodicity = 7;
        this.nDims = 3;
        this.pt = new P3();
    }

    protected void setPeriodicity(P3[] vertices, float scale) {
    }

    protected void renderCage(int mad, P3[] vertices, int[][] faces, P3[] axisPoints, int firstLine, int allowedEdges0, int allowedEdges1, float scale) {
        this.g3d.setC(this.colix);
        FontLineShape fls = (FontLineShape)this.shape;
        boolean hiddenLines = faces != null;
        this.imageFontScaling = this.vwr.imageFontScaling;
        this.font3d = this.vwr.gdata.getFont3DScaled(fls.font3d, this.imageFontScaling);
        float zSum = 0.0f;
        int i = 8;
        while (--i >= 0) {
            this.pt.setT(vertices[i]);
            if (scale != 1.0f) {
                this.pt.sub(vertices[0]);
                this.pt.scaleAdd2(scale, this.pt, vertices[0]);
            }
            this.tm.transformPtNoClip(this.pt, this.p3Screens[i]);
            zSum += this.p3Screens[i].z;
        }
        this.setPeriodicity(vertices, scale);
        BS bsSolid = null;
        if (hiddenLines) {
            bsSolid = new BS();
            int i2 = 12;
            while (--i2 >= 0) {
                int[] face = faces[i2];
                Measure.getNormalThroughPoints(this.p3Screens[face[0]], this.p3Screens[face[1]], this.p3Screens[face[2]], this.pt1, this.pt);
                if (!(this.pt1.z <= 0.0f)) continue;
                bsSolid.set(face[0]);
                bsSolid.set(face[1]);
                bsSolid.set(face[2]);
            }
        }
        int diameter = this.getDiameter((int)Math.floor(zSum / 8.0f), mad);
        int axisPt = 2;
        char edge = '\u0000';
        allowedEdges0 &= this.isPolymer ? 1 : (this.isSlab ? 85 : 255);
        allowedEdges1 &= this.isPolymer ? 16 : (this.isSlab ? 85 : 255);
        this.setBSPeriod();
        for (int i3 = firstLine * 2; i3 < 24; i3 += 2) {
            boolean drawTicks;
            if (this.bsPeriod != null && !this.bsPeriod.get(i3)) continue;
            int d = diameter;
            byte edge0 = BoxInfo.edges[i3];
            byte edge1 = BoxInfo.edges[i3 + 1];
            if (!(!hiddenLines || bsSolid.get(edge0) && bsSolid.get(edge1))) {
                d = -Math.abs(diameter);
            }
            if (axisPoints != null && edge0 == 0) {
                this.tm.transformPtNoClip(axisPoints[axisPt--], this.p3Screens[0]);
            }
            if ((allowedEdges0 & 1 << edge0) == 0 || (allowedEdges1 & 1 << edge1) == 0) continue;
            boolean bl = drawTicks = fls.tickInfos != null && (edge = this.tickEdges[i3 >> 1]) != '\u0000';
            if (drawTicks) {
                this.checkTickTemps();
                this.tickA.setT(vertices[edge0]);
                this.tickB.setT(vertices[edge1]);
                float start = 0.0f;
                if (this.shape instanceof Bbcage) {
                    switch (edge) {
                        case 'x': {
                            start = this.tickA.x;
                            break;
                        }
                        case 'y': {
                            start = this.tickA.y;
                            break;
                        }
                        case 'z': {
                            start = this.tickA.z;
                        }
                    }
                }
                this.tickInfo = fls.tickInfos["xyz".indexOf(edge) + 1];
                if (this.tickInfo == null) {
                    this.tickInfo = fls.tickInfos[0];
                }
                if (this.tickInfo == null) {
                    drawTicks = false;
                } else {
                    this.tickInfo.first = start;
                }
            }
            this.renderCageLine(i3, edge0, edge1, d, drawTicks);
        }
    }

    protected void renderCageLine(int i, int edge0, int edge1, int d, boolean drawTicks) {
        P3 p1 = this.p3Screens[edge0];
        P3 p2 = this.p3Screens[edge1];
        this.renderLine(p1, p2, d, drawTicks);
    }

    protected void setBSPeriod() {
    }

    protected void setShifts() {
        this.shiftA = (this.periodicity & 1) == 0;
        this.shiftB = (this.periodicity & 2) == 0;
        this.shiftC = (this.periodicity & 4) == 0;
        this.shifting = this.shiftA || this.shiftB || this.shiftC;
    }
}

